/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.util;

import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.internal.nls.Messages;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;

public class HashUtil {
    private static final Log LOG = LogFactory.getLog(HashUtil.class.getName());
    private static final String NLS_FAILED_TO_GENERATE_HASH_VALUE = "HashUtil.FailedToGenerateHashValue";

    public static String getStacktraceHash(Throwable throwable) {
        StringWriter stringWriter = new StringWriter(500);
        throwable.printStackTrace(new PrintWriter(stringWriter));
        String string = stringWriter.toString();
        return HashUtil.getHashValue(string);
    }

    public static String getHashValue(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] byArray = messageDigest.digest(string.getBytes("UTF-8"));
            StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
            byte[] byArray2 = byArray;
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte by = byArray2[n2];
                stringBuilder.append(String.format("%02X", by));
                ++n2;
            }
            return stringBuilder.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.warn((Object)Messages.getServerString(NLS_FAILED_TO_GENERATE_HASH_VALUE), (Throwable)noSuchAlgorithmException);
            return null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.warn((Object)Messages.getServerString(NLS_FAILED_TO_GENERATE_HASH_VALUE), (Throwable)unsupportedEncodingException);
            return null;
        }
    }
}

