/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.util;

import com.ibm.team.repository.common.internal.util.InternalTeamPlatform;
import com.ibm.team.repository.common.util.ExtensionReader$1;
import com.ibm.team.repository.common.util.ExtensionReader$2;
import com.ibm.team.repository.common.util.ExtensionReader$3;
import com.ibm.team.repository.common.util.ExtensionReaderListener;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.SafeRunner;

public abstract class ExtensionReader {
    private static final Log logger = LogFactory.getLog(ExtensionReader.class);
    private final String pluginId;
    private final String extensionPointId;
    private final IRegistryChangeListener registryChangeListener;
    private final Object startLock = new Object();
    private boolean started;
    private final List listeners;

    public static String getPluginId(IConfigurationElement iConfigurationElement) {
        IExtension iExtension;
        String string = null;
        if (iConfigurationElement != null && (iExtension = iConfigurationElement.getDeclaringExtension()) != null) {
            string = iExtension.getNamespaceIdentifier();
        }
        return string;
    }

    protected ExtensionReader(String string, String string2) {
        this.pluginId = string;
        this.extensionPointId = string2;
        this.registryChangeListener = this.createRegistryChangeListener();
        this.listeners = new ArrayList(3);
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtensionReaderListener(ExtensionReaderListener extensionReaderListener) {
        List list = this.listeners;
        synchronized (list) {
            boolean bl = this.listeners.contains(extensionReaderListener);
            if (bl) {
                return;
            }
            this.listeners.add(extensionReaderListener);
        }
    }

    protected final void addRegistryListener(IRegistryChangeListener iRegistryChangeListener, String string) {
        IExtensionRegistry iExtensionRegistry = this.getRegistry();
        if (iExtensionRegistry != null) {
            iExtensionRegistry.addRegistryChangeListener(iRegistryChangeListener, string);
        }
    }

    protected final void checkStarted() {
        boolean bl = this.isStarted();
        if (bl) {
            return;
        }
        throw (Throwable)new RuntimeException("Registry is not started");
    }

    private IRegistryChangeListener createRegistryChangeListener() {
        return new ExtensionReader$1(this);
    }

    public final void earlyStart() {
        if (!InternalTeamPlatform.getDefault().asBundle()) {
            this.start();
        }
    }

    private IExtensionRegistry getRegistry() {
        return RegistryFactory.getRegistry();
    }

    protected boolean handleExtensionAdded(IConfigurationElement iConfigurationElement) {
        return false;
    }

    protected boolean handleExtensionRemoved(IConfigurationElement iConfigurationElement) {
        return false;
    }

    private void handleRegistryChanged(int n, IConfigurationElement iConfigurationElement) {
        switch (n) {
            case 1: {
                boolean bl = this.handleExtensionAdded(iConfigurationElement);
                if (bl) {
                    this.notifyListenersOfExtensionAdded(iConfigurationElement);
                    break;
                }
                this.logFailedToAddExtension(iConfigurationElement);
                break;
            }
            case 2: {
                boolean bl = this.handleExtensionRemoved(iConfigurationElement);
                if (bl) {
                    this.notifyListenersOfExtensionRemoved(iConfigurationElement);
                    break;
                }
                this.logFailedToRemoveExtension(iConfigurationElement);
                break;
            }
            default: {
                this.logFailedToHandleRegistryChange(n, iConfigurationElement);
            }
        }
    }

    private void handleRegistryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas(this.pluginId, this.extensionPointId);
        int n = iExtensionDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionDelta iExtensionDelta = iExtensionDeltaArray[n2];
            int n3 = iExtensionDelta.getKind();
            IExtension iExtension = iExtensionDelta.getExtension();
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n4 = iConfigurationElementArray.length;
            int n5 = 0;
            while (n5 < n4) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n5];
                this.handleRegistryChanged(n3, iConfigurationElement);
                ++n5;
            }
            ++n2;
        }
    }

    private void internalReadElement(IConfigurationElement iConfigurationElement) {
        boolean bl = this.handleExtensionAdded(iConfigurationElement);
        if (!bl) {
            this.logError(iConfigurationElement, "Error processing extension: " + iConfigurationElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isStarted() {
        Object object = this.startLock;
        synchronized (object) {
            return this.started;
        }
    }

    protected final void logError(IConfigurationElement iConfigurationElement, String string) {
        IExtension iExtension = iConfigurationElement.getDeclaringExtension();
        String string2 = iExtension.getNamespaceIdentifier();
        String string3 = iExtension.getExtensionPointUniqueIdentifier();
        int n = 20 + string2.length() + string3.length() + string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append("Plugin ");
        stringBuffer.append(string2);
        stringBuffer.append(", extension ");
        stringBuffer.append(string3);
        stringBuffer.append('\n');
        stringBuffer.append(string);
        String string4 = stringBuffer.toString();
        logger.warn((Object)string4);
    }

    private void logFailedToAddExtension(IConfigurationElement iConfigurationElement) {
        IExtension iExtension = iConfigurationElement.getDeclaringExtension();
        String string = iExtension.getExtensionPointUniqueIdentifier();
        String string2 = "The extension reader {0} failed to add an extension to {1}.{2} with the ID {3}";
        String string3 = NLS.bind(string2, this, this.pluginId, this.extensionPointId, string);
        logger.error((Object)string3);
    }

    private void logFailedToHandleRegistryChange(int n, IConfigurationElement iConfigurationElement) {
        String string = String.valueOf(n);
        IExtension iExtension = iConfigurationElement.getDeclaringExtension();
        String string2 = iExtension.getExtensionPointUniqueIdentifier();
        String string3 = "The extension reader {0} failed to handle a registry change of type {1} to the extension point {2}.{3} with the ID {4}";
        String string4 = NLS.bind(string3, this, string, this.pluginId, this.extensionPointId, string2);
        logger.error((Object)string4);
    }

    private void logFailedToRemoveExtension(IConfigurationElement iConfigurationElement) {
        IExtension iExtension = iConfigurationElement.getDeclaringExtension();
        String string = iExtension.getExtensionPointUniqueIdentifier();
        String string2 = "The extension reader {0} failed to remove an extension from {1}.{2} with the ID {3}";
        String string3 = NLS.bind(string2, this, this.pluginId, this.extensionPointId, string);
        logger.error((Object)string3);
    }

    protected final void logMissingAttribute(IConfigurationElement iConfigurationElement, String string) {
        int n = 35 + string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append("Required attribute '");
        stringBuffer.append(string);
        stringBuffer.append("' not defined");
        String string2 = stringBuffer.toString();
        this.logError(iConfigurationElement, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfExtensionAdded(IConfigurationElement iConfigurationElement) {
        ExtensionReaderListener[] extensionReaderListenerArray = null;
        List list = this.listeners;
        synchronized (list) {
            extensionReaderListenerArray = this.listeners.toArray(new ExtensionReaderListener[this.listeners.size()]);
        }
        int n = 0;
        while (n < extensionReaderListenerArray.length) {
            ExtensionReaderListener extensionReaderListener = extensionReaderListenerArray[n];
            SafeRunner.run((ISafeRunnable)new ExtensionReader$2(this, extensionReaderListener, iConfigurationElement));
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfExtensionRemoved(IConfigurationElement iConfigurationElement) {
        ExtensionReaderListener[] extensionReaderListenerArray = null;
        List list = this.listeners;
        synchronized (list) {
            extensionReaderListenerArray = this.listeners.toArray(new ExtensionReaderListener[this.listeners.size()]);
        }
        int n = 0;
        while (n < extensionReaderListenerArray.length) {
            ExtensionReaderListener extensionReaderListener = extensionReaderListenerArray[n];
            SafeRunner.run((ISafeRunnable)new ExtensionReader$3(this, extensionReaderListener, iConfigurationElement));
            ++n;
        }
    }

    public boolean readElement(IConfigurationElement iConfigurationElement) {
        boolean bl = this.handleExtensionAdded(iConfigurationElement);
        return bl;
    }

    protected final void readRegistry() {
        IExtensionRegistry iExtensionRegistry = this.getRegistry();
        if (iExtensionRegistry == null) {
            return;
        }
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(this.pluginId, this.extensionPointId);
        if (iExtensionPoint == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        if (iConfigurationElementArray == null) {
            return;
        }
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            this.internalReadElement(iConfigurationElementArray[n]);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExtensionReaderListener(ExtensionReaderListener extensionReaderListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(extensionReaderListener);
        }
    }

    protected final void removeRegistryListener(IRegistryChangeListener iRegistryChangeListener) {
        IExtensionRegistry iExtensionRegistry = this.getRegistry();
        if (iExtensionRegistry != null) {
            iExtensionRegistry.removeRegistryChangeListener(iRegistryChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStarted(boolean bl) {
        Object object = this.startLock;
        synchronized (object) {
            this.started = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.startLock;
        synchronized (object) {
            boolean bl = this.isStarted();
            if (bl) {
                return;
            }
            this.setStarted(true);
            this.addRegistryListener(this.registryChangeListener, this.pluginId);
            this.readRegistry();
            this.started();
        }
    }

    protected void started() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.startLock;
        synchronized (object) {
            boolean bl = this.isStarted();
            if (!bl) {
                return;
            }
            this.setStarted(false);
            this.removeRegistryListener(this.registryChangeListener);
            this.stopped();
        }
    }

    protected void stopped() {
    }

    static /* synthetic */ void access$0(ExtensionReader extensionReader, IRegistryChangeEvent iRegistryChangeEvent) {
        extensionReader.handleRegistryChanged(iRegistryChangeEvent);
    }

    static /* synthetic */ Log access$1() {
        return logger;
    }
}

