/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.transport;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUtil {
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String CONNECTION = "Connection";
    public static final String DATE = "Date";
    public static final String PRAGMA = "Pragma";
    public static final String TRAILER = "Trailer";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String UPGRADE = "Upgrade";
    public static final String VIA = "Via";
    public static final String WARNING = "Warning";
    public static final String PUBLIC = "public";
    public static final String PRIVATE = "private";
    public static final String NO_CACHE = "no-cache";
    public static final String NO_STORE = "no-store";
    public static final String MAX_AGE = "max-age";
    public static final String MAX_STALE = "max-stale";
    public static final String MIN_FRESH = "min-fresh";
    public static final String S_MAXAGE = "s-maxage";
    public static final String PROXY_MAXAGE = "s-maxage";
    public static final String ONLY_IF_CACHED = "only-if-cached";
    public static final String MUST_REVALIDATE = "must-revalidate";
    public static final String PROXY_REVALIDATE = "proxy-revalidate";
    public static final String NO_TRANSFORM = "no-transform";
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_CHARSET = "Accept-Charset";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String AUTHORIZATION = "Authorization";
    public static final String EXPECT = "Expect";
    public static final String FROM = "From";
    public static final String HOST = "Host";
    public static final String IF_MATCH = "If-Match";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String IF_RANGE = "If-Range";
    public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    public static final String MAX_FORWARDS = "Max-Forwards";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String X_METHOD_OVERRIDE = "X-Method-Override";
    public static final String ACCEPT_RANGES = "Accept-Ranges";
    public static final String AGE = "Age";
    public static final String ETAG = "ETag";
    public static final String LOCATION = "Location";
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String SERVER = "Server";
    public static final String VARY = "Vary";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String ALLOW = "Allow";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_LANGUAGE = "Content-Language";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_LOCATION = "Content-Location";
    public static final String CONTENT_MD5 = "Content-MD5";
    public static final String CONTENT_RANGE = "Content-Range";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String EXPIRES = "Expires";
    public static final String LAST_MODFIED = "Last-Modified";
    public static final String WILDCARD = "*";
    public static final String WEAK_ETAG_PREFIX = "W/";
    public static final String GZIP = "gzip";
    public static final String SSL = "SSL";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String SLASH = "/";
    public static final String BACKWARDS_SLASH = "\\";
    public static final String CLOSE = "Close";
    public static final String CHARSET = "charset";
    public static final String MEDIATYPE = "_mediaType";
    public static final String CHAR_ENCODING = "_charEncoding";
    public static final String PRETTY_PRINT = "_prettyPrint";
    public static final String WEBUI = "_webUI";
    public static final String RESPONSE_ASTEXT = "_asText";
    public static final String X_USERID = "X-com-ibm-team-userid";
    public static final String X_MARSHALLING_VERSION = "X-com-ibm-team-marshaller-version";
    public static final String X_SERVICE_VERSION = "X-com-ibm-team-service-version";
    public static final String X_COMPONENT_CONFIGURATION_VERSIONS = "X-com-ibm-team-configuration-versions";
    public static final String X_ITEM_LOCATION = "X-com-ibm-team-Item-Location";
    public static final String X_STATE_LOCATION = "X-com-ibm-team-State-Location";

    public static List<String> splitHashRuleHeader(String header, int min, int max) {
        if (header == null) {
            return new ArrayList<String>(0);
        }
        if (min < 0) {
            throw new IllegalArgumentException("min must be >= 0");
        }
        if (max < 0) {
            throw new IllegalArgumentException("max must be >= 0");
        }
        String[] a = header.split(",");
        ArrayList<String> l = new ArrayList<String>(a.length);
        String[] stringArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String e = s.trim();
            if (e.length() != 0) {
                l.add(e);
            }
            ++n2;
        }
        if (l.size() < min) {
            throw new IllegalArgumentException("header contains too few elements");
        }
        if (l.size() > max) {
            throw new IllegalArgumentException("header contains too many elements");
        }
        return l;
    }

    public static List<String> splitHashRuleHeader(String header) {
        return HttpUtil.splitHashRuleHeader(header, 0, Integer.MAX_VALUE);
    }

    public static boolean isETagWeak(String etag) {
        return etag.startsWith(WEAK_ETAG_PREFIX);
    }

    public static long roundToSeconds(long time) {
        time /= 1000L;
        return time *= 1000L;
    }

    public static String contentTypeHeader(String mediaType, String charset) {
        if (mediaType == null) {
            throw new IllegalArgumentException("mediaType must not be null");
        }
        String retVal = null;
        retVal = charset != null && charset.length() > 0 ? String.format("%s;charset=%s", mediaType, charset) : String.format("%s", mediaType);
        return retVal;
    }

    public static Writer createWriter(OutputStream outputStream, CharsetEncoding charset) throws UnsupportedEncodingException {
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream must not be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset must not be null");
        }
        if (charset == CharsetEncoding.ANY) {
            charset = CharsetEncoding.UTF8;
        }
        return new BufferedWriter(new OutputStreamWriter(outputStream, charset.toCharset()));
    }

    public static InputStreamReader createReader(InputStream inputStream, CharsetEncoding charset) {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream must not be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset must not be null");
        }
        InputStreamReader reader = new InputStreamReader(inputStream, charset.toCharset());
        return reader;
    }

    public static String trimTrailingSlash(String uri) {
        if (uri == null) {
            return uri;
        }
        if (uri.endsWith(SLASH) || uri.endsWith(BACKWARDS_SLASH)) {
            int len = uri.length();
            if (len > 1) {
                return uri.substring(0, len - 1);
            }
            return new String();
        }
        return uri;
    }

    public static String trimLeadingSlash(String uri) {
        if (uri == null) {
            return uri;
        }
        if ((uri = uri.trim()).startsWith(SLASH) || uri.startsWith(BACKWARDS_SLASH)) {
            if (uri.length() > 1) {
                return uri.substring(1);
            }
            uri = new String();
        }
        return uri;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CharsetEncoding {
        ANY("*"),
        UTF8("UTF-8"),
        ISO8859("ISO-8859-1");

        private final String _name;

        private CharsetEncoding(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }

        public Charset toCharset() {
            return Charset.forName(this._name);
        }

        public static CharsetEncoding fromString(String name) {
            if (name == null) {
                return null;
            }
            CharsetEncoding[] charsetEncodingArray = CharsetEncoding.values();
            int n = charsetEncodingArray.length;
            int n2 = 0;
            while (n2 < n) {
                CharsetEncoding encoding = charsetEncodingArray[n2];
                if (encoding.toString().equals(name)) {
                    return encoding;
                }
                ++n2;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MediaType {
        ANY("*/*"),
        HTML("text/html"),
        JSON("text/json"),
        APP("application/atom+xml"),
        RSS("application/rss+xml"),
        XHTML("application/xhtml+xml"),
        XML("text/xml"),
        TEXT("text/*"),
        TEXT_PLAIN("text/plain"),
        UNKNOWN("Unknown"),
        FORM_URLENCODED("application/x-www-form-urlencoded");

        private final String _name;

        private MediaType(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }

        public static MediaType fromString(String name) {
            if (name == null) {
                return null;
            }
            MediaType[] mediaTypeArray = MediaType.values();
            int n = mediaTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MediaType mType = mediaTypeArray[n2];
                if (mType.toString().equals(name)) {
                    return mType;
                }
                ++n2;
            }
            return null;
        }
    }
}

