/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.query;

import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.query.IDataField;
import com.ibm.team.repository.common.query.IDataRow;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;

class DataRow
implements IDataRow {
    static final String ILLEGAL_DATATYPE_MSG = "Illegal Data Type Code specified in data query.";
    private final List dataFields;
    private final Map namesToPositions;
    private final List rawData;
    private final int startIndex;

    public DataRow(List list, Map map, List list2, int n) {
        this.dataFields = list;
        this.namesToPositions = map;
        this.rawData = list2;
        this.startIndex = n;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean((Integer)this.namesToPositions.get(string));
    }

    private Boolean getBooleanForPosition(int n) {
        String string = (String)this.rawData.get(this.startIndex + n);
        if (string == null) {
            return Boolean.FALSE;
        }
        if ("1".equals(string)) {
            return Boolean.TRUE;
        }
        return (boolean)Boolean.valueOf(string);
    }

    public boolean getBoolean(int n) {
        return this.getBooleanForPosition(n);
    }

    public BigDecimal getDecimal(String string) {
        return this.getDecimal((Integer)this.namesToPositions.get(string));
    }

    public BigDecimal getDecimal(int n) {
        String string = (String)this.rawData.get(this.startIndex + n);
        if (string == null) {
            return null;
        }
        return new BigDecimal(string);
    }

    public int getInt(String string) {
        return this.getInt((Integer)this.namesToPositions.get(string));
    }

    public int getInt(int n) {
        String string = (String)this.rawData.get(this.startIndex + n);
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public long getLong(String string) {
        return this.getLong((Integer)this.namesToPositions.get(string));
    }

    public long getLong(int n) {
        String string = (String)this.rawData.get(this.startIndex + n);
        if (string == null) {
            return 0L;
        }
        return Long.parseLong(string);
    }

    public Object getObject(String string) {
        return this.getObject((Integer)this.namesToPositions.get(string));
    }

    public Object getObject(int n) {
        String string = (String)this.rawData.get(this.startIndex + n);
        if (string == null) {
            return null;
        }
        int n2 = ((IDataField)this.dataFields.get(n)).getFieldType();
        Object object = null;
        switch (n2) {
            case 1: {
                object = this.getBooleanForPosition(n);
                break;
            }
            case 5: {
                object = new BigDecimal(string);
                break;
            }
            case 0: {
                object = new Integer(string);
                break;
            }
            case 6: {
                object = new Long(string);
                break;
            }
            case 8: {
                object = new Float(string);
                break;
            }
            case 9: {
                object = new Double(string);
                break;
            }
            case 2: {
                object = new String(string);
                break;
            }
            case 3: {
                object = Timestamp.valueOf(string);
                break;
            }
            case 4: {
                object = UUID.valueOf(string);
                break;
            }
            case 7: {
                object = ItemUtil.string2ItemType(string);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException(ILLEGAL_DATATYPE_MSG);
            }
        }
        return object;
    }

    public String getString(String string) {
        return this.getString((Integer)this.namesToPositions.get(string));
    }

    public String getString(int n) {
        return (String)this.rawData.get(this.startIndex + n);
    }

    public Timestamp getTimestamp(String string) {
        return this.getTimestamp((Integer)this.namesToPositions.get(string));
    }

    public Timestamp getTimestamp(int n) {
        String string = (String)this.rawData.get(this.startIndex + n);
        if (string == null) {
            return null;
        }
        if (!string.contains(String.valueOf(':'))) {
            return new Timestamp(Long.valueOf(string));
        }
        return Timestamp.valueOf(string);
    }

    public UUID getUUID(String string) {
        return this.getUUID((Integer)this.namesToPositions.get(string));
    }

    public UUID getUUID(int n) {
        String string = (String)this.rawData.get(this.startIndex + n);
        if (string == null) {
            return null;
        }
        return UUID.valueOf(string);
    }

    public IItemType getItemType(String string) {
        return this.getItemType((Integer)this.namesToPositions.get(string));
    }

    public IItemType getItemType(int n) {
        String string = (String)this.rawData.get(this.startIndex + n);
        if (string == null) {
            return null;
        }
        return ItemUtil.string2ItemType(string);
    }

    public double getDouble(String string) {
        return this.getDouble((Integer)this.namesToPositions.get(string));
    }

    public double getDouble(int n) {
        String string = (String)this.rawData.get(this.startIndex + n);
        if (string == null) {
            return 0.0;
        }
        return Double.parseDouble(string);
    }

    public float getFloat(String string) {
        return this.getFloat((Integer)this.namesToPositions.get(string));
    }

    public float getFloat(int n) {
        String string = (String)this.rawData.get(this.startIndex + n);
        if (string == null) {
            return 0.0f;
        }
        return Float.parseFloat(string);
    }
}

