/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.oauth;

import com.ibm.team.repository.common.model.OAuthServiceProviderInfo;
import com.ibm.team.repository.common.model.RepositoryFactory;
import com.ibm.team.repository.common.oauth.IOAuthHttpClient;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthServiceProvider;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class OAuthHttpClient
implements IOAuthHttpClient {
    private OAuthAccessor accessor;
    private HttpClient httpClient;

    public static OAuthServiceProviderInfo createProviderInfo(String repoUrl) {
        OAuthServiceProviderInfo info = RepositoryFactory.eINSTANCE.createOAuthServiceProviderInfo();
        if (!repoUrl.endsWith("/")) {
            repoUrl = String.valueOf(repoUrl) + "/";
        }
        info.setRequestTokenURL(String.valueOf(repoUrl) + "oauth-request-token");
        info.setAccessTokenURL(String.valueOf(repoUrl) + "oauth-access-token");
        info.setAuthorizeUserURL(String.valueOf(repoUrl) + "oauth-authorize");
        info.setRealm(String.valueOf(repoUrl) + "oauth/");
        return info;
    }

    private static HttpClient buildHttpClient(OAuthServiceProviderInfo spInfo, ProtocolSocketFactory secureSocketFactory) throws URIException {
        HttpClient httpClient = new HttpClient();
        HostConfiguration configuration = new HostConfiguration();
        URI uri = new URI(spInfo.getAccessTokenURL(), false);
        if ("https".equals(uri.getScheme())) {
            String host = uri.getHost();
            int port = uri.getPort();
            Protocol protocol = new Protocol("https", secureSocketFactory, 443);
            configuration.setHost(host, port, protocol);
        } else {
            configuration.setHost(uri.getHost(), uri.getPort());
        }
        httpClient.setHostConfiguration(configuration);
        return httpClient;
    }

    public OAuthHttpClient(OAuthServiceProviderInfo spInfo, ProtocolSocketFactory secureSocketFactory) throws HttpException {
        this(spInfo, OAuthHttpClient.buildHttpClient(spInfo, secureSocketFactory));
    }

    private static OAuthAccessor buildAccessor(OAuthServiceProviderInfo spInfo) {
        OAuthServiceProvider provider = new OAuthServiceProvider(spInfo.getRequestTokenURL(), spInfo.getAuthorizeUserURL(), spInfo.getAccessTokenURL());
        OAuthConsumer consumer = new OAuthConsumer(null, spInfo.getConsumerKey(), spInfo.getConsumerSecret(), provider);
        OAuthAccessor accessor = new OAuthAccessor(consumer);
        return accessor;
    }

    public OAuthHttpClient(OAuthServiceProviderInfo spInfo, HttpClient client) {
        this(OAuthHttpClient.buildAccessor(spInfo), client);
    }

    public OAuthHttpClient(OAuthAccessor accessor, HttpClient client) {
        this.accessor = accessor;
        this.httpClient = client;
    }

    public int executeMethod(HttpMethod method) throws IOException, HttpException {
        if (method.getURI().isAbsoluteURI()) {
            throw new UnsupportedOperationException("Only host relative URIs can be used.");
        }
        this.prepOAuthMethod(method, this.accessor);
        return this.httpClient.executeMethod(method);
    }

    private void prepOAuthMethod(HttpMethod method, OAuthAccessor accessor) throws IOException, HttpException {
        OAuthMessage message;
        List parameters = null;
        if (accessor.requestToken != null) {
            parameters = OAuth.newList((String[])new String[]{"oauth_token", accessor.requestToken});
        }
        try {
            URI uri = new URI(new URI(this.httpClient.getHostConfiguration().getHostURL(), false), method.getURI());
            message = accessor.newRequestMessage(method.getName(), uri.toString(), (Collection)parameters);
        }
        catch (OAuthException e) {
            throw new HttpException("The HTTP request could not be augmented with OAuth credentials", (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new HttpException("The HTTP request could not be augmented with OAuth credentials", (Throwable)e);
        }
        String authorizationHeader = message.getAuthorizationHeader(null);
        method.addRequestHeader("Authorization", authorizationHeader);
    }

    public String getRequestToken() throws HttpException {
        String requestTokenURL = this.accessor.consumer.serviceProvider.requestTokenURL;
        URI uri = new URI(requestTokenURL, false);
        String path = uri.getPathQuery();
        PostMethod requestToken = new PostMethod(path);
        try {
            try {
                int response = this.executeMethod((HttpMethod)requestToken);
                if (response != 200) {
                    throw new HttpException(MessageFormat.format("The OAuth consumer failed to get a request token.  The server responded with HTTP status = {0}", response));
                }
                this.accessor.requestToken = null;
                this.accessor.accessToken = null;
                this.accessor.tokenSecret = null;
                String responseString = requestToken.getResponseBodyAsString();
                List decodedForm = OAuth.decodeForm((String)responseString);
                for (OAuth.Parameter param : decodedForm) {
                    if (param.getKey().equals("oauth_token")) {
                        this.accessor.requestToken = param.getValue();
                        continue;
                    }
                    if (!param.getKey().equals("oauth_token_secret")) continue;
                    this.accessor.tokenSecret = param.getValue();
                }
            }
            catch (HttpException e) {
                throw e;
            }
            catch (Exception e1) {
                throw new HttpException("The OAuth consumer failed to get a request token.", (Throwable)e1);
            }
        }
        finally {
            requestToken.releaseConnection();
        }
        if (this.accessor.requestToken == null) {
            throw new HttpException("A request token was not returned from registration");
        }
        if (this.accessor.tokenSecret == null) {
            throw new HttpException("A request token secret was not returned from registration");
        }
        PostMethod userAuth = new PostMethod(this.accessor.consumer.serviceProvider.userAuthorizationURL);
        userAuth.setQueryString(new NameValuePair[]{new NameValuePair("oauth_token", this.accessor.requestToken)});
        return userAuth.getURI().getEscapedURI();
    }

    public void getAccessToken() throws HttpException {
        String accessTokenURL = this.accessor.consumer.serviceProvider.accessTokenURL;
        URI uri = new URI(accessTokenURL, false);
        String path = uri.getPathQuery();
        PostMethod requestAccessToken = new PostMethod(path);
        try {
            int result = this.executeMethod((HttpMethod)requestAccessToken);
            if (result != 200) {
                throw new HttpException("The OAuth access token failed to be acquired.");
            }
            this.accessor.requestToken = null;
            this.accessor.accessToken = null;
            this.accessor.tokenSecret = null;
            String responseString = requestAccessToken.getResponseBodyAsString();
            List decodedForm = OAuth.decodeForm((String)responseString);
            for (OAuth.Parameter param : decodedForm) {
                if (param.getKey().equals("oauth_token")) {
                    this.accessor.accessToken = param.getValue();
                    continue;
                }
                if (!param.getKey().equals("oauth_token_secret")) continue;
                this.accessor.tokenSecret = param.getValue();
            }
        }
        catch (Exception e) {
            throw new HttpException("The OAuth access token failed to be acquired.", (Throwable)e);
        }
        if (this.accessor.accessToken == null) {
            throw new HttpException("An access token was not returned.");
        }
        if (this.accessor.tokenSecret == null) {
            throw new HttpException("An access token secret was not returned.");
        }
    }

    public void setRequestToken(String token, String tokenSecret) {
        this.accessor.requestToken = token;
        this.accessor.tokenSecret = tokenSecret;
    }
}

