/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.model.impl;

import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.model.ExternalUser;
import com.ibm.team.repository.common.model.ExternalUserStatus;
import com.ibm.team.repository.common.model.RepositoryPackage$Literals;
import com.ibm.team.repository.common.model.impl.DetailEntryImpl;
import com.ibm.team.repository.common.model.impl.HelperImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;

public class ExternalUserImpl
extends HelperImpl
implements ExternalUser {
    protected EList fullNames;
    protected EList userIds;
    protected EList emailAddresses;
    protected EMap detailFields;
    protected ExternalUserStatus status;
    protected static final int STATUS_ESETFLAG = 2;

    protected ExternalUserImpl() {
    }

    protected EClass eStaticClass() {
        return RepositoryPackage$Literals.EXTERNAL_USER;
    }

    public List getFullNames() {
        if (this.fullNames == null) {
            this.fullNames = (EList)new EDataTypeUniqueEList.Unsettable(String.class, (InternalEObject)this, 1);
        }
        return (List)this.fullNames;
    }

    public void unsetFullNames() {
        if (this.fullNames != null) {
            ((InternalEList.Unsettable)this.fullNames).unset();
        }
    }

    public boolean isSetFullNames() {
        return this.fullNames != null && ((InternalEList.Unsettable)this.fullNames).isSet();
    }

    public List getUserIds() {
        if (this.userIds == null) {
            this.userIds = (EList)new EDataTypeUniqueEList.Unsettable(String.class, (InternalEObject)this, 2);
        }
        return (List)this.userIds;
    }

    public void unsetUserIds() {
        if (this.userIds != null) {
            ((InternalEList.Unsettable)this.userIds).unset();
        }
    }

    public boolean isSetUserIds() {
        return this.userIds != null && ((InternalEList.Unsettable)this.userIds).isSet();
    }

    public List getEmailAddresses() {
        if (this.emailAddresses == null) {
            this.emailAddresses = (EList)new EDataTypeUniqueEList.Unsettable(String.class, (InternalEObject)this, 3);
        }
        return (List)this.emailAddresses;
    }

    public void unsetEmailAddresses() {
        if (this.emailAddresses != null) {
            ((InternalEList.Unsettable)this.emailAddresses).unset();
        }
    }

    public boolean isSetEmailAddresses() {
        return this.emailAddresses != null && ((InternalEList.Unsettable)this.emailAddresses).isSet();
    }

    public Map getDetailFields() {
        if (this.detailFields == null) {
            this.detailFields = (EMap)new EcoreEMap.Unsettable(RepositoryPackage$Literals.DETAIL_ENTRY, DetailEntryImpl.class, (InternalEObject)this, 4);
        }
        return this.detailFields.map();
    }

    public void unsetDetailFields() {
        if (this.detailFields != null) {
            ((InternalEList.Unsettable)this.detailFields).unset();
        }
    }

    public boolean isSetDetailFields() {
        return this.detailFields != null && ((InternalEList.Unsettable)this.detailFields).isSet();
    }

    public ExternalUserStatus getStatus() {
        return this.status;
    }

    public NotificationChain basicSetStatus(ExternalUserStatus externalUserStatus, NotificationChain notificationChain) {
        ExternalUserStatus externalUserStatus2 = this.status;
        this.status = externalUserStatus;
        boolean bl = (this.ALL_FLAGS & 2) != 0;
        this.ALL_FLAGS |= 2;
        if (this.eNotificationRequired()) {
            ENotificationImpl eNotificationImpl = new ENotificationImpl((InternalEObject)this, 1, 5, (Object)externalUserStatus2, (Object)externalUserStatus, !bl);
            if (notificationChain == null) {
                notificationChain = eNotificationImpl;
            } else {
                notificationChain.add((Notification)eNotificationImpl);
            }
        }
        return notificationChain;
    }

    public void setStatus(ExternalUserStatus externalUserStatus) {
        if (externalUserStatus != this.status) {
            NotificationChain notificationChain = null;
            if (this.status != null) {
                notificationChain = ((InternalEObject)this.status).eInverseRemove((InternalEObject)this, -6, null, notificationChain);
            }
            if (externalUserStatus != null) {
                notificationChain = ((InternalEObject)externalUserStatus).eInverseAdd((InternalEObject)this, -6, null, notificationChain);
            }
            if ((notificationChain = this.basicSetStatus(externalUserStatus, notificationChain)) != null) {
                notificationChain.dispatch();
            }
        } else {
            boolean bl = (this.ALL_FLAGS & 2) != 0;
            this.ALL_FLAGS |= 2;
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)externalUserStatus, (Object)externalUserStatus, !bl));
            }
        }
    }

    public NotificationChain basicUnsetStatus(NotificationChain notificationChain) {
        ExternalUserStatus externalUserStatus = this.status;
        this.status = null;
        boolean bl = (this.ALL_FLAGS & 2) != 0;
        this.ALL_FLAGS &= 0xFFFFFFFD;
        if (this.eNotificationRequired()) {
            ENotificationImpl eNotificationImpl = new ENotificationImpl((InternalEObject)this, 2, 5, (Object)externalUserStatus, null, bl);
            if (notificationChain == null) {
                notificationChain = eNotificationImpl;
            } else {
                notificationChain.add((Notification)eNotificationImpl);
            }
        }
        return notificationChain;
    }

    public void unsetStatus() {
        if (this.status != null) {
            NotificationChain notificationChain = null;
            notificationChain = ((InternalEObject)this.status).eInverseRemove((InternalEObject)this, -6, null, notificationChain);
            if ((notificationChain = this.basicUnsetStatus(notificationChain)) != null) {
                notificationChain.dispatch();
            }
        } else {
            boolean bl = (this.ALL_FLAGS & 2) != 0;
            this.ALL_FLAGS &= 0xFFFFFFFD;
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 5, null, null, bl));
            }
        }
    }

    public boolean isSetStatus() {
        return (this.ALL_FLAGS & 2) != 0;
    }

    public String getUserId() {
        List list = this.getUserIds();
        if (list == null || list.size() == 0) {
            return null;
        }
        return (String)list.get(0);
    }

    public String getFullName() {
        List list = this.getFullNames();
        if (list == null || list.size() == 0) {
            return null;
        }
        return (String)list.get(0);
    }

    public String getEmailAddress() {
        List list = this.getEmailAddresses();
        if (list == null || list.size() == 0) {
            return null;
        }
        return (String)list.get(0);
    }

    public IStatus isValidUser() {
        ExternalUserStatus externalUserStatus = this.getStatus();
        if (externalUserStatus.isValid()) {
            return this.createOKStatus();
        }
        return this.createErrorStatus(externalUserStatus.getMessage());
    }

    private IStatus createOKStatus() {
        return (IStatus)new Status(0, "com.ibm.team.repository.common", "Valid User");
    }

    private IStatus createErrorStatus(String string) {
        return (IStatus)new Status(4, "com.ibm.team.repository.common", 4, string, null);
    }

    public IStatus isValidUser(List list) {
        IStatus iStatus;
        if (list.contains(IContributor.USERID_PROPERTY) && (iStatus = this.validateUserId()).getSeverity() == 4) {
            return iStatus;
        }
        if (list.contains(IContributor.NAME_PROPERTY) && (iStatus = this.validateName()).getSeverity() == 4) {
            return iStatus;
        }
        if (list.contains(IContributor.EMAIL_ADDRESS_PROPERTY)) {
            return this.validateEmailAddress();
        }
        return this.createOKStatus();
    }

    private IStatus validateUserId() {
        List list = this.getUserIds();
        if (list != null && list.size() > 1) {
            return this.createErrorStatus(Messages.getServerString("ExternalUserImpl.ErrorMoreThanOneId"));
        }
        boolean bl = this.isListOfStringsValid(list);
        if (!bl) {
            return this.createErrorStatus(Messages.getServerString("ExternalUserImpl.ErrorMissingId"));
        }
        return this.createOKStatus();
    }

    private IStatus validateName() {
        List list = this.getFullNames();
        boolean bl = this.isListOfStringsValid(list);
        if (!bl) {
            return this.createErrorStatus(Messages.getServerString("ExternalUserImpl.ErrorMissingName"));
        }
        return this.createOKStatus();
    }

    private IStatus validateEmailAddress() {
        List list = this.getEmailAddresses();
        boolean bl = this.isListOfStringsValid(list);
        if (!bl) {
            return this.createErrorStatus(Messages.getServerString("ExternalUserImpl.ErrorMissingEmail"));
        }
        return (IStatus)new Status(0, "com.ibm.team.repository.common", "Valid User");
    }

    private boolean isListOfStringsValid(List list) {
        if (list == null || list.size() == 0) {
            return false;
        }
        boolean bl = false;
        for (String string : list) {
            if (string == null || string.trim().length() == 0) continue;
            bl = true;
        }
        return bl;
    }

    public NotificationChain eInverseRemove(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        switch (n) {
            case 4: {
                return ((InternalEList)((EMap.InternalMapView)this.getDetailFields()).eMap()).basicRemove((Object)internalEObject, notificationChain);
            }
            case 5: {
                return this.basicUnsetStatus(notificationChain);
            }
        }
        return super.eInverseRemove(internalEObject, n, notificationChain);
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 1: {
                return this.getFullNames();
            }
            case 2: {
                return this.getUserIds();
            }
            case 3: {
                return this.getEmailAddresses();
            }
            case 4: {
                if (bl2) {
                    return ((EMap.InternalMapView)this.getDetailFields()).eMap();
                }
                return this.getDetailFields();
            }
            case 5: {
                return this.getStatus();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 1: {
                this.getFullNames().clear();
                this.getFullNames().addAll((Collection)object);
                return;
            }
            case 2: {
                this.getUserIds().clear();
                this.getUserIds().addAll((Collection)object);
                return;
            }
            case 3: {
                this.getEmailAddresses().clear();
                this.getEmailAddresses().addAll((Collection)object);
                return;
            }
            case 4: {
                ((EStructuralFeature.Setting)((EMap.InternalMapView)this.getDetailFields()).eMap()).set(object);
                return;
            }
            case 5: {
                this.setStatus((ExternalUserStatus)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 1: {
                this.unsetFullNames();
                return;
            }
            case 2: {
                this.unsetUserIds();
                return;
            }
            case 3: {
                this.unsetEmailAddresses();
                return;
            }
            case 4: {
                this.unsetDetailFields();
                return;
            }
            case 5: {
                this.unsetStatus();
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 1: {
                return this.isSetFullNames();
            }
            case 2: {
                return this.isSetUserIds();
            }
            case 3: {
                return this.isSetEmailAddresses();
            }
            case 4: {
                return this.isSetDetailFields();
            }
            case 5: {
                return this.isSetStatus();
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (fullNames: ");
        stringBuffer.append(this.fullNames);
        stringBuffer.append(", userIds: ");
        stringBuffer.append(this.userIds);
        stringBuffer.append(", emailAddresses: ");
        stringBuffer.append(this.emailAddresses);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

