/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.model.Item;
import com.ibm.team.repository.common.model.ItemType;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocationUtil {
    private static final char AMPERSAND = '&';
    private static final String EMPTY_STRING = "";
    private static final char EQUALS = '=';
    private static final char FORWARD_SLASH = '/';
    private static final char POUND = '#';
    private static final String UTF8 = "UTF-8";
    private static final String URL_ENCODED_SPACE = "%20";

    public static boolean hasNamedIdentifier(IItemHandle item) {
        if (item == null) {
            throw new IllegalArgumentException("item must not be null");
        }
        return ((ItemType)item.getItemType()).idPropertyName() != null;
    }

    public static String encode(String str) throws UnsupportedEncodingException {
        if (str == null) {
            throw new IllegalArgumentException("str must not be null");
        }
        String newStr = URLEncoder.encode(str, UTF8);
        return newStr.replaceAll("\\+", URL_ENCODED_SPACE);
    }

    public static String decode(String str) throws UnsupportedEncodingException {
        if (str == null) {
            throw new IllegalArgumentException("str must not be null");
        }
        str = str.replaceAll(URL_ENCODED_SPACE, "\\+");
        return URLDecoder.decode(str, UTF8);
    }

    public static Map parseQueryParameters(String query) {
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        if (query == null || query.length() == 0) {
            return map;
        }
        if (query.charAt(0) != '&') {
            query = String.valueOf('&') + query;
        }
        int masterNdx = 0;
        while (masterNdx < query.length()) {
            int startNdx;
            int endNdx;
            String parm = EMPTY_STRING;
            if ((endNdx = query.indexOf(38, startNdx = ++masterNdx)) == -1) {
                parm = query.substring(startNdx);
                masterNdx = query.length();
            } else {
                parm = query.substring(startNdx, endNdx);
                masterNdx = endNdx;
            }
            LocationUtil.loadParmInMap(parm, map);
        }
        HashMap<String, String[]> newMap = new HashMap<String, String[]>(map.size());
        for (String key : map.keySet()) {
            ArrayList list = (ArrayList)map.get(key);
            String[] strings = new String[list.size()];
            int i = 0;
            while (i < list.size()) {
                strings[i] = (String)list.get(i);
                ++i;
            }
            newMap.put(key, strings);
        }
        return newMap;
    }

    public static String queryString(Map<String, String[]> parmMap) {
        return LocationUtil.queryString(parmMap, null);
    }

    public static String queryString(Map<String, String[]> parmMap, String[] exclude) {
        if (parmMap == null) {
            throw new IllegalArgumentException("parmMap must not be null");
        }
        StringBuffer buf = new StringBuffer(256);
        for (Map.Entry<String, String[]> entry : parmMap.entrySet()) {
            String[] values;
            int n;
            String key = entry.getKey();
            boolean includeParm = true;
            if (exclude != null) {
                String[] stringArray = exclude;
                n = exclude.length;
                int n2 = 0;
                while (n2 < n) {
                    String parm = stringArray[n2];
                    if (key.equals(parm)) {
                        includeParm = false;
                        break;
                    }
                    ++n2;
                }
            }
            if (!includeParm) continue;
            String[] stringArray = values = entry.getValue();
            int n3 = values.length;
            n = 0;
            while (n < n3) {
                String value = stringArray[n];
                if (buf.length() != 0) {
                    buf.append('&');
                }
                buf.append(key);
                buf.append('=');
                buf.append(value);
                ++n;
            }
        }
        return buf.toString();
    }

    private static void loadParmInMap(String parm, HashMap<String, ArrayList<String>> map) {
        int equals = parm.indexOf(61);
        String key = null;
        String value = EMPTY_STRING;
        if (equals == -1) {
            key = parm;
        } else if (equals == parm.length() - 1) {
            key = parm.substring(0, equals);
        } else {
            key = parm.substring(0, equals);
            value = parm.substring(equals + 1);
        }
        ArrayList<String> mapValue = map.get(key);
        if (mapValue == null) {
            mapValue = new ArrayList();
            map.put(key, mapValue);
        }
        mapValue.add(value);
    }

    public static Object namedIdentifierPropValue(IItem item) {
        if (item == null) {
            throw new IllegalArgumentException("item must not be null");
        }
        String namedProperty = ((ItemType)item.getItemType()).idPropertyName();
        if (namedProperty == null) {
            throw new IllegalArgumentException("Specified itemType contains no named identifier annotation");
        }
        Item i = (Item)item;
        return i.getPropertyValue(namedProperty);
    }

    public static Location createNamedLocationByFeature(EObject feature, String repoUrl, String query, String serviceName) throws TeamRepositoryException {
        if (feature == null) {
            throw new IllegalArgumentException("feature must not be null");
        }
        Object[] result = LocationUtil.buildFeaturePath(feature, query);
        Location loc = null;
        try {
            loc = Location.location(new URI((String)result[1]));
        }
        catch (URISyntaxException e) {
            throw new TeamRepositoryException(e);
        }
        return Location.location(loc, repoUrl, serviceName);
    }

    public static Location createNamedLocationByFeature(EObject feature, String repoUrl, String query) throws TeamRepositoryException {
        return LocationUtil.createNamedLocationByFeature(feature, repoUrl, query, null);
    }

    private static Object[] buildFeaturePath(EObject eObject, String query) {
        String path = EMPTY_STRING;
        while (!(eObject instanceof IItem)) {
            if (eObject.eContainer() == null) {
                throw new IllegalArgumentException("Referenced feature is not an Item, nor contained by one");
            }
            EStructuralFeature feature = eObject.eContainingFeature();
            String selector = EMPTY_STRING;
            if (feature.isMany()) {
                Object collection = eObject.eContainer().eGet(feature);
                if (collection instanceof List) {
                    int index = ((List)collection).indexOf(eObject) + 1;
                    selector = String.valueOf('[') + Integer.toString(index) + ']';
                } else {
                    throw new IllegalArgumentException("Unsupported collection type");
                }
            }
            path = String.valueOf('/') + feature.getName() + selector + path;
            eObject = eObject.eContainer();
        }
        path = String.valueOf('#') + path.substring(1);
        if (!(eObject instanceof IItem)) {
            throw new IllegalArgumentException("Top-level feature container not an Item");
        }
        String base = Location.itemToNamedURI((IItem)eObject, query);
        return new Object[]{eObject, String.valueOf(base) + path};
    }
}

