/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.querypath;

import com.ibm.team.repository.common.internal.queryast.ComparisonOp;
import com.ibm.team.repository.common.internal.queryast.ElementType;
import com.ibm.team.repository.common.internal.queryast.FeaturePath;
import com.ibm.team.repository.common.internal.queryast.FilterElement;
import com.ibm.team.repository.common.internal.queryast.FunctionType;
import com.ibm.team.repository.common.internal.queryast.InList;
import com.ibm.team.repository.common.internal.queryast.Like;
import com.ibm.team.repository.common.internal.queryast.Literal;
import com.ibm.team.repository.common.internal.queryast.NumericScalarFunction;
import com.ibm.team.repository.common.internal.queryast.QueryDataElement;
import com.ibm.team.repository.common.internal.queryast.QueryastFactory;
import com.ibm.team.repository.common.internal.queryast.ScalarFunction;
import com.ibm.team.repository.common.internal.queryast.StringScalarFunction;
import com.ibm.team.repository.common.internal.querypath.AbstractQueryModelField;
import com.ibm.team.repository.common.internal.querypath.IQueryPath;
import com.ibm.team.repository.common.query.ast.IInListValueSource;
import com.ibm.team.repository.common.query.ast.INumeric;
import com.ibm.team.repository.common.query.ast.INumericScalarFunction;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.query.ast.IStringField;
import com.ibm.team.repository.common.query.ast.IStringScalarFunction;

public class StringField
extends AbstractQueryModelField
implements IStringField {
    public StringField(IQueryPath iQueryPath, String string) {
        this.name(string);
        this.parent(iQueryPath);
    }

    public ElementType getFieldType() {
        return ElementType.STRING_LITERAL;
    }

    public IPredicate _in(String[] stringArray) {
        this.checkInPredicateValueArray(stringArray);
        this.checkInPredicateValueArray(stringArray);
        FeaturePath featurePath = QueryastFactory.eINSTANCE.createFeaturePath(this);
        InList inList = QueryastFactory.eINSTANCE.createInList();
        inList.setField(featurePath);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            Literal literal = QueryastFactory.eINSTANCE.createStringLiteral(string);
            inList.getValues().add((Object)literal);
            ++n2;
        }
        return inList;
    }

    public IPredicate _in(IString[] iStringArray) {
        this.checkInPredicateValueArray(iStringArray);
        FeaturePath featurePath = QueryastFactory.eINSTANCE.createFeaturePath(this);
        InList inList = QueryastFactory.eINSTANCE.createInList();
        inList.setField(featurePath);
        IString[] iStringArray2 = iStringArray;
        int n = iStringArray.length;
        int n2 = 0;
        while (n2 < n) {
            IString iString = iStringArray2[n2];
            this.checkInPredicateNullValue(iString);
            FilterElement filterElement = QueryastFactory.eINSTANCE.createFilterElement(iString);
            inList.getValues().add((Object)filterElement);
            ++n2;
        }
        return inList;
    }

    public IPredicate _like(IString iString) {
        FilterElement filterElement = QueryastFactory.eINSTANCE.createFilterElement(iString);
        return this.createLikePredicate(filterElement, null);
    }

    public IPredicate _like(String string) {
        Literal literal = QueryastFactory.eINSTANCE.createStringLiteral(string);
        return this.createLikePredicate(literal, null);
    }

    public IPredicate _like(String string, char c) {
        Literal literal = QueryastFactory.eINSTANCE.createStringLiteral(string);
        Literal literal2 = QueryastFactory.eINSTANCE.createStringLiteral(Character.toString(c));
        return this.createLikePredicate(literal, literal2);
    }

    public IPredicate _like(IString iString, char c) {
        FilterElement filterElement = QueryastFactory.eINSTANCE.createFilterElement(iString);
        Literal literal = QueryastFactory.eINSTANCE.createStringLiteral(Character.toString(c));
        return this.createLikePredicate(filterElement, literal);
    }

    public IPredicate _ignoreCaseLike(IString iString) {
        FilterElement filterElement = QueryastFactory.eINSTANCE.createFilterElement(iString);
        return this.createIgnoreCaseLikePredicate(filterElement, null);
    }

    public IPredicate _ignoreCaseLike(String string) {
        Literal literal = QueryastFactory.eINSTANCE.createStringLiteral(string);
        return this.createIgnoreCaseLikePredicate(literal, null);
    }

    public IPredicate _ignoreCaseLike(String string, char c) {
        Literal literal = QueryastFactory.eINSTANCE.createStringLiteral(string);
        Literal literal2 = QueryastFactory.eINSTANCE.createStringLiteral(Character.toString(c));
        return this.createIgnoreCaseLikePredicate(literal, literal2);
    }

    public IPredicate _ignoreCaseLike(IString iString, char c) {
        FilterElement filterElement = QueryastFactory.eINSTANCE.createFilterElement(iString);
        Literal literal = QueryastFactory.eINSTANCE.createStringLiteral(Character.toString(c));
        return this.createIgnoreCaseLikePredicate(filterElement, literal);
    }

    private Like createLikePredicate(FilterElement filterElement, FilterElement filterElement2) {
        Like like = QueryastFactory.eINSTANCE.createLike();
        FilterElement filterElement3 = QueryastFactory.eINSTANCE.createFilterElement(this);
        like.setExpression(filterElement3);
        like.setPattern(filterElement);
        if (filterElement2 != null) {
            like.setEscape(filterElement2);
        }
        return like;
    }

    private IPredicate createIgnoreCaseLikePredicate(FilterElement filterElement, FilterElement filterElement2) {
        Like like = this.createLikePredicate(filterElement, filterElement2);
        like.setIgnoreCase(true);
        return like;
    }

    public INumericScalarFunction _indexOf(IString iString, Integer n) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.LOCATE_LITERAL);
        this.addASTFieldToScalarFunction(numericScalarFunction);
        QueryDataElement queryDataElement = QueryastFactory.eINSTANCE.createQueryDataElement(iString);
        numericScalarFunction.getArgs().add((Object)queryDataElement);
        Literal literal = QueryastFactory.eINSTANCE.createNumericLiteral(n);
        numericScalarFunction.getArgs().add((Object)literal);
        return numericScalarFunction;
    }

    public INumericScalarFunction _indexOf(IString iString, INumeric iNumeric) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.LOCATE_LITERAL);
        this.addASTFieldToScalarFunction(numericScalarFunction);
        QueryDataElement queryDataElement = QueryastFactory.eINSTANCE.createQueryDataElement(iString);
        numericScalarFunction.getArgs().add((Object)queryDataElement);
        QueryDataElement queryDataElement2 = QueryastFactory.eINSTANCE.createQueryDataElement(iNumeric);
        numericScalarFunction.getArgs().add((Object)queryDataElement2);
        return numericScalarFunction;
    }

    public INumericScalarFunction _indexOf(IString iString) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.LOCATE_LITERAL);
        this.addASTFieldToScalarFunction(numericScalarFunction);
        QueryDataElement queryDataElement = QueryastFactory.eINSTANCE.createQueryDataElement(iString);
        numericScalarFunction.getArgs().add((Object)queryDataElement);
        return numericScalarFunction;
    }

    public INumericScalarFunction _indexOf(String string, Integer n) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.LOCATE_LITERAL);
        this.addASTFieldToScalarFunction(numericScalarFunction);
        Literal literal = QueryastFactory.eINSTANCE.createStringLiteral(string);
        numericScalarFunction.getArgs().add((Object)literal);
        Literal literal2 = QueryastFactory.eINSTANCE.createNumericLiteral(n);
        numericScalarFunction.getArgs().add((Object)literal2);
        return numericScalarFunction;
    }

    public INumericScalarFunction _indexOf(String string, INumeric iNumeric) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.LOCATE_LITERAL);
        this.addASTFieldToScalarFunction(numericScalarFunction);
        Literal literal = QueryastFactory.eINSTANCE.createStringLiteral(string);
        numericScalarFunction.getArgs().add((Object)literal);
        QueryDataElement queryDataElement = QueryastFactory.eINSTANCE.createQueryDataElement(iNumeric);
        numericScalarFunction.getArgs().add((Object)queryDataElement);
        return numericScalarFunction;
    }

    public INumericScalarFunction _indexOf(String string) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.LOCATE_LITERAL);
        this.addASTFieldToScalarFunction(numericScalarFunction);
        Literal literal = QueryastFactory.eINSTANCE.createStringLiteral(string);
        numericScalarFunction.getArgs().add((Object)literal);
        return numericScalarFunction;
    }

    public INumericScalarFunction _length() {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.LENGTH_LITERAL);
        this.addASTFieldToScalarFunction(numericScalarFunction);
        return numericScalarFunction;
    }

    public IStringScalarFunction _lower() {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.LOWER_LITERAL);
        this.addASTFieldToScalarFunction(stringScalarFunction);
        return stringScalarFunction;
    }

    public IStringScalarFunction _upper() {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.UPPER_LITERAL);
        this.addASTFieldToScalarFunction(stringScalarFunction);
        return stringScalarFunction;
    }

    public IStringScalarFunction _substring(Integer n, Integer n2) {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.SUBSTRING_LITERAL);
        this.addASTFieldToScalarFunction(stringScalarFunction);
        Literal literal = QueryastFactory.eINSTANCE.createNumericLiteral(n);
        stringScalarFunction.getArgs().add((Object)literal);
        Literal literal2 = QueryastFactory.eINSTANCE.createNumericLiteral(n2);
        stringScalarFunction.getArgs().add((Object)literal2);
        return stringScalarFunction;
    }

    public IStringScalarFunction _substring(Integer n, INumeric iNumeric) {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.SUBSTRING_LITERAL);
        this.addASTFieldToScalarFunction(stringScalarFunction);
        Literal literal = QueryastFactory.eINSTANCE.createNumericLiteral(n);
        stringScalarFunction.getArgs().add((Object)literal);
        QueryDataElement queryDataElement = QueryastFactory.eINSTANCE.createQueryDataElement(iNumeric);
        stringScalarFunction.getArgs().add((Object)queryDataElement);
        return stringScalarFunction;
    }

    public IStringScalarFunction _substring(INumeric iNumeric, Integer n) {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.SUBSTRING_LITERAL);
        this.addASTFieldToScalarFunction(stringScalarFunction);
        QueryDataElement queryDataElement = QueryastFactory.eINSTANCE.createQueryDataElement(iNumeric);
        stringScalarFunction.getArgs().add((Object)queryDataElement);
        Literal literal = QueryastFactory.eINSTANCE.createNumericLiteral(n);
        stringScalarFunction.getArgs().add((Object)literal);
        return stringScalarFunction;
    }

    public IStringScalarFunction _substring(INumeric iNumeric, INumeric iNumeric2) {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.SUBSTRING_LITERAL);
        this.addASTFieldToScalarFunction(stringScalarFunction);
        QueryDataElement queryDataElement = QueryastFactory.eINSTANCE.createQueryDataElement(iNumeric);
        stringScalarFunction.getArgs().add((Object)queryDataElement);
        QueryDataElement queryDataElement2 = QueryastFactory.eINSTANCE.createQueryDataElement(iNumeric2);
        stringScalarFunction.getArgs().add((Object)queryDataElement2);
        return stringScalarFunction;
    }

    public IStringScalarFunction _concat(IString iString) {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.CONCAT_LITERAL);
        this.addASTFieldToScalarFunction(stringScalarFunction);
        QueryDataElement queryDataElement = QueryastFactory.eINSTANCE.createQueryDataElement(iString);
        stringScalarFunction.getArgs().add((Object)queryDataElement);
        return stringScalarFunction;
    }

    public IStringScalarFunction _concat(String string) {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.CONCAT_LITERAL);
        this.addASTFieldToScalarFunction(stringScalarFunction);
        Literal literal = QueryastFactory.eINSTANCE.createStringLiteral(string);
        stringScalarFunction.getArgs().add((Object)literal);
        return stringScalarFunction;
    }

    private StringScalarFunction createStringScalarFunction(FunctionType functionType) {
        StringScalarFunction stringScalarFunction = QueryastFactory.eINSTANCE.createStringScalarFunction(functionType);
        return stringScalarFunction;
    }

    private NumericScalarFunction createNumericScalarFunction(FunctionType functionType) {
        NumericScalarFunction numericScalarFunction = QueryastFactory.eINSTANCE.createNumericScalarFunction(functionType);
        return numericScalarFunction;
    }

    private void addASTFieldToScalarFunction(ScalarFunction scalarFunction) {
        FeaturePath featurePath = QueryastFactory.eINSTANCE.createFeaturePath(this);
        scalarFunction.getArgs().add((Object)featurePath);
    }

    public IPredicate _eq(IString iString) {
        return this.createBasicComparison(ComparisonOp.EQUALS_LITERAL, iString);
    }

    public IPredicate _eq(String string) {
        return this.createBasicComparison(ComparisonOp.EQUALS_LITERAL, string);
    }

    public IPredicate _notEq(IString iString) {
        return this.createBasicComparison(ComparisonOp.NOT_EQUALS_LITERAL, iString);
    }

    public IPredicate _notEq(String string) {
        return this.createBasicComparison(ComparisonOp.NOT_EQUALS_LITERAL, string);
    }

    private IPredicate createBasicComparison(ComparisonOp comparisonOp, String string) {
        FeaturePath featurePath = QueryastFactory.eINSTANCE.createFeaturePath(this);
        return QueryastFactory.eINSTANCE.createBasicComparison(comparisonOp, (FilterElement)featurePath, string);
    }

    private IPredicate createBasicComparison(ComparisonOp comparisonOp, IString iString) {
        FeaturePath featurePath = QueryastFactory.eINSTANCE.createFeaturePath(this);
        return QueryastFactory.eINSTANCE.createBasicComparison(comparisonOp, (FilterElement)featurePath, iString);
    }

    public IPredicate _inLargeList(IInListValueSource iInListValueSource) {
        FeaturePath featurePath = QueryastFactory.eINSTANCE.createFeaturePath(this);
        InList inList = QueryastFactory.eINSTANCE.createInList();
        inList.setField(featurePath);
        inList.setInputValueSource(iInListValueSource);
        return inList;
    }
}

