/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.querypath;

import com.ibm.team.repository.common.internal.queryast.ComparisonOp;
import com.ibm.team.repository.common.internal.queryast.ElementType;
import com.ibm.team.repository.common.internal.queryast.FeaturePath;
import com.ibm.team.repository.common.internal.queryast.FilterElement;
import com.ibm.team.repository.common.internal.queryast.FunctionType;
import com.ibm.team.repository.common.internal.queryast.InList;
import com.ibm.team.repository.common.internal.queryast.Literal;
import com.ibm.team.repository.common.internal.queryast.NumericScalarFunction;
import com.ibm.team.repository.common.internal.queryast.QueryDataElement;
import com.ibm.team.repository.common.internal.queryast.QueryastFactory;
import com.ibm.team.repository.common.internal.querypath.AbstractQueryModelField;
import com.ibm.team.repository.common.internal.querypath.IQueryPath;
import com.ibm.team.repository.common.query.ast.IInListValueSource;
import com.ibm.team.repository.common.query.ast.INumeric;
import com.ibm.team.repository.common.query.ast.INumericField;
import com.ibm.team.repository.common.query.ast.INumericScalarFunction;
import com.ibm.team.repository.common.query.ast.IPredicate;
import java.math.BigDecimal;

public class NumericField
extends AbstractQueryModelField
implements INumericField {
    private ElementType type;

    public NumericField(IQueryPath iQueryPath, String string, String string2) {
        this.name(string);
        this.parent(iQueryPath);
        if (Integer.class.getName().equals(string2)) {
            this.type = ElementType.INT_LITERAL;
        } else if (Long.class.getName().equals(string2)) {
            this.type = ElementType.LONG_LITERAL;
        } else if (BigDecimal.class.getName().equals(string2)) {
            this.type = ElementType.BIG_DECIMAL_LITERAL;
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported numeric type: " + string2);
        }
    }

    public ElementType getFieldType() {
        return this.type;
    }

    public IPredicate _in(Number[] numberArray) {
        this.checkInPredicateValueArray(numberArray);
        FeaturePath featurePath = QueryastFactory.eINSTANCE.createFeaturePath(this);
        InList inList = QueryastFactory.eINSTANCE.createInList();
        inList.setField(featurePath);
        Number[] numberArray2 = numberArray;
        int n = numberArray.length;
        int n2 = 0;
        while (n2 < n) {
            Number number = numberArray2[n2];
            Literal literal = QueryastFactory.eINSTANCE.createNumericLiteral(number);
            inList.getValues().add((Object)literal);
            ++n2;
        }
        return inList;
    }

    public IPredicate _in(INumeric[] iNumericArray) {
        this.checkInPredicateValueArray(iNumericArray);
        FeaturePath featurePath = QueryastFactory.eINSTANCE.createFeaturePath(this);
        InList inList = QueryastFactory.eINSTANCE.createInList();
        inList.setField(featurePath);
        INumeric[] iNumericArray2 = iNumericArray;
        int n = iNumericArray.length;
        int n2 = 0;
        while (n2 < n) {
            INumeric iNumeric = iNumericArray2[n2];
            this.checkInPredicateNullValue(iNumeric);
            FilterElement filterElement = QueryastFactory.eINSTANCE.createFilterElement(iNumeric);
            inList.getValues().add((Object)filterElement);
            ++n2;
        }
        return inList;
    }

    public IPredicate _inLargeList(IInListValueSource iInListValueSource) {
        FeaturePath featurePath = QueryastFactory.eINSTANCE.createFeaturePath(this);
        InList inList = QueryastFactory.eINSTANCE.createInList();
        inList.setField(featurePath);
        inList.setInputValueSource(iInListValueSource);
        return inList;
    }

    public INumericScalarFunction _abs() {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.ABS_LITERAL);
        return numericScalarFunction;
    }

    public INumericScalarFunction _mod(INumeric iNumeric) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.MOD_LITERAL);
        QueryDataElement queryDataElement = QueryastFactory.eINSTANCE.createQueryDataElement(iNumeric);
        numericScalarFunction.getArgs().add((Object)queryDataElement);
        return numericScalarFunction;
    }

    public INumericScalarFunction _mod(Integer n) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.MOD_LITERAL);
        Literal literal = QueryastFactory.eINSTANCE.createNumericLiteral(n);
        numericScalarFunction.getArgs().add((Object)literal);
        return numericScalarFunction;
    }

    public INumericScalarFunction _sqrt() {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.SQRT_LITERAL);
        return numericScalarFunction;
    }

    private NumericScalarFunction createNumericScalarFunction(FunctionType functionType) {
        NumericScalarFunction numericScalarFunction = QueryastFactory.eINSTANCE.createNumericScalarFunction(functionType);
        FeaturePath featurePath = QueryastFactory.eINSTANCE.createFeaturePath(this);
        numericScalarFunction.getArgs().add((Object)featurePath);
        return numericScalarFunction;
    }

    public IPredicate _eq(Number number) {
        return this.createBasicComparison(ComparisonOp.EQUALS_LITERAL, number);
    }

    public IPredicate _eq(INumeric iNumeric) {
        return this.createBasicComparison(ComparisonOp.EQUALS_LITERAL, iNumeric);
    }

    public IPredicate _notEq(Number number) {
        return this.createBasicComparison(ComparisonOp.NOT_EQUALS_LITERAL, number);
    }

    public IPredicate _notEq(INumeric iNumeric) {
        return this.createBasicComparison(ComparisonOp.NOT_EQUALS_LITERAL, iNumeric);
    }

    public IPredicate _gt(Number number) {
        return this.createBasicComparison(ComparisonOp.GREATER_THAN_LITERAL, number);
    }

    public IPredicate _gt(INumeric iNumeric) {
        return this.createBasicComparison(ComparisonOp.GREATER_THAN_LITERAL, iNumeric);
    }

    public IPredicate _gtOrEq(Number number) {
        return this.createBasicComparison(ComparisonOp.GT_OR_EQ_LITERAL, number);
    }

    public IPredicate _gtOrEq(INumeric iNumeric) {
        return this.createBasicComparison(ComparisonOp.GT_OR_EQ_LITERAL, iNumeric);
    }

    public IPredicate _lt(Number number) {
        return this.createBasicComparison(ComparisonOp.LESS_THAN_LITERAL, number);
    }

    public IPredicate _lt(INumeric iNumeric) {
        return this.createBasicComparison(ComparisonOp.LESS_THAN_LITERAL, iNumeric);
    }

    public IPredicate _ltOrEq(Number number) {
        return this.createBasicComparison(ComparisonOp.LT_OR_EQ_LITERAL, number);
    }

    public IPredicate _ltOrEq(INumeric iNumeric) {
        return this.createBasicComparison(ComparisonOp.LT_OR_EQ_LITERAL, iNumeric);
    }

    private IPredicate createBasicComparison(ComparisonOp comparisonOp, Number number) {
        FeaturePath featurePath = QueryastFactory.eINSTANCE.createFeaturePath(this);
        return QueryastFactory.eINSTANCE.createBasicComparison(comparisonOp, (FilterElement)featurePath, number);
    }

    private IPredicate createBasicComparison(ComparisonOp comparisonOp, INumeric iNumeric) {
        FeaturePath featurePath = QueryastFactory.eINSTANCE.createFeaturePath(this);
        return QueryastFactory.eINSTANCE.createBasicComparison(comparisonOp, (FilterElement)featurePath, iNumeric);
    }
}

