/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.queryast.impl;

import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.queryast.AggregateFunction;
import com.ibm.team.repository.common.internal.queryast.AggregateFunctionType;
import com.ibm.team.repository.common.internal.queryast.AstQuery;
import com.ibm.team.repository.common.internal.queryast.BasicComparison;
import com.ibm.team.repository.common.internal.queryast.BasicComparisonStateExtension;
import com.ibm.team.repository.common.internal.queryast.BinaryConditionalExpression;
import com.ibm.team.repository.common.internal.queryast.BinaryOp;
import com.ibm.team.repository.common.internal.queryast.ComparisonOp;
import com.ibm.team.repository.common.internal.queryast.Count;
import com.ibm.team.repository.common.internal.queryast.ElementType;
import com.ibm.team.repository.common.internal.queryast.Exists;
import com.ibm.team.repository.common.internal.queryast.FeaturePath;
import com.ibm.team.repository.common.internal.queryast.FilterElement;
import com.ibm.team.repository.common.internal.queryast.FunctionType;
import com.ibm.team.repository.common.internal.queryast.InList;
import com.ibm.team.repository.common.internal.queryast.InListStateExtension;
import com.ibm.team.repository.common.internal.queryast.InputArg;
import com.ibm.team.repository.common.internal.queryast.IsEmpty;
import com.ibm.team.repository.common.internal.queryast.IsMemberOf;
import com.ibm.team.repository.common.internal.queryast.IsMissing;
import com.ibm.team.repository.common.internal.queryast.IsNull;
import com.ibm.team.repository.common.internal.queryast.IsNullStateExtension;
import com.ibm.team.repository.common.internal.queryast.IsTypeOf;
import com.ibm.team.repository.common.internal.queryast.ItemTypePseudoVariable;
import com.ibm.team.repository.common.internal.queryast.Like;
import com.ibm.team.repository.common.internal.queryast.Literal;
import com.ibm.team.repository.common.internal.queryast.Not;
import com.ibm.team.repository.common.internal.queryast.NumericScalarFunction;
import com.ibm.team.repository.common.internal.queryast.OrderBy;
import com.ibm.team.repository.common.internal.queryast.Parens;
import com.ibm.team.repository.common.internal.queryast.Predicate;
import com.ibm.team.repository.common.internal.queryast.QueryDataElement;
import com.ibm.team.repository.common.internal.queryast.QueryastFactory;
import com.ibm.team.repository.common.internal.queryast.QueryastPackage;
import com.ibm.team.repository.common.internal.queryast.ScalarFunction;
import com.ibm.team.repository.common.internal.queryast.StringScalarFunction;
import com.ibm.team.repository.common.internal.queryast.impl.AggregateFunctionImpl;
import com.ibm.team.repository.common.internal.queryast.impl.AstQueryImpl;
import com.ibm.team.repository.common.internal.queryast.impl.BasicComparisonImpl;
import com.ibm.team.repository.common.internal.queryast.impl.BasicComparisonStateExtensionImpl;
import com.ibm.team.repository.common.internal.queryast.impl.BinaryConditionalExpressionImpl;
import com.ibm.team.repository.common.internal.queryast.impl.CountImpl;
import com.ibm.team.repository.common.internal.queryast.impl.ExistsImpl;
import com.ibm.team.repository.common.internal.queryast.impl.FeaturePathImpl;
import com.ibm.team.repository.common.internal.queryast.impl.InListImpl;
import com.ibm.team.repository.common.internal.queryast.impl.InListStateExtensionImpl;
import com.ibm.team.repository.common.internal.queryast.impl.InputArgEntryImpl;
import com.ibm.team.repository.common.internal.queryast.impl.InputArgImpl;
import com.ibm.team.repository.common.internal.queryast.impl.IsEmptyImpl;
import com.ibm.team.repository.common.internal.queryast.impl.IsMemberOfImpl;
import com.ibm.team.repository.common.internal.queryast.impl.IsMissingImpl;
import com.ibm.team.repository.common.internal.queryast.impl.IsNullImpl;
import com.ibm.team.repository.common.internal.queryast.impl.IsNullStateExtensionImpl;
import com.ibm.team.repository.common.internal.queryast.impl.IsTypeOfImpl;
import com.ibm.team.repository.common.internal.queryast.impl.ItemTypePseudoVariableImpl;
import com.ibm.team.repository.common.internal.queryast.impl.LikeImpl;
import com.ibm.team.repository.common.internal.queryast.impl.LiteralImpl;
import com.ibm.team.repository.common.internal.queryast.impl.NotImpl;
import com.ibm.team.repository.common.internal.queryast.impl.NumericScalarFunctionImpl;
import com.ibm.team.repository.common.internal.queryast.impl.OrderByImpl;
import com.ibm.team.repository.common.internal.queryast.impl.ParensImpl;
import com.ibm.team.repository.common.internal.queryast.impl.ScalarFunctionImpl;
import com.ibm.team.repository.common.internal.queryast.impl.StringScalarFunctionImpl;
import com.ibm.team.repository.common.internal.querypath.AbstractQueryModelField;
import com.ibm.team.repository.common.internal.querypath.AbstractQueryPathModel;
import com.ibm.team.repository.common.internal.querypath.AbstractQueryPathModel$Implementation;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.internal.util.SafeSimpleDataFormat;
import com.ibm.team.repository.common.query.ast.IEnum;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IFilterElement;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class QueryastFactoryImpl
extends EFactoryImpl
implements QueryastFactory {
    public static QueryastFactory init() {
        try {
            QueryastFactory queryastFactory = (QueryastFactory)EPackage.Registry.INSTANCE.getEFactory("com.ibm.team.repository.query");
            if (queryastFactory != null) {
                return queryastFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new QueryastFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createAstQuery();
            }
            case 1: {
                return this.createBasicComparisonStateExtension();
            }
            case 2: {
                return this.createInListStateExtension();
            }
            case 4: {
                return this.createAggregateFunction();
            }
            case 5: {
                return this.createCount();
            }
            case 6: {
                return this.createFeaturePath();
            }
            case 7: {
                return this.createInputArg();
            }
            case 8: {
                return this.createLiteral();
            }
            case 9: {
                return this.createOrderBy();
            }
            case 10: {
                return this.createScalarFunction();
            }
            case 11: {
                return this.createNumericScalarFunction();
            }
            case 12: {
                return this.createStringScalarFunction();
            }
            case 14: {
                return (EObject)this.createInputArgEntry();
            }
            case 15: {
                return this.createBasicComparison();
            }
            case 16: {
                return this.createBinaryConditionalExpression();
            }
            case 19: {
                return this.createNot();
            }
            case 20: {
                return this.createParens();
            }
            case 21: {
                return this.createInList();
            }
            case 22: {
                return this.createIsEmpty();
            }
            case 23: {
                return this.createIsMemberOf();
            }
            case 24: {
                return this.createIsNull();
            }
            case 25: {
                return this.createIsNullStateExtension();
            }
            case 26: {
                return this.createIsTypeOf();
            }
            case 27: {
                return this.createLike();
            }
            case 31: {
                return this.createIsMissing();
            }
            case 33: {
                return this.createItemTypePseudoVariable();
            }
            case 34: {
                return this.createExists();
            }
        }
        throw (Throwable)new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String string) {
        switch (eDataType.getClassifierID()) {
            case 35: {
                return this.createElementTypeFromString(eDataType, string);
            }
            case 36: {
                return this.createComparisonOpFromString(eDataType, string);
            }
            case 37: {
                return this.createBinaryOpFromString(eDataType, string);
            }
            case 38: {
                return this.createFunctionTypeFromString(eDataType, string);
            }
            case 39: {
                return this.createAggregateFunctionTypeFromString(eDataType, string);
            }
        }
        throw (Throwable)new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object object) {
        switch (eDataType.getClassifierID()) {
            case 35: {
                return this.convertElementTypeToString(eDataType, object);
            }
            case 36: {
                return this.convertComparisonOpToString(eDataType, object);
            }
            case 37: {
                return this.convertBinaryOpToString(eDataType, object);
            }
            case 38: {
                return this.convertFunctionTypeToString(eDataType, object);
            }
            case 39: {
                return this.convertAggregateFunctionTypeToString(eDataType, object);
            }
        }
        throw (Throwable)new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public AstQuery createAstQuery() {
        AstQueryImpl astQueryImpl = new AstQueryImpl();
        return astQueryImpl;
    }

    public AggregateFunction createAggregateFunction() {
        AggregateFunctionImpl aggregateFunctionImpl = new AggregateFunctionImpl();
        return aggregateFunctionImpl;
    }

    public AggregateFunction createAggregateFunction(AggregateFunctionType aggregateFunctionType) {
        AggregateFunction aggregateFunction = this.createAggregateFunction();
        aggregateFunction.setFunction(aggregateFunctionType);
        return aggregateFunction;
    }

    public Count createCount() {
        CountImpl countImpl = new CountImpl();
        countImpl.setFunction(AggregateFunctionType.COUNT_LITERAL);
        return countImpl;
    }

    public FeaturePath createFeaturePath() {
        FeaturePathImpl featurePathImpl = new FeaturePathImpl();
        return featurePathImpl;
    }

    public Count createCount(FeaturePath featurePath) {
        Count count = this.createCount();
        count.setField(featurePath);
        count.setFunction(AggregateFunctionType.COUNT_LITERAL);
        return count;
    }

    public Count createCountDistinct(FeaturePath featurePath, boolean bl) {
        Count count = this.createCount();
        count.setField(featurePath);
        count.setFunction(AggregateFunctionType.COUNT_LITERAL);
        count.setDistinct(bl);
        return count;
    }

    public FeaturePath createFeaturePath(IField iField) {
        AbstractQueryModelField abstractQueryModelField = (AbstractQueryModelField)iField;
        FeaturePath featurePath = this.createFeaturePath(abstractQueryModelField);
        featurePath.setKind(abstractQueryModelField.getFieldType());
        this.setRoot(featurePath, abstractQueryModelField);
        return featurePath;
    }

    private void setRoot(FeaturePath featurePath, AbstractQueryModelField abstractQueryModelField) {
        AbstractQueryPathModel$Implementation abstractQueryPathModel$Implementation = AbstractQueryPathModel.getImplementation(abstractQueryModelField.getRoot());
        featurePath.setPathRootItemType(abstractQueryPathModel$Implementation.getItemType());
    }

    public FeaturePath createFeaturePath(IQueryModel iQueryModel) {
        AbstractQueryPathModel$Implementation abstractQueryPathModel$Implementation = AbstractQueryPathModel.getImplementation(iQueryModel);
        FeaturePath featurePath = this.createFeaturePath();
        featurePath.setPath(abstractQueryPathModel$Implementation.toPathString());
        featurePath.setKind(ElementType.REFERENCE_LITERAL);
        this.setRoot(featurePath, iQueryModel);
        return featurePath;
    }

    private void setRoot(FeaturePath featurePath, IQueryModel iQueryModel) {
        AbstractQueryPathModel$Implementation abstractQueryPathModel$Implementation = AbstractQueryPathModel.getImplementation(iQueryModel);
        AbstractQueryPathModel$Implementation abstractQueryPathModel$Implementation2 = AbstractQueryPathModel.getImplementation(abstractQueryPathModel$Implementation.getRoot());
        featurePath.setPathRootItemType(abstractQueryPathModel$Implementation2.getItemType());
    }

    private FeaturePath createFeaturePath(AbstractQueryModelField abstractQueryModelField) {
        FeaturePath featurePath = this.createFeaturePath();
        featurePath.setPath(abstractQueryModelField.toPathString());
        return featurePath;
    }

    public FilterElement createFilterElement(IFilterElement iFilterElement) {
        if (iFilterElement instanceof IField) {
            return this.createFeaturePath((IField)iFilterElement);
        }
        return (FilterElement)EcoreUtil.copy((EObject)((EObject)iFilterElement));
    }

    public QueryDataElement createQueryDataElement(IFilterElement iFilterElement) {
        if (iFilterElement instanceof IField) {
            return this.createFeaturePath((IField)iFilterElement);
        }
        return (QueryDataElement)EcoreUtil.copy((EObject)((EObject)iFilterElement));
    }

    public InputArg createInputArg() {
        InputArgImpl inputArgImpl = new InputArgImpl();
        return inputArgImpl;
    }

    public Literal createLiteral() {
        LiteralImpl literalImpl = new LiteralImpl();
        return literalImpl;
    }

    public Literal createDateTimeLiteral(Date date) {
        Literal literal = this.createLiteral();
        literal.setKind(ElementType.DATE_TIME_LITERAL);
        literal.setStringValue(SafeSimpleDataFormat.DATE_FORMATS[0].format(date));
        return literal;
    }

    public Literal createStringLiteral(String string) {
        Literal literal = this.createLiteral();
        literal.setKind(ElementType.STRING_LITERAL);
        literal.setStringValue(string);
        return literal;
    }

    public Literal createNumericLiteral(Number number) {
        Literal literal = this.createLiteral();
        if (number instanceof Byte || number instanceof Short || number instanceof Integer) {
            literal.setKind(ElementType.INT_LITERAL);
        } else if (number instanceof Long) {
            literal.setKind(ElementType.LONG_LITERAL);
        } else if (number instanceof Float || number instanceof Double || number instanceof BigDecimal) {
            literal.setKind(ElementType.BIG_DECIMAL_LITERAL);
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported literal type: " + number.getClass());
        }
        literal.setStringValue(String.valueOf(number));
        return literal;
    }

    public Literal createUUIDLiteral(UUID uUID) {
        Literal literal = this.createLiteral();
        literal.setKind(ElementType.UUID_LITERAL);
        literal.setStringValue(uUID.getUuidValue());
        return literal;
    }

    public Literal createBooleanLiteral(Boolean bl) {
        Literal literal = this.createLiteral();
        literal.setKind(ElementType.BOOLEAN_LITERAL);
        literal.setStringValue(bl != false ? "1" : "0");
        return literal;
    }

    public Literal createItemTypeLiteral(IItemType iItemType) {
        Literal literal = this.createLiteral();
        literal.setKind(ElementType.ITEM_TYPE_LITERAL);
        literal.setStringValue(ItemUtil.itemType2String(iItemType));
        return literal;
    }

    public OrderBy createOrderBy() {
        OrderByImpl orderByImpl = new OrderByImpl();
        return orderByImpl;
    }

    public ScalarFunction createScalarFunction() {
        ScalarFunctionImpl scalarFunctionImpl = new ScalarFunctionImpl();
        return scalarFunctionImpl;
    }

    public NumericScalarFunction createNumericScalarFunction() {
        NumericScalarFunctionImpl numericScalarFunctionImpl = new NumericScalarFunctionImpl();
        return numericScalarFunctionImpl;
    }

    public NumericScalarFunction createNumericScalarFunction(FunctionType functionType) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction();
        numericScalarFunction.setFunction(functionType);
        return numericScalarFunction;
    }

    public StringScalarFunction createStringScalarFunction() {
        StringScalarFunctionImpl stringScalarFunctionImpl = new StringScalarFunctionImpl();
        return stringScalarFunctionImpl;
    }

    public StringScalarFunction createStringScalarFunction(FunctionType functionType) {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction();
        stringScalarFunction.setFunction(functionType);
        return stringScalarFunction;
    }

    public Map.Entry createInputArgEntry() {
        InputArgEntryImpl inputArgEntryImpl = new InputArgEntryImpl();
        return (Map.Entry)((Object)inputArgEntryImpl);
    }

    public BinaryConditionalExpression createBinaryConditionalExpression() {
        BinaryConditionalExpressionImpl binaryConditionalExpressionImpl = new BinaryConditionalExpressionImpl();
        return binaryConditionalExpressionImpl;
    }

    public BinaryConditionalExpression createBinaryConditionalExpression(Predicate predicate, BinaryOp binaryOp, Predicate predicate2) {
        BinaryConditionalExpression binaryConditionalExpression = this.createBinaryConditionalExpression();
        binaryConditionalExpression.setLhs(predicate);
        binaryConditionalExpression.setRhs(predicate2);
        binaryConditionalExpression.setOperator(binaryOp);
        return binaryConditionalExpression;
    }

    public BasicComparison createBasicComparison() {
        BasicComparisonImpl basicComparisonImpl = new BasicComparisonImpl();
        return basicComparisonImpl;
    }

    public BasicComparisonStateExtension createBasicComparisonStateExtension() {
        BasicComparisonStateExtensionImpl basicComparisonStateExtensionImpl = new BasicComparisonStateExtensionImpl();
        return basicComparisonStateExtensionImpl;
    }

    private IPredicate createComparisonPredicate(ComparisonOp comparisonOp, FilterElement filterElement, FilterElement filterElement2) {
        BasicComparison basicComparison = this.createBasicComparison();
        basicComparison.setOperator(comparisonOp);
        basicComparison.setLhs(filterElement);
        basicComparison.setRhs(filterElement2);
        return basicComparison;
    }

    public IPredicate createBasicComparisonStateExtension(ComparisonOp comparisonOp, FilterElement filterElement, FilterElement filterElement2, FilterElement filterElement3) {
        BasicComparisonStateExtension basicComparisonStateExtension = this.createBasicComparisonStateExtension();
        basicComparisonStateExtension.setOperator(comparisonOp);
        basicComparisonStateExtension.setKey(filterElement);
        basicComparisonStateExtension.setLhs(filterElement2);
        basicComparisonStateExtension.setRhs(filterElement3);
        return basicComparisonStateExtension;
    }

    public IPredicate createBasicComparison(ComparisonOp comparisonOp, FilterElement filterElement, IFilterElement iFilterElement) {
        FilterElement filterElement2 = this.createFilterElement(iFilterElement);
        return this.createComparisonPredicate(comparisonOp, filterElement, filterElement2);
    }

    public IPredicate createBasicComparison(ComparisonOp comparisonOp, FilterElement filterElement, Date date) {
        Literal literal = this.createDateTimeLiteral(date);
        return this.createBasicComparison(comparisonOp, filterElement, literal);
    }

    public IPredicate createBasicComparison(ComparisonOp comparisonOp, FilterElement filterElement, Number number) {
        Literal literal = this.createNumericLiteral(number);
        return this.createComparisonPredicate(comparisonOp, filterElement, literal);
    }

    public IPredicate createBasicComparison(ComparisonOp comparisonOp, FilterElement filterElement, String string) {
        Literal literal = this.createStringLiteral(string);
        return this.createComparisonPredicate(comparisonOp, filterElement, literal);
    }

    public IPredicate createBasicComparisonStateExtension(ComparisonOp comparisonOp, FilterElement filterElement, FilterElement filterElement2, String string) {
        Literal literal = this.createStringLiteral(string);
        return this.createBasicComparisonStateExtension(comparisonOp, filterElement, filterElement2, literal);
    }

    public IPredicate createBasicComparison(ComparisonOp comparisonOp, FilterElement filterElement, UUID uUID) {
        Literal literal = this.createUUIDLiteral(uUID);
        return this.createComparisonPredicate(comparisonOp, filterElement, literal);
    }

    public IPredicate createBasicComparison(ComparisonOp comparisonOp, FilterElement filterElement, IEnum iEnum) {
        FilterElement filterElement2 = this.createFilterElement(iEnum);
        return this.createComparisonPredicate(comparisonOp, filterElement, filterElement2);
    }

    public IPredicate createBasicComparison(ComparisonOp comparisonOp, FilterElement filterElement, Boolean bl) {
        Literal literal = this.createBooleanLiteral(bl);
        return this.createComparisonPredicate(comparisonOp, filterElement, literal);
    }

    public Not createNot() {
        NotImpl notImpl = new NotImpl();
        return notImpl;
    }

    public Not createNot(Predicate predicate) {
        Not not = this.createNot();
        not.setPredicate(predicate);
        return not;
    }

    public Parens createParens() {
        ParensImpl parensImpl = new ParensImpl();
        return parensImpl;
    }

    public Parens createParens(Predicate predicate) {
        Parens parens = this.createParens();
        parens.setPredicate(predicate);
        return parens;
    }

    public InList createInList() {
        InListImpl inListImpl = new InListImpl();
        return inListImpl;
    }

    public InListStateExtension createInListStateExtension() {
        InListStateExtensionImpl inListStateExtensionImpl = new InListStateExtensionImpl();
        return inListStateExtensionImpl;
    }

    public IsEmpty createIsEmpty() {
        IsEmptyImpl isEmptyImpl = new IsEmptyImpl();
        return isEmptyImpl;
    }

    public IsMemberOf createIsMemberOf() {
        IsMemberOfImpl isMemberOfImpl = new IsMemberOfImpl();
        return isMemberOfImpl;
    }

    public IsNull createIsNull() {
        IsNullImpl isNullImpl = new IsNullImpl();
        return isNullImpl;
    }

    public IsNullStateExtension createIsNullStateExtension() {
        IsNullStateExtensionImpl isNullStateExtensionImpl = new IsNullStateExtensionImpl();
        return isNullStateExtensionImpl;
    }

    public IsTypeOf createIsTypeOf() {
        IsTypeOfImpl isTypeOfImpl = new IsTypeOfImpl();
        return isTypeOfImpl;
    }

    public Like createLike() {
        LikeImpl likeImpl = new LikeImpl();
        return likeImpl;
    }

    public IsMissing createIsMissing() {
        IsMissingImpl isMissingImpl = new IsMissingImpl();
        return isMissingImpl;
    }

    public ItemTypePseudoVariable createItemTypePseudoVariable() {
        ItemTypePseudoVariableImpl itemTypePseudoVariableImpl = new ItemTypePseudoVariableImpl();
        return itemTypePseudoVariableImpl;
    }

    public Exists createExists() {
        ExistsImpl existsImpl = new ExistsImpl();
        return existsImpl;
    }

    public ElementType createElementTypeFromString(EDataType eDataType, String string) {
        ElementType elementType = ElementType.get(string);
        if (elementType == null) {
            throw (Throwable)new IllegalArgumentException("The value '" + string + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return elementType;
    }

    public String convertElementTypeToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    public ComparisonOp createComparisonOpFromString(EDataType eDataType, String string) {
        ComparisonOp comparisonOp = ComparisonOp.get(string);
        if (comparisonOp == null) {
            throw (Throwable)new IllegalArgumentException("The value '" + string + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return comparisonOp;
    }

    public String convertComparisonOpToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    public BinaryOp createBinaryOpFromString(EDataType eDataType, String string) {
        BinaryOp binaryOp = BinaryOp.get(string);
        if (binaryOp == null) {
            throw (Throwable)new IllegalArgumentException("The value '" + string + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return binaryOp;
    }

    public String convertBinaryOpToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    public FunctionType createFunctionTypeFromString(EDataType eDataType, String string) {
        FunctionType functionType = FunctionType.get(string);
        if (functionType == null) {
            throw (Throwable)new IllegalArgumentException("The value '" + string + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return functionType;
    }

    public String convertFunctionTypeToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    public AggregateFunctionType createAggregateFunctionTypeFromString(EDataType eDataType, String string) {
        AggregateFunctionType aggregateFunctionType = AggregateFunctionType.get(string);
        if (aggregateFunctionType == null) {
            throw (Throwable)new IllegalArgumentException("The value '" + string + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return aggregateFunctionType;
    }

    public String convertAggregateFunctionTypeToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    public QueryastPackage getQueryastPackage() {
        return (QueryastPackage)this.getEPackage();
    }

    public static QueryastPackage getPackage() {
        return QueryastPackage.eINSTANCE;
    }
}

