/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class UUID
implements Comparable {
    private static char[] LASTCHAR_DIGITS = new char[]{'A', 'Q', 'g', 'w'};
    private long msb;
    private long lsb;
    private static final char[] BASE64_DIGITS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
    private static final char UUID_STARTS_WITH;
    private static final int UUID_CHAR_LENGTH;
    private static final char MAX_UUID_CHAR;
    private static final int[] DIGIT_MAP;
    private static final int[] LASTCHAR_DIGIT_MAP;

    static {
        UUID.sortCharArray(BASE64_DIGITS);
        UUID.sortCharArray(LASTCHAR_DIGITS);
        UUID_STARTS_WITH = (char)95;
        UUID_CHAR_LENGTH = 23;
        MAX_UUID_CHAR = (char)128;
        DIGIT_MAP = UUID.computeInverseMap(BASE64_DIGITS);
        LASTCHAR_DIGIT_MAP = UUID.computeInverseMap(LASTCHAR_DIGITS);
    }

    public static UUID generate() {
        return UUID.createFrom(EcoreUtil.generateUUID().toCharArray());
    }

    public static UUID valueOf(String string) {
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("null UUID");
        }
        char[] cArray = string.trim().toCharArray();
        if (!UUID.validateUUID(cArray)) {
            throw (Throwable)new IllegalArgumentException(String.format("invalid UUID [%s]", string));
        }
        return UUID.createFrom(cArray);
    }

    private static UUID createFrom(char[] cArray) {
        long l;
        char c;
        long l2 = 0L;
        int n = 1;
        while (n < 11) {
            c = cArray[n];
            l = DIGIT_MAP[c];
            l2 <<= 6;
            l2 |= l;
            ++n;
        }
        c = cArray[11];
        l = DIGIT_MAP[c];
        l2 <<= 4;
        l2 |= l >> 2;
        long l3 = l & 3L;
        int n2 = 12;
        while (n2 < 22) {
            c = cArray[n2];
            l = DIGIT_MAP[c];
            l3 <<= 6;
            l3 |= l;
            ++n2;
        }
        c = cArray[22];
        l = LASTCHAR_DIGIT_MAP[c];
        l3 <<= 2;
        return new UUID(l2, l3 |= l);
    }

    public int hashCode() {
        return (int)(this.msb ^ this.lsb ^ this.msb >> 32 ^ this.lsb >> 32);
    }

    public String getUuidValue() {
        char[] cArray = new char[UUID_CHAR_LENGTH];
        cArray[0] = 95;
        long l = this.lsb;
        cArray[22] = LASTCHAR_DIGITS[(int)(l & 3L)];
        l >>>= 2;
        int n = 21;
        while (n >= 12) {
            cArray[n] = BASE64_DIGITS[(int)(l & 0x3FL)];
            l >>>= 6;
            --n;
        }
        long l2 = this.msb;
        cArray[11] = BASE64_DIGITS[(int)(l | (l2 & 0xFL) << 2)];
        l2 >>>= 4;
        int n2 = 10;
        while (n2 != 0) {
            cArray[n2] = BASE64_DIGITS[(int)(l2 & 0x3FL)];
            l2 >>>= 6;
            --n2;
        }
        return new String(cArray);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof UUID)) {
            return false;
        }
        UUID uUID = (UUID)object;
        return this.msb == uUID.msb && this.lsb == uUID.lsb;
    }

    public int compareTo(Object object) {
        if (object instanceof UUID) {
            UUID uUID = (UUID)object;
            int n = this.unsignedCompare(this.msb, uUID.msb);
            if (n == 0) {
                return this.unsignedCompare(this.lsb, uUID.lsb);
            }
            return n;
        }
        return 1;
    }

    private int unsignedCompare(long l, long l2) {
        if (l == l2) {
            return 0;
        }
        long l3 = l >>> 32;
        long l4 = l2 >>> 32;
        if (l3 == l4) {
            long l5 = l & 0xFFFFFFFFFFFFFFFFL;
            long l6 = l2 & 0xFFFFFFFFFFFFFFFFL;
            return l5 < l6 ? -1 : 1;
        }
        return l3 < l4 ? -1 : 1;
    }

    public String toString() {
        return String.format("[UUID %s]", this.getUuidValue());
    }

    private static boolean validateUUID(char[] cArray) {
        int n = cArray.length;
        if (n != UUID_CHAR_LENGTH) {
            return false;
        }
        char[] cArray2 = cArray;
        if (cArray2[0] != UUID_STARTS_WITH) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            char c = cArray2[n2];
            if (c > MAX_UUID_CHAR || DIGIT_MAP[c] == -1) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private UUID(long l, long l2) {
        this.msb = l;
        this.lsb = l2;
    }

    private static int[] computeInverseMap(char[] cArray) {
        int[] nArray = new int[MAX_UUID_CHAR + '\u0001'];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = -1;
            ++n;
        }
        n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            if (c > MAX_UUID_CHAR) {
                throw (Throwable)new IllegalStateException();
            }
            nArray[c] = n++;
        }
        return nArray;
    }

    private static void sortCharArray(char[] cArray) {
        ArrayList<Character> arrayList = new ArrayList<Character>();
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            arrayList.add(Character.valueOf(c));
            ++n;
        }
        Collections.sort((List)arrayList);
        n = 0;
        for (Character c : arrayList) {
            cArray[n] = c.charValue();
            ++n;
        }
    }
}

