/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.util.NLS;
import java.util.Arrays;

public enum LineDelimiter {
    LINE_DELIMITER_NONE(0),
    LINE_DELIMITER_LF(1),
    LINE_DELIMITER_CR(2),
    LINE_DELIMITER_CRLF(3),
    LINE_DELIMITER_PLATFORM(4);

    private static final String[] PRETTY_NAME;
    private final int columnValue;
    private static final boolean IS_CRLF_PLATFORM;
    private static final boolean IS_LF_PLATFORM;
    private static final boolean IS_CR_PLATFORM;

    static {
        PRETTY_NAME = new String[]{"None", "LF (Unix)", "CR (Mac)", "CRLF (Windows)", "Platform"};
        IS_CRLF_PLATFORM = Arrays.equals(System.getProperty("line.separator").toCharArray(), new char[]{'\r', '\n'});
        IS_LF_PLATFORM = Arrays.equals(System.getProperty("line.separator").toCharArray(), new char[]{'\n'});
        IS_CR_PLATFORM = Arrays.equals(System.getProperty("line.separator").toCharArray(), new char[]{'\r'});
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private LineDelimiter() {
        void var3_2;
        this.columnValue = var3_2;
    }

    public int columnValue() {
        return this.columnValue;
    }

    public static LineDelimiter getLineDelimiter(int n) {
        LineDelimiter[] lineDelimiterArray = LineDelimiter.values();
        int n2 = lineDelimiterArray.length;
        int n3 = 0;
        while (n3 < n2) {
            LineDelimiter lineDelimiter = lineDelimiterArray[n3];
            if (lineDelimiter.columnValue() == n) {
                return lineDelimiter;
            }
            ++n3;
        }
        return null;
    }

    public static LineDelimiter fromString(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        while (n < PRETTY_NAME.length) {
            if (string.equals(PRETTY_NAME[n])) {
                return LineDelimiter.values()[n];
            }
            ++n;
        }
        return null;
    }

    public String asQuery() throws TeamRepositoryException {
        if (this == LINE_DELIMITER_NONE) {
            return "";
        }
        if (this == LINE_DELIMITER_LF) {
            return "LF";
        }
        if (this == LINE_DELIMITER_CR) {
            return "CR";
        }
        if (this == LINE_DELIMITER_CRLF) {
            return "CRLF";
        }
        String string = NLS.bind(Messages.getServerString("TeamContent.ErrorInvalidLineEnding"), (Object)this, new Object[0]);
        throw (Throwable)new TeamRepositoryException(string);
    }

    public static LineDelimiter fromQuery(String string) {
        if (string == null || string.length() == 0) {
            return LINE_DELIMITER_NONE;
        }
        if (string.equals("LF")) {
            return LINE_DELIMITER_LF;
        }
        if (string.equals("CR")) {
            return LINE_DELIMITER_CR;
        }
        if (string.equals("CRLF")) {
            return LINE_DELIMITER_CRLF;
        }
        throw (Throwable)new IllegalArgumentException("Unrecognized query string for delimiter type");
    }

    public static LineDelimiter getPlatformDelimiter() {
        if (IS_CRLF_PLATFORM) {
            return LINE_DELIMITER_CRLF;
        }
        if (IS_LF_PLATFORM) {
            return LINE_DELIMITER_LF;
        }
        if (IS_CR_PLATFORM) {
            return LINE_DELIMITER_CR;
        }
        throw (Throwable)new IllegalStateException();
    }

    public String toString() {
        return PRETTY_NAME[this.columnValue];
    }
}

