/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.scripting.facades;

import com.ibm.team.apt.internal.common.WorkflowUtils;
import com.ibm.team.apt.internal.common.scripting.AbstractWrapperScriptType;
import com.ibm.team.apt.internal.common.scripting.annotation.Function;
import com.ibm.team.apt.internal.common.scripting.annotation.ScriptType;
import com.ibm.team.apt.internal.common.scripting.annotation.WrapType;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScriptType(value="com.ibm.team.apt.client.WorkflowInfo")
@WrapType(value=IWorkflowInfo.class)
public class WorkflowInfoScriptType
extends AbstractWrapperScriptType<IWorkflowInfo> {
    private String[] fAllStateIds;

    public WorkflowInfoScriptType(Context cx, Scriptable scope, IWorkflowInfo wrapped) {
        super(cx, scope, (Object)wrapped);
    }

    @Function
    public String getId() {
        return ((IWorkflowInfo)this.getSubject()).getIdentifier();
    }

    @Function
    public String getStartStateId() {
        Identifier startActionId = ((IWorkflowInfo)this.getSubject()).getStartActionId();
        if (startActionId == null) {
            return this.getStateIds()[0];
        }
        return WorkflowInfoScriptType.getActionResultState((IWorkflowInfo)this.getSubject(), (Identifier<IWorkflowAction>)startActionId).getStringIdentifier();
    }

    @Function
    public String[] getStateIds() {
        if (this.fAllStateIds == null) {
            Identifier[] allStateIds = WorkflowUtils.getSortedStates((IWorkflowInfo)((IWorkflowInfo)this.getSubject()));
            this.fAllStateIds = new String[allStateIds.length];
            int i = 0;
            while (i < allStateIds.length) {
                this.fAllStateIds[i] = allStateIds[i].getStringIdentifier();
                ++i;
            }
        }
        return this.fAllStateIds;
    }

    @Function
    public int getStateGroup(String stateId) {
        return ((IWorkflowInfo)this.getSubject()).getStateGroup(Identifier.create(IState.class, (String)stateId));
    }

    @Function
    public String getStateLabel(String stateId) {
        return ((IWorkflowInfo)this.getSubject()).getStateName(Identifier.create(IState.class, (String)stateId));
    }

    @Function
    public String getActionResultState(String actionId) {
        return WorkflowInfoScriptType.getActionResultState((IWorkflowInfo)this.getSubject(), (Identifier<IWorkflowAction>)Identifier.create(IWorkflowAction.class, (String)actionId)).getStringIdentifier();
    }

    private static Identifier<IState> getActionResultState(IWorkflowInfo workflowInfo, Identifier<IWorkflowAction> action) {
        Identifier result = workflowInfo.getActionResultState(action);
        String stripOffPrefix = WorkflowInfoScriptType.stripOffPrefix(result.getStringIdentifier(), 's');
        return Identifier.create(IState.class, (String)stripOffPrefix);
    }

    private static String stripOffPrefix(String s, char prefix) {
        int l;
        if (s != null && (l = s.length()) > 1 && s.charAt(0) == prefix) {
            int i = 1;
            while (i < l) {
                if (!Character.isDigit(s.charAt(i))) {
                    return s;
                }
                ++i;
            }
            return s.substring(1);
        }
        return s;
    }
}

