/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.common.APTCommon;
import com.ibm.team.apt.common.resource.IContributorAbsence;
import com.ibm.team.apt.internal.client.DurationSupport;
import com.ibm.team.apt.internal.client.GetterKind;
import com.ibm.team.apt.internal.client.IAttributeRegistry;
import com.ibm.team.apt.internal.client.IItemResolveService;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.IPlanAttributeDelta;
import com.ibm.team.apt.internal.client.IPlanElementChangeEvent;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IPlanElementDeltaVisitor;
import com.ibm.team.apt.internal.client.IPlanElementListener;
import com.ibm.team.apt.internal.client.IPlanElementVisitor;
import com.ibm.team.apt.internal.client.IPlanItemAttributeSetter;
import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.IPlanningAttributeValueSet;
import com.ibm.team.apt.internal.client.IScheduleItem;
import com.ibm.team.apt.internal.client.ItemSequenceManager;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.Messages;
import com.ibm.team.apt.internal.client.MissingFutureExecutorServiceException;
import com.ibm.team.apt.internal.client.OutOfOfficeItem;
import com.ibm.team.apt.internal.client.PlanAttributeDelta;
import com.ibm.team.apt.internal.client.PlanAttributeRegistry;
import com.ibm.team.apt.internal.client.PlanDeltaBuilder;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanItemWorkItemAttribute;
import com.ibm.team.apt.internal.client.PlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ReflectiveAttribute;
import com.ibm.team.apt.internal.client.ScriptableAttribute;
import com.ibm.team.apt.internal.client.SetterKind;
import com.ibm.team.apt.internal.client.planchecker.CheckerReport;
import com.ibm.team.apt.internal.client.planchecker.IPlanCheckReportAcceptor;
import com.ibm.team.apt.internal.client.planchecker.PlanCheck;
import com.ibm.team.apt.internal.client.planchecker.PlanCheckEngine;
import com.ibm.team.apt.internal.client.planchecker.PlanCheckReport;
import com.ibm.team.apt.internal.client.resource.IContributorInfo;
import com.ibm.team.apt.internal.client.resource.IResourcePlanningListener;
import com.ibm.team.apt.internal.client.resource.ProjectWorkEnvironment;
import com.ibm.team.apt.internal.client.resource.ResourcePlanningEvent;
import com.ibm.team.apt.internal.client.resource.ResourcePlanningManager;
import com.ibm.team.apt.internal.client.teamload.LoadInformation;
import com.ibm.team.apt.internal.client.util.IDeferredResolveListener;
import com.ibm.team.apt.internal.client.util.WorkItems;
import com.ibm.team.apt.internal.common.IPlanningCommon;
import com.ibm.team.apt.internal.common.Iterations;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IProblemDescription;
import com.ibm.team.apt.internal.common.process.ConfigurationElementFactory;
import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.EstimateOutputFormat;
import com.ibm.team.apt.internal.common.util.IEventCondition;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemAwareMap;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.ItemCollections;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemHashSet;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.apt.internal.common.util.ItemSet;
import com.ibm.team.apt.internal.common.util.IterationHierarchy;
import com.ibm.team.apt.internal.common.util.PlanRunnable;
import com.ibm.team.foundation.rcp.core.readstate.IReadStateListener;
import com.ibm.team.foundation.rcp.core.readstate.IReadStateManager;
import com.ibm.team.foundation.rcp.core.readstate.ReadStateChangeEvent;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IReconcileReport;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.client.internal.WorkItemClient;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.model.WorkItemType;
import com.ibm.team.workitem.common.internal.util.SequenceValue;
import com.ibm.team.workitem.common.internal.workflow.WorkflowManager;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.workflow.ICombinedWorkflowInfos;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResolvedPlan
extends PlanElement {
    public static final IPlanningAttributeIdentifier RESOURCE_PLANNING = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planmodel.resourcePlanning");
    public static final IPlanningAttributeIdentifier REFERENCE_TIME = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planmodel.referenceTime");
    private ListenerList fListeners;
    private IItemResolveService fResolveService;
    private volatile int fConnectCounter;
    private final Object fDeltaBuilderLock = new Object();
    private volatile int fDeltaBuilderCounter;
    private PlanDeltaBuilder fDeltaBuilder;
    private ItemMap<IWorkItemHandle, IWorkItem> fWorkItemMap = ItemAwareMap.map((CMode)CMode.CURRENT_HANDLEONLY, new LinkedHashMap());
    private ItemMap<IWorkItemHandle, PlanItem> fWorkItem2PlanItem = ItemAwareMap.map((CMode)CMode.CURRENT_HANDLEONLY, new ConcurrentHashMap());
    private ItemMap<IWorkItemHandle, PlanItem> fRemovedWorkItems;
    private ItemMap<IWorkItemHandle, Integer> fIgnoredWorkItems = new ItemHashMap(CMode.CURRENT_HANDLEONLY);
    private ItemMap<IContributorHandle, IContributor> fOwners = ItemAwareMap.map((CMode)CMode.CURRENT_HANDLEONLY, new ConcurrentHashMap());
    private ItemMap<IContributorHandle, IContributor> fAllContributors = ItemAwareMap.map((CMode)CMode.CURRENT_HANDLEONLY, new ConcurrentHashMap());
    private ItemMap<ICategoryHandle, ICategory> fCategoriesMap = new ItemHashMap(CMode.CURRENT_HANDLEONLY);
    private ItemMap<IIterationHandle, IIteration> fIntervalMap = new ItemHashMap(CMode.CURRENT_HANDLEONLY);
    private ItemMap<IDevelopmentLineHandle, IDevelopmentLine> fDevelopmentLineMap = new ItemHashMap(CMode.CURRENT_HANDLEONLY);
    private ItemMap<IDevelopmentLineHandle, IterationHierarchy> fDevelopmentLineIterations = new ItemHashMap(CMode.CURRENT_HANDLEONLY);
    private ItemMap<IProcessAreaHandle, IProcessArea> fProcessAreaMap = new ItemHashMap(CMode.CURRENT_HANDLEONLY);
    private List<? extends Object> fWorkItemTransportObjects;
    private IContributor fNullOwner;
    private ICategory fUnassignedCategory;
    private IAttribute fOwnerAttribute;
    private IAttribute fWorkItemTypeAttribute;
    private ICombinedWorkflowInfos fCombinedWorkflowInfos;
    private IWorkItemWorkingCopyManager fReadWorkingCopyManager;
    private IWorkItemWorkingCopyManager fWriteWorkingCopyManager;
    private WorkItemListener fWorkItemListener;
    private ResourcePlanningManager fResourcePlanningManager;
    private IResourcePlanningListener fResourcePlanningListener;
    private ProjectWorkEnvironment fProjectWorkEnvironment;
    private EstimateOutputFormat fEstimateOutputFormat = EstimateOutputFormat.Mixed;
    private IReadStateManager fReadStateManager;
    private ReadStateListener fReadStateListener;
    private PlanCheckEngine fPlanChecker;
    private PlanCheckReport fReport;
    private Date fReferenceTime;
    private ItemProfile<IWorkItem> fWorkItemProfile;
    private PlanAttributeRegistry fAttributeRegistry = new PlanAttributeRegistry();
    private Map<IPlanningAttributeIdentifier, Collection<ScriptableAttribute>> fAttributeDependencies;
    private Map<String, IWorkItemType> fAllWorkItemTypes;
    private List<IWorkItemType> fAvailableWorkItemTypes;
    protected final DurationSupport fDurationSupport;
    private final Collection<PlanCheck> fPlanChecks;
    private Set<String> fTopLevelWorkItemTypes;

    public ResolvedPlan(List<? extends Object> workItemTransportObjects, Collection<IAttributeDefinitionDescriptor> attributeDescriptors, Collection<IPlanningAttribute<?, ?>> planningAttributes, Collection<PlanCheck> planChecks, Collection<? extends IContributor> owners, Collection<? extends IContributor> creators, Collection<? extends IDevelopmentLine> allDevelopmentLines, Collection<? extends ICategory> allCategories, Collection<? extends IIteration> allIntervals, DurationSupport durationSupport, Set<String> topLevelWorkItemTypes) {
        super(true);
        this.fPlanChecks = planChecks;
        this.fListeners = new ListenerList(1);
        for (ICategory iCategory : allCategories) {
            this.addResolvedCategory(iCategory);
        }
        for (IContributor iContributor : owners) {
            this.addResolvedOwner(iContributor);
        }
        for (IContributor iContributor : creators) {
            this.addResolvedContributor(iContributor);
        }
        for (IIteration iIteration : allIntervals) {
            this.addResolvedIteration(iIteration);
        }
        for (IDevelopmentLine iDevelopmentLine : allDevelopmentLines) {
            this.addResolvedDevelopmentLine(iDevelopmentLine);
        }
        this.fWorkItemTransportObjects = workItemTransportObjects;
        this.fReferenceTime = new Date(System.currentTimeMillis());
        this.fDurationSupport = durationSupport;
        this.fTopLevelWorkItemTypes = topLevelWorkItemTypes;
        this.createAttributes(attributeDescriptors);
        for (IPlanningAttribute iPlanningAttribute : planningAttributes) {
            this.fAttributeRegistry.registerAttribute(iPlanningAttribute);
        }
    }

    public abstract ITeamRepository getTeamRepository();

    public synchronized void connect(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fConnectCounter == 0) {
            IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient(this.getTeamRepository());
            IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient(this.getTeamRepository());
            IIterationPlanClient planningClient = PlanningClientPlugin.getIterationPlanClient(this.getTeamRepository());
            IAuditableCommonProcess processCommon = auditableClient.getProcess((IProcessAreaHandle)this.getProjectAreaHandle(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fWorkItemProfile = APTCommon.getPlanningWorkItemProfile((IPlanningCommon)planningClient, (IAuditableCommonProcess)processCommon, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fAttributeDependencies = new HashMap<IPlanningAttributeIdentifier, Collection<ScriptableAttribute>>();
            for (IPlanningAttribute<?, ?> planningAttribute : this.fAttributeRegistry.getAllAttributes()) {
                planningAttribute.initialize(this, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (!(planningAttribute instanceof ScriptableAttribute)) continue;
                Collection<IPlanningAttributeIdentifier> collection = ((ScriptableAttribute)planningAttribute).getDependantAttributes();
                for (IPlanningAttributeIdentifier iPlanningAttributeIdentifier : collection) {
                    Collection<ScriptableAttribute> attributes = this.fAttributeDependencies.get(iPlanningAttributeIdentifier);
                    if (attributes == null) {
                        attributes = new HashSet<ScriptableAttribute>();
                        this.fAttributeDependencies.put(iPlanningAttributeIdentifier, attributes);
                    }
                    attributes.add((ScriptableAttribute)planningAttribute);
                }
            }
            this.fReadWorkingCopyManager = workItemClient.createWorkingCopyManager(this.getName(), false);
            this.fWriteWorkingCopyManager = workItemClient.createWorkingCopyManager(this.getName(), true);
            monitor.beginTask("", this.fWorkItemTransportObjects.size() + this.fDevelopmentLineMap.size() + 11);
            long start = System.currentTimeMillis();
            for (Object object : this.fWorkItemTransportObjects) {
                this.addResolvedWorkItem(this.doConnectWorkItem(this.fReadWorkingCopyManager, object, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            }
            if (IterationPlanClient.TRACE_FETCH_ITERATION_PLAN) {
                System.out.println("    >> connecting working copies: " + (System.currentTimeMillis() - start) + " ms");
            }
            start = System.currentTimeMillis();
            this.fEstimateOutputFormat = ((IterationPlanClient)planningClient).fetchEstimateOutputFormat((IProcessAreaHandle)this.getProjectAreaHandle(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fWorkItemTypeAttribute = workItemClient.findAttribute(this.getProjectAreaHandle(), IWorkItem.TYPE_PROPERTY, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IAttribute iAttribute = workItemClient.findAttribute(this.getProjectAreaHandle(), IWorkItem.CATEGORY_PROPERTY, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fUnassignedCategory = (ICategory)iAttribute.getNullValue((IAuditableCommon)auditableClient, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fOwnerAttribute = workItemClient.findAttribute(this.getProjectAreaHandle(), IWorkItem.OWNER_PROPERTY, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fNullOwner = (IContributor)this.fOwnerAttribute.getNullValue((IAuditableCommon)auditableClient);
            this.addResolvedOwner(this.fNullOwner);
            this.fCombinedWorkflowInfos = workItemClient.findCachedCombinedWorkflowInfos(this.getProjectAreaHandle());
            if (this.fCombinedWorkflowInfos == null || WorkflowManager.containsOnlyBuiltinWorkflows((ICombinedWorkflowInfos)this.fCombinedWorkflowInfos)) {
                this.fCombinedWorkflowInfos = workItemClient.findCombinedWorkflowInfos(this.getProjectAreaHandle(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            if (IterationPlanClient.TRACE_FETCH_ITERATION_PLAN) {
                System.out.println("    >> getting null values: " + (System.currentTimeMillis() - start) + " ms");
            }
            for (IDevelopmentLine iDevelopmentLine : this.fDevelopmentLineMap.values()) {
                this.fDevelopmentLineIterations.put((IItemHandle)iDevelopmentLine, (Object)Iterations.fetchIterationHierarchy((IDevelopmentLineHandle)iDevelopmentLine, (IAuditableCommon)auditableClient, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1)));
            }
            this.processItems(this.fWorkItemTransportObjects);
            this.fWorkItemListener = new WorkItemListener();
            this.fReadWorkingCopyManager.addWorkItemListener((IWorkItemListener)this.fWorkItemListener);
            this.fReadWorkingCopyManager.addWorkingCopyListener((IWorkingCopyListener)this.fWorkItemListener);
            this.fResourcePlanningManager = PlanningClientPlugin.getResourcePlanningManager(this.getTeamRepository());
            this.fResourcePlanningListener = new ResourcePlanningListener();
            this.fResourcePlanningManager.addResourceListener(this.fResourcePlanningListener);
            this.fProjectWorkEnvironment = this.fResourcePlanningManager.getProjectWorkEnvironment((IProcessAreaHandle)this.getProjectAreaHandle(), true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IItemManager iItemManager = this.getTeamRepository().itemManager();
            iItemManager.addItemChangeListener(IWorkItem.ITEM_TYPE, (ISharedItemChangeListener)this.fWorkItemListener);
            this.fReadStateManager = IReadStateManager.DEFAULT;
            this.fReadStateListener = new ReadStateListener();
            this.fReadStateManager.addListener((IReadStateListener)this.fReadStateListener);
            List workItemTypes = ((WorkItemClient)workItemClient).findCachedWorkItemTypes(this.getProjectAreaHandle());
            if (workItemTypes == null) {
                workItemTypes = ((WorkItemCommon)workItemClient).findWorkItemTypes(this.getProjectAreaHandle(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            this.fAllWorkItemTypes = new HashMap<String, IWorkItemType>();
            for (IWorkItemType workItemType : workItemTypes) {
                this.fAllWorkItemTypes.put(workItemType.getIdentifier(), workItemType);
            }
            this.fAvailableWorkItemTypes = new ArrayList<IWorkItemType>();
            TreeMap<String, IWorkItemType> map = new TreeMap<String, IWorkItemType>();
            ItemCollection<IProcessArea> teamMemberAreas = this.getTeamMemberAreas();
            for (IProcessArea teamMemberArea : teamMemberAreas) {
                String[] identifiers = ((WorkItemClient)workItemClient).findCachedAvailableWorkItemTypes((IProcessAreaHandle)teamMemberArea);
                if (identifiers == null) {
                    identifiers = ((WorkItemCommon)workItemClient).findAvailableWorkItemTypes((IProcessAreaHandle)teamMemberArea, null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                String[] stringArray = identifiers;
                int n = identifiers.length;
                int n2 = 0;
                while (n2 < n) {
                    String identifier = stringArray[n2];
                    IWorkItemType workItemType = this.fAllWorkItemTypes.get(identifier);
                    if (workItemType != null) {
                        map.put(workItemType.getIdentifier(), workItemType);
                    }
                    ++n2;
                }
            }
            for (IWorkItemType type : map.values()) {
                this.fAvailableWorkItemTypes.add(type);
            }
            this.fPlanChecker = new PlanCheckEngine(this, new IPlanCheckReportAcceptor(){

                public void accept(PlanCheckReport newReport) {
                    try {
                        PlanDeltaBuilder builder = ResolvedPlan.this.connectDeltaBuilder();
                        builder.planCheckerChanged(ResolvedPlan.this.fReport, newReport);
                        newReport.removeEmptyReports();
                        ResolvedPlan.this.fReport = newReport;
                    }
                    finally {
                        ResolvedPlan.this.disconnectDeltaBuilder();
                    }
                }
            });
            for (PlanCheck check : this.fPlanChecks) {
                check.initialize(this, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.fPlanChecker.addCheck(check);
            }
            this.doConnect(monitor);
        }
        ++this.fConnectCounter;
    }

    public synchronized void disconnect() {
        if (this.fConnectCounter == 1) {
            this.fPlanChecker.cancel();
            this.fReadWorkingCopyManager.removeWorkingCopyListener((IWorkingCopyListener)this.fWorkItemListener);
            this.fReadWorkingCopyManager.removeWorkItemListener((IWorkItemListener)this.fWorkItemListener);
            IItemManager itemManager = this.getTeamRepository().itemManager();
            itemManager.purgeItemChangeListener((ISharedItemChangeListener)this.fWorkItemListener);
            this.fWorkItemListener = null;
            this.fReadStateManager.removeListener((IReadStateListener)this.fReadStateListener);
            this.fReadStateListener = null;
            this.fReadStateManager = null;
            this.fResourcePlanningManager.removeResourceListener(this.fResourcePlanningListener);
            this.fResourcePlanningListener = null;
            this.fResourcePlanningManager = null;
            this.doDisconnect();
            for (PlanItem planItem : this.getAllPlanItems()) {
                planItem.removeWriteAbility(planItem.isDirty());
            }
            this.clearChildren();
            this.fWorkItem2PlanItem.clear();
            this.fWorkItemMap.clear();
            this.fPlanChecker.dispose();
            this.fReadWorkingCopyManager.dispose();
            this.fWriteWorkingCopyManager.dispose();
        }
        --this.fConnectCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Exception> boolean runConnected(PlanRunnable<E> code) throws E {
        ResolvedPlan resolvedPlan = this;
        synchronized (resolvedPlan) {
            block7: {
                if (this.isConnected()) break block7;
                return false;
            }
            ++this.fConnectCounter;
        }
        try {
            code.run();
            return true;
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitForDisconnect(IProgressMonitor monitor) {
        int retries = 50;
        monitor.beginTask("", retries);
        try {
            while (this.fConnectCounter > 0 && retries-- > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                monitor.worked(1);
            }
            return this.fConnectCounter == 0;
        }
        finally {
            monitor.done();
        }
    }

    public boolean isConnected() {
        return this.fConnectCounter > 0;
    }

    public void setItemResolveService(IItemResolveService service) {
        this.fResolveService = service;
    }

    public void addListener(IPlanElementListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeListener(IPlanElementListener listener) {
        this.fListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlanDeltaBuilder connectDeltaBuilder() {
        Object object = this.fDeltaBuilderLock;
        synchronized (object) {
            Assert.isTrue((this.fDeltaBuilderCounter >= 0 ? 1 : 0) != 0);
            if (this.fDeltaBuilderCounter == 0) {
                this.fDeltaBuilder = new PlanDeltaBuilder(this);
            }
            ++this.fDeltaBuilderCounter;
            return this.fDeltaBuilder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectDeltaBuilder() {
        PlanDeltaBuilder builder = null;
        Object object = this.fDeltaBuilderLock;
        synchronized (object) {
            Assert.isTrue((this.fDeltaBuilderCounter > 0 ? 1 : 0) != 0);
            try {
                if (this.fDeltaBuilderCounter == 1) {
                    builder = this.fDeltaBuilder;
                    this.processCustomAttributeChanges(builder);
                    this.fDeltaBuilder = null;
                }
            }
            finally {
                --this.fDeltaBuilderCounter;
            }
        }
        if (builder != null) {
            if (!builder.isEmpty()) {
                this.fireEvent(builder.getEvent());
            }
            builder.sendPostNotifications();
        }
    }

    private void processCustomAttributeChanges(final PlanDeltaBuilder builder) {
        int maxIterations = 100;
        final boolean[] hasChanges = new boolean[]{false};
        do {
            final int currentGeneration = builder.newGeneration();
            builder.getEvent().getDelta().accept(new IPlanElementDeltaVisitor(){

                public boolean visit(IPlanElementDelta delta) {
                    IPlanAttributeDelta[] iPlanAttributeDeltaArray = delta.getAttributeDeltas();
                    int n = iPlanAttributeDeltaArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Collection dependantAttributes;
                        IPlanAttributeDelta attributeDelta = iPlanAttributeDeltaArray[n2];
                        if (((PlanAttributeDelta)attributeDelta).getGeneration() == currentGeneration && (dependantAttributes = (Collection)ResolvedPlan.this.fAttributeDependencies.get(attributeDelta.getAttribute())) != null) {
                            for (ScriptableAttribute dependantAttribute : dependantAttributes) {
                                dependantAttribute.changed(delta, builder);
                                hasChanges[0] = true;
                            }
                        }
                        ++n2;
                    }
                    return true;
                }
            });
        } while (hasChanges[0] && --maxIterations > 0);
        if (hasChanges[0]) {
            PlanningClientPlugin.log((IStatus)new Status(2, PlanningClientPlugin.getPluginId(), "ResolvedPlan#processCustomAttributeChanges: too many iterations"));
        }
    }

    @Override
    public abstract boolean isDirty();

    public abstract void markAsDirty();

    protected void writeSequenceValues(Collection<PlanItem> planItems, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            monitor.beginTask(Messages.ResolvedPlan_MONITOR_WRITE_SQUENCE_VALUE, planItems.size() + 1);
            ITeamRepository teamRepository = this.getTeamRepository();
            IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
            IProcessItemService processItemService = (IProcessItemService)teamRepository.getClientLibrary(IProcessItemService.class);
            IContributor currentUser = teamRepository.loggedInContributor();
            ItemHashSet teamAreas = new ItemHashSet();
            teamAreas = new ItemHashSet((Collection)processItemService.findTeamAreas(currentUser, (IProjectAreaHandle)this.getProjectArea(), IProcessClientService.ALL_PROPERTIES, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            for (PlanItem planItem : planItems) {
                if (planItem.isDirty()) {
                    boolean writeValue = planItem.getOwner().sameItemId((IItemHandle)currentUser);
                    if (!writeValue) {
                        IProcessAreaHandle processArea = workItemClient.findProcessArea((IWorkItemHandle)planItem.getWorkItem(false), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        boolean bl = writeValue = processArea instanceof ITeamAreaHandle && teamAreas.contains((Object)processArea);
                    }
                    if (writeValue) {
                        planItem.writeSequenceValue();
                    }
                    planItem.readSequenceValue();
                    continue;
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void revert(IReconcileReport[] reports) {
        int i = 0;
        while (i < reports.length) {
            IReconcileReport report = reports[i];
            PlanItem planItem = this.getPlanItem((IWorkItemHandle)report.getBase());
            if (planItem != null) {
                planItem.revert();
            }
            ++i;
        }
    }

    public void refresh(IReconcileReport[] reports) {
        int i = 0;
        while (i < reports.length) {
            IReconcileReport report = reports[i];
            IWorkItem incoming = (IWorkItem)report.getIncoming();
            Assert.isTrue((this.getResolvedWorkItem((IWorkItemHandle)incoming) != null ? 1 : 0) != 0);
            ((WorkItemWorkingCopyManager)this.getWorkingCopyManager(false)).internalRefresh(incoming);
            ++i;
        }
    }

    public void autoMerge(IReconcileReport[] reports) {
        int i = 0;
        while (i < reports.length) {
            IReconcileReport report = reports[i];
            IWorkItem base = (IWorkItem)report.getBase();
            Assert.isTrue((this.getResolvedWorkItem((IWorkItemHandle)base) != null ? 1 : 0) != 0);
            WorkItemWorkingCopy workingCopy = this.getWorkingCopyManager(false).getWorkingCopy((IWorkItemHandle)base);
            Assert.isNotNull((Object)workingCopy, (String)"Work item not connected to working copy");
            WorkItems.refreshAndMergeWithServer(report, workingCopy);
            IItemManager manager = this.getTeamRepository().itemManager();
            List result = manager.applyItemUpdates(Collections.singletonList(report.getIncoming()));
            Assert.isTrue((result.get(0) != null ? 1 : 0) != 0);
            ++i;
        }
    }

    public abstract String getName();

    public Timespan getPlannedTimespan() {
        Timespan result = null;
        Date startDate = this.getStartDate();
        if (startDate != null) {
            result = new Timespan(startDate, this.getEndDate());
        }
        return result;
    }

    public abstract Date getStartDate();

    public abstract Date getEndDate();

    public abstract IProjectArea getProjectArea();

    public abstract IProjectAreaHandle getProjectAreaHandle();

    public abstract LoadInformation getLoadInformation(IIterationHandle var1);

    public Collection<PlanItem> getAllPlanItems() {
        final ArrayList<PlanItem> result = new ArrayList<PlanItem>();
        this.accept(new IPlanElementVisitor(){

            public boolean visit(PlanElement element) {
                if (element instanceof PlanItem) {
                    result.add(element);
                }
                return true;
            }
        });
        return result;
    }

    @Override
    public PlanCheckReport getPlanCheckReport() {
        return this.fReport;
    }

    public IProblemDescription getProblemDefinition(String problemId) {
        return this.fPlanChecker.getProblemDefinition(problemId);
    }

    public void triggerCheckerCalculation() {
        this.fPlanChecker.runFullCheck();
    }

    public IEventCondition getPlanCheckerDoneCondition() {
        return this.fPlanChecker.getPlanCheckerExecutedCondition();
    }

    public Date getReferenceTime() {
        return this.fReferenceTime;
    }

    public void setReferenceTime(Date referenceTime) {
        this.fReferenceTime = referenceTime;
    }

    public List<String> getPopularTags(int count) {
        final HashMap tagCounts = new HashMap();
        this.accept(new IPlanElementVisitor(){

            public boolean visit(PlanElement element) {
                if (element instanceof PlanItem) {
                    String[] stringArray = ((PlanItem)element).getTags();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String tag = stringArray[n2];
                        int[] tagCount = (int[])tagCounts.get(tag);
                        if (tagCount == null) {
                            tagCount = new int[1];
                            tagCounts.put(tag, tagCount);
                        }
                        tagCount[0] = tagCount[0] + 1;
                        ++n2;
                    }
                }
                return true;
            }
        });
        ArrayList sorted = new ArrayList(tagCounts.entrySet());
        Collections.sort(sorted, new Comparator<Map.Entry<String, int[]>>(){

            @Override
            public int compare(Map.Entry<String, int[]> o1, Map.Entry<String, int[]> o2) {
                return o2.getValue()[0] - o1.getValue()[0];
            }
        });
        ArrayList<String> result = new ArrayList<String>(Math.min(count, sorted.size()));
        for (Map.Entry entry : sorted) {
            if (count-- <= 0) break;
            result.add((String)entry.getKey());
        }
        return result;
    }

    public abstract boolean matchesPlanQuery(PlanItem var1);

    public abstract void adopt(IWorkItem var1, IProgressMonitor var2) throws TeamRepositoryException;

    protected abstract void initializeNewPlanItem(PlanItem var1, IProgressMonitor var2) throws TeamRepositoryException;

    public abstract List<String> getUnrelevantWorkItemReasons(IWorkItem var1, IProgressMonitor var2) throws TeamRepositoryException;

    public abstract Collection<OutOfOfficeItem> getAbsences();

    public ItemProfile<IWorkItem> getWorkItemProfile() {
        return this.fWorkItemProfile;
    }

    public PlanItem[] getPlanItems() {
        PlanElement[] planElements = this.getChildren();
        PlanItem[] result = new PlanItem[planElements.length];
        System.arraycopy(planElements, 0, result, 0, planElements.length);
        return result;
    }

    public ItemCollection<IContributor> getOwners() {
        return ItemCollections.unmodifiableItemCollection((ItemCollection)this.fOwners.values());
    }

    public ItemCollection<IContributor> getMemberContributors() {
        return this.getOwners();
    }

    public ItemCollection<ICategory> getCategories() {
        return ItemCollections.unmodifiableItemCollection((ItemCollection)this.fCategoriesMap.values());
    }

    protected ICategory getUnassignedCategory() {
        return this.fUnassignedCategory;
    }

    public ItemCollection<IIteration> getIntervals() {
        return ItemCollections.unmodifiableItemCollection((ItemCollection)this.fIntervalMap.values());
    }

    public ItemCollection<IDevelopmentLine> getDevelopmentLines() {
        return ItemCollections.unmodifiableItemCollection((ItemCollection)this.fDevelopmentLineMap.values());
    }

    public DurationSupport getDurationSupport() {
        return this.fDurationSupport;
    }

    public abstract ItemCollection<IProcessArea> getTeamMemberAreas();

    public abstract IProcessArea getTeamMemberArea(ICategoryHandle var1);

    public abstract ICategory getPrimaryCategoryFor(IProcessArea var1);

    public abstract ItemSet<IIteration> getPlannedIterations();

    public abstract IIteration suggestCurrentIteration(PlanItem var1, IProgressMonitor var2) throws TeamRepositoryException;

    public IterationHierarchy getDevelopmentLineIterationHierarchy(IDevelopmentLineHandle developmentLineHandle) {
        return (IterationHierarchy)this.fDevelopmentLineIterations.get((IItemHandle)developmentLineHandle);
    }

    public ItemList<IIteration> getRelatedIterations(IDevelopmentLineHandle devLine) {
        ItemArrayList result = new ItemArrayList();
        IterationHierarchy iterationHierarchy = this.getDevelopmentLineIterationHierarchy(devLine);
        if (iterationHierarchy != null) {
            if (iterationHierarchy.getCurrentIteration() != null) {
                result.add((Object)iterationHierarchy.getCurrentIteration());
            }
            int count = 2;
            Iterator futureIterations = iterationHierarchy.getFutureIterations().iterator();
            while (count > 0 && futureIterations.hasNext()) {
                result.add((Object)((IIteration)futureIterations.next()));
                --count;
            }
        }
        return result;
    }

    public boolean contains(IWorkItemHandle handle) {
        return this.fWorkItemMap.containsKey((IItemHandle)handle);
    }

    public PlanItem getPlanItem(IWorkItemHandle handle) {
        return (PlanItem)this.fWorkItem2PlanItem.get((IItemHandle)handle);
    }

    public PlanItem getPlanItem(UUID workItemUuid) {
        return this.getPlanItem((IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(workItemUuid, null));
    }

    public IContributor getResolvedContributor(IContributorHandle handle) {
        return (IContributor)this.fAllContributors.get((IItemHandle)handle);
    }

    public ItemCollection<IContributor> getResolvedContributors() {
        return ItemCollections.unmodifiableItemCollection((ItemCollection)this.fAllContributors.values());
    }

    public ICategory getResolvedCategory(ICategoryHandle handle) {
        return (ICategory)this.fCategoriesMap.get((IItemHandle)handle);
    }

    public ItemCollection<ICategory> getResolvedCategories() {
        return ItemCollections.unmodifiableItemCollection((ItemCollection)this.fCategoriesMap.values());
    }

    public IIteration getResolvedIteration(IIterationHandle handle) {
        return handle != null ? (IIteration)this.fIntervalMap.get((IItemHandle)handle) : null;
    }

    public ItemCollection<IIteration> getResolvedIterations() {
        return ItemCollections.unmodifiableItemCollection((ItemCollection)this.fIntervalMap.values());
    }

    public IDevelopmentLine getResolvedDevelopmentLine(IDevelopmentLineHandle handle) {
        return (IDevelopmentLine)this.fDevelopmentLineMap.get((IItemHandle)handle);
    }

    public ItemCollection<IDevelopmentLine> getResolvedDevelopmentLines() {
        return ItemCollections.unmodifiableItemCollection((ItemCollection)this.fDevelopmentLineMap.values());
    }

    public IProcessArea getResolvedProcessArea(IProcessAreaHandle handle) {
        return handle != null ? (IProcessArea)this.fProcessAreaMap.get((IItemHandle)handle) : null;
    }

    public ItemCollection<IProcessArea> getResolvedProcessAreas() {
        return ItemCollections.unmodifiableItemCollection((ItemCollection)this.fProcessAreaMap.values());
    }

    public IAttribute getWorkItemTypeAttribute() {
        return this.fWorkItemTypeAttribute;
    }

    public List<IWorkItemType> getWorkItemTypes() {
        return Collections.unmodifiableList(this.fAvailableWorkItemTypes);
    }

    public List<IWorkItemType> getCreatableWorkItemTypes() {
        return this.getWorkItemTypes();
    }

    public IWorkItemType getResolvedWorkItemType(String typeIdentifier) {
        IWorkItemType result = this.fAllWorkItemTypes.get(typeIdentifier);
        if (result == null) {
            URL unknownTypeUrl = FileLocator.find((Bundle)Platform.getBundle((String)"com.ibm.team.apt.common"), (IPath)new Path("icons/obj16/unknown.png"), null);
            result = new WorkItemType((IProjectAreaHandle)this.getProjectArea(), typeIdentifier, "deleted", Collections.EMPTY_LIST, typeIdentifier, Collections.EMPTY_LIST, unknownTypeUrl, null, Integer.MAX_VALUE);
            this.fAllWorkItemTypes.put(typeIdentifier, result);
        }
        return result;
    }

    public Collection<IWorkItemType> getResolvedWorkItemTypes() {
        return Collections.unmodifiableCollection(this.fAllWorkItemTypes.values());
    }

    public IWorkItemType getDefaultWorkItemType() {
        if (this.fAvailableWorkItemTypes.size() > 0) {
            return this.fAvailableWorkItemTypes.get(0);
        }
        return null;
    }

    public Set<String> getTopLevelWorkItemTypes() {
        return this.fTopLevelWorkItemTypes;
    }

    public boolean isTopLevelItem(PlanItem item) {
        return this.getTopLevelWorkItemTypes().contains(item.getItemType().getIdentifier());
    }

    public IAttribute getOwnerAttribute() {
        return this.fOwnerAttribute;
    }

    public IContributor getNullOwner() {
        return this.fNullOwner;
    }

    public ProjectWorkEnvironment getProjectWorkEnvironment() {
        return this.fProjectWorkEnvironment;
    }

    public EstimateOutputFormat getEstimateOutputFormat() {
        return this.fEstimateOutputFormat;
    }

    public <T, V> IPlanningAttribute<T, V> findAttribute(IPlanningAttributeIdentifier identifier) {
        return this.fAttributeRegistry.getAttribute(identifier);
    }

    public Collection<IPlanningAttribute<?, ?>> getAllAttributes() {
        return this.fAttributeRegistry.getAllAttributes();
    }

    IAttributeRegistry getAttributeRegistry() {
        return this.fAttributeRegistry;
    }

    boolean isOpen(PlanItem item) {
        IWorkItem workItem = item.getWorkItem(false);
        if (workItem.isNewItem()) {
            return true;
        }
        return 1 == this.fCombinedWorkflowInfos.getStateGroup(workItem.getState2());
    }

    boolean isInProgress(PlanItem item) {
        return 4 == this.fCombinedWorkflowInfos.getStateGroup(item.getWorkItem(false).getState2());
    }

    boolean isClosed(PlanItem item) {
        return 2 == this.fCombinedWorkflowInfos.getStateGroup(item.getWorkItem(false).getState2());
    }

    public ICombinedWorkflowInfos getCombinedWorkflowInfos() {
        return this.fCombinedWorkflowInfos;
    }

    public IWorkflowInfo getWorkflowInfo(String workflowId) {
        IProjectArea projectArea = this.getProjectArea();
        IWorkItemClient workItemClient = (IWorkItemClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IWorkItemClient.class);
        return ((WorkflowManager)workItemClient.getWorkflowManager()).getWorkflowInfo((IProjectAreaHandle)projectArea, workflowId, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public abstract ItemSequenceManager getItemSequenceManager(IScheduleItem var1);

    /*
     * Exception decompiling
     */
    public PlanItem createNewPlanItem(PlanElement parent, IPlanItemAttributeSetter initializer, IProgressMonitor monitor) throws TeamRepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void runWithDeltaBuilder(Runnable runnable) {
        try {
            this.connectDeltaBuilder();
            runnable.run();
        }
        finally {
            this.disconnectDeltaBuilder();
        }
    }

    @Override
    public ResolvedPlan getPlan() {
        return this;
    }

    @Override
    public PlanElement getParent() {
        return null;
    }

    @Override
    public void moveTo(PlanElement newParent) {
        throw new IllegalStateException("Can't move the plan root");
    }

    @Override
    protected void doChildAdded(PlanElement parent, PlanElement child) {
        try {
            PlanDeltaBuilder builder = this.connectDeltaBuilder();
            if (!builder.isInMove() && child instanceof PlanItem) {
                PlanItem item = (PlanItem)child;
                IWorkItemHandle workItemHandle = item.getWorkItemHandle();
                this.fWorkItem2PlanItem.put((IItemHandle)workItemHandle, (Object)item);
                this.addResolvedWorkItem(item.getWorkItem(false));
                if (this.fRemovedWorkItems != null) {
                    this.fRemovedWorkItems.remove((Object)workItemHandle);
                    this.removeFromPlanCheckerReport(builder, item);
                }
            }
            builder.added(child);
            if (this.fConnectCounter > 0) {
                this.doRecomputeWorkItemDirtyState();
            }
        }
        finally {
            this.disconnectDeltaBuilder();
        }
    }

    @Override
    protected void doChildRemoved(PlanElement parent, PlanElement child) {
        try {
            PlanDeltaBuilder builder = this.connectDeltaBuilder();
            if (!builder.isInMove() && child instanceof PlanItem) {
                final PlanItem planItem = (PlanItem)child;
                if (planItem.isDraftItem()) {
                    PlanElement[] planElementArray = planItem.getChildren();
                    int n = planElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PlanElement toReParent = planElementArray[n2];
                        toReParent.moveTo(parent);
                        ++n2;
                    }
                }
                final IWorkItemHandle workItemHandle = planItem.getWorkItemHandle();
                this.fWorkItem2PlanItem.remove((Object)workItemHandle);
                this.fWorkItemMap.remove((Object)workItemHandle);
                if (!planItem.isDraftItem() && planItem.isDirty()) {
                    if (this.fRemovedWorkItems == null) {
                        this.fRemovedWorkItems = new ItemHashMap();
                    }
                    this.fRemovedWorkItems.put((IItemHandle)workItemHandle, (Object)planItem);
                } else {
                    this.removeFromPlanCheckerReport(builder, planItem);
                    builder.addPostNotification(new Runnable(){

                        public void run() {
                            ResolvedPlan.this.doDisconnectPlanItem(planItem);
                            ResolvedPlan.this.fWorkItemMap.remove((Object)workItemHandle);
                        }
                    });
                }
            }
            builder.removed(child);
            if (this.fConnectCounter > 0) {
                this.doRecomputeWorkItemDirtyState();
            }
        }
        finally {
            this.disconnectDeltaBuilder();
        }
    }

    protected abstract void doConnect(IProgressMonitor var1) throws TeamRepositoryException;

    protected abstract IWorkItem doConnectWorkItem(IWorkItemWorkingCopyManager var1, Object var2, IProgressMonitor var3) throws TeamRepositoryException;

    protected abstract void doDisconnect();

    protected abstract boolean isRelevantForPlan(IWorkItem var1);

    protected abstract PlanItem doCreateNewPlanItem(PlanElement var1, WorkItemWorkingCopy var2);

    protected abstract void processItems(List var1);

    protected abstract List<? extends PlanItem> processItem(IWorkItem var1);

    protected abstract boolean isResolvingRequired(WorkItemWorkingCopy var1);

    protected abstract void doResolvePlanItems(List<IWorkItemHandle> var1, IDeferredResolveListener<List<Object>> var2, boolean var3) throws MissingFutureExecutorServiceException;

    protected abstract void doProcessResourcePlanningUpdate(ResourcePlanningEvent var1);

    protected abstract void doRecomputeWorkItemDirtyState();

    private void createAttributes(Collection<IAttributeDefinitionDescriptor> attributeDescriptors) {
        this.addReflectiveAttribute(PlanElement.CHILDREN, attributeDescriptors, "children", PlanElement.class, Boolean.TYPE, GetterKind.HAS, SetterKind.NONE);
        this.addReflectiveAttribute(PlanElement.CHILDREN_COUNT, attributeDescriptors, "childrenCount", PlanElement.class, Integer.TYPE, GetterKind.GET, SetterKind.NONE);
        this.addReflectiveAttribute(PlanElement.PLANCHECK_REPORT, attributeDescriptors, "planCheckReport", PlanElement.class, CheckerReport.class, GetterKind.GET, SetterKind.NONE);
        this.addReflectiveAttribute(PlanElement.DIRTY, attributeDescriptors, "dirty", PlanElement.class, Boolean.TYPE, GetterKind.IS, SetterKind.NONE);
        this.addReflectiveAttribute(RESOURCE_PLANNING, attributeDescriptors, "resourcePlanning", ResolvedPlan.class, Void.class, GetterKind.NONE, SetterKind.NONE);
        this.addReflectiveAttribute(REFERENCE_TIME, attributeDescriptors, "referenceTime", ResolvedPlan.class, Date.class, GetterKind.GET, SetterKind.NONE);
        this.addReflectiveAttribute(IScheduleItem.SUMMARY, attributeDescriptors, "summary", IScheduleItem.class, String.class);
        this.addReflectiveAttribute(IScheduleItem.SCHEDULED_TIME, attributeDescriptors, "scheduledTime", IScheduleItem.class, Timespan.class, GetterKind.GET, SetterKind.NONE);
        this.addReflectiveAttribute(IScheduleItem.OWNER, attributeDescriptors, "owner", IScheduleItem.class, IContributor.class, GetterKind.GET, SetterKind.SET, new IPlanningAttributeValueSet<IContributor>(){
            Collection<IContributor> fAllContributors;

            @Override
            public Collection<IContributor> getValues() {
                if (this.fAllContributors == null) {
                    this.fAllContributors = new ArrayList<IContributor>(ResolvedPlan.this.getMemberContributors().toCollection());
                    this.fAllContributors.add(ResolvedPlan.this.fNullOwner);
                }
                return this.fAllContributors;
            }

            @Override
            public IContributor getNullValue() {
                return ResolvedPlan.this.fNullOwner;
            }

            @Override
            public IContributor getValue(String valueId) {
                return ResolvedPlan.this.getResolvedContributor((IContributorHandle)IContributor.ITEM_TYPE.createItemHandle(UUID.valueOf((String)valueId), null));
            }

            @Override
            public Collection<IContributor> getAllValues() {
                return ResolvedPlan.this.getResolvedContributors().toCollection();
            }
        });
        this.addReflectiveAttribute(IScheduleItem.RESOLVED, attributeDescriptors, "resolved", IScheduleItem.class, Boolean.TYPE, GetterKind.IS, SetterKind.NONE);
        this.addReflectiveAttribute(IScheduleItem.SEQUENCE_VALUE, attributeDescriptors, "sequenceValue", IScheduleItem.class, SequenceValue.class, GetterKind.GET, SetterKind.NONE);
        this.addReflectiveAttribute(IScheduleItem.PRIMARY_ITEM, attributeDescriptors, "primaryPlanItem", IScheduleItem.class, Boolean.TYPE, GetterKind.IS, SetterKind.NONE);
        this.addReflectiveAttribute(PlanItem.ID, attributeDescriptors, "id", PlanItem.class, Integer.TYPE, GetterKind.GET, SetterKind.NONE);
        this.addReflectiveAttribute(PlanItem.ITEM_TYPE, attributeDescriptors, "itemType", PlanItem.class, IWorkItemType.class, GetterKind.GET, SetterKind.NONE, new IPlanningAttributeValueSet.EmptyValueSet<IWorkItemType>(){

            @Override
            public Collection<IWorkItemType> getAllValues() {
                return ResolvedPlan.this.getResolvedWorkItemTypes();
            }
        });
        this.addReflectiveAttribute(PlanItem.DESCRIPTION, attributeDescriptors, "description", PlanItem.class, String.class);
        this.addReflectiveAttribute(PlanItem.CREATOR, attributeDescriptors, "creator", PlanItem.class, IContributor.class, GetterKind.GET, SetterKind.NONE, new IPlanningAttributeValueSet.EmptyValueSet<IContributor>(){

            @Override
            public Collection<IContributor> getAllValues() {
                return ResolvedPlan.this.getResolvedContributors().toCollection();
            }
        });
        this.addReflectiveAttribute(PlanItem.CATEGORY, attributeDescriptors, "category", PlanItem.class, ICategory.class, new IPlanningAttributeValueSet<ICategory>(){

            @Override
            public ICategory getValue(String valueId) {
                return ResolvedPlan.this.getResolvedCategory((ICategoryHandle)ICategory.ITEM_TYPE.createItemHandle(UUID.valueOf((String)valueId), null));
            }

            @Override
            public ICategory getNullValue() {
                return ResolvedPlan.this.getUnassignedCategory();
            }

            @Override
            public Collection<ICategory> getValues() {
                return Collections.emptyList();
            }

            @Override
            public Collection<ICategory> getAllValues() {
                return ResolvedPlan.this.getResolvedCategories().toCollection();
            }
        });
        this.addReflectiveAttribute(PlanItem.TARGET, attributeDescriptors, "target", PlanItem.class, IIteration.class, new IPlanningAttributeValueSet.EmptyValueSet<IIteration>(){

            @Override
            public Collection<IIteration> getAllValues() {
                return ResolvedPlan.this.getResolvedIterations().toCollection();
            }
        });
        this.addReflectiveAttribute(PlanItem.TIMELINE, attributeDescriptors, "timeline", PlanItem.class, IDevelopmentLine.class, GetterKind.GET, SetterKind.NONE, new IPlanningAttributeValueSet.EmptyValueSet<IDevelopmentLine>(){

            @Override
            public Collection<IDevelopmentLine> getAllValues() {
                return ResolvedPlan.this.getDevelopmentLines().toCollection();
            }
        });
        this.addReflectiveAttribute(PlanItem.PRIMARY_TAG, attributeDescriptors, "primaryTag", PlanItem.class, String.class, new IPlanningAttributeValueSet.EmptyValueSet(){

            public Collection getAllValues() {
                final HashSet result = new HashSet();
                ResolvedPlan.this.accept(new IPlanElementVisitor(){

                    public boolean visit(PlanElement element) {
                        if (element instanceof PlanItem) {
                            result.add(((PlanItem)element).getPrimaryTag());
                        }
                        return true;
                    }
                });
                return result;
            }
        });
        this.addReflectiveAttribute(PlanItem.TAGS, attributeDescriptors, "tags", PlanItem.class, String[].class, GetterKind.GET, SetterKind.NONE, new IPlanningAttributeValueSet.EmptyValueSet(){

            public Collection getAllValues() {
                final HashSet result = new HashSet();
                ResolvedPlan.this.accept(new IPlanElementVisitor(){

                    public boolean visit(PlanElement element) {
                        if (element instanceof PlanItem) {
                            result.addAll(Arrays.asList(((PlanItem)element).getTags()));
                        }
                        return true;
                    }
                });
                return result;
            }
        });
        this.addReflectiveAttribute(PlanItem.STATE, attributeDescriptors, "state", PlanItem.class, Identifier.class, GetterKind.GET, SetterKind.NONE);
        this.addReflectiveAttribute(PlanItem.WORKFLOW_ACTION, attributeDescriptors, "workflowAction", PlanItem.class, Identifier.class, GetterKind.GET, SetterKind.NONE);
        this.addWorkItemAttribute(PlanItem.PRIORITY, attributeDescriptors, (Identifier<IAttribute>)WorkItemAttributes.PRIORITY, false);
        this.addWorkItemAttribute(PlanItem.SEVERITY, attributeDescriptors, (Identifier<IAttribute>)WorkItemAttributes.SEVERITY, false);
        this.addReflectiveAttribute(PlanItem.ESTIMATE, attributeDescriptors, "estimate", PlanItem.class, Duration.class);
        this.addReflectiveAttribute(PlanItem.EFFORT, attributeDescriptors, "effort", PlanItem.class, Duration.class);
        this.addReflectiveAttribute(PlanItem.ORIGINAL_ESTIMATE, attributeDescriptors, "originalEstimate", PlanItem.class, Duration.class);
        this.addReflectiveAttribute(PlanItem.CORRECTED_ESTIMATE, attributeDescriptors, "correctedEstimate", PlanItem.class, Duration.class);
        this.addReflectiveAttribute(PlanItem.TIMESPENT, attributeDescriptors, "timeSpent", PlanItem.class, Duration.class);
        this.addReflectiveAttribute(PlanItem.DURATION, attributeDescriptors, "duration", PlanItem.class, Duration.class);
        this.addReflectiveAttribute(PlanItem.DUE_DATE, attributeDescriptors, "dueDate", PlanItem.class, Timestamp.class, GetterKind.GET, SetterKind.NONE);
        this.addReflectiveAttribute(PlanItem.RESOLUTION_DATE, attributeDescriptors, "resolutionDate", PlanItem.class, Timestamp.class, GetterKind.GET, SetterKind.NONE);
        this.addReflectiveAttribute(PlanItem.DRAFT_ITEM, attributeDescriptors, "draftItem", PlanItem.class, Boolean.TYPE, GetterKind.IS, SetterKind.NONE);
        this.addReflectiveAttribute(PlanItem.AUXILIARY_ITEM, attributeDescriptors, "auxiliaryPlanItem", PlanItem.class, Boolean.TYPE, GetterKind.IS, SetterKind.NONE);
        this.addReflectiveAttribute(PlanItem.PARENT, attributeDescriptors, "parent", PlanItem.class, Void.class, GetterKind.NONE, SetterKind.NONE);
        this.addReflectiveAttribute(PlanItem.MARKED_READ, attributeDescriptors, "markedRead", PlanItem.class, Boolean.TYPE, GetterKind.IS, SetterKind.NONE);
        this.addReflectiveAttribute(PlanItem.NEW_ITEM, attributeDescriptors, "newItem", PlanItem.class, Boolean.TYPE, GetterKind.IS, SetterKind.NONE);
    }

    private <R, V> void addReflectiveAttribute(IPlanningAttributeIdentifier identifier, Collection<IAttributeDefinitionDescriptor> attributeDescriptors, String name, Class<R> receiverType, Class<V> valueType) {
        this.addReflectiveAttribute(identifier, attributeDescriptors, name, receiverType, valueType, null);
    }

    private <R, V> void addReflectiveAttribute(IPlanningAttributeIdentifier identifier, Collection<IAttributeDefinitionDescriptor> attributeDescriptors, String name, Class<R> receiverType, Class<V> valueType, IPlanningAttributeValueSet<V> valueSet) {
        IAttributeDefinitionDescriptor attributeDescriptor = this.findAttributeDescriptor(identifier, attributeDescriptors);
        this.fAttributeRegistry.registerAttribute(new ReflectiveAttribute<R, V>(attributeDescriptor, name, receiverType, valueType, valueSet));
    }

    private <R, V> void addReflectiveAttribute(IPlanningAttributeIdentifier identifier, Collection<IAttributeDefinitionDescriptor> attributeDescriptors, String name, Class<R> receiverType, Class<V> valueType, GetterKind getter, SetterKind setter) {
        this.addReflectiveAttribute(identifier, attributeDescriptors, name, receiverType, valueType, getter, setter, null);
    }

    private <R, V> void addReflectiveAttribute(IPlanningAttributeIdentifier identifier, Collection<IAttributeDefinitionDescriptor> attributeDescriptors, String name, Class<R> receiverType, Class<V> valueType, GetterKind getter, SetterKind setter, IPlanningAttributeValueSet<V> valueSet) {
        IAttributeDefinitionDescriptor attributeDescriptor = this.findAttributeDescriptor(identifier, attributeDescriptors);
        this.fAttributeRegistry.registerAttribute(new ReflectiveAttribute<R, V>(attributeDescriptor, name, receiverType, valueType, getter, setter, valueSet));
    }

    private <R, V> void addWorkItemAttribute(IPlanningAttributeIdentifier identifier, Collection<IAttributeDefinitionDescriptor> attributeDescriptors, Identifier<IAttribute> workItemAttribute, boolean addCustomAttribute) {
        IAttributeDefinitionDescriptor attributeDescriptor = this.findAttributeDescriptor(identifier, attributeDescriptors);
        Identifier internalId = Identifier.create(IAttribute.class, (String)WorkItemAttributes.getAttributeId(workItemAttribute));
        this.fAttributeRegistry.registerAttribute(new PlanItemWorkItemAttribute(attributeDescriptor, (Identifier<IAttribute>)internalId, addCustomAttribute));
    }

    private IAttributeDefinitionDescriptor findAttributeDescriptor(IPlanningAttributeIdentifier identifier, Collection<IAttributeDefinitionDescriptor> attributeDescriptors) {
        IAttributeDefinitionDescriptor attributeDescriptor = null;
        for (IAttributeDefinitionDescriptor candidateDescriptor : attributeDescriptors) {
            if (!candidateDescriptor.getId().equals(identifier.getId())) continue;
            attributeDescriptor = candidateDescriptor;
            break;
        }
        if (attributeDescriptor == null) {
            PlanningClientPlugin.log((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), NLS.bind((String)Messages.ResolvedPlan_MISSING_ATTRIBUTE_DESCRIPTOR, (Object)identifier.getId(), (Object[])new Object[0])));
            attributeDescriptor = (IAttributeDefinitionDescriptor)ConfigurationElementFactory.emptyInstance(IAttributeDefinitionDescriptor.class);
            attributeDescriptor.setId(identifier.getId());
            attributeDescriptor.setDisplayName(identifier.getId());
            attributeDescriptor.setImplementationName("com.ibm.team.apt.client.BuiltInAttribute");
        }
        return attributeDescriptor;
    }

    protected IContributorInfo fetchContributorInfo(ItemCollection<? extends IContributorHandle> contributors, IProgressMonitor monitor) throws TeamRepositoryException {
        ResourcePlanningManager manager = PlanningClientPlugin.getResourcePlanningManager(this.getTeamRepository());
        ItemSet<IIteration> iterations = this.getPlannedIterations();
        if (iterations.size() == 1) {
            IIteration iteration = (IIteration)iterations.iterator().next();
            Timestamp start = iteration.getStartDate() != null ? new Timestamp(iteration.getStartDate().getTime()) : new Timestamp(0L);
            Timestamp end = this.calculateEnd(iteration.getEndDate());
            return manager.getContributorInfo(contributors, start, end, false, false, monitor);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.add(1, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date start = calendar.getTime();
        Date end = null;
        for (IIteration iteration : iterations) {
            Date date = iteration.getStartDate();
            if (date != null && date.before(start)) {
                start = date;
            }
            if ((date = iteration.getEndDate()) == null || end != null && !date.after(end)) continue;
            end = date;
        }
        return manager.getContributorInfo(contributors, new Timestamp(start.getTime()), this.calculateEnd(end), false, false, monitor);
    }

    protected Collection<OutOfOfficeItem> doCreateAbsences(ItemCollection<IContributorAbsence> absences) {
        ArrayList<OutOfOfficeItem> result = new ArrayList<OutOfOfficeItem>(absences.size());
        Timespan plannedTimespan = this.getPlannedTimespan();
        if (plannedTimespan != null) {
            if (plannedTimespan.getEnd() != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(plannedTimespan.getEnd().getTime());
                calendar.add(2, 2);
                plannedTimespan = new Timespan(plannedTimespan.getStart(), new Date(calendar.getTimeInMillis()));
            }
            for (IContributorAbsence absence : absences) {
                if (!plannedTimespan.contains(absence.getEndDate()) && !plannedTimespan.contains(absence.getStartDate())) continue;
                result.add(new OutOfOfficeItem(this, absence));
            }
        }
        return result;
    }

    private Timestamp calculateEnd(Date endDate) {
        Timestamp result = null;
        if (endDate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(endDate.getTime());
            calendar.add(2, 2);
            result = new Timestamp(calendar.getTimeInMillis());
        }
        return result;
    }

    public void joinPlanChecker(IProgressMonitor monitor) throws InterruptedException {
        this.fPlanChecker.join(monitor);
    }

    public PlanCheckEngine getPlanChecker() {
        return this.fPlanChecker;
    }

    protected void itemsAdded(List<? extends PlanItem> items) {
        this.fPlanChecker.runItemCheck(items);
    }

    protected boolean hasDirtyWorkingCopies() {
        final boolean[] result = new boolean[1];
        this.accept(new IPlanElementVisitor(){

            public boolean visit(PlanElement element) {
                if (!result[0] && element instanceof PlanItem) {
                    result[0] = ((PlanItem)element).isDirty();
                }
                return !result[0];
            }
        });
        if (!result[0] && this.fRemovedWorkItems != null) {
            for (PlanItem planItem : this.fRemovedWorkItems.values()) {
                if (!planItem.getWorkItemWorkingCopy(false).isDirty()) continue;
                result[0] = true;
                break;
            }
        }
        return result[0];
    }

    protected WorkItemWorkingCopy[] getDirtyWorkingCopies(final boolean resetCachedState) {
        final ArrayList<WorkItemWorkingCopy> result = new ArrayList<WorkItemWorkingCopy>();
        this.accept(new IPlanElementVisitor(){

            public boolean visit(PlanElement element) {
                PlanItem item;
                if (element instanceof PlanItem && (item = (PlanItem)element).isDirty()) {
                    result.add(item.getWorkItemWorkingCopy(false));
                    if (resetCachedState) {
                        item.resetCachedState();
                    }
                }
                return true;
            }
        });
        if (this.fRemovedWorkItems != null) {
            for (PlanItem planItem : this.fRemovedWorkItems.values()) {
                WorkItemWorkingCopy wc = planItem.getWorkItemWorkingCopy(false);
                if (!wc.isDirty()) continue;
                result.add(wc);
            }
        }
        return result.toArray(new WorkItemWorkingCopy[result.size()]);
    }

    protected void handleDirtyStateChanged(WorkingCopyEvent event) {
        PlanDeltaBuilder builder = this.connectDeltaBuilder();
        try {
            PlanItem planItem = this.getPlanItem((IWorkItemHandle)event.getSource().getWorkItem());
            if (planItem != null) {
                boolean eventDirty = event.getSource().isDirty();
                if (this.getProjectAreaHandle().sameItemId((IItemHandle)event.getSource().getWorkItem().getProjectArea())) {
                    builder.changed(planItem, PlanItem.DIRTY, !eventDirty, eventDirty);
                    if (!eventDirty) {
                        planItem.removeWriteAbility(false);
                    }
                }
            }
        }
        finally {
            this.disconnectDeltaBuilder();
        }
    }

    private void handleWorkflowActionChanged(WorkingCopyEvent event) {
        PlanDeltaBuilder builder = this.connectDeltaBuilder();
        try {
            PlanItem planItem = this.getPlanItem((IWorkItemHandle)event.getSource().getWorkItem());
            if (planItem != null) {
                Identifier<IWorkflowAction> oldAction = planItem.getWorkflowAction();
                String newActionId = event.getSource().getWorkflowAction();
                Identifier newAction = newActionId == null ? null : Identifier.create(IWorkflowAction.class, (String)newActionId);
                planItem.internalSetWorkflowAction((Identifier<IWorkflowAction>)newAction);
                builder.changed(planItem, PlanItem.WORKFLOW_ACTION, oldAction, newAction);
            }
        }
        finally {
            this.disconnectDeltaBuilder();
        }
    }

    protected IItemResolveService getResolveService() {
        return this.fResolveService;
    }

    protected void addResolvedOwner(IContributor owner) {
        this.fOwners.put((IItemHandle)((IContributorHandle)owner.getItemHandle()), (Object)owner);
        this.addResolvedContributor(owner);
    }

    protected void addResolvedContributor(IContributor contributor) {
        this.fAllContributors.put((IItemHandle)((IContributorHandle)contributor.getItemHandle()), (Object)contributor);
    }

    protected void addResolvedCategory(ICategory category) {
        this.fCategoriesMap.put((IItemHandle)((ICategoryHandle)category.getItemHandle()), (Object)category);
    }

    protected void addResolvedIteration(IIteration interval) {
        this.fIntervalMap.put((IItemHandle)((IIterationHandle)interval.getItemHandle()), (Object)interval);
    }

    protected void addResolvedDevelopmentLine(IDevelopmentLine developmentLine) {
        this.fDevelopmentLineMap.put((IItemHandle)((IDevelopmentLineHandle)developmentLine.getItemHandle()), (Object)developmentLine);
    }

    protected void addResolvedProcessArea(IProcessArea processArea) {
        this.fProcessAreaMap.put((IItemHandle)((IProcessAreaHandle)processArea.getItemHandle()), (Object)processArea);
    }

    protected void addResolvedWorkItem(IWorkItem workItem) {
        ItemProfile<IWorkItem> profile = this.getWorkItemProfile();
        if (!profile.isMatched((IAuditable)workItem)) {
            Collection setProperties = ItemProfile.computeProfile((IAuditable)workItem).getProperties();
            ArrayList missing = new ArrayList(profile.getProperties());
            missing.removeAll(setProperties);
            Assert.isTrue((boolean)false, (String)NLS.bind((String)"Profile mismatch for WI {0}; {1}", (Object)workItem.getId(), (Object[])new Object[]{((Object)missing).toString()}));
        }
        this.fWorkItemMap.put((IItemHandle)((IWorkItemHandle)workItem.getItemHandle()), (Object)workItem);
    }

    public IWorkItem getResolvedWorkItem(IWorkItemHandle workItemHandle) {
        return (IWorkItem)this.fWorkItemMap.get((IItemHandle)workItemHandle);
    }

    protected IWorkItemWorkingCopyManager getWorkingCopyManager(boolean readOnly) {
        return readOnly ? this.fReadWorkingCopyManager : this.fWriteWorkingCopyManager;
    }

    protected void disconnectRemovedPlanItems() {
        this.accept(new IPlanElementVisitor(){

            public boolean visit(PlanElement element) {
                PlanItem planItem;
                if (element instanceof PlanItem && !ResolvedPlan.this.isRelevantForPlan((planItem = (PlanItem)element).getWorkItem(false))) {
                    planItem.getParent().removeChild(planItem);
                }
                return true;
            }
        });
        if (this.fRemovedWorkItems == null) {
            return;
        }
        boolean changed = false;
        PlanCheckReport newReport = new PlanCheckReport(this.fReport);
        for (PlanItem planItem : this.fRemovedWorkItems.values()) {
            changed |= newReport.removeReport(planItem) != null;
        }
        if (changed) {
            PlanDeltaBuilder builder = this.connectDeltaBuilder();
            try {
                builder.planCheckerChanged(this.fReport, newReport);
                this.fReport = newReport;
            }
            finally {
                this.disconnectDeltaBuilder();
            }
        }
        for (PlanItem planItem : this.fRemovedWorkItems.values()) {
            this.doDisconnectPlanItem(planItem);
            this.fWorkItemMap.remove((Object)planItem.getWorkItemHandle());
        }
        this.fRemovedWorkItems = null;
    }

    private void doDisconnectPlanItem(PlanItem planItem) {
        planItem.removeWriteAbility(false);
        this.fReadWorkingCopyManager.disconnect(planItem.getWorkItemHandle());
    }

    private void fireEvent(final IPlanElementChangeEvent event) {
        if (this.fConnectCounter == 0) {
            return;
        }
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IPlanElementListener listener = (IPlanElementListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.planElementChanged(event);
                }

                public void handleException(Throwable exception) {
                    PlanningClientPlugin.log(exception);
                }
            });
            ++i;
        }
    }

    protected void doProcessAdd(IWorkItem added, Runnable executeAfterProcessed) {
        this.connectDeltaBuilder();
        try {
            List<? extends PlanItem> items = this.processItem(added);
            if (executeAfterProcessed != null) {
                executeAfterProcessed.run();
            }
            if (!items.isEmpty()) {
                this.itemsAdded(items);
            }
        }
        finally {
            this.disconnectDeltaBuilder();
        }
    }

    protected void resolvePlanItem(IWorkItemHandle workItemHandle, IDeferredResolveListener<List<Object>> listener) throws MissingFutureExecutorServiceException {
        if (this.fResolveService == null) {
            throw new MissingFutureExecutorServiceException();
        }
        if (this.getPlanItem(workItemHandle) != null) {
            return;
        }
        this.doResolvePlanItems(Collections.singletonList(workItemHandle), listener, true);
    }

    private void processWorkItemChangeEvent(WorkItemChangeEvent event) {
        IWorkItem workItem = event.getWorkItem();
        PlanItem planItem = (PlanItem)this.fWorkItem2PlanItem.get((IItemHandle)workItem);
        if (planItem != null) {
            planItem.processWorkItemChangeEvent(event);
        } else if (this.getWorkItemProfile().isMatched((IAuditable)workItem) && this.isRelevantForPlan(workItem)) {
            this.handleNewRelevantWorkItem(workItem);
        } else if (this.fRemovedWorkItems != null && (planItem = (PlanItem)this.fRemovedWorkItems.get((IItemHandle)workItem)) != null) {
            this.fPlanChecker.runItemCheck(Collections.singletonList(planItem));
        }
    }

    private void processSharedWorkItemChangeEvent(ISharedItemChangeEvent event) {
        PlanItem planItem;
        Assert.isTrue((boolean)(event.getSharedItem() instanceof IWorkItem));
        IWorkItem workItem = (IWorkItem)event.getAfterState();
        if (workItem != null && (planItem = (PlanItem)this.fWorkItem2PlanItem.get((IItemHandle)workItem)) == null && this.getWorkItemProfile().isMatched((IAuditable)workItem) && this.isRelevantForPlan(workItem)) {
            this.handleNewRelevantWorkItem(workItem);
        }
    }

    private void handleNewRelevantWorkItem(final IWorkItem workItem) {
        boolean needResolve = true;
        final Runnable acceptCurrentUserWorkRunnable = new Runnable(){

            public void run() {
                WorkItemWorkingCopyImpl workingCopy;
                IWorkItem baseState;
                PlanItem planItem;
                IContributor currentUser = ResolvedPlan.this.getTeamRepository().loggedInContributor();
                if (currentUser != null && (planItem = ResolvedPlan.this.getPlanItem((IWorkItemHandle)workItem)) != null && currentUser.sameItemId((IItemHandle)planItem.getOwnerHandle()) && planItem.isNewItem() && ((baseState = (workingCopy = (WorkItemWorkingCopyImpl)planItem.getWorkItemWorkingCopy(false)).getBaseState()) == null || !baseState.getOwner().sameItemId((IItemHandle)planItem.getOwnerHandle()))) {
                    planItem.setSequenceValue(SequenceValue.FACTORY.successor(planItem.getSequenceManager().getLastSequenceValue()), false);
                }
            }
        };
        if (this.fReadWorkingCopyManager.connectLocal((IWorkItemHandle)workItem, this.getWorkItemProfile())) {
            boolean doDisconnect = true;
            try {
                WorkItemWorkingCopy wc = this.fReadWorkingCopyManager.getWorkingCopy((IWorkItemHandle)workItem);
                if (!this.isResolvingRequired(wc)) {
                    needResolve = false;
                    if (this.fRemovedWorkItems == null || !this.fRemovedWorkItems.containsKey((IItemHandle)workItem)) {
                        doDisconnect = false;
                    }
                    this.doProcessAdd(workItem, acceptCurrentUserWorkRunnable);
                } else {
                    Assert.isTrue((doDisconnect && needResolve ? 1 : 0) != 0);
                }
            }
            finally {
                if (doDisconnect) {
                    this.fReadWorkingCopyManager.disconnect((IWorkItemHandle)workItem);
                }
            }
        }
        if (needResolve) {
            try {
                this.resolvePlanItem((IWorkItemHandle)workItem, new IDeferredResolveListener<List<Object>>(){

                    @Override
                    public void resolved(List<Object> result) {
                        acceptCurrentUserWorkRunnable.run();
                    }

                    @Override
                    public void failed(IStatus state) {
                    }

                    @Override
                    public void canceled() {
                    }
                });
            }
            catch (MissingFutureExecutorServiceException missingFutureExecutorServiceException) {
                PlanningClientPlugin.log((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), 4, "No resolver service available", null));
            }
        }
    }

    private void processReadStateChangeEvent(ReadStateChangeEvent event) {
        PlanItem planItem;
        IItemHandle itemHandle = event.getItemHandle();
        if (itemHandle instanceof IWorkItemHandle && (planItem = (PlanItem)this.fWorkItem2PlanItem.get(itemHandle)) != null) {
            planItem.processReadStateChangeEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWorkItemIgnored(IWorkItemHandle workItemHandle) {
        ItemMap<IWorkItemHandle, Integer> itemMap = this.fIgnoredWorkItems;
        synchronized (itemMap) {
            Integer ignoredCount = (Integer)this.fIgnoredWorkItems.get((IItemHandle)workItemHandle);
            return ignoredCount != null && ignoredCount > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setWorkItemIgnored(IWorkItemHandle workItemHandle, boolean isIgnored) {
        ItemMap<IWorkItemHandle, Integer> itemMap = this.fIgnoredWorkItems;
        synchronized (itemMap) {
            Integer oldCount;
            if (workItemHandle instanceof IWorkItem) {
                workItemHandle = (IWorkItemHandle)((IWorkItem)workItemHandle).getItemHandle();
            }
            int newCount = ((oldCount = (Integer)this.fIgnoredWorkItems.get((IItemHandle)workItemHandle)) != null ? oldCount : 0) + (isIgnored ? 1 : -1);
            Assert.isTrue((newCount >= 0 ? 1 : 0) != 0);
            if (newCount > 0) {
                this.fIgnoredWorkItems.put((IItemHandle)workItemHandle, (Object)newCount);
            } else {
                this.fIgnoredWorkItems.remove((Object)workItemHandle);
            }
        }
    }

    protected void addAttributeChange(IPlanningAttributeIdentifier attributeId, Object oldValue, Object newValue) {
        PlanDeltaBuilder builder = this.connectDeltaBuilder();
        try {
            builder.changed(this, attributeId, oldValue, newValue);
        }
        finally {
            this.disconnectDeltaBuilder();
        }
    }

    private void removeFromPlanCheckerReport(PlanDeltaBuilder builder, PlanItem planItem) {
        if (this.fReport != null && this.fReport.getReport(planItem) != null) {
            PlanCheckReport newReport = new PlanCheckReport(this.fReport);
            newReport.removeReport(planItem);
            builder.planCheckerChanged(this.fReport, newReport);
            this.fReport = newReport;
        }
    }

    private class ReadStateListener
    implements IReadStateListener {
        private ReadStateListener() {
        }

        public void readStateChanged(ReadStateChangeEvent event) {
            if (ResolvedPlan.this.fConnectCounter > 0 && event.getItemHandle() instanceof IWorkItemHandle && !ResolvedPlan.this.isWorkItemIgnored((IWorkItemHandle)event.getItemHandle())) {
                ResolvedPlan.this.processReadStateChangeEvent(event);
            }
        }
    }

    private class ResourcePlanningListener
    implements IResourcePlanningListener {
        private ResourcePlanningListener() {
        }

        public void resourceNotification(ResourcePlanningEvent event) {
            if (Boolean.getBoolean("com.ibm.team.apt.ide.ui.ignoreResourcePlanningUpdates")) {
                return;
            }
            if (event.getType() == 2) {
                ResolvedPlan.this.doProcessResourcePlanningUpdate(event);
            }
        }
    }

    private class WorkItemListener
    implements IWorkItemListener,
    IWorkingCopyListener,
    ISharedItemChangeListener {
        private WorkItemListener() {
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            if (ResolvedPlan.this.fConnectCounter > 0 && !ResolvedPlan.this.isWorkItemIgnored((IWorkItemHandle)event.getWorkItem())) {
                ResolvedPlan.this.processWorkItemChangeEvent(event);
            }
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }

        public void workingCopyEvent(WorkingCopyEvent event) {
            WorkItemWorkingCopy wc = event.getSource();
            if (ResolvedPlan.this.fConnectCounter <= 0 || !ResolvedPlan.this.fWorkItemMap.containsKey((IItemHandle)wc.getWorkItem()) || ResolvedPlan.this.isWorkItemIgnored((IWorkItemHandle)wc.getWorkItem())) {
                return;
            }
            if ("dirtyState".equals(event.getType())) {
                ResolvedPlan.this.handleDirtyStateChanged(event);
            } else if ("workflowAction".equals(event.getType())) {
                ResolvedPlan.this.handleWorkflowActionChanged(event);
            }
        }

        public void itemsChanged(List events) {
            if (ResolvedPlan.this.fConnectCounter > 0) {
                for (ISharedItemChangeEvent event : events) {
                    Assert.isTrue((boolean)(event.getSharedItem() instanceof IWorkItem));
                    if (ResolvedPlan.this.isWorkItemIgnored((IWorkItemHandle)event.getSharedItem())) continue;
                    ResolvedPlan.this.processSharedWorkItemChangeEvent(event);
                }
            }
        }
    }
}

