/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.internal.client.AbstractPlanningAttribute;
import com.ibm.team.apt.internal.client.AttributeNotAvailableException;
import com.ibm.team.apt.internal.client.IPlanningAttributeValueSet;
import com.ibm.team.apt.internal.client.Messages;
import com.ibm.team.apt.internal.client.PlanDeltaBuilder;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.internal.model.ConfigurationItem;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.ChangeDetails;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.Identifier;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanItemWorkItemAttribute
extends AbstractPlanningAttribute<PlanItem, Object> {
    private final Identifier<IAttribute> fWorkItemAttributeId;
    private IAttribute fAttribute;
    private IPlanningAttributeValueSet<Object> fValueSet;
    private final boolean fAddCustomAttribute;
    private IEnumeration<? extends ILiteral> fEnumeration;
    private Map<Identifier<ILiteral>, ILiteral> fUnknownLiterals;

    public PlanItemWorkItemAttribute(IAttributeDefinitionDescriptor attributeDescriptor, Identifier<IAttribute> workItemAttributeId, boolean addCustomAttribute) {
        super(attributeDescriptor);
        this.fWorkItemAttributeId = workItemAttributeId;
        this.fAddCustomAttribute = addCustomAttribute;
    }

    public IAttribute getAttribute() {
        return this.fAttribute;
    }

    @Override
    public IPlanningAttributeValueSet<Object> getValueSet() {
        return this.fValueSet;
    }

    public void changed(PlanItem receiver, ChangeDetails changeDetails, PlanDeltaBuilder builder) {
        builder.changed(receiver, this, this.convertToPlanItem(changeDetails.getOldValue()), this.convertToPlanItem(changeDetails.getNewValue()));
    }

    @Override
    public void initialize(ResolvedPlan plan, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient(plan.getTeamRepository());
        this.fAttribute = workItemClient.findAttribute(plan.getProjectAreaHandle(), this.fWorkItemAttributeId.getStringIdentifier(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (this.fAttribute != null) {
            if (AttributeTypes.isEnumerationAttributeType((String)this.fAttribute.getAttributeType())) {
                this.fEnumeration = workItemClient.resolveEnumeration((IAttributeHandle)this.fAttribute, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.fEnumeration = workItemClient.resolveEnumeration((IAttributeHandle)this.fAttribute, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (this.fEnumeration != null) {
                    this.fValueSet = new IPlanningAttributeValueSet<Object>(){

                        @Override
                        public List<Object> getValues() {
                            return PlanItemWorkItemAttribute.this.fEnumeration.getEnumerationLiterals();
                        }

                        @Override
                        public Object getValue(String valueId) {
                            List literals = PlanItemWorkItemAttribute.this.fEnumeration.getEnumerationLiterals();
                            for (ILiteral literal : literals) {
                                if (!literal.getIdentifier2().getStringIdentifier().equals(valueId)) continue;
                                return literal;
                            }
                            return null;
                        }

                        @Override
                        public Object getNullValue() {
                            return PlanItemWorkItemAttribute.this.fEnumeration.findNullEnumerationLiteral();
                        }

                        @Override
                        public Collection<Object> getAllValues() {
                            return this.getValues();
                        }
                    };
                }
            }
        } else {
            PlanningClientPlugin.log((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), NLS.bind((String)Messages.PlanItemWorkItemAttribute_UNKNOWN_WORKITEM_ATTRIBUTE, (Object)this.getId(), (Object[])new Object[]{this.fWorkItemAttributeId.getStringIdentifier()})));
        }
        if (this.fValueSet == null) {
            this.fValueSet = new IPlanningAttributeValueSet.EmptyValueSet<Object>();
        }
    }

    @Override
    public Object getValue(PlanItem receiver) {
        if (this.fAttribute == null || !receiver.getWorkItem(false).hasAttribute(this.fAttribute)) {
            throw new AttributeNotAvailableException(this);
        }
        return this.convertToPlanItem(receiver.getWorkItem(false).getValue(this.fAttribute));
    }

    @Override
    public void setValue(PlanItem receiver, Object value) {
        if (this.fAttribute != null) {
            if (!receiver.getWorkItem(false).hasAttribute(this.fAttribute)) {
                if (!this.fAddCustomAttribute) {
                    return;
                }
                receiver.getWorkItem(true).addCustomAttribute(this.fAttribute);
            }
            receiver.getWorkItem(true).setValue(this.fAttribute, this.convertToWorkItem(value));
        }
    }

    @Override
    public boolean isSupported(Class<?> receiverType) {
        return PlanItem.class.isAssignableFrom(receiverType);
    }

    @Override
    public boolean isDefined(PlanItem receiver) {
        return this.fAttribute != null && receiver.getWorkItem(false).isAttributeSet(this.fAttribute);
    }

    private Object convertToPlanItem(Object value) {
        switch (this.getAttributeType()) {
            case ENUMERATION: {
                if (value != null) {
                    Identifier identifier = (Identifier)value;
                    ILiteral literal = this.fEnumeration.findEnumerationLiteral(identifier);
                    if (literal == null) {
                        if (this.fUnknownLiterals == null) {
                            this.fUnknownLiterals = new HashMap<Identifier<ILiteral>, ILiteral>();
                        }
                        if ((literal = this.fUnknownLiterals.get(identifier)) == null) {
                            URL unknownLiteralUrl = FileLocator.find((Bundle)Platform.getBundle((String)"com.ibm.team.apt.common"), (IPath)new Path("icons/obj16/unknown.png"), null);
                            literal = new ConfigurationItem(null, identifier.getStringIdentifier(), identifier.getStringIdentifier(), unknownLiteralUrl, Integer.MAX_VALUE - this.fUnknownLiterals.size());
                            this.fUnknownLiterals.put((Identifier<ILiteral>)identifier, literal);
                        }
                    }
                    return literal;
                }
                return null;
            }
            case DURATION: {
                return value != null ? new Duration(((Long)value).longValue()) : Duration.UNSPECIFIED;
            }
        }
        return value;
    }

    private Object convertToWorkItem(Object value) {
        switch (this.getAttributeType()) {
            case ENUMERATION: {
                return value != null ? ((ILiteral)value).getIdentifier2() : null;
            }
            case DURATION: {
                return value != null ? Long.valueOf(((Duration)value).longValue()) : null;
            }
            case INTEGER: {
                if (!(value instanceof Number)) {
                    return value;
                }
                String workItemType = this.fAttribute.getAttributeType();
                if ("integer".equals(workItemType)) {
                    return new Integer(((Number)value).intValue());
                }
                if (!"long".equals(workItemType)) break;
                return new Long(((Number)value).longValue());
            }
        }
        return value;
    }
}

