/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.common.resource.IContributorAbsence;
import com.ibm.team.apt.common.resource.IContributorAbsenceHandle;
import com.ibm.team.apt.internal.client.IScheduleItem;
import com.ibm.team.apt.internal.client.ItemSequenceManager;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.planchecker.CheckerReport;
import com.ibm.team.apt.internal.common.BookedTimeType;
import com.ibm.team.apt.internal.common.IBookedTime;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.workitem.common.internal.util.SequenceValue;
import java.util.Date;

public class OutOfOfficeItem
extends PlanElement
implements IScheduleItem,
IBookedTime {
    private IContributorAbsence fAbsence;
    private final ResolvedPlan fPlan;

    public OutOfOfficeItem(ResolvedPlan plan, IContributorAbsence absence) {
        this.fPlan = plan;
        this.fAbsence = absence;
    }

    public IContributorAbsenceHandle getAbsenceHandle() {
        return (IContributorAbsenceHandle)this.fAbsence.getItemHandle();
    }

    public Date getStart() {
        return this.fAbsence.getStartDate();
    }

    public Date getEnd() {
        return this.fAbsence.getEndDate();
    }

    public BookedTimeType getType() {
        return BookedTimeType.OUT_OF_OFFICE;
    }

    public String getSummary() {
        return this.fAbsence.getSummary();
    }

    public XMLString getHTMLSummary() {
        return XMLString.createFromXMLText((String)this.fAbsence.getSummary());
    }

    public void setSummary(String summary) {
        throw new UnsupportedOperationException();
    }

    public void setHTMLSummary(XMLString summary) {
        throw new UnsupportedOperationException();
    }

    public IContributor getOwner() {
        return this.fPlan.getResolvedContributor(this.fAbsence.getContributor());
    }

    public void setOwner(IContributor owner) {
        throw new UnsupportedOperationException();
    }

    public ItemSequenceManager getSequenceManager() {
        return this.fPlan.getItemSequenceManager(this);
    }

    public SequenceValue getSequenceValue() {
        return SequenceValue.NEW;
    }

    public Timespan getScheduledTime() {
        ItemSequenceManager sequenceManager = this.getSequenceManager();
        return sequenceManager != null ? sequenceManager.getScheduledTime(this) : null;
    }

    public boolean isOpen() {
        return this.fPlan.getReferenceTime().before(this.fAbsence.getStartDate());
    }

    public boolean isInProgress() {
        return !this.isOpen() && !this.isResolved();
    }

    public boolean isResolved() {
        return !this.fAbsence.getEndDate().after(this.fPlan.getReferenceTime());
    }

    public boolean isPrimaryPlanItem() {
        return true;
    }

    public boolean isDirty() {
        return false;
    }

    public ResolvedPlan getPlan() {
        return this.fPlan;
    }

    public CheckerReport getPlanCheckReport() {
        return null;
    }

    public PlanElement getParent() {
        return null;
    }

    public void moveTo(PlanElement newParent) {
        throw new UnsupportedOperationException();
    }

    public void addChild(PlanElement element) {
        throw new UnsupportedOperationException();
    }

    protected void doChildAdded(PlanElement parent, PlanElement child) {
        throw new UnsupportedOperationException();
    }

    protected void doChildRemoved(PlanElement parent, PlanElement child) {
        throw new UnsupportedOperationException();
    }
}

