/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.IOAuthClientLibrary;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.nls.Messages;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.model.OAuthSecretType;
import com.ibm.team.repository.common.model.OAuthServiceProviderInfo;
import com.ibm.team.repository.common.oauth.IOAuthProviderService;
import com.ibm.team.repository.common.oauth.IRemoteOAuthConsumerService;
import com.ibm.team.repository.common.oauth.OAuthHttpClient;
import com.ibm.team.repository.common.util.Base64;
import com.ibm.team.repository.common.util.NLS;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.text.MessageFormat;
import javax.crypto.KeyGenerator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class OAuthClientLibrary
extends EventSource
implements IOAuthClientLibrary {
    private IClientLibraryContext context;
    private IOAuthProviderService providerService;
    private IRemoteOAuthConsumerService consumerService;

    public OAuthClientLibrary(IClientLibraryContext context) {
        this.context = context;
        this.providerService = (IOAuthProviderService)context.getServiceInterface(IOAuthProviderService.class);
        this.consumerService = (IRemoteOAuthConsumerService)context.getServiceInterface(IRemoteOAuthConsumerService.class);
    }

    public String getAuthenticationToken(ITeamRepository consumerRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        IOAuthClientLibrary consumerLibrary = (IOAuthClientLibrary)consumerRepository.getClientLibrary(IOAuthClientLibrary.class);
        monitor = monitor == null ? new NullProgressMonitor() : monitor;
        String taskName = NLS.bind((String)Messages.getServerString("OAuthClientLibrary.GetAuthenticationToken"), (Object)this.context.teamRepository().getRepositoryURI(), (Object[])new Object[]{consumerRepository.getRepositoryURI()});
        monitor.beginTask(taskName, 2);
        try {
            final String consumerKey = consumerLibrary.ensureConsumerIsRegistered(this.context.teamRepository(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            String string = this.context.callCancelableService(new IClientLibraryContext.IServiceRunnable<String>(){

                @Override
                public String run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return OAuthClientLibrary.this.providerService.getAuthorizedRequestToken(consumerKey);
                }
            }, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            return string;
        }
        finally {
            monitor.done();
        }
    }

    public String ensureConsumerIsRegistered(ITeamRepository serviceProviderRepo, IProgressMonitor monitor) throws TeamRepositoryException {
        IOAuthClientLibrary spLib = (IOAuthClientLibrary)serviceProviderRepo.getClientLibrary(IOAuthClientLibrary.class);
        final OAuthServiceProviderInfo providerInfo = spLib.getServiceProviderInfo();
        monitor = monitor == null ? new NullProgressMonitor() : monitor;
        String taskName = NLS.bind((String)Messages.getServerString("OAuthClientLibrary.EnsureRegisteredConsumer"), (Object)this.context.teamRepository().getRepositoryURI(), (Object[])new Object[]{serviceProviderRepo.getRepositoryURI()});
        monitor.beginTask(taskName, 3);
        try {
            String key = this.context.callCancelableService(new IClientLibraryContext.IServiceRunnable<String>(){

                @Override
                public String run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return OAuthClientLibrary.this.consumerService.getConsumerKey(providerInfo.getRealm());
                }
            }, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (key == null) {
                KeyGenerator secretGenerator;
                try {
                    secretGenerator = KeyGenerator.getInstance("AES");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new TeamRepositoryException(MessageFormat.format("The required cipher algorithm \"{0}\" was not available", "AES"), (Throwable)e);
                }
                String consumerSecret = this.getBase64Encoded(secretGenerator.generateKey().getEncoded());
                String consumerKey = spLib.registerConsumer(consumerSecret, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                providerInfo.setConsumerKey(consumerKey);
                providerInfo.setConsumerSecret(consumerSecret);
                this.context.callCancelableService(new IClientLibraryContext.IServiceRunnable<Object>(){

                    @Override
                    public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                        OAuthClientLibrary.this.consumerService.register(providerInfo);
                        return null;
                    }
                }, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                key = consumerKey;
            }
            String string = key;
            return string;
        }
        finally {
            monitor.done();
        }
    }

    public String registerConsumer(final String consumerSecret, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.context.callCancelableService(new IClientLibraryContext.IServiceRunnable<String>(){

            @Override
            public String run(IProgressMonitor monitor) throws TeamRepositoryException {
                return OAuthClientLibrary.this.providerService.registerConsumer(OAuthSecretType.STRING_LITERAL, consumerSecret);
            }
        }, monitor);
    }

    public String registerConsumer(PublicKey publicKey, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec encodedKey = factory.getKeySpec(publicKey, X509EncodedKeySpec.class);
            byte[] encodedBytes = encodedKey.getEncoded();
            byte[] b64EncodedBytes = Base64.encode((byte[])encodedBytes);
            final String encodedSecret = new String(b64EncodedBytes, "ASCII");
            return this.context.callCancelableService(new IClientLibraryContext.IServiceRunnable<String>(){

                @Override
                public String run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return OAuthClientLibrary.this.providerService.registerConsumer(OAuthSecretType.RSA_PUBLIC_KEY_LITERAL, encodedSecret);
                }
            }, monitor);
        }
        catch (GeneralSecurityException exp) {
            throw new TeamRepositoryException("An unexpected security excpetion occurred.", (Throwable)exp);
        }
        catch (UnsupportedEncodingException exp) {
            throw new TeamRepositoryException("The ASCII character encoding could not be created.", (Throwable)exp);
        }
    }

    private String getBase64Encoded(byte[] bytes) throws TeamRepositoryException {
        try {
            return new String(Base64.encode((byte[])bytes), "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new TeamRepositoryException("The ASCII character encoding could not be found", (Throwable)e);
        }
    }

    public OAuthServiceProviderInfo getServiceProviderInfo() throws TeamRepositoryException {
        String repoURI = this.context.teamRepository().getRepositoryURI();
        OAuthServiceProviderInfo providerInfo = OAuthHttpClient.createProviderInfo((String)repoURI);
        if (repoURI.startsWith("https")) {
            byte[] signature;
            X509Certificate[] certificatePath = this.context.getServerCertificatePath();
            if (certificatePath == null || certificatePath.length == 0) {
                throw new TeamRepositoryException("The full service provider info cannot be built until at least one secure connection has been made.");
            }
            try {
                signature = certificatePath[0].getEncoded();
            }
            catch (CertificateEncodingException e) {
                throw new TeamRepositoryException("The service providers SSL certificate could not be saved", (Throwable)e);
            }
            String base64Signature = this.getBase64Encoded(signature);
            providerInfo.setPublicKey(base64Signature);
        }
        return providerInfo;
    }

    public void authorizeRequestToken(final String requestToken, final boolean approve, IProgressMonitor monitor) throws TeamRepositoryException {
        this.context.callCancelableService(new IClientLibraryContext.IServiceRunnable<Object>(){

            @Override
            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                OAuthClientLibrary.this.providerService.authorizeRequestToken(requestToken, approve);
                return null;
            }
        }, monitor);
    }
}

