/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVTokenizer {
    private static final char QUOTE = '\"';
    private final Reader fReader;
    private final String fDelimiter;
    private String fLineSeparator;
    private final List<List<String>> fTokens;

    public CSVTokenizer(Reader reader, String delimiter) throws IOException {
        this.fReader = reader;
        this.fDelimiter = delimiter;
        this.fTokens = new ArrayList<List<String>>();
        this.fLineSeparator = System.getProperty("line.separator");
        if (this.fLineSeparator == null || this.fLineSeparator.length() == 0) {
            this.fLineSeparator = "\n";
        }
        this.parse();
    }

    public List<List<String>> getRows() {
        return this.fTokens;
    }

    private void parse() throws IOException {
        BufferedReader bufReader = null;
        try {
            String line;
            StringBuilder prevRow = new StringBuilder();
            bufReader = new BufferedReader(this.fReader);
            while ((line = bufReader.readLine()) != null) {
                List<String> tokens;
                int quoteCount = this.count(line, '\"');
                if (prevRow.length() == 0) {
                    if (quoteCount == 0 || quoteCount % 2 == 0) {
                        tokens = this.parseTokens(line);
                        if (tokens.isEmpty()) continue;
                        this.fTokens.add(tokens);
                        continue;
                    }
                    prevRow.append(line);
                    continue;
                }
                if (quoteCount == 0 || quoteCount % 2 == 0) {
                    prevRow.append(this.fLineSeparator).append(line);
                    continue;
                }
                prevRow.append(this.fLineSeparator).append(line);
                tokens = this.parseTokens(prevRow.toString());
                if (!tokens.isEmpty()) {
                    this.fTokens.add(tokens);
                }
                prevRow.setLength(0);
            }
        }
        finally {
            if (bufReader != null) {
                bufReader.close();
            }
        }
    }

    private int count(String str, char c) {
        int count = 0;
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == c) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private List<String> parseTokens(String line) {
        ArrayList<StringBuilder> builderList = new ArrayList<StringBuilder>();
        int tokenIndex = 0;
        boolean inQuotes = false;
        boolean inOpenEscapedQuotes = false;
        builderList.add(new StringBuilder());
        int i = 0;
        while (i < line.length()) {
            char curChar = line.charAt(i);
            if (curChar == '\"' && !inQuotes) {
                inQuotes = true;
            } else if (curChar == '\"' && inQuotes) {
                if (!inOpenEscapedQuotes && i + 1 < line.length() && line.charAt(i + 1) == '\"') {
                    inOpenEscapedQuotes = true;
                    ((StringBuilder)builderList.get(tokenIndex)).append(curChar);
                } else if (i > 0 && line.charAt(i - 1) == '\"' && inOpenEscapedQuotes) {
                    inOpenEscapedQuotes = false;
                } else {
                    inQuotes = false;
                    inOpenEscapedQuotes = false;
                }
            } else if (!inQuotes && String.valueOf(curChar).equals(this.fDelimiter)) {
                ++tokenIndex;
                builderList.add(new StringBuilder());
            } else {
                ((StringBuilder)builderList.get(tokenIndex)).append(curChar);
            }
            ++i;
        }
        ArrayList<String> tokens = new ArrayList<String>(builderList.size());
        for (StringBuilder builder : builderList) {
            tokens.add(builder.toString());
        }
        return tokens;
    }
}

