/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.csv;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaException;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.IExtendedBugRetrievalStrategy;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.AttachmentData;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.AttachmentDescription;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.ReportData;
import com.ibm.team.workitem.rcp.core.internal.csv.CSVTokenizer;
import com.ibm.team.workitem.rcp.core.internal.csv.Messages;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVBugRetrievalStrategy
implements IExtendedBugRetrievalStrategy {
    private static final String DEFAULT_CHARSET = "UTF-16";
    private final String fCSVFile;
    private final String fDelimiter;
    private Map<String, ReportData> fDataMap = new TreeMap<String, ReportData>(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return Integer.valueOf(o1).compareTo(Integer.valueOf(o2));
        }
    });

    public CSVBugRetrievalStrategy(String csvFile, String delimiter) throws IOException {
        this.fCSVFile = csvFile;
        this.fDelimiter = delimiter;
        this.load();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String detectCharset(File file) {
        block14: {
            detector = new CharsetDetector();
            inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(file));
                detector.setText((InputStream)inputStream);
                match = detector.detect();
                if (match == null) break block14;
                if (match.getName().contains("UTF-16")) {
                }
                ** GOTO lbl-1000
            }
            catch (IOException v0) {
                try {
                }
                catch (Throwable var5_6) {
                    if (inputStream == null) throw var5_6;
                    try {
                        inputStream.close();
                        throw var5_6;
                    }
                    catch (IOException v1) {}
                    throw var5_6;
                }
            }
            if (inputStream == null) return "UTF-16";
            try {
                inputStream.close();
                return "UTF-16";
            }
            catch (IOException v2) {}
            return "UTF-16";
lbl-1000:
            // 1 sources

            {
                var6_5 = match.getName();
                if (inputStream == null) return var6_5;
            }
            try {
                inputStream.close();
                return var6_5;
            }
            catch (IOException v3) {}
            return var6_5;
        }
        if (inputStream == null) return "UTF-16";
        try {
            inputStream.close();
            return "UTF-16";
        }
        catch (IOException v4) {}
        return "UTF-16";
    }

    private void load() throws IOException {
        File file = new File(this.fCSVFile);
        String charset = this.detectCharset(file);
        CSVTokenizer tokenizer = new CSVTokenizer(new InputStreamReader((InputStream)new FileInputStream(file), charset), this.fDelimiter);
        List<List<String>> rows = tokenizer.getRows();
        if (rows.isEmpty()) {
            throw new IOException(Messages.CSVBugRetrievalStrategy_EOF);
        }
        ArrayList attributes = new ArrayList();
        attributes.addAll(rows.get(0));
        int i = 1;
        while (i < rows.size()) {
            List<String> rowTokens = rows.get(i);
            if (!rowTokens.isEmpty()) {
                if (rowTokens.size() > attributes.size()) {
                    throw new IOException(MessageFormat.format(Messages.CSVBugRetrievalStrategy_ERROR_COL_MISMATCH, i));
                }
                ReportData data = new ReportData();
                data.set("bug_id", NLS.bind((String)Messages.CSVBugRetrievalStrategy_CSV_LINE, (Object)file.getName(), (Object[])new Object[]{i}));
                int j = 0;
                while (j < rowTokens.size()) {
                    data.set((String)attributes.get(j), rowTokens.get(j));
                    ++j;
                }
                this.fDataMap.put(String.valueOf(i), data);
            }
            ++i;
        }
    }

    @Override
    public Iterator<String> getIterator() throws BugzillaException {
        return this.fDataMap.keySet().iterator();
    }

    @Override
    public int getNumberOfBugs() {
        return this.fDataMap.size();
    }

    @Override
    public ReportData getData(String id) {
        return this.fDataMap.get(id);
    }

    @Override
    public AttachmentData[] getAttachments(String id, List<AttachmentDescription> attachmentinfo) throws BugzillaException {
        return new AttachmentData[0];
    }

    @Override
    public String getXML(String id) throws BugzillaException {
        throw new UnsupportedOperationException();
    }
}

