/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.xml;

import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaException;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.Messages;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class Parser {
    private SAXParser fParser;

    public void parse(String nr, String source, DefaultHandler handler) throws BugzillaException {
        try {
            this.fParser.parse(new InputSource(new StringReader(source)), handler);
        }
        catch (SAXParseException e) {
            if (nr == null) {
                throw new BugzillaException(com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.Messages.Parser_UNEXPECTED_CONTENT, e);
            }
            throw new BugzillaException(Messages.getBugMessage(nr, com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.Messages.Parser_UNEXPECTED_CONTENT), e);
        }
        catch (SAXException e) {
            this.handleError(nr, e);
        }
        catch (IOException e) {
            this.handleError(nr, e);
        }
    }

    public Parser(boolean validating, boolean namespaceAware) throws BugzillaException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(validating);
            factory.setNamespaceAware(namespaceAware);
            this.fParser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            this.handleConfigurationError(e);
        }
        catch (SAXException e) {
            this.handleConfigurationError(e);
        }
    }

    private void handleConfigurationError(Throwable e) throws BugzillaException {
        throw new BugzillaException(e.getLocalizedMessage(), e);
    }

    private void handleError(String nr, Throwable e) throws BugzillaException {
        if (nr == null) {
            throw new BugzillaException(e.getLocalizedMessage(), e);
        }
        throw new BugzillaException(Messages.getBugMessage(nr, e.getLocalizedMessage()), e);
    }
}

