/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.xml;

import com.ibm.team.workitem.rcp.core.internal.WorkItemRCPCorePlugin;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Data {
    private static final DateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private final Map<String, String> fValues = new HashMap<String, String>();

    public void set(String key, String value) {
        this.fValues.put(key, value);
    }

    public void set(String key, Date date) {
        if (date == null) {
            date = new Date(0L);
        }
        this.set(key, sDateFormat.format(date));
    }

    public void set(String key, boolean state) {
        this.set(key, Boolean.valueOf(state).toString());
    }

    public String getString(String key) {
        return this.fValues.get(key);
    }

    public Date getDate(String key) {
        String date = this.fValues.get(key);
        if (date == null) {
            return null;
        }
        return Data.parseDate(date);
    }

    public static Date parseDate(String date) {
        try {
            return sDateFormat.parse(date);
        }
        catch (ParseException e) {
            Status status = new Status(4, "com.ibm.team.workitem.rcp.core", 104, "Could not parse date" + e.getMessage(), null);
            WorkItemRCPCorePlugin.getDefault().log(new CoreException((IStatus)status));
            return null;
        }
    }

    public boolean getBoolean(String key) {
        return Boolean.valueOf(this.getString(key));
    }

    public boolean exists(String key) {
        return this.fValues.containsKey(key);
    }

    public Map<String, String> getValues() {
        return Collections.unmodifiableMap(this.fValues);
    }
}

