/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BugzillaMapping;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.Messages;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.StringMapper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.ReportData;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsMapper
extends StringMapper {
    private IAttribute fAttribute;

    public TagsMapper(BugzillaMapping.AttributeMapping attributeMapping, BugzillaMapping.AttributeTypeMapping attributeTypeMapping) {
        super(attributeMapping, attributeTypeMapping);
    }

    @Override
    public XMLString copy(IWorkItem workItem, ReportData data, boolean isUpdate, LocalizationContext localization, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fAttribute == null || !this.fAttribute.getProjectArea().sameItemId((IItemHandle)workItem.getProjectArea())) {
            this.fAttribute = this.getAttributeMapping().resolveTargetAttribute(workItem.getProjectArea(), monitor);
        }
        if (this.fAttribute == null) {
            return null;
        }
        String sourceValue = data.getString(this.getAttributeMapping().getSourceId());
        if (sourceValue == null) {
            return null;
        }
        BugzillaMapping.ValueMapping valueMapping = this.getValueMapping(sourceValue);
        String targetValueId = valueMapping != null ? valueMapping.getTargetId() : sourceValue;
        Object targetValue = this.findValue(targetValueId);
        List<String> tagList = this.convertToList(targetValue.toString());
        if (!workItem.hasAttribute(this.fAttribute)) {
            workItem.addCustomAttribute(this.fAttribute);
        }
        workItem.setValue(this.fAttribute, tagList);
        if (!this.isAccurate(valueMapping, targetValueId)) {
            return XMLString.createFromPlainText((String)NLS.bind((String)Messages.getString(localization, "EnumerationMapper_ATTRIBUTE_WAS_VALUE"), (Object)this.fAttribute.getDisplayName(), (Object[])new Object[]{sourceValue}));
        }
        return null;
    }

    private List<String> convertToList(String tagsInString) {
        StringTokenizer tokenizer = new StringTokenizer(tagsInString, " \t\r\n,", false);
        ArrayList<String> tagList = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            tagList.add(token);
        }
        return tagList;
    }
}

