/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.AttributeMapper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BugzillaMapping;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.Messages;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.ReportData;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class SimpleMapper
extends AttributeMapper {
    private IAttribute fAttribute;

    public SimpleMapper(BugzillaMapping.AttributeMapping attributeMapping, BugzillaMapping.AttributeTypeMapping attributeTypeMapping) {
        super(attributeMapping, attributeTypeMapping);
    }

    protected abstract Object findValue(String var1);

    protected abstract boolean isAccurate(BugzillaMapping.ValueMapping var1, String var2);

    protected IAttribute getAttribute() {
        return this.fAttribute;
    }

    public XMLString copy(IWorkItem workItem, ReportData data, boolean isUpdate, LocalizationContext localization, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fAttribute == null || !this.fAttribute.getProjectArea().sameItemId((IItemHandle)workItem.getProjectArea())) {
            this.fAttribute = this.getAttributeMapping().resolveTargetAttribute(workItem.getProjectArea(), monitor);
        }
        if (this.fAttribute == null) {
            return null;
        }
        boolean isState = WorkItemAttributes.getAttributeId((Identifier)WorkItemAttributes.STATE).equals(this.fAttribute.getIdentifier());
        boolean isResolution = WorkItemAttributes.getAttributeId((Identifier)WorkItemAttributes.RESOLUTION).equals(this.fAttribute.getIdentifier());
        boolean isCreationDate = WorkItemAttributes.getAttributeId((Identifier)WorkItemAttributes.CREATION_DATE).equals(this.fAttribute.getIdentifier());
        boolean isResolutionDate = WorkItemAttributes.getAttributeId((Identifier)WorkItemAttributes.RESOLUTION_DATE).equals(this.fAttribute.getIdentifier());
        if (!(isState || isResolution || isCreationDate || isResolutionDate || !this.fAttribute.isInternal() && !this.fAttribute.isReadOnly())) {
            return null;
        }
        String sourceValue = data.getString(this.getAttributeMapping().getSourceId());
        if (sourceValue == null) {
            return null;
        }
        BugzillaMapping.ValueMapping valueMapping = this.getValueMapping(sourceValue);
        String targetValueId = valueMapping != null ? valueMapping.getTargetId() : (isState ? this.findValueForState(workItem, sourceValue, monitor) : (isResolution ? this.findValueForResolution(workItem, sourceValue, monitor) : sourceValue));
        Object targetValue = this.findValue(targetValueId);
        if (!workItem.hasAttribute(this.fAttribute)) {
            workItem.addCustomAttribute(this.fAttribute);
        }
        workItem.setValue(this.fAttribute, targetValue);
        if (!this.isAccurate(valueMapping, targetValueId)) {
            return XMLString.createFromPlainText((String)NLS.bind((String)Messages.getString(localization, "EnumerationMapper_ATTRIBUTE_WAS_VALUE"), (Object)this.fAttribute.getDisplayName(), (Object[])new Object[]{sourceValue}));
        }
        return null;
    }

    private String findValueForState(IWorkItem item, String sourceValue, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkflowInfo workFlowInfo = this.getWorkFlowInfo(item, monitor);
        if (workFlowInfo != null) {
            Identifier[] stateIds;
            Identifier[] identifierArray = stateIds = workFlowInfo.getAllStateIds();
            int n = stateIds.length;
            int n2 = 0;
            while (n2 < n) {
                Identifier stateId = identifierArray[n2];
                String stateName = workFlowInfo.getStateName(stateId);
                if (stateName.equals(sourceValue)) {
                    return stateId.getStringIdentifier();
                }
                ++n2;
            }
        }
        return sourceValue;
    }

    private String findValueForResolution(IWorkItem item, String sourceValue, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkflowInfo workFlowInfo = this.getWorkFlowInfo(item, monitor);
        if (workFlowInfo != null) {
            Identifier[] resolutionIds;
            Identifier[] identifierArray = resolutionIds = workFlowInfo.getAllResolutionIds();
            int n = resolutionIds.length;
            int n2 = 0;
            while (n2 < n) {
                Identifier resolutionId = identifierArray[n2];
                String resolutionName = workFlowInfo.getResolutionName(resolutionId);
                if (resolutionName.equals(sourceValue)) {
                    return resolutionId.getStringIdentifier();
                }
                ++n2;
            }
        }
        return sourceValue;
    }

    private IWorkflowInfo getWorkFlowInfo(IWorkItem item, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = (ITeamRepository)item.getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
        IWorkflowInfo workFlowInfo = workItemClient.findCachedWorkflowInfo(item);
        if (workFlowInfo == null) {
            workFlowInfo = workItemClient.findWorkflowInfo(item, monitor);
        }
        return workFlowInfo;
    }
}

