/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers;

import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.DurationFormat;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BugzillaMapping;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.NumberMapper;
import java.text.ParseException;

public class DurationMapper
extends NumberMapper {
    private static final DurationFormat fgDurationFormat = DurationFormat.getInstance();

    public DurationMapper(BugzillaMapping.AttributeMapping attributeMapping, BugzillaMapping.AttributeTypeMapping attributeTypeMapping) {
        super(attributeMapping, attributeTypeMapping);
    }

    protected Object findValue(String valueId) {
        if (valueId == null || valueId.length() == 0) {
            return Duration.UNSPECIFIED.longValue();
        }
        try {
            return fgDurationFormat.parse(valueId).longValue();
        }
        catch (ParseException parseException) {
            return this.findValueUsingNumberFormat(valueId);
        }
    }

    protected boolean isAccurate(BugzillaMapping.ValueMapping valueMapping, String valueId) {
        if (valueMapping != null && !valueMapping.isAccurate()) {
            return false;
        }
        if (valueId == null || valueId.length() == 0) {
            return true;
        }
        try {
            fgDurationFormat.parse(valueId);
            return true;
        }
        catch (ParseException parseException) {
            return super.isAccurate(valueMapping, valueId);
        }
    }

    private Object findValueUsingNumberFormat(String valueId) {
        Number value = this.parseNumber(valueId);
        if (value == null) {
            return Duration.UNSPECIFIED.longValue();
        }
        return (long)(3600000.0f * value.floatValue());
    }
}

