/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IDeliverable;
import com.ibm.team.workitem.common.model.IDeliverableHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.AttributeMapper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BugzillaMapping;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.ReportData;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class DeliverableMapper
extends AttributeMapper {
    private IAttribute fAttribute;
    private Map<String, IDeliverableHandle> fDeliverables = new HashMap<String, IDeliverableHandle>();

    public DeliverableMapper(BugzillaMapping.AttributeMapping attributeMapping, BugzillaMapping.AttributeTypeMapping attributeTypeMapping) {
        super(attributeMapping, attributeTypeMapping);
    }

    public XMLString copy(IWorkItem workItem, ReportData data, boolean isUpdate, LocalizationContext localization, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectAreaHandle projectArea = workItem.getProjectArea();
        this.invalidateCachedValues(projectArea);
        if (this.fAttribute == null) {
            this.fAttribute = this.getAttributeMapping().resolveTargetAttribute(projectArea, monitor);
        }
        if (this.fAttribute == null) {
            return null;
        }
        String sourceName = data.getString(this.getAttributeMapping().getSourceId());
        String targetName = this.getTargetName(sourceName);
        if (targetName == null || targetName.length() == 0) {
            return null;
        }
        IDeliverableHandle deliverable = this.findOrCreateDeliverable(projectArea, targetName, monitor);
        if (!workItem.hasAttribute(this.fAttribute)) {
            workItem.addCustomAttribute(this.fAttribute);
        }
        workItem.setValue(this.fAttribute, (Object)deliverable);
        return null;
    }

    private void invalidateCachedValues(IProjectAreaHandle projectArea) {
        if (this.fAttribute != null && !this.fAttribute.getProjectArea().sameItemId((IItemHandle)projectArea)) {
            this.fAttribute = null;
            this.fDeliverables.clear();
        }
    }

    private String getTargetName(String sourceName) {
        BugzillaMapping.ValueMapping valueMapping = this.getValueMapping(sourceName);
        String targetName = valueMapping != null ? valueMapping.getTargetId() : sourceName;
        return targetName;
    }

    private IDeliverableHandle findOrCreateDeliverable(IProjectAreaHandle projectArea, String name, IProgressMonitor monitor) throws TeamRepositoryException {
        IDeliverableHandle deliverable = this.fDeliverables.get(name);
        if (deliverable != null) {
            return deliverable;
        }
        ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        IDeliverable item = workItemClient.findDeliverableByName(projectArea, name, IDeliverable.SMALL_PROFILE, monitor);
        if (item == null) {
            item = workItemClient.createDeliverable(projectArea, name, monitor);
            workItemClient.saveDeliverable(item, monitor);
        }
        IDeliverableHandle handle = (IDeliverableHandle)item.getItemHandle();
        this.fDeliverables.put(name, handle);
        return handle;
    }
}

