/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.internal.AuditableClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.model.DefaultModel;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.internal.util.PermissionContext;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.AttributeMapper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BugzillaMapping;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.ReportData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class ContributorMapper
extends AttributeMapper {
    private Map<String, IContributorHandle> fContributorsByEmail = new HashMap<String, IContributorHandle>();
    private Map<String, IContributorHandle> fContributorsByName = new HashMap<String, IContributorHandle>();
    private Map<String, IContributorHandle> fContributorsByUserId = new HashMap<String, IContributorHandle>();
    private IAttribute fAttribute;

    public ContributorMapper(BugzillaMapping.AttributeMapping attributeMapping, BugzillaMapping.AttributeTypeMapping attributeTypeMapping) {
        super(attributeMapping, attributeTypeMapping);
    }

    public XMLString copy(IWorkItem workItem, ReportData data, boolean isUpdate, LocalizationContext localization, IProgressMonitor monitor) throws TeamRepositoryException {
        String username;
        ITeamRepository teamRepository = (ITeamRepository)workItem.getOrigin();
        if (this.fAttribute == null || !this.fAttribute.getProjectArea().sameItemId((IItemHandle)workItem.getProjectArea())) {
            this.fAttribute = this.getAttributeMapping().resolveTargetAttribute(workItem.getProjectArea(), monitor);
        }
        if (this.fAttribute == null) {
            return null;
        }
        if (this.getAttributeMapping().getSourceId().equals("cc")) {
            for (String cc : data.ccs) {
                IContributorHandle handle = this.findContributor(teamRepository, cc, monitor);
                if (handle == null) continue;
                workItem.getSubscriptions().add(handle);
            }
        }
        if ((username = data.getString(this.getAttributeMapping().getSourceId())) == null || DefaultModel.NULL_CONTRIBUTOR_NAME.equals(username)) {
            return null;
        }
        IContributorHandle handle = null;
        handle = username != null && username.length() == 0 && isUpdate ? (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle(DefaultModel.NULL_CONTRIBUTOR_ITEM_ID, null) : this.findContributor(teamRepository, username, monitor);
        if (handle == null) {
            return null;
        }
        if (!workItem.hasAttribute(this.fAttribute)) {
            workItem.addCustomAttribute(this.fAttribute);
        }
        workItem.setValue(this.fAttribute, (Object)handle);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public IContributorHandle findContributor(ITeamRepository teamRepository, String username, IProgressMonitor monitor) throws TeamRepositoryException {
        auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        valueMapping = this.getValueMapping(username);
        userId = valueMapping != null ? valueMapping.getTargetId() : username;
        if (userId.length() == 0) {
            return null;
        }
        handle = this.fContributorsByUserId.get(userId);
        if (handle != null) {
            return handle;
        }
        handle = this.fContributorsByEmail.get(username);
        if (handle != null) {
            return handle;
        }
        handle = this.fContributorsByName.get(username);
        if (handle != null) {
            return handle;
        }
        try {
            contributor = teamRepository.contributorManager().fetchContributorByUserId(userId, monitor);
            return this.cache(contributor);
        }
        catch (ItemNotFoundException v0) {
            iter = WorkItemQueries.contributorByEmail((IAuditableCommon)auditableClient, (String)username);
            ** while (iter.hasNext((IProgressMonitor)monitor))
        }
lbl-1000:
        // 1 sources

        {
            contributor = (IContributor)auditableClient.resolveAuditable((IAuditableHandle)iter.next(monitor), ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
            if (contributor.isArchived() && iter.hasNext(monitor)) continue;
            return this.cache(contributor);
        }
lbl24:
        // 1 sources

        iter = WorkItemQueries.contributorByName((IAuditableCommon)auditableClient, (String)username);
        while (iter.hasNext(monitor)) {
            contributor = (IContributor)auditableClient.resolveAuditable((IAuditableHandle)iter.next(monitor), ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
            if (contributor.isArchived() && iter.hasNext(monitor)) continue;
            return this.cache(contributor);
        }
        contributor = (IContributor)auditableClient.createAuditable(IContributor.ITEM_TYPE);
        PermissionContext.setDefault((IItem)contributor);
        contributor.setName(this.inferNameFromEmailAdress(username));
        contributor.setEmailAddress(username);
        contributor.setUserId(userId);
        contributor = teamRepository.contributorManager().saveContributor(contributor, monitor);
        ((AuditableClient)auditableClient).updateFromItemManager(Collections.singletonList(contributor), monitor);
        return this.cache(contributor);
    }

    private IContributorHandle cache(IContributor contributor) {
        IContributorHandle handle = (IContributorHandle)contributor.getItemHandle();
        this.fContributorsByEmail.put(contributor.getEmailAddress(), handle);
        this.fContributorsByUserId.put(contributor.getUserId(), handle);
        this.fContributorsByName.put(contributor.getName(), handle);
        return handle;
    }

    private String inferNameFromEmailAdress(String email) {
        int i = email.indexOf(64);
        String string = i <= 0 ? email : email.substring(0, i);
        String inferredName = this.capitalizeFirstLetter(string);
        String[] name = inferredName.split("_");
        if (name.length == 2) {
            int isDoubleName = name[0].indexOf("-");
            if (isDoubleName > 0) {
                int firstLetterOfSecondName = isDoubleName + 1;
                name[0] = String.valueOf(name[0].substring(0, firstLetterOfSecondName)) + this.capitalizeFirstLetter(name[0].substring(firstLetterOfSecondName));
            }
            inferredName = String.valueOf(name[0]) + " " + this.capitalizeFirstLetter(name[1]);
        }
        return inferredName;
    }

    private String capitalizeFirstLetter(String inferredName) {
        return String.valueOf(inferredName.substring(0, 1).toUpperCase()) + inferredName.substring(1);
    }

    public void record(ReportData data, IProgressMonitor monitor) {
        if ("cc".equals(this.getAttributeMapping().getSourceId())) {
            for (String cc : data.ccs) {
                if (cc == null || cc.length() <= 0) continue;
                if (this.getAttributeTypeMapping().getTargetId().length() > 0) {
                    this.getAttributeTypeMapping().recordValueMapping(cc);
                    continue;
                }
                this.getAttributeMapping().recordValueMapping(cc);
            }
            return;
        }
        super.record(data, monitor);
    }
}

