/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IComments;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.AttributeMapper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BugzillaMapping;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.ReportData;
import org.eclipse.core.runtime.IProgressMonitor;

public class CommentsMapper
extends AttributeMapper {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public CommentsMapper(BugzillaMapping.AttributeMapping attributeMapping, BugzillaMapping.AttributeTypeMapping attributeTypeMapping) {
        super(attributeMapping, attributeTypeMapping);
    }

    public XMLString copy(IWorkItem workItem, ReportData data, boolean isUpdate, LocalizationContext localization, IProgressMonitor monitor) throws TeamRepositoryException {
        IComments comments = workItem.getComments();
        String commentValue = data.getString(this.getAttributeMapping().getSourceId());
        if (commentValue != null) {
            commentValue = this.findNewComment(comments, commentValue);
        }
        if (commentValue == null || commentValue.trim().length() == 0) {
            return null;
        }
        IContributor loggedInContributor = ((ITeamRepository)workItem.getOrigin()).loggedInContributor();
        if (loggedInContributor != null) {
            IComment comment = comments.createComment((IContributorHandle)loggedInContributor, XMLString.createFromPlainText((String)commentValue.trim()));
            comments.append(comment);
        }
        return null;
    }

    private String findNewComment(IComments commentsObj, String commentValue) {
        IComment[] comments = commentsObj.getContents();
        if (comments.length == 0 || commentValue.length() == 0) {
            return commentValue;
        }
        String lastCommentContent = comments[comments.length - 1].getHTMLContent().getPlainText();
        String lastCommentContentWithSeparator = String.valueOf(lastCommentContent) + LINE_SEPARATOR;
        int indexOfLastComment = commentValue.lastIndexOf(lastCommentContentWithSeparator);
        if (indexOfLastComment >= 0) {
            return commentValue.substring(indexOfLastComment + lastCommentContentWithSeparator.length());
        }
        indexOfLastComment = commentValue.lastIndexOf(lastCommentContent);
        if (indexOfLastComment >= 0) {
            return commentValue.substring(indexOfLastComment + lastCommentContent.length());
        }
        return commentValue;
    }
}

