/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers;

import com.ibm.icu.text.Collator;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.FileLocator;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaConfiguration;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.Messages;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaMapping {
    private List<InternalMapping> fMappings = new ArrayList<InternalMapping>();
    private List<AttributeMapping> fAttributeMappings = new ArrayList<AttributeMapping>();
    private Map<String, AttributeTypeMapping> fAttributeTypeMappings = new HashMap<String, AttributeTypeMapping>();

    public static BugzillaMapping readMapping(String url) throws TeamRepositoryException {
        return BugzillaMapping.readMapping(url, false);
    }

    private static BugzillaMapping readMapping(String url, boolean forRecording) throws TeamRepositoryException {
        try {
            BugzillaMapping mapping = new BugzillaMapping();
            XMLReader xmlReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            MappingHandler handler = new MappingHandler(mapping, forRecording);
            xmlReader.setContentHandler(handler);
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            xmlReader.parse(url);
            return mapping;
        }
        catch (SAXException x) {
            throw new TeamRepositoryException(Messages.BugzillaMapping_EXCEPTION_PARSING_MAPPING, (Throwable)x);
        }
        catch (ParserConfigurationException x) {
            throw new TeamRepositoryException(Messages.BugzillaMapping_EXCEPTION_PARSING_MAPPING, (Throwable)x);
        }
        catch (FactoryConfigurationError x) {
            throw new TeamRepositoryException(Messages.BugzillaMapping_EXCEPTION_PARSING_MAPPING, (Throwable)x);
        }
        catch (IOException x) {
            throw new TeamRepositoryException(Messages.BugzillaMapping_EXCEPTION_PARSING_MAPPING, (Throwable)x);
        }
    }

    public static BugzillaMapping readDefaultMapping() throws TeamRepositoryException {
        return BugzillaMapping.readMapping(BugzillaMapping.getDefaultMappingURL().toString());
    }

    public static BugzillaMapping readDefaultMapping(BugzillaConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isTrue((configuration.getProjectArea() != null ? 1 : 0) != 0);
        BugzillaMapping mapping = new BugzillaMapping();
        ITeamRepository teamRepository = configuration.getTeamRepository();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        List attributes = workItemClient.findAttributes(configuration.getProjectArea(), monitor);
        List builtInAttributes = workItemClient.findBuiltInAttributes(configuration.getProjectArea(), monitor);
        final ArrayList<UUID> builtInAttributeUUIDs = new ArrayList<UUID>(builtInAttributes.size());
        for (IAttributeHandle handle : builtInAttributes) {
            builtInAttributeUUIDs.add(handle.getItemId());
        }
        final Collator coll = Collator.getInstance();
        coll.setStrength(1);
        Collections.sort(attributes, new Comparator<IAttribute>(){

            @Override
            public int compare(IAttribute a1, IAttribute a2) {
                boolean a1BuiltIn = builtInAttributeUUIDs.contains(a1.getItemId());
                boolean a2BuiltIn = builtInAttributeUUIDs.contains(a2.getItemId());
                if (a1BuiltIn && a2BuiltIn) {
                    return coll.compare(a1.getDisplayName(), a2.getDisplayName());
                }
                return a1BuiltIn ? -1 : 1;
            }
        });
        for (IAttribute attribute : attributes) {
            String sourceId = attribute.getDisplayName();
            Identifier identifier = WorkItemAttributes.getPropertyIdentifier((String)attribute.getIdentifier());
            if (!BugzillaMapping.isSupported((Identifier<IAttribute>)identifier)) continue;
            AttributeMapping attributeMapping = new AttributeMapping(mapping, sourceId, identifier.getStringIdentifier());
            if (!AttributeTypes.isEnumerationAttributeType((String)attribute.getAttributeType())) continue;
            IEnumeration enumeration = workItemClient.resolveEnumeration((IAttributeHandle)attribute, monitor);
            List list = enumeration.getEnumerationLiterals();
            for (ILiteral literal : list) {
                String name = literal.getName();
                String id = literal.getIdentifier2().getStringIdentifier();
                ValueMapping valueMapping = new ValueMapping(name, id, true);
                valueMapping.setInUse(true);
                attributeMapping.addValueMapping(valueMapping);
            }
            String defaultValue = "";
            ILiteral defaultEnumerationLiteral = enumeration.findDefaultEnumerationLiteral();
            if (defaultEnumerationLiteral != null && defaultEnumerationLiteral.getIdentifier2() != null) {
                defaultValue = defaultEnumerationLiteral.getIdentifier2().getStringIdentifier();
            }
            ValueMapping defaultMapping = new ValueMapping("*", defaultValue, true);
            defaultMapping.setInUse(true);
            attributeMapping.addValueMapping(defaultMapping);
        }
        new AttributeMapping(mapping, "*", "");
        return mapping;
    }

    private static boolean isSupported(Identifier<IAttribute> identifier) {
        if (WorkItemAttributes.APPROVAL_DESCRIPTORS.equals(identifier)) {
            return false;
        }
        if (WorkItemAttributes.APPROVALS.equals(identifier)) {
            return false;
        }
        if (WorkItemAttributes.SUBSCRIPTIONS.equals(identifier)) {
            return false;
        }
        return !WorkItemAttributes.TYPE.equals(identifier);
    }

    public static BugzillaMapping createMappingForRecording() throws TeamRepositoryException {
        return BugzillaMapping.readMapping(BugzillaMapping.getDefaultMappingURL().toString(), true);
    }

    public static URL getDefaultMappingURL() {
        return FileLocator.find((String)"com.ibm.team.workitem.rcp.core", (IPath)new Path("resources/bugzilla_mapping.xml"));
    }

    public static BugzillaMapping createCustomMapping() {
        return new BugzillaMapping();
    }

    private BugzillaMapping() {
    }

    public List<AttributeMapping> getAttributeMappings() {
        return this.fAttributeMappings;
    }

    public List<AttributeTypeMapping> getAttributeTypeMappings() {
        return new ArrayList<AttributeTypeMapping>(this.fAttributeTypeMappings.values());
    }

    public AttributeTypeMapping findAttributeTypeMapping(String attributeType) {
        AttributeTypeMapping mapping = this.fAttributeTypeMappings.get(attributeType);
        if (mapping == null) {
            mapping = new AttributeTypeMapping(this, attributeType);
        }
        return mapping;
    }

    public Map<String, AttributeMapping> getAttributeMappingsBySourceId() {
        HashMap<String, AttributeMapping> map = new HashMap<String, AttributeMapping>(this.fAttributeMappings.size());
        for (AttributeMapping mapping : this.fAttributeMappings) {
            map.put(mapping.getSourceId(), mapping);
        }
        return map;
    }

    public void write(Writer writer, IProgressMonitor monitor) throws TeamRepositoryException {
        this.write(writer, false, monitor);
    }

    public void write(Writer writer, boolean withInstructions, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mapping version=\"1\">\n");
            if (withInstructions) {
                writer.write("<!--\r\n\t\r\n\t");
                writer.write(Messages.BugzillaMapping_MAPPING_HELP);
                writer.write("\r\n\t\r\n-->\n");
            }
            for (InternalMapping mapping : this.fMappings) {
                mapping.write(writer, monitor);
            }
            writer.write("</mapping>\n");
        }
        catch (IOException x) {
            throw new TeamRepositoryException((Throwable)x);
        }
    }

    private static String escapeForXML(String textToEscape) {
        if (textToEscape == null) {
            return textToEscape;
        }
        String escapedText = textToEscape.replace("&", "&amp;");
        escapedText = escapedText.replace("<", "&lt;");
        escapedText = escapedText.replace(">", "&gt;");
        escapedText = escapedText.replace("\"", "&quot;");
        escapedText = escapedText.replace("'", "&apos;");
        return escapedText;
    }

    public static class AttributeMapping
    extends InternalMapping {
        private String fSourceId;
        private IProjectAreaHandle fProjectArea;
        private IAttribute fAttribute;

        public AttributeMapping(BugzillaMapping bugzillaMapping, String sourceId, String targetId) {
            super(bugzillaMapping, targetId);
            this.fSourceId = sourceId;
            bugzillaMapping.fAttributeMappings.add(this);
        }

        public String getSourceId() {
            return this.fSourceId;
        }

        public IAttribute resolveTargetAttribute(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
            if (projectArea.sameItemId((IItemHandle)this.fProjectArea)) {
                return this.fAttribute;
            }
            ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
            IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
            String targetId = this.getTargetId();
            if (targetId.length() == 0) {
                return null;
            }
            String identifier = WorkItemAttributes.getAttributeId((Identifier)Identifier.create(IAttribute.class, (String)targetId));
            this.fAttribute = workItemClient.findAttribute(projectArea, identifier, monitor);
            this.fProjectArea = projectArea;
            return this.fAttribute;
        }

        public void write(Writer writer, IProgressMonitor monitor) throws TeamRepositoryException {
            try {
                String sourceId = this.getSourceId();
                String targetId = this.getTargetId();
                if ("".equals(sourceId)) {
                    return;
                }
                if (targetId != null && targetId.length() > 0) {
                    writer.write("\t<attribute sourceId=\"" + BugzillaMapping.escapeForXML(sourceId) + "\" targetId=\"" + BugzillaMapping.escapeForXML(targetId) + "\"");
                } else {
                    writer.write("\t<attribute sourceId=\"" + BugzillaMapping.escapeForXML(sourceId) + "\"");
                }
                if (this.getValueMappings().isEmpty()) {
                    writer.write("/>\n");
                } else {
                    writer.write(">\n");
                    ArrayList<ValueMapping> valueMappings = new ArrayList<ValueMapping>(this.getValueMappings());
                    Collections.sort(valueMappings, new Comparator<ValueMapping>(){

                        @Override
                        public int compare(ValueMapping o1, ValueMapping o2) {
                            int result = Collator.getInstance().compare(o1.getTargetId(), o2.getTargetId());
                            if (result != 0) {
                                return result;
                            }
                            return Collator.getInstance().compare(o1.getSourceId(), o2.getSourceId());
                        }
                    });
                    for (ValueMapping valueMapping : valueMappings) {
                        valueMapping.write(writer, monitor);
                    }
                    writer.write("\t</attribute>\n");
                }
            }
            catch (IOException x) {
                throw new TeamRepositoryException((Throwable)x);
            }
        }
    }

    public static class AttributeTypeMapping
    extends InternalMapping {
        public AttributeTypeMapping(BugzillaMapping bugzillaMapping, String targetId) {
            super(bugzillaMapping, targetId);
            bugzillaMapping.fAttributeTypeMappings.put(targetId, this);
        }

        public void write(Writer writer, IProgressMonitor monitor) throws TeamRepositoryException {
            try {
                if (this.getValueMappings().isEmpty()) {
                    return;
                }
                String targetId = this.getTargetId();
                writer.write("\t<attributeType targetId=\"" + BugzillaMapping.escapeForXML(targetId) + "\">\n");
                ArrayList<ValueMapping> valueMappings = new ArrayList<ValueMapping>(this.getValueMappings());
                Collections.sort(valueMappings, new Comparator<ValueMapping>(){

                    @Override
                    public int compare(ValueMapping o1, ValueMapping o2) {
                        int result = Collator.getInstance().compare(o1.getTargetId(), o2.getTargetId());
                        if (result != 0) {
                            return result;
                        }
                        return Collator.getInstance().compare(o1.getSourceId(), o2.getSourceId());
                    }
                });
                for (ValueMapping valueMapping : valueMappings) {
                    valueMapping.write(writer, monitor);
                }
                writer.write("\t</attributeType>\n");
            }
            catch (IOException x) {
                throw new TeamRepositoryException((Throwable)x);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class InternalMapping {
        private BugzillaMapping fBugzillaMapping;
        private String fTargetId;
        private Map<String, ValueMapping> fValueMappings = new HashMap<String, ValueMapping>();

        public InternalMapping(BugzillaMapping bugzillaMapping, String targetId) {
            this.fBugzillaMapping = bugzillaMapping;
            this.fTargetId = targetId;
            this.fBugzillaMapping.fMappings.add(this);
        }

        public String getTargetId() {
            return this.fTargetId;
        }

        public List<ValueMapping> getValueMappings() {
            return new ArrayList<ValueMapping>(this.fValueMappings.values());
        }

        public ValueMapping getValueMapping(String sourceId) {
            return this.fValueMappings.get(sourceId);
        }

        public void addValueMapping(ValueMapping valueMapping) {
            this.fValueMappings.put(valueMapping.getSourceId(), valueMapping);
        }

        public void recordValueMapping(String value) {
            ValueMapping valueMapping = this.fValueMappings.get(value);
            if (valueMapping == null) {
                valueMapping = new ValueMapping(value, value, true);
                this.fValueMappings.put(value, valueMapping);
            }
            valueMapping.setInUse(true);
        }

        public abstract void write(Writer var1, IProgressMonitor var2) throws TeamRepositoryException;
    }

    private static class MappingHandler
    extends DefaultHandler2 {
        private static final String ATTRIBUTE = "attribute";
        private static final String ATTRIBUTE_TYPE = "attributeType";
        private static final String VALUE = "value";
        private static final String TARGET_ID = "targetId";
        private static final String SOURCE_ID = "sourceId";
        private static final String ACCURATE = "accurate";
        private BugzillaMapping fMapping;
        private boolean fForRecording;
        private AttributeMapping fAttributeMapping;
        private AttributeTypeMapping fAttributeTypeMapping;

        private MappingHandler(BugzillaMapping mapping, boolean forRecording) {
            this.fMapping = mapping;
            this.fForRecording = forRecording;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (ATTRIBUTE.equals(qName)) {
                String sourceId = attributes.getValue(SOURCE_ID);
                String targetId = attributes.getValue(TARGET_ID);
                if (sourceId != null && targetId != null) {
                    this.fAttributeMapping = new AttributeMapping(this.fMapping, sourceId, targetId);
                }
            } else if (this.fAttributeMapping != null && VALUE.equals(qName)) {
                String targetId = attributes.getValue(TARGET_ID);
                String sourceId = attributes.getValue(SOURCE_ID);
                String accurate = attributes.getValue(ACCURATE);
                if (targetId != null && sourceId != null) {
                    this.fAttributeMapping.addValueMapping(new ValueMapping(sourceId, targetId, accurate == null || Boolean.valueOf(accurate) != false));
                }
            } else if (ATTRIBUTE_TYPE.equals(qName)) {
                String targetId = attributes.getValue(TARGET_ID);
                if (targetId != null) {
                    this.fAttributeTypeMapping = new AttributeTypeMapping(this.fMapping, targetId);
                }
            } else if (this.fAttributeTypeMapping != null && VALUE.equals(qName)) {
                String targetId = attributes.getValue(TARGET_ID);
                String sourceId = attributes.getValue(SOURCE_ID);
                String accurate = attributes.getValue(ACCURATE);
                if (targetId != null && sourceId != null) {
                    this.fAttributeTypeMapping.addValueMapping(new ValueMapping(sourceId, targetId, accurate == null || Boolean.valueOf(accurate) != false));
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (ATTRIBUTE.equals(qName)) {
                this.fAttributeMapping = null;
            }
            if (ATTRIBUTE_TYPE.equals(qName)) {
                this.fAttributeTypeMapping = null;
            }
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            if (!this.fForRecording) {
                return;
            }
            final String comment = new String(ch, start, length);
            new InternalMapping(this.fMapping, comment){

                public void write(Writer writer, IProgressMonitor monitor) throws TeamRepositoryException {
                    try {
                        writer.write("<!--");
                        writer.write(comment);
                        writer.write("-->\n");
                    }
                    catch (IOException x) {
                        throw new TeamRepositoryException((Throwable)x);
                    }
                }
            };
        }
    }

    public static class ValueMapping {
        private String fSourceId;
        private String fTargetId;
        private boolean fIsAccurate;
        private boolean fIsInUse;

        public ValueMapping(String sourceId, String targetId, boolean isAccurate) {
            this.fSourceId = sourceId;
            this.fTargetId = targetId;
            this.fIsAccurate = isAccurate;
        }

        public String getSourceId() {
            return this.fSourceId;
        }

        public String getTargetId() {
            return this.fTargetId;
        }

        public boolean isAccurate() {
            return this.fIsAccurate;
        }

        public boolean isInUse() {
            return this.fIsInUse;
        }

        public void setInUse(boolean isInUse) {
            this.fIsInUse = isInUse;
        }

        public void write(Writer writer, IProgressMonitor monitor) throws TeamRepositoryException {
            try {
                String sourceId = this.getSourceId();
                String targetId = this.getTargetId();
                if (targetId != null && targetId.length() > 0) {
                    writer.write("\t\t<value sourceId=\"" + BugzillaMapping.escapeForXML(sourceId) + "\" targetId=\"" + BugzillaMapping.escapeForXML(targetId) + "\"" + (!this.isAccurate() ? " accurate=\"false\"" : "") + "/>");
                } else {
                    writer.write("\t\t<value sourceId=\"" + BugzillaMapping.escapeForXML(sourceId) + "\"" + (!this.isAccurate() ? " accurate=\"false\"" : "") + "/>");
                }
                if (!this.isInUse()) {
                    writer.write("<!-- " + Messages.BugzillaMapping_UNUSED_VALUE_MAPPING + " -->");
                }
                writer.write("\n");
            }
            catch (IOException x) {
                throw new TeamRepositoryException((Throwable)x);
            }
        }
    }
}

