/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BugzillaMapping;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.ReportData;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AttributeMapper {
    private static final String ALL = "*";
    private BugzillaMapping.AttributeMapping fAttributeMapping;
    private BugzillaMapping.AttributeTypeMapping fAttributeTypeMapping;

    public AttributeMapper(BugzillaMapping.AttributeMapping attributeMapping, BugzillaMapping.AttributeTypeMapping attributeTypeMapping) {
        this.fAttributeMapping = attributeMapping;
        this.fAttributeTypeMapping = attributeTypeMapping;
    }

    public BugzillaMapping.AttributeMapping getAttributeMapping() {
        return this.fAttributeMapping;
    }

    public BugzillaMapping.AttributeTypeMapping getAttributeTypeMapping() {
        return this.fAttributeTypeMapping;
    }

    public BugzillaMapping.ValueMapping getValueMapping(String sourceId) {
        BugzillaMapping.ValueMapping valueMapping = this.getAttributeMapping().getValueMapping(sourceId);
        if (valueMapping != null) {
            return valueMapping;
        }
        valueMapping = this.getAttributeTypeMapping().getValueMapping(sourceId);
        if (valueMapping != null) {
            return valueMapping;
        }
        valueMapping = this.getAttributeMapping().getValueMapping(ALL);
        if (valueMapping != null) {
            return valueMapping;
        }
        return this.getAttributeTypeMapping().getValueMapping(ALL);
    }

    public abstract XMLString copy(IWorkItem var1, ReportData var2, boolean var3, LocalizationContext var4, IProgressMonitor var5) throws TeamRepositoryException;

    public void record(ReportData data, IProgressMonitor monitor) {
        String value = data.getString(this.getAttributeMapping().getSourceId());
        if (value == null) {
            return;
        }
        String targetId = this.getAttributeMapping().getTargetId();
        if (this.fAttributeTypeMapping.getTargetId().length() > 0 && !WorkItemAttributes.STATE.getStringIdentifier().equals(targetId) && !WorkItemAttributes.RESOLUTION.getStringIdentifier().equals(targetId)) {
            this.fAttributeTypeMapping.recordValueMapping(value);
        } else {
            this.fAttributeMapping.recordValueMapping(value);
        }
    }
}

