/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.commandline;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.internal.util.DefaultLoginHandler;
import com.ibm.team.workitem.rcp.core.internal.WorkItemRCPCorePlugin;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaConfiguration;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaException;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaFilteredRetrieval;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaImporter;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaLogStatusMonitor;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaNumberedRetrieval;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaZipFileRetrieval;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.IBugRetrievalStrategy;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.IBugzillaStatusMonitor;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.VerboseProgressMonitor;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.commandline.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;

public class BugzillaCommandLineApplication
implements IPlatformRunnable {
    private static final String CORRECTING_COMMAND_LINE = Messages.BugzillaCommandLineApplication_CORRECTING_COMMAND_LINE;
    private static final String ERROR_COMMANDLINE_ARGUMENTS_INSUFFICIENT = Messages.BugzillaCommandLineApplication_COMMAND_LINE_INSUFFICIENT;
    public static final Integer EXIT_WITH_ERROR = new Integer(1);
    private String fFileName = null;
    private Properties props = new Properties();
    private IProgressMonitor monitor = new NullProgressMonitor();
    private static final String IMPORT = "-import";
    private static final String CONFIG = "config";
    private static final String YES = "yes";
    private static final String REALM = "realm";
    private static final String COOKIES = "cookies";
    private static final String BUGZILLA = "bugzilla";
    private static final String ZIPFILE = "zipfile";
    private static final String REPOSITORYURI = "repository.uri";
    private static final String REPOSITORYUSERNAME = "repository.username";
    private static final String REPOSITORYPASSWORD = "repository.password";
    private static final String IMPORTSOURCE = "import.source";
    private static final String IMPORTFILE = "import.filename";
    private static final String BUGZILLABASEURL = "import.bugzilla.baseurl";
    private static final String NEEDSAUTH = "import.bugzilla.needsauth";
    private static final String AUTHMETHOD = "import.bugzilla.authmethod";
    private static final String USERNAME = "import.bugzilla.username";
    private static final String PASSWORD = "import.bugzilla.password";
    private static final String IMPORTFROMID = "import.bugzilla.from.id";
    private static final String IMPORTTOID = "import.bugzilla.to.id";
    private static final String IMPORTPRODUCT = "import.bugzilla.product";
    private static final String SAVEIMPORTTOFILE = "import.bugzilla.savedownloadeddata";
    private static final String SAVEIMPORTTOFILENAME = "import.bugzilla.savedownloadeddata.filename";
    private static final String SAVEIMPORTTOFILEOVERWRITE = "import.bugzilla.savedownloadeddata.filename.overwrite";
    private static final String VERBOSE_OPTION = "/debug/bugzilla/verbose";
    private static final boolean VERBOSE = !Boolean.FALSE.equals(Platform.getDebugOption((String)"com.ibm.team.workitem.rcp.core/debug/bugzilla/verbose"));

    public BugzillaCommandLineApplication() {
        if (VERBOSE) {
            this.monitor = new VerboseProgressMonitor(this.monitor);
        }
    }

    public Object run(Object args) {
        String[] arguments = (String[])args;
        try {
            String[] overridedOptions = this.checkArgs(arguments);
            this.readConfig(overridedOptions);
            this.checkIfCredentialsProvided();
            BugzillaLogStatusMonitor statusMonitor = new BugzillaLogStatusMonitor(){

                public void reportStatus(IStatus status) {
                    if (VERBOSE && status != null && !status.isOK()) {
                        System.out.println("Status with message: " + status.getMessage());
                    }
                    super.reportStatus(status);
                }
            };
            this.importBugs(statusMonitor);
            IStatus status = statusMonitor.getStatus();
            if (!status.isOK()) {
                System.out.println(Messages.BugzillaCommandLineApplication_ERRORS_OCCURRED);
            } else {
                this.sayGoodbye();
            }
        }
        catch (BugzillaConfigurationException x) {
            this.showHelp();
            System.out.println("\n" + x.getMessage());
            return EXIT_WITH_ERROR;
        }
        return IApplication.EXIT_OK;
    }

    private void sayGoodbye() {
        System.out.print(Messages.BugzillaCommandLineApplication_SUCCESS);
    }

    private ITeamRepository createTeamServices() throws BugzillaConfigurationException {
        String uri = this.props.getProperty(REPOSITORYURI);
        String user = this.props.getProperty(REPOSITORYUSERNAME);
        System.out.println(NLS.bind((String)Messages.BugzillaCommandLineApplication_LOGGING_IN, (Object)uri, (Object[])new Object[]{user}));
        System.out.println(Messages.BugzillaCommandLineApplication_PLEASE_WAIT);
        ITeamRepository teamRepository = TeamPlatform.getTeamRepositoryService().getTeamRepository(uri);
        if (teamRepository == null) {
            throw new BugzillaConfigurationException(Messages.BugzillaCommandLineApplication_COULD_NOT_CONNECT);
        }
        try {
            teamRepository.registerLoginHandler((ITeamRepository.ILoginHandler)new DefaultLoginHandler(user, this.props.getProperty(REPOSITORYPASSWORD)));
            teamRepository.login(null);
            System.out.println();
            System.out.println(Messages.BugzillaCommandLineApplication_LOGGED_IN);
        }
        catch (TeamRepositoryException x) {
            WorkItemRCPCorePlugin.getDefault().log(x);
            throw new BugzillaConfigurationException(Messages.BugzillaCommandLineApplication_COULD_NOT_LOG_IN);
        }
        return teamRepository;
    }

    private void checkIfCredentialsProvided() throws BugzillaConfigurationException {
        if (!(this.ensureTeamRepositoryCredentials() && this.checkIfPropertyHasValue(REPOSITORYURI) && this.checkIfPropertyHasValue(REPOSITORYUSERNAME) && this.checkIfPropertyHasValue(REPOSITORYPASSWORD))) {
            throw new BugzillaConfigurationException(Messages.BugzillaCommandLineApplication_NO_REPOSITORY_CREDENTIALS_PROVIDED);
        }
    }

    private void importBugs(IBugzillaStatusMonitor statusMonitor) throws BugzillaConfigurationException {
        ITeamRepository teamRepository;
        if (!this.ensureAllPropsForImportProvided()) {
            throw new BugzillaConfigurationException(Messages.BugzillaCommandLineApplication_NOT_ALL_REQUIRED_PROPERTIES_PROVIDED);
        }
        BugzillaConfiguration conf = null;
        IBugRetrievalStrategy strategy = null;
        ITeamRepository iTeamRepository = teamRepository = this.isSaveXML() ? null : this.createTeamServices();
        if (ZIPFILE.equals(this.props.getProperty(IMPORTSOURCE))) {
            conf = new BugzillaConfiguration("", teamRepository);
            if (!this.checkIfPropertyHasValue(IMPORTFILE)) {
                throw new BugzillaConfigurationException(Messages.BugzillaCommandLineApplication_NO_FILE_TO_IMPORT);
            }
            System.out.println(NLS.bind((String)Messages.BugzillaCommandLineApplication_IMPORTING_FROM, (Object)this.props.getProperty(IMPORTFILE), (Object[])new Object[0]));
            try {
                strategy = new BugzillaZipFileRetrieval(this.props.getProperty(IMPORTFILE));
            }
            catch (BugzillaException e) {
                throw new BugzillaConfigurationException(Messages.BugzillaCommandLineApplication_COULD_NOT_ACCESS_ZIP, (Throwable)((Object)e));
            }
        } else if (BUGZILLA.equals(this.props.getProperty(IMPORTSOURCE))) {
            conf = this.createConfigurationForBugzillaImport(teamRepository);
            if (this.checkIfPropertyHasValue(IMPORTPRODUCT)) {
                strategy = new BugzillaFilteredRetrieval(conf, this.props.getProperty(IMPORTPRODUCT));
                System.out.println(NLS.bind((String)Messages.BugzillaCommandLineApplication_IMPORTING_PRODUCT_FROM, (Object)this.props.getProperty(IMPORTPRODUCT), (Object[])new Object[]{this.props.getProperty(BUGZILLABASEURL)}));
            } else {
                try {
                    int from = Integer.parseInt(this.props.getProperty(IMPORTFROMID));
                    int to = Integer.parseInt(this.props.getProperty(IMPORTTOID));
                    strategy = new BugzillaNumberedRetrieval(conf, from, to);
                    System.out.println(NLS.bind((String)Messages.BugzillaCommandLineApplication_IMPORTING_FROM_TO, (Object)from, (Object[])new Object[]{to, this.props.getProperty(BUGZILLABASEURL)}));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BugzillaConfigurationException(Messages.BugzillaCommandLineApplication_COULD_NOT_READ_RANGE);
                }
            }
        } else {
            throw new BugzillaConfigurationException(NLS.bind((String)Messages.BugzillaCommandLineApplication_VALUE_MUST_BE_THIS_OR_THAT, (Object)IMPORTSOURCE, (Object[])new Object[]{ZIPFILE, BUGZILLA}));
        }
        System.out.println(Messages.BugzillaCommandLineApplication_IMPORTING_PLEASE_WAIT);
        BugzillaImporter importer = new BugzillaImporter(conf);
        importer.doImport(strategy, statusMonitor, this.monitor);
    }

    private BugzillaConfiguration createConfigurationForBugzillaImport(ITeamRepository teamRepository) throws BugzillaConfigurationException {
        if (!this.checkIfPropertyHasValue(BUGZILLABASEURL)) {
            throw new BugzillaConfigurationException(Messages.BugzillaCommandLineApplication_NO_BASE_URL_PROVIDED);
        }
        BugzillaConfiguration conf = new BugzillaConfiguration(this.props.getProperty(BUGZILLABASEURL), teamRepository);
        if (YES.equals(this.props.getProperty(NEEDSAUTH))) {
            conf.setNeedsAuthentication(YES.equals(this.props.getProperty(NEEDSAUTH)));
            if (!this.checkIfPropertyHasValue(AUTHMETHOD) || !this.checkIfPropertyHasValue(AUTHMETHOD)) {
                throw new BugzillaConfigurationException(Messages.BugzillaCommandLineApplication_NO_AUTHENTICATION_METHOD_PROVIDED);
            }
            boolean isBasicHTTPAuthentication = false;
            if (REALM.equals(this.props.getProperty(AUTHMETHOD))) {
                isBasicHTTPAuthentication = true;
            } else if (COOKIES.equals(this.props.getProperty(AUTHMETHOD))) {
                isBasicHTTPAuthentication = false;
            } else {
                throw new BugzillaConfigurationException(NLS.bind((String)Messages.BugzillaCommandLineApplication_VALUE_MUST_BE_THIS_OR_THAT, (Object)AUTHMETHOD, (Object[])new Object[]{REALM, COOKIES}));
            }
            conf.setIsBasicHTTPAuthentication(isBasicHTTPAuthentication);
            if (!this.checkIfPropertyHasValue(USERNAME) || !this.checkIfPropertyHasValue(PASSWORD)) {
                throw new BugzillaConfigurationException(Messages.BugzillaCommandLineApplication_NO_BUGZILLA_CREDENTIALS_PROVIDED);
            }
            conf.setUsername(this.props.getProperty(USERNAME));
            conf.setPassword(this.props.getProperty(PASSWORD));
        }
        if (this.isSaveXML()) {
            conf.setIsSaveXML(true);
            conf.setOverWriteExisting(YES.equals(this.props.getProperty(SAVEIMPORTTOFILEOVERWRITE)));
            if (!this.checkIfPropertyHasValue(SAVEIMPORTTOFILENAME)) {
                throw new BugzillaConfigurationException(Messages.BugzillaCommandLineApplication_NO_FILE_TO_SAVE);
            }
            conf.setSaveFileName(this.props.getProperty(SAVEIMPORTTOFILENAME));
        }
        return conf;
    }

    private boolean isSaveXML() {
        return YES.equals(this.props.getProperty(SAVEIMPORTTOFILE));
    }

    private boolean checkIfPropertyHasValue(String name) {
        return this.props.getProperty(name) != null && !"".equals(this.props.getProperty(name));
    }

    private boolean ensureTeamRepositoryCredentials() {
        boolean ok = this.ensurePropertyExists(REPOSITORYURI) && this.ensurePropertyExists(REPOSITORYUSERNAME) && this.ensurePropertyExists(REPOSITORYPASSWORD);
        return ok;
    }

    private boolean ensureAllPropsForImportProvided() {
        boolean ok = this.ensurePropertyExists(BUGZILLABASEURL) && this.ensurePropertyExists(IMPORTSOURCE) && this.ensurePropertyExists(IMPORTFILE) && this.ensurePropertyExists(NEEDSAUTH) && this.ensurePropertyExists(AUTHMETHOD) && this.ensurePropertyExists(USERNAME) && this.ensurePropertyExists(PASSWORD) && this.ensurePropertyExists(IMPORTFROMID) && this.ensurePropertyExists(IMPORTTOID) && this.ensurePropertyExists(IMPORTPRODUCT) && this.ensurePropertyExists(SAVEIMPORTTOFILE) && this.ensurePropertyExists(SAVEIMPORTTOFILENAME) && this.ensurePropertyExists(SAVEIMPORTTOFILEOVERWRITE);
        return ok;
    }

    private boolean ensurePropertyExists(String name) {
        return this.props.containsKey(name);
    }

    private void readConfig(String[] overriddenOptions) throws BugzillaConfigurationException {
        System.out.println(NLS.bind((String)Messages.BugzillaCommandLineApplication_WELCOME, (Object)this.getConfigFileName(), (Object[])new Object[0]));
        File f = new File(this.getConfigFileName());
        if (!f.canRead()) {
            throw new BugzillaConfigurationException(Messages.BugzillaCommandLineApplication_CANNOT_READ_CONFIG);
        }
        try {
            FileInputStream fin = new FileInputStream(f);
            this.props.load(fin);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new BugzillaConfigurationException(Messages.BugzillaCommandLineApplication_CONFIG_NOT_FOUND);
        }
        catch (IOException iOException) {
            throw new BugzillaConfigurationException(Messages.BugzillaCommandLineApplication_CANNOT_READ_CONFIG);
        }
        boolean isOverriddenImportFile = false;
        boolean isOverriddenBugzillaImport = false;
        if (overriddenOptions != null) {
            int i = 0;
            while (i < overriddenOptions.length) {
                String[] optionpair = overriddenOptions[i].split("=");
                if (optionpair.length != 2) {
                    throw new BugzillaConfigurationException(ERROR_COMMANDLINE_ARGUMENTS_INSUFFICIENT);
                }
                String optionName = optionpair[0];
                String optionValue = optionpair[1];
                this.props.setProperty(optionName, optionValue);
                if (IMPORTFILE.equals(optionName)) {
                    isOverriddenImportFile = true;
                } else if (BUGZILLABASEURL.equals(optionName)) {
                    isOverriddenBugzillaImport = true;
                }
                ++i;
            }
        }
        if (isOverriddenImportFile && !ZIPFILE.equals(this.props.getProperty(IMPORTSOURCE))) {
            this.props.setProperty(IMPORTSOURCE, ZIPFILE);
            System.out.println(NLS.bind((String)CORRECTING_COMMAND_LINE, (Object)IMPORTFILE, (Object[])new Object[]{IMPORTSOURCE, ZIPFILE}));
        }
        if (isOverriddenBugzillaImport && !BUGZILLA.equals(this.props.getProperty(IMPORTSOURCE))) {
            this.props.setProperty(IMPORTSOURCE, BUGZILLA);
            System.out.println(NLS.bind((String)CORRECTING_COMMAND_LINE, (Object)BUGZILLABASEURL, (Object[])new Object[]{IMPORTSOURCE, BUGZILLA}));
        }
    }

    public String[] checkArgs(String[] args) throws BugzillaConfigurationException {
        if (args == null || args.length == 0) {
            throw new BugzillaConfigurationException(ERROR_COMMANDLINE_ARGUMENTS_INSUFFICIENT);
        }
        int shift = 0;
        if ("-pdelaunch".equals(args[0])) {
            shift = 1;
        }
        if (args.length != 2 + shift && args.length != 3 + shift) {
            throw new BugzillaConfigurationException(ERROR_COMMANDLINE_ARGUMENTS_INSUFFICIENT);
        }
        if (!IMPORT.equals(args[0 + shift])) {
            throw new BugzillaConfigurationException(ERROR_COMMANDLINE_ARGUMENTS_INSUFFICIENT);
        }
        String[] config = args[1 + shift].split("=");
        if (config.length != 2) {
            throw new BugzillaConfigurationException(ERROR_COMMANDLINE_ARGUMENTS_INSUFFICIENT);
        }
        if (!CONFIG.equals(config[0])) {
            throw new BugzillaConfigurationException(ERROR_COMMANDLINE_ARGUMENTS_INSUFFICIENT);
        }
        this.setConfigFileName(config[1]);
        String[] overridedOptions = null;
        if (args.length == 3 + shift) {
            overridedOptions = args[2 + shift].split(",");
        }
        return overridedOptions;
    }

    public String getConfigFileName() {
        return this.fFileName;
    }

    public void setConfigFileName(String fileName) {
        this.fFileName = fileName;
    }

    private void showHelp() {
        System.out.println(Messages.BugzillaCommandLineApplication_HELP);
    }

    private static class BugzillaConfigurationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public BugzillaConfigurationException() {
        }

        public BugzillaConfigurationException(String message, Throwable cause) {
            super(message, cause);
        }

        public BugzillaConfigurationException(String message) {
            super(message);
        }

        public BugzillaConfigurationException(Throwable cause) {
            super(cause);
        }
    }
}

