/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla;

import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaException;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.IBugRetrievalStrategy;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.Messages;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.importer.ZipFileHelper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.AttachmentData;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.AttachmentDescription;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaZipFileRetrieval
implements IBugRetrievalStrategy {
    private ZipFile fZip = null;
    Map<String, ZipEntry> fMap = null;

    public BugzillaZipFileRetrieval(String filename) throws BugzillaException {
        try {
            this.fZip = new ZipFile(filename);
        }
        catch (IOException e) {
            throw new BugzillaException(Messages.Messages_EXCEPTION_READING_ZIP, e);
        }
    }

    @Override
    public String getXML(String id) throws BugzillaException {
        String xml = null;
        ZipEntry entry = this.fMap.get(id);
        try {
            xml = ZipFileHelper.readEntryfromZipFile(this.fZip, entry).toString(HttpUtil.CharsetEncoding.UTF8.toString());
        }
        catch (IOException e) {
            throw new BugzillaException(Messages.getBugMessage(id, Messages.Messages_EXCEPTION_READING_ZIP), e);
        }
        return xml;
    }

    public AttachmentData[] getAttachments(String id, List attachmentinfo) throws BugzillaException {
        ArrayList<AttachmentData> atts = new ArrayList<AttachmentData>();
        for (AttachmentDescription desc : attachmentinfo) {
            String fileid = desc.getString("0");
            String filename = desc.getString("5");
            String name = this.fMap.get(id).getName();
            String path = name.substring(0, name.lastIndexOf(47) + 1);
            String fullName = String.valueOf(path) + String.valueOf(id) + "/" + fileid;
            ZipEntry entry = this.fZip.getEntry(fullName);
            if (entry == null) {
                fullName = String.valueOf(path) + String.valueOf(id) + "/ " + fileid;
                entry = this.fZip.getEntry(fullName);
            }
            if (entry == null) {
                throw new BugzillaException(4, Messages.getAttachmentMessage(id, Messages.Messages_EXCEPTION_READING_ZIP));
            }
            AttachmentData attachment = new AttachmentData();
            if (filename != null && filename.length() > 0) {
                attachment.set("0", filename);
            } else {
                attachment.set("0", fileid);
            }
            try {
                attachment.data = ZipFileHelper.readEntryfromZipFile(this.fZip, entry).toByteArray();
            }
            catch (IOException e1) {
                throw new BugzillaException(Messages.getAttachmentMessage(id, Messages.Messages_EXCEPTION_READING_ZIP), e1);
            }
            atts.add(attachment);
        }
        if (atts.size() > 0) {
            AttachmentData[] attData = atts.toArray(new AttachmentData[atts.size()]);
            return attData;
        }
        return null;
    }

    @Override
    public int getNumberOfBugs() {
        return this.fMap.size();
    }

    @Override
    public Iterator<String> getIterator() {
        if (this.fMap == null) {
            HashSet<String> roots = new HashSet<String>();
            Enumeration<? extends ZipEntry> e = this.fZip.entries();
            while (e.hasMoreElements()) {
                int i;
                String path;
                String name;
                ZipEntry entry = e.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).endsWith(".xml") || roots.contains(path = name.substring(0, (i = name.lastIndexOf(47)) + 1))) continue;
                boolean add = true;
                Iterator iter = roots.iterator();
                while (iter.hasNext()) {
                    String root = (String)iter.next();
                    if (path.startsWith(root)) {
                        add = false;
                        break;
                    }
                    if (!root.startsWith(path)) continue;
                    iter.remove();
                }
                if (!add) continue;
                roots.add(path);
            }
            TreeMap<String, ZipEntry> map = new TreeMap<String, ZipEntry>();
            Enumeration<? extends ZipEntry> e2 = this.fZip.entries();
            while (e2.hasMoreElements()) {
                String name;
                ZipEntry entry = e2.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).endsWith(".xml")) continue;
                int i = name.lastIndexOf(47);
                String id = name.substring(i + 1, name.length() - 4);
                String path = name.substring(0, i + 1);
                if (!roots.contains(path)) continue;
                map.put(id, entry);
            }
            this.fMap = map;
        }
        return this.fMap.keySet().iterator();
    }
}

