/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla;

import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaConfiguration;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaException;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.IBugRetrievalStrategy;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.Messages;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.http.BugzillaOperations;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.AttachmentData;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.AttachmentDescription;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BugzillaRetrieval
implements IBugRetrievalStrategy {
    protected BugzillaOperations fOperations;
    protected BugzillaConfiguration fConfiguration;

    public BugzillaRetrieval(BugzillaConfiguration conf) {
        this.fConfiguration = conf;
        this.fOperations = new BugzillaOperations();
    }

    @Override
    public String getXML(String id) throws BugzillaException {
        String xml;
        try {
            xml = this.fOperations.downloadReportData((IProgressMonitor)new NullProgressMonitor(), this.fConfiguration, id);
        }
        catch (IOException e) {
            throw new BugzillaException(Messages.Messages_EXCEPTION_CONTACTING_BUGZILLA, e);
        }
        return xml;
    }

    @Override
    public AttachmentData[] getAttachments(String id, List<AttachmentDescription> attachmentInfo) throws BugzillaException {
        ArrayList<AttachmentData> attachmentsContents = new ArrayList<AttachmentData>();
        HashSet<String> fileNames = new HashSet<String>();
        for (AttachmentDescription desc : attachmentInfo) {
            try {
                AttachmentData att = this.fOperations.getAttachment((IProgressMonitor)new NullProgressMonitor(), this.fConfiguration, desc);
                String fileName = att.getString("0");
                if (fileName == null || fileName.trim().length() == 0) {
                    fileName = Messages.BugzillaRetrieval_UNNAMED_ATTACHMENT;
                }
                if (fileNames.contains((fileName = fileName.trim()).toLowerCase())) {
                    String extension;
                    String name;
                    int extensionPos = fileName.lastIndexOf(".");
                    if (extensionPos > 0) {
                        name = fileName.substring(0, extensionPos);
                        extension = fileName.substring(extensionPos);
                    } else {
                        name = fileName;
                        extension = "";
                    }
                    int incNumber = 2;
                    while (fileNames.contains(fileName.toLowerCase())) {
                        fileName = String.valueOf(name) + " (" + incNumber++ + ")" + extension;
                    }
                }
                fileNames.add(fileName.toLowerCase());
                att.set("0", fileName);
                attachmentsContents.add(att);
            }
            catch (IOException e) {
                throw new BugzillaException(4, Messages.Messages_EXCEPTION_CONTACTING_BUGZILLA, e);
            }
        }
        return attachmentsContents.toArray(new AttachmentData[attachmentsContents.size()]);
    }
}

