/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.rcp.core.internal.WorkItemRCPCorePlugin;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.IBugzillaStatusMonitor;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;

public class BugzillaLogStatusMonitor
implements IBugzillaStatusMonitor {
    private static final int MAX_ERRORS = Integer.MAX_VALUE;
    private List<IStatus> fStatuses = new ArrayList<IStatus>();
    private int fErrors = 0;

    public void reportStatus(IStatus status) {
        if (status == null) {
            WorkItemRCPCorePlugin.getDefault().log("Status is null", new NullPointerException());
            return;
        }
        this.fStatuses.add(status);
        WorkItemRCPCorePlugin.getDefault().log(status);
        if (status.matches(4)) {
            ++this.fErrors;
            if (this.fErrors >= Integer.MAX_VALUE) {
                throw new OperationCanceledException(NLS.bind((String)Messages.BugzillaLogStatusMonitor_TERMINATING, (Object)this.fErrors, (Object[])new Object[0]));
            }
        }
    }

    public IStatus getStatus() {
        if (this.fStatuses.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (this.fStatuses.size() == 1) {
            return this.fStatuses.get(0);
        }
        return new MultiStatus("com.ibm.team.workitem.rcp.core", 0, this.fStatuses.toArray(new IStatus[this.fStatuses.size()]), Messages.BugzillaLogStatusMonitor_MULTIPLE_MESSAGES, null);
    }

    public int getNumberOfErrors() {
        return this.fErrors;
    }
}

