/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla;

import com.ibm.team.foundation.common.internal.util.FoundationStatus;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemOperation;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaConfiguration;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaException;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaFilteredRetrieval;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.IBugRetrievalStrategy;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.IBugzillaStatusMonitor;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.IExtendedBugRetrievalStrategy;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.Messages;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.http.BugzillaOperations;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.http.CookieLoginOperation;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.importer.DataCopier;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.importer.DependenciesResolver;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.importer.ITestBugRetrievalStrategy;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.AttachmentData;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.ReportData;
import com.ibm.team.workitem.rcp.core.internal.csv.CSVBugRetrievalStrategy;
import com.ibm.team.workitem.rcp.core.internal.util.RepositoryCreationUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class BugzillaImporter {
    private boolean isTestRun = false;
    private String fServerUrl = null;
    private ZipOutputStream zOut;
    private BugzillaConfiguration fConfiguration;
    private DependenciesResolver fResolver = null;
    private DataCopier fCopier = null;

    public BugzillaImporter(BugzillaConfiguration configuration) {
        this.fConfiguration = configuration;
        this.fResolver = new DependenciesResolver(configuration.getTeamRepository());
        this.fCopier = new DataCopier(configuration);
    }

    public void doImport(final IBugRetrievalStrategy strategy, final IBugzillaStatusMonitor statusMonitor, final IProgressMonitor monitor) {
        Utils.runImport((Runnable)new Runnable(){

            public void run() {
                BugzillaImporter.this.runImport(strategy, statusMonitor, monitor);
            }
        });
    }

    private void runImport(IBugRetrievalStrategy strategy, IBugzillaStatusMonitor statusMonitor, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                monitor.beginTask(Messages.BugzillaImporter_IMPORTING_WORK_ITEMS, 100);
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                if (this.fConfiguration.getTeamRepository() != null && this.fConfiguration.getDevelopmentLine() == null) {
                    try {
                        IProjectArea projectArea;
                        IDevelopmentLineHandle[] developmentLines;
                        ITeamRepository teamRepository = this.fConfiguration.getTeamRepository();
                        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                        IDevelopmentLine developmentLine = auditableClient.findDefaultDevelopmentLine(this.fConfiguration.getProjectArea(), (IProgressMonitor)subMonitor);
                        if (developmentLine == null && (developmentLines = (projectArea = (IProjectArea)auditableClient.resolveAuditable((IAuditableHandle)this.fConfiguration.getProjectArea(), ItemProfile.PROJECT_AREA_DEFAULT, (IProgressMonitor)subMonitor)).getDevelopmentLines()).length > 0) {
                            developmentLine = (IDevelopmentLine)auditableClient.resolveAuditable((IAuditableHandle)developmentLines[0], ItemProfile.DEVELOPMENT_LINE_DEFAULT, (IProgressMonitor)subMonitor);
                        }
                        if (developmentLine == null) {
                            throw new BugzillaException((IStatus)new Status(4, "com.ibm.team.workitem.rcp.core", 4, Messages.BugzillaImporter_NO_DEFAULT_DEV_LINE_FOUND, null));
                        }
                        this.fConfiguration.setDevelopmentLine(developmentLine);
                    }
                    catch (TeamRepositoryException x) {
                        throw new BugzillaException((IStatus)new Status(4, "com.ibm.team.workitem.rcp.core", 4, Messages.Messages_EXCEPTION_CONTACTING_REPOSITORY, (Throwable)x));
                    }
                }
                if (this.fConfiguration.getTeamRepository() != null && this.fConfiguration.getProjectPhase() == null) {
                    try {
                        this.fConfiguration.setProjectPhase(RepositoryCreationUtil.getCurrentProjectPhase(this.fConfiguration.getDevelopmentLine(), (IProgressMonitor)subMonitor));
                    }
                    catch (TeamRepositoryException x) {
                        throw new BugzillaException((IStatus)new Status(4, "com.ibm.team.workitem.rcp.core", 4, Messages.Messages_EXCEPTION_CONTACTING_REPOSITORY, (Throwable)x));
                    }
                }
                if (strategy instanceof ITestBugRetrievalStrategy) {
                    this.isTestRun = true;
                }
                this.ensureIsLoggedIn();
                if (!this.fConfiguration.isComputeMappingFileOnly() && this.fConfiguration.isSaveXML()) {
                    this.openZipOutputStream();
                }
                this.importBugs(strategy, statusMonitor, (IProgressMonitor)new SubProgressMonitor(monitor, 95));
                if (this.fConfiguration.isComputeMappingFileOnly()) {
                    this.writeMapping(monitor);
                }
            }
            catch (BugzillaException x) {
                statusMonitor.reportStatus((IStatus)new FoundationStatus(4, "com.ibm.team.workitem.rcp.core", 4, x.getMessage(), (Throwable)((Object)x), x.getStatus() instanceof FoundationStatus && ((FoundationStatus)x.getStatus()).isExpected()));
                try {
                    if (!this.fConfiguration.isComputeMappingFileOnly() && this.fConfiguration.isSaveXML()) {
                        this.closeZipOutputStream();
                    }
                }
                catch (IOException x2) {
                    statusMonitor.reportStatus((IStatus)new Status(4, "com.ibm.team.workitem.rcp.core", 4, Messages.Messages_EXCEPTION_WRITING_ZIP, (Throwable)x2));
                }
                monitor.done();
            }
        }
        finally {
            try {
                if (!this.fConfiguration.isComputeMappingFileOnly() && this.fConfiguration.isSaveXML()) {
                    this.closeZipOutputStream();
                }
            }
            catch (IOException x) {
                statusMonitor.reportStatus((IStatus)new Status(4, "com.ibm.team.workitem.rcp.core", 4, Messages.Messages_EXCEPTION_WRITING_ZIP, (Throwable)x));
            }
            monitor.done();
        }
    }

    private void checkIfItemAlreadyExists(String value) throws BugzillaException {
        if (this.fConfiguration.isCheckIfAlreadyImported() && this.fResolver.isInCache(value)) {
            throw new BugzillaException(4, NLS.bind((String)Messages.BugzillaImporter_ITEM_EXISTS, (Object)value, (Object[])new Object[0]));
        }
    }

    private void importBugs(IBugRetrievalStrategy strategy, IBugzillaStatusMonitor statusMonitor, IProgressMonitor monitor) {
        Iterator<String> iter;
        try {
            iter = strategy.getIterator();
        }
        catch (BugzillaException x) {
            statusMonitor.reportStatus(x.getStatus());
            return;
        }
        if (strategy instanceof BugzillaFilteredRetrieval && !iter.hasNext()) {
            statusMonitor.reportStatus((IStatus)new FoundationStatus(2, "com.ibm.team.workitem.rcp.core", NLS.bind((String)Messages.BugzillaImporter_NO_BUG_WITH_PRODUCT, (Object)((BugzillaFilteredRetrieval)strategy).getProductName(), (Object[])new Object[0]), true));
            return;
        }
        monitor.beginTask(NLS.bind((String)Messages.BugzillaImporter_IMPORTING_NUMBER_OF_WORK_ITEMS, (Object)strategy.getNumberOfBugs(), (Object[])new Object[0]), strategy.getNumberOfBugs());
        while (iter.hasNext()) {
            block21: {
                ReportData data;
                String xml;
                SubProgressMonitor subMonitor;
                String nr;
                block19: {
                    block20: {
                        nr = iter.next();
                        String message = strategy instanceof CSVBugRetrievalStrategy ? (statusMonitor.getNumberOfErrors() == 0 ? NLS.bind((String)Messages.BugzillaImporter_IMPORTING_FROM_CSV, (Object)nr, (Object[])new Object[0]) : NLS.bind((String)Messages.BugzillaImporter_IMPORTING_FROM_CSV_WITH_ERRORS, (Object)nr, (Object[])new Object[]{statusMonitor.getNumberOfErrors()})) : (statusMonitor.getNumberOfErrors() == 0 ? NLS.bind((String)Messages.BugzillaImporter_IMPORTING_FROM, (Object)nr, (Object[])new Object[0]) : NLS.bind((String)Messages.BugzillaImporter_IMPORTING_FROM_WITH_ERRORS, (Object)nr, (Object[])new Object[]{statusMonitor.getNumberOfErrors()}));
                        monitor.subTask(message);
                        subMonitor = new SubProgressMonitor(monitor, 1, 2);
                        subMonitor.beginTask(message, 1);
                        xml = null;
                        if (strategy instanceof IExtendedBugRetrievalStrategy) {
                            data = ((IExtendedBugRetrievalStrategy)strategy).getData(nr);
                        } else {
                            xml = strategy.getXML(nr);
                            data = BugzillaOperations.getOperations().parseReport(nr, xml);
                        }
                        if (!data.notfound) break block19;
                        statusMonitor.reportStatus((IStatus)new FoundationStatus(2, "com.ibm.team.workitem.rcp.core", NLS.bind((String)Messages.BugzillaImporter_NO_BUG_WITH_ID, (Object)nr, (Object[])new Object[0]), true));
                        if (!monitor.isCanceled()) break block20;
                        throw new OperationCanceledException();
                    }
                    subMonitor.worked(1);
                    subMonitor.done();
                    continue;
                }
                try {
                    this.determineServerUrl(data.getString("urlbase"));
                    this.checkIfItemAlreadyExists(String.valueOf(this.fServerUrl) + data.getString("bug_id"));
                    if (this.fConfiguration.isComputeMappingFileOnly()) {
                        this.recordMapping(strategy, data, (IProgressMonitor)subMonitor);
                    } else if (this.fConfiguration.isSaveXML()) {
                        this.writeDataToZip(strategy, nr, xml, data.attachments);
                    } else {
                        this.saveWorkItem(strategy, data, (IProgressMonitor)subMonitor);
                    }
                }
                catch (BugzillaException x) {
                    statusMonitor.reportStatus(x.getStatus());
                    subMonitor.worked(1);
                    subMonitor.done();
                    break block21;
                }
                catch (RuntimeException x) {
                    try {
                        if (x instanceof OperationCanceledException) {
                            throw x;
                        }
                        statusMonitor.reportStatus((IStatus)new Status(4, "com.ibm.team.workitem.rcp.core", 4, "Exception while importing bug " + nr, (Throwable)x));
                        break block21;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        subMonitor.worked(1);
                        subMonitor.done();
                    }
                }
                subMonitor.worked(1);
                subMonitor.done();
            }
            if (!monitor.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        monitor.done();
    }

    private void determineServerUrl(String urlbase) {
        if (this.fServerUrl == null || this.isTestRun) {
            this.fServerUrl = urlbase;
            if (this.fServerUrl != null && this.fServerUrl.length() > 0) {
                if (!this.fServerUrl.endsWith("/")) {
                    this.fServerUrl = String.valueOf(this.fServerUrl) + "/";
                }
                this.fServerUrl = String.valueOf(this.fServerUrl) + "show_bug.cgi?id=";
            }
        }
    }

    private void recordMapping(IBugRetrievalStrategy strategy, ReportData data, IProgressMonitor monitor) throws BugzillaException {
        try {
            this.fCopier.recordMapping(strategy, data, monitor);
        }
        catch (TeamRepositoryException x) {
            throw new BugzillaException(4, Messages.BugzillaImporter_EXCEPTION_COMPUTING_MAPPING, x);
        }
    }

    private void writeMapping(IProgressMonitor monitor) throws BugzillaException {
        try {
            FileOutputStream stream = new FileOutputStream(this.fConfiguration.getSaveMappingFile());
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            try {
                this.fCopier.writeMapping(writer, monitor);
            }
            finally {
                ((Writer)writer).flush();
                ((Writer)writer).close();
            }
        }
        catch (IOException x) {
            throw new BugzillaException(4, Messages.BugzillaImporter_EXCEPTION_WRITING_MAPPING, x);
        }
        catch (TeamRepositoryException x) {
            throw new BugzillaException(4, Messages.BugzillaImporter_EXCEPTION_WRITING_MAPPING, x);
        }
    }

    private void writeDataToZip(IBugRetrievalStrategy strategy, String id, String xml, List attachmentInfo) throws BugzillaException {
        AttachmentData[] attachments = strategy.getAttachments(id, attachmentInfo);
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.zOut, HttpUtil.CharsetEncoding.UTF8.toString());
            int i = 0;
            while (i < attachments.length) {
                xml = xml.replaceFirst("<attachid>\\d+</attachid>", "<TEMPattachid>" + attachments[i].getString("0") + "</attachid>");
                this.zOut.putNextEntry(new ZipEntry(String.valueOf(String.valueOf(id)) + "/" + attachments[i].getString("0")));
                this.zOut.write(attachments[i].data);
                this.zOut.flush();
                this.zOut.closeEntry();
                ++i;
            }
            xml = xml.replaceAll("<TEMPattachid>", "<attachid>");
            this.zOut.putNextEntry(new ZipEntry(String.valueOf(String.valueOf(id)) + ".xml"));
            writer.write(xml);
            writer.flush();
            this.zOut.closeEntry();
        }
        catch (IOException e) {
            throw new BugzillaException(Messages.Messages_EXCEPTION_WRITING_ZIP, e);
        }
    }

    private void saveWorkItem(final IBugRetrievalStrategy strategy, final ReportData data, IProgressMonitor monitor) throws BugzillaException {
        final boolean[] doUpdate = new boolean[1];
        try {
            final ITeamRepository teamRepository = this.fConfiguration.getTeamRepository();
            WorkItemOperation operation = new WorkItemOperation(Messages.BugzillaImporter_IMPORTING_WORK_ITEM, IWorkItem.FULL_PROFILE){

                protected void execute(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
                    try {
                        HashSet<String> unresolvedIds = new HashSet<String>();
                        BugzillaImporter.this.fCopier.copyData(workingCopy, strategy, data, doUpdate[0], BugzillaImporter.this.fServerUrl, BugzillaImporter.this.fConfiguration.isCheckIfAlreadyImported(), BugzillaImporter.this.isTestRun, unresolvedIds, monitor);
                        IDetailedStatus status = workingCopy.save(monitor);
                        if (status.getSeverity() == 8 || status.getSeverity() == 4) {
                            throw new TeamRepositoryException((Object)teamRepository, status.getMessage(), status.getException());
                        }
                        monitor.subTask(NLS.bind((String)Messages.BugzillaImporter_IMPORTING_FROM_TO, (Object)data.getString("bug_id"), (Object[])new Object[]{workingCopy.getWorkItem().getId()}));
                        if (!(strategy instanceof CSVBugRetrievalStrategy)) {
                            BugzillaImporter.this.fCopier.addToCache(workingCopy, unresolvedIds);
                            BugzillaImporter.this.fResolver.putInCache(workingCopy, monitor);
                            BugzillaImporter.this.fResolver.resolve(workingCopy, monitor);
                        }
                    }
                    catch (BugzillaException x) {
                        throw new TeamRepositoryException((Object)teamRepository, x.getMessage(), (Throwable)((Object)x));
                    }
                }
            };
            IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
            if (this.fConfiguration.getImportMode() == BugzillaConfiguration.Mode.UPDATE || this.fConfiguration.getImportMode() == BugzillaConfiguration.Mode.UPDATE_OR_CREATE) {
                IWorkItem existingWorkItem = null;
                IAttribute idAttribute = workItemClient.findAttribute(this.fConfiguration.getProjectArea(), WorkItemAttributes.getAttributeId((Identifier)WorkItemAttributes.ID), monitor);
                if (idAttribute != null) {
                    String workItemId = data.getString(idAttribute.getDisplayName());
                    try {
                        if (workItemId != null) {
                            existingWorkItem = workItemClient.findWorkItemById(Integer.valueOf(workItemId).intValue(), IWorkItem.FULL_PROFILE, monitor);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        doUpdate[0] = false;
                    }
                }
                if (existingWorkItem != null && existingWorkItem.getProjectArea().sameItemId((IItemHandle)this.fConfiguration.getProjectArea())) {
                    doUpdate[0] = true;
                    operation.run((IWorkItemHandle)existingWorkItem, monitor);
                    if (this.isTestRun) {
                        IWorkItem workItem = workItemClient.resolveWorkItem((IWorkItemHandle)existingWorkItem.getItemHandle(), IWorkItem.FULL_PROFILE, monitor);
                        ((ITestBugRetrievalStrategy)strategy).handOverImportedWorkItem(workItem);
                    }
                } else if (this.fConfiguration.getImportMode() == BugzillaConfiguration.Mode.UPDATE_OR_CREATE) {
                    doUpdate[0] = false;
                } else {
                    return;
                }
            }
            if (!doUpdate[0]) {
                IWorkItemType workItemType = null;
                IAttribute typeAttribute = workItemClient.findAttribute(this.fConfiguration.getProjectArea(), WorkItemAttributes.getAttributeId((Identifier)WorkItemAttributes.TYPE), monitor);
                if (typeAttribute != null && data.exists(typeAttribute.getDisplayName())) {
                    String typeValue = data.getString(typeAttribute.getDisplayName());
                    List workItemTypes = workItemClient.findCachedWorkItemTypes(this.fConfiguration.getProjectArea());
                    if (workItemTypes == null) {
                        workItemTypes = workItemClient.findWorkItemTypes(this.fConfiguration.getProjectArea(), monitor);
                    }
                    for (IWorkItemType type : workItemTypes) {
                        if (!type.getDisplayName().equals(typeValue)) continue;
                        workItemType = type;
                        break;
                    }
                }
                if (workItemType == null) {
                    workItemType = workItemClient.findWorkItemType(this.fConfiguration.getProjectArea(), "defect", monitor);
                }
                IWorkItemHandle handle = operation.run(workItemType, monitor);
                if (this.isTestRun) {
                    IWorkItem workItem = workItemClient.resolveWorkItem(handle, IWorkItem.FULL_PROFILE, monitor);
                    ((ITestBugRetrievalStrategy)strategy).handOverImportedWorkItem(workItem);
                }
            }
        }
        catch (TeamRepositoryException e) {
            if (strategy instanceof CSVBugRetrievalStrategy) {
                throw new BugzillaException(NLS.bind((String)Messages.BugzillaImporter_COULD_NOT_CREATE_CSV, (Object)data.getString("bug_id"), (Object[])new Object[0]), e);
            }
            throw new BugzillaException(NLS.bind((String)Messages.BugzillaImporter_COULD_NOT_CREATE, (Object)data.getString("bug_id"), (Object[])new Object[0]), e);
        }
    }

    private void openZipOutputStream() throws BugzillaException {
        File newFile = new File(this.fConfiguration.getSaveFileName());
        if (newFile.exists()) {
            if (!this.fConfiguration.isOverWriteExisting()) {
                throw new BugzillaException((IStatus)new FoundationStatus(4, "com.ibm.team.workitem.rcp.core", NLS.bind((String)Messages.BugzillaImporter_FILE_EXISTS, (Object)this.fConfiguration.getSaveFileName(), (Object[])new Object[0]), true));
            }
            newFile.delete();
            try {
                newFile.createNewFile();
            }
            catch (IOException e) {
                throw new BugzillaException(4, Messages.Messages_EXCEPTION_WRITING_ZIP, e);
            }
        }
        Path zipFile = new Path(this.fConfiguration.getSaveFileName());
        try {
            FileOutputStream out = new FileOutputStream(zipFile.toOSString());
            this.zOut = new ZipOutputStream(out);
        }
        catch (FileNotFoundException e) {
            throw new BugzillaException(4, Messages.Messages_EXCEPTION_WRITING_ZIP, e);
        }
    }

    private void closeZipOutputStream() throws IOException {
        try {
            if (this.zOut != null) {
                this.zOut.flush();
                this.zOut.close();
            }
        }
        catch (ZipException zipException) {}
    }

    private void ensureIsLoggedIn() throws BugzillaException {
        if (this.fConfiguration.isNeedsAuthentication() && !this.fConfiguration.isBasicHTTPAuthentication()) {
            CookieLoginOperation login = new CookieLoginOperation(this.fConfiguration);
            login.getCookie();
        }
    }

    public BugzillaConfiguration getConfiguration() {
        return this.fConfiguration;
    }
}

