/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.core.model.internal;

import com.ibm.team.feed.core.internal.AdaptableDataObject;
import com.ibm.team.feed.core.internal.FeedCorePlugin;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.FeedPackage;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.feed.core.model.internal.CustomFieldEntryImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;

public class ChannelImpl
extends AdaptableDataObject
implements Channel {
    private static final long serialVersionUID = 1L;
    protected EList internalContents = null;
    protected static final String TITLE_EDEFAULT = null;
    protected String title = TITLE_EDEFAULT;
    protected static final String HOMEPAGE_EDEFAULT = null;
    protected String homepage = HOMEPAGE_EDEFAULT;
    protected static final String URL_EDEFAULT = null;
    protected String url = URL_EDEFAULT;
    protected static final String DESCRIPTION_EDEFAULT = null;
    protected String description = DESCRIPTION_EDEFAULT;
    protected static final String CATEGORY_EDEFAULT = null;
    protected String category = CATEGORY_EDEFAULT;
    protected static final int UPDATE_INTERVAL_EDEFAULT = 0;
    protected int updateInterval = 0;
    protected static final String LAST_ERROR_EDEFAULT = null;
    protected String lastError = LAST_ERROR_EDEFAULT;
    protected static final String ETAG_EDEFAULT = null;
    protected String eTag = ETAG_EDEFAULT;
    protected static final String LAST_MODIFIED_EDEFAULT = null;
    protected String lastModified = LAST_MODIFIED_EDEFAULT;
    protected static final int COLOR_EDEFAULT = 0;
    protected int color = 0;
    protected static final boolean FORCE_DOWNLOAD_EDEFAULT = false;
    protected boolean forceDownload = false;
    protected EMap customFields = null;
    protected static final long AGE_LIMIT_EDEFAULT = -1L;
    protected long ageLimit = -1L;
    protected static final int ITEM_LIMIT_EDEFAULT = 400;
    protected int itemLimit = 400;
    private boolean fIsLoading;
    private int fUnreadCount = 0;
    private String fPreviousURL;
    private final Object fgLock = new Object();
    private boolean fExplicitRefresh;

    protected ChannelImpl() {
    }

    protected EClass eStaticClass() {
        return FeedPackage.Literals.CHANNEL;
    }

    public List getInternalContents() {
        if (this.internalContents == null) {
            this.internalContents = new EObjectContainmentEList(NewsItem.class, (InternalEObject)this, 0);
        }
        return this.internalContents;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String newTitle) {
        String oldTitle = this.title;
        this.title = newTitle;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldTitle, (Object)this.title));
        }
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String newHomepage) {
        String oldHomepage = this.homepage;
        this.homepage = newHomepage;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldHomepage, (Object)this.homepage));
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String newUrl) {
        Assert.isNotNull((Object)newUrl);
        String oldUrl = this.url;
        this.url = newUrl;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldUrl, (Object)this.url));
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldDescription, (Object)this.description));
        }
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String newCategory) {
        String oldCategory = this.category;
        this.category = newCategory;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldCategory, (Object)this.category));
        }
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(int newUpdateInterval) {
        int oldUpdateInterval = this.updateInterval;
        this.updateInterval = newUpdateInterval;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldUpdateInterval, this.updateInterval));
        }
    }

    public String getLastError() {
        return this.lastError;
    }

    public void setLastError(String newLastError) {
        String oldLastError = this.lastError;
        this.lastError = newLastError;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldLastError, (Object)this.lastError));
        }
    }

    public String getETag() {
        return this.eTag;
    }

    public void setETag(String newETag) {
        String oldETag = this.eTag;
        this.eTag = newETag;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldETag, (Object)this.eTag));
        }
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String newLastModified) {
        String oldLastModified = this.lastModified;
        this.lastModified = newLastModified;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldLastModified, (Object)this.lastModified));
        }
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int newColor) {
        int oldColor = this.color;
        this.color = newColor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldColor, this.color));
        }
    }

    public boolean isForceDownload() {
        return this.forceDownload;
    }

    public void setForceDownload(boolean newForceDownload) {
        boolean oldForceDownload = this.forceDownload;
        this.forceDownload = newForceDownload;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, oldForceDownload, this.forceDownload));
        }
    }

    public Map getCustomFields() {
        if (this.customFields == null) {
            this.customFields = new EcoreEMap(FeedPackage.Literals.CUSTOM_FIELD_ENTRY, CustomFieldEntryImpl.class, (InternalEObject)this, 12);
        }
        return this.customFields.map();
    }

    public long getAgeLimit() {
        return this.ageLimit;
    }

    public void setAgeLimit(long newAgeLimit) {
        long oldAgeLimit = this.ageLimit;
        this.ageLimit = newAgeLimit;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, oldAgeLimit, this.ageLimit));
        }
    }

    public int getItemLimit() {
        return this.itemLimit;
    }

    public void setItemLimit(int newItemLimit) {
        int oldItemLimit = this.itemLimit;
        this.itemLimit = newItemLimit;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, oldItemLimit, this.itemLimit));
        }
    }

    public NewsItem[] getItems() {
        NewsItem[] allItems = this.getAllItems();
        ArrayList<NewsItem> items = new ArrayList<NewsItem>(allItems.length);
        int i = 0;
        while (i < allItems.length) {
            if (!allItems[i].isDeleted()) {
                items.add(allItems[i]);
            }
            ++i;
        }
        return items.toArray(new NewsItem[items.size()]);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Channel)) {
            return false;
        }
        Channel channel = (Channel)obj;
        return channel.getUrl() != null && channel.getUrl().equals(this.getUrl());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(NewsItem item) {
        NewsItem[] newsItems;
        Object object = this.fgLock;
        synchronized (object) {
            List contents = this.getInternalContents();
            newsItems = contents.toArray(new NewsItem[contents.size()]);
        }
        NewsItem[] newsItemArray = newsItems;
        int n = newsItems.length;
        int n2 = 0;
        while (n2 < n) {
            NewsItem contentItem = newsItemArray[n2];
            if (contentItem.equals(item)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getCustomAttribute(String namespace, String name) {
        String key = String.valueOf(namespace) + ":" + name;
        Object value = this.getCustomFields().get(key);
        if (value != null) {
            return (String)value;
        }
        return null;
    }

    public void clearCustomAttributes() {
        this.getCustomFields().clear();
    }

    public NewsItem[] getRelated(NewsItem item) {
        if (!this.equals(item.getChannel())) {
            return new NewsItem[0];
        }
        ArrayList<NewsItem> relatedItems = new ArrayList<NewsItem>();
        NewsItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            NewsItem containedItem = items[i];
            if (item.getLink() != null && item.getLink().equals(containedItem.getLink())) {
                relatedItems.add(containedItem);
            }
            ++i;
        }
        return relatedItems.toArray(new NewsItem[relatedItems.size()]);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getInternalContents()).basicRemove((Object)otherEnd, msgs);
            }
            case 12: {
                return ((InternalEList)((EMap.InternalMapView)this.getCustomFields()).eMap()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getInternalContents();
            }
            case 1: {
                return this.getTitle();
            }
            case 2: {
                return this.getHomepage();
            }
            case 3: {
                return this.getUrl();
            }
            case 4: {
                return this.getDescription();
            }
            case 5: {
                return this.getCategory();
            }
            case 6: {
                return new Integer(this.getUpdateInterval());
            }
            case 7: {
                return this.getLastError();
            }
            case 8: {
                return this.getETag();
            }
            case 9: {
                return this.getLastModified();
            }
            case 10: {
                return new Integer(this.getColor());
            }
            case 11: {
                return this.isForceDownload() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 12: {
                if (coreType) {
                    return ((EMap.InternalMapView)this.getCustomFields()).eMap();
                }
                return this.getCustomFields();
            }
            case 13: {
                return new Long(this.getAgeLimit());
            }
            case 14: {
                return new Integer(this.getItemLimit());
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getInternalContents().clear();
                this.getInternalContents().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setTitle((String)newValue);
                return;
            }
            case 2: {
                this.setHomepage((String)newValue);
                return;
            }
            case 3: {
                this.setUrl((String)newValue);
                return;
            }
            case 4: {
                this.setDescription((String)newValue);
                return;
            }
            case 5: {
                this.setCategory((String)newValue);
                return;
            }
            case 6: {
                this.setUpdateInterval((Integer)newValue);
                return;
            }
            case 7: {
                this.setLastError((String)newValue);
                return;
            }
            case 8: {
                this.setETag((String)newValue);
                return;
            }
            case 9: {
                this.setLastModified((String)newValue);
                return;
            }
            case 10: {
                this.setColor((Integer)newValue);
                return;
            }
            case 11: {
                this.setForceDownload((Boolean)newValue);
                return;
            }
            case 12: {
                ((EStructuralFeature.Setting)((EMap.InternalMapView)this.getCustomFields()).eMap()).set(newValue);
                return;
            }
            case 13: {
                this.setAgeLimit((Long)newValue);
                return;
            }
            case 14: {
                this.setItemLimit((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getInternalContents().clear();
                return;
            }
            case 1: {
                this.setTitle(TITLE_EDEFAULT);
                return;
            }
            case 2: {
                this.setHomepage(HOMEPAGE_EDEFAULT);
                return;
            }
            case 3: {
                this.setUrl(URL_EDEFAULT);
                return;
            }
            case 4: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
            case 5: {
                this.setCategory(CATEGORY_EDEFAULT);
                return;
            }
            case 6: {
                this.setUpdateInterval(0);
                return;
            }
            case 7: {
                this.setLastError(LAST_ERROR_EDEFAULT);
                return;
            }
            case 8: {
                this.setETag(ETAG_EDEFAULT);
                return;
            }
            case 9: {
                this.setLastModified(LAST_MODIFIED_EDEFAULT);
                return;
            }
            case 10: {
                this.setColor(0);
                return;
            }
            case 11: {
                this.setForceDownload(false);
                return;
            }
            case 12: {
                this.getCustomFields().clear();
                return;
            }
            case 13: {
                this.setAgeLimit(-1L);
                return;
            }
            case 14: {
                this.setItemLimit(400);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.internalContents != null && !this.internalContents.isEmpty();
            }
            case 1: {
                return TITLE_EDEFAULT == null ? this.title != null : !TITLE_EDEFAULT.equals(this.title);
            }
            case 2: {
                return HOMEPAGE_EDEFAULT == null ? this.homepage != null : !HOMEPAGE_EDEFAULT.equals(this.homepage);
            }
            case 3: {
                return URL_EDEFAULT == null ? this.url != null : !URL_EDEFAULT.equals(this.url);
            }
            case 4: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 5: {
                return CATEGORY_EDEFAULT == null ? this.category != null : !CATEGORY_EDEFAULT.equals(this.category);
            }
            case 6: {
                return this.updateInterval != 0;
            }
            case 7: {
                return LAST_ERROR_EDEFAULT == null ? this.lastError != null : !LAST_ERROR_EDEFAULT.equals(this.lastError);
            }
            case 8: {
                return ETAG_EDEFAULT == null ? this.eTag != null : !ETAG_EDEFAULT.equals(this.eTag);
            }
            case 9: {
                return LAST_MODIFIED_EDEFAULT == null ? this.lastModified != null : !LAST_MODIFIED_EDEFAULT.equals(this.lastModified);
            }
            case 10: {
                return this.color != 0;
            }
            case 11: {
                return this.forceDownload;
            }
            case 12: {
                return this.customFields != null && !this.customFields.isEmpty();
            }
            case 13: {
                return this.ageLimit != -1L;
            }
            case 14: {
                return this.itemLimit != 400;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (title: ");
        result.append(this.title);
        result.append(", homepage: ");
        result.append(this.homepage);
        result.append(", url: ");
        result.append(this.url);
        result.append(", description: ");
        result.append(this.description);
        result.append(", category: ");
        result.append(this.category);
        result.append(", updateInterval: ");
        result.append(this.updateInterval);
        result.append(", lastError: ");
        result.append(this.lastError);
        result.append(", eTag: ");
        result.append(this.eTag);
        result.append(", lastModified: ");
        result.append(this.lastModified);
        result.append(", color: ");
        result.append(this.color);
        result.append(", forceDownload: ");
        result.append(this.forceDownload);
        result.append(", ageLimit: ");
        result.append(this.ageLimit);
        result.append(", itemLimit: ");
        result.append(this.itemLimit);
        result.append(')');
        return result.toString();
    }

    public boolean isLoading() {
        return this.fIsLoading;
    }

    public void setIsLoading(boolean loading) {
        this.fIsLoading = loading;
    }

    public int getUnreadCount() {
        return this.fUnreadCount;
    }

    public void setUnreadCount(int count) {
        if (count < 0) {
            FeedCorePlugin.getDefault().logOnce(this.url, new IllegalArgumentException("Invalid negative count= " + count));
        }
        this.fUnreadCount = count;
        if (this.fUnreadCount < 0) {
            this.fUnreadCount = 0;
        }
    }

    public void increaseUnreadCount(int count) {
        if (this.fUnreadCount + count < 0) {
            FeedCorePlugin.getDefault().logOnce(String.valueOf(this.url) + "1", new IllegalArgumentException("fUnreadcound= " + this.fUnreadCount + " count= " + count));
        }
        this.fUnreadCount += count;
        if (this.fUnreadCount < 0) {
            this.fUnreadCount = 0;
        }
    }

    public String getPreviousURL() {
        return this.fPreviousURL;
    }

    public void setPreviousURL(String previousURL) {
        this.fPreviousURL = previousURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNewsItem(NewsItem item) {
        Object object = this.fgLock;
        synchronized (object) {
            return this.getInternalContents().add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NewsItem[] getAllItems() {
        Object object = this.fgLock;
        synchronized (object) {
            return this.getInternalContents().toArray(new NewsItem[this.getInternalContents().size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeNewsItem(NewsItem item) {
        Object object = this.fgLock;
        synchronized (object) {
            return this.getInternalContents().remove(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearNewsItems() {
        Object object = this.fgLock;
        synchronized (object) {
            this.getInternalContents().clear();
            this.fUnreadCount = 0;
        }
    }

    public boolean isExplicitRefresh() {
        return this.fExplicitRefresh;
    }

    public void setExplicitRefresh(boolean isExplicit) {
        this.fExplicitRefresh = isExplicit;
    }
}

