/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.core.internal.dao;

import com.ibm.team.feed.core.internal.Feed;
import com.ibm.team.feed.core.internal.FeedCorePlugin;
import com.ibm.team.feed.core.internal.LoadManager;
import com.ibm.team.feed.core.internal.dao.ConnectionManager;
import com.ibm.team.feed.core.internal.dao.FeedHandler;
import com.ibm.team.feed.core.internal.dao.Messages;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.foundation.client.internal.util.ClientURIUtils;
import com.ibm.team.foundation.common.IFeedConstants;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.DateUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class FeedCreator {
    private static final Object REPOSITORY_LOGIN_LOCK = new Object();
    private static final int USER_VARIABLE_LENGTH = "{$user}".length();
    private static final int MAX_RESULTS_PER_REQUEST = 1000;
    private Feed fCachedFeed;
    private final Channel fChannel;
    private String fCachedUserId;

    public FeedCreator(Channel channel) {
        this.fChannel = channel;
    }

    public synchronized Feed parseFeed(IProgressMonitor monitor) throws Exception {
        try {
            return this.internalParseFeed(monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            return this.getCachedFeed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Feed internalParseFeed(final IProgressMonitor monitor) throws Exception {
        String requestUriStr;
        String lastError = this.fChannel.getLastError();
        boolean isExplicit = this.fChannel.isExplicitRefresh();
        this.fChannel.setExplicitRefresh(false);
        if (!isExplicit && lastError != null && lastError.startsWith(LoadManager.MESSAGE_AUTHENTICATION_ERROR)) {
            throw new Exception("-401");
        }
        TeamRepository repository = this.findTeamRepository();
        if (repository != null) {
            Object object = REPOSITORY_LOGIN_LOCK;
            synchronized (object) {
                if (isExplicit && repository.getErrorState() == 1) {
                    repository.login(null);
                    return this.getCachedFeed();
                }
                if (repository.getErrorState() != 0 && repository.getLastError() != null) {
                    throw new Exception(repository.getLastError());
                }
                if (!repository.loggedIn()) {
                    return this.getCachedFeed();
                }
            }
        }
        if ((requestUriStr = this.prepareRequestURI()) == null) {
            return this.getCachedFeed();
        }
        URI requestUri = new URI(requestUriStr);
        InputStream inputStream = repository != null ? ConnectionManager.getInputStream(repository, this.fChannel.getUrl(), requestUri, monitor) : ConnectionManager.getInputStream(this.fChannel.getUrl(), requestUriStr);
        if (inputStream == ConnectionManager.NOT_MODIFIED_SINCE) {
            return this.getCachedFeed();
        }
        InputStream feedStream = new InputStream(inputStream){
            private InputStream fInputStream;
            {
                this.fInputStream = inputStream;
            }

            public int read() throws IOException {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                return this.fInputStream.read();
            }

            public int read(byte[] b) throws IOException {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                return this.fInputStream.read(b);
            }

            public int read(byte[] b, int off, int len) throws IOException {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                return this.fInputStream.read(b, off, len);
            }

            public long skip(long n) throws IOException {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                return this.fInputStream.skip(n);
            }

            public int available() throws IOException {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                return this.fInputStream.available();
            }

            public void close() throws IOException {
                this.fInputStream.close();
            }

            public synchronized void mark(int readlimit) {
                this.fInputStream.mark(readlimit);
            }

            public synchronized void reset() throws IOException {
                this.fInputStream.reset();
            }

            public boolean markSupported() {
                return this.fInputStream.markSupported();
            }
        };
        Feed parsed = null;
        FeedHandler handler = new FeedHandler(requestUriStr);
        XMLReader xmlReader = FeedCreator.getReader(handler);
        try {
            xmlReader.parse(new InputSource(feedStream));
        }
        finally {
            block19: {
                try {
                    feedStream.close();
                }
                catch (IOException e) {
                    FeedCorePlugin feedCorePlugin = FeedCorePlugin.getDefault();
                    if (feedCorePlugin == null) break block19;
                    feedCorePlugin.log(e.getMessage(), e);
                }
            }
        }
        parsed = handler.getFeed();
        if (parsed == null) {
            parsed = new Feed("");
        }
        this.fCachedFeed = parsed;
        return parsed;
    }

    private TeamRepository findTeamRepository() throws URISyntaxException {
        String validFeedUrl = this.fChannel.getUrl();
        if (validFeedUrl.contains("{$user}")) {
            validFeedUrl = validFeedUrl.substring(0, validFeedUrl.indexOf("{$user}"));
        }
        return (TeamRepository)ClientURIUtils.findTeamRepository((URI)new URI(validFeedUrl));
    }

    private Feed getCachedFeed() {
        if (this.fCachedFeed == null) {
            Feed empty;
            this.fCachedFeed = empty = new Feed("");
            return empty;
        }
        return this.fCachedFeed;
    }

    public static XMLReader getReader(FeedHandler handler) throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser saxParser = factory.newSAXParser();
        saxParser.getXMLReader().setContentHandler(handler);
        saxParser.getXMLReader().setErrorHandler(handler);
        saxParser.getXMLReader().setEntityResolver(FeedCreator.getEntityResolver());
        return saxParser.getXMLReader();
    }

    private static EntityResolver getEntityResolver() {
        return new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(FeedCreator.class.getResourceAsStream("entities.dtd"));
            }
        };
    }

    private String prepareRequestURI() throws TeamRepositoryException, URISyntaxException, UnsupportedEncodingException {
        Location location;
        String repoUri;
        StringBuffer uri = new StringBuffer(this.fChannel.getUrl());
        int userIdx = uri.indexOf("{$user}");
        if (userIdx > 0 && (repoUri = (location = Location.location((URI)new URI(this.fChannel.getUrl().substring(0, userIdx)))).getRepoUri()) != null && repoUri.length() > 0) {
            ITeamRepository[] allrepos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            ITeamRepository repository = null;
            if (repoUri.charAt(repoUri.length() - 1) == '/') {
                repoUri = repoUri.substring(0, repoUri.length() - 2);
            }
            ITeamRepository[] iTeamRepositoryArray = allrepos;
            int n = allrepos.length;
            int n2 = 0;
            while (n2 < n) {
                ITeamRepository teamRepository = iTeamRepositoryArray[n2];
                if (teamRepository.getRepositoryURI().startsWith(repoUri)) {
                    repository = teamRepository;
                    break;
                }
                ++n2;
            }
            if (repository == null) {
                String msg = MessageFormat.format(Messages.FeedCreator_UNKNOWN_REPOSITORY, repoUri);
                throw new TeamRepositoryException(msg);
            }
            if (!(repository == null || repository.loggedIn() && repository.getErrorState() == 0)) {
                return null;
            }
            String userId = repository.loggedInContributor().getUserId();
            if (!userId.equals(this.fCachedUserId)) {
                if (this.fCachedUserId != null) {
                    this.fChannel.clearNewsItems();
                    this.fCachedFeed = null;
                }
                this.fCachedUserId = userId;
            }
            userId = URLEncoder.encode(userId, "utf-8");
            uri.replace(userIdx, userIdx + USER_VARIABLE_LENGTH, userId);
        }
        uri.append(this.getSinceAndMaxResultsParam());
        return uri.toString();
    }

    private String getSinceAndMaxResultsParam() {
        if (this.fChannel.getUrl().indexOf(IFeedConstants.SERVICE_NAME) == -1) {
            return "";
        }
        boolean dateFound = false;
        NewsItem[] items = this.fChannel.getAllItems();
        Date maxDate = new Date(0L);
        NewsItem[] newsItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            NewsItem newsItem = newsItemArray[n2];
            Date currdate = newsItem.getPublishDate();
            if (maxDate.compareTo(currdate) < 0) {
                dateFound = true;
                maxDate = currdate;
            }
            ++n2;
        }
        if (!dateFound) {
            return "&since=" + DateUtils.formatTimeISO8601((Date)maxDate);
        }
        return "&maxResults=1000&since=" + DateUtils.formatTimeISO8601((Date)maxDate);
    }
}

