/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.core.internal.dao;

import com.ibm.icu.text.MessageFormat;
import com.ibm.team.feed.core.internal.FeedCorePlugin;
import com.ibm.team.feed.core.internal.dao.Messages;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.foundation.rcp.core.IAuthenticatorChecker;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.client.util.FormBasedAuth;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.IFeedService;
import com.ibm.team.repository.transport.client.ITeamRestServiceClient;
import com.ibm.team.repository.transport.client.SSLContextUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class ConnectionManager {
    private static final String ACCEPT_GZIP_ENCODING = "gzip, *";
    private static final String DISABLE_CONDITIONAL_GET = "com.ibm.team.feed.core/disableConditionalGet";
    private static final Map<Object, String> ETAG_CACHE = new ConcurrentHashMap<Object, String>();
    private static final String HTTP_STATUS_NOT_MODIFIED = "304";
    private static final Map<Object, String> LAST_MODIFIED_CACHE = new ConcurrentHashMap<Object, String>();
    static final InputStream NOT_MODIFIED_SINCE = new InputStream(){

        public int read() {
            return 0;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheConditionalGet(String feedUrl, String eTag, String lastModified) {
        Map<Object, String> map;
        if (eTag != null) {
            map = ETAG_CACHE;
            synchronized (map) {
                ETAG_CACHE.put(feedUrl, eTag);
            }
        }
        if (lastModified != null) {
            map = LAST_MODIFIED_CACHE;
            synchronized (map) {
                LAST_MODIFIED_CACHE.put(feedUrl, lastModified);
            }
        }
    }

    private static void cacheConditionalGet(String feedUrl, URLConnection urlCon) {
        String lastModified = null;
        String eTag = null;
        if (urlCon.getHeaderField("Last-Modified") != null) {
            lastModified = urlCon.getHeaderField("Last-Modified");
        }
        if (urlCon.getHeaderField("ETag") != null) {
            eTag = urlCon.getHeaderField("ETag");
        }
        ConnectionManager.cacheConditionalGet(feedUrl, eTag, lastModified);
    }

    private static void cacheConditionalGet(String feedUrl, ITeamRestServiceClient.IRestClientConnection.Response response) {
        String lastModified = null;
        String eTag = null;
        if (response.getResponseHeader("Last-Modified") != null) {
            lastModified = response.getResponseHeader("Last-Modified");
        }
        if (response.getResponseHeader("ETag") != null) {
            eTag = response.getResponseHeader("ETag");
        }
        ConnectionManager.cacheConditionalGet(feedUrl, eTag, lastModified);
    }

    private static InputStream compressConnection(String contentEncoding, InputStream inputStream) throws IOException {
        boolean isGzipStream = false;
        if (!(contentEncoding != null && contentEncoding.equals("gzip") || inputStream != null && inputStream.markSupported())) {
            return inputStream;
        }
        if (contentEncoding != null && contentEncoding.equals("gzip")) {
            isGzipStream = true;
        } else if (inputStream != null && inputStream.markSupported()) {
            inputStream.mark(2);
            int id1 = inputStream.read();
            int id2 = inputStream.read();
            inputStream.reset();
            if (id1 == 31 && id2 == 139) {
                isGzipStream = true;
            }
        }
        if (isGzipStream) {
            inputStream = new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    private static InputStream compressConnection(URLConnection urlCon, InputStream inputStream) throws IOException {
        return ConnectionManager.compressConnection(urlCon.getHeaderField("Content-Encoding") != null ? urlCon.getHeaderField("Content-Encoding") : null, inputStream);
    }

    private static InputStream compressConnection(ITeamRestServiceClient.IRestClientConnection.Response response, InputStream inputStream) throws IOException {
        return ConnectionManager.compressConnection(response.getResponseHeader("Content-Encoding") != null ? response.getResponseHeader("Content-Encoding") : null, inputStream);
    }

    public static String getETag(String feedUrl) {
        return ETAG_CACHE.get(feedUrl);
    }

    public static InputStream getInputStream(TeamRepository repository, String feedUrl, URI requestUrl, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        Assert.isTrue((repository != null ? 1 : 0) != 0);
        ITeamRestServiceClient restClient = (ITeamRestServiceClient)repository.getServiceInterface(IFeedService.class);
        final ITeamRestServiceClient.IRestClientConnection connection = restClient.getConnection(Location.serviceLocation((String)repository.getRepositoryURI(), IFeedService.class, (String)requestUrl.getPath(), (String)requestUrl.getQuery()));
        ConnectionManager.setHeaders(feedUrl, connection);
        ITeamRestServiceClient.IRestClientConnection.Response response = (ITeamRestServiceClient.IRestClientConnection.Response)repository.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<ITeamRestServiceClient.IRestClientConnection.Response>(){

            public ITeamRestServiceClient.IRestClientConnection.Response run(IProgressMonitor progressMonitor) throws TeamRepositoryException {
                try {
                    progressMonitor.beginTask("", -1);
                    ITeamRestServiceClient.IRestClientConnection.Response response = connection.doGet();
                    return response;
                }
                finally {
                    progressMonitor.done();
                }
            }
        }, monitor);
        ConnectionManager.cacheConditionalGet(feedUrl, response);
        boolean disableConditionalGet = Boolean.valueOf(Platform.getDebugOption((String)DISABLE_CONDITIONAL_GET));
        if (!disableConditionalGet && response.getStatusCode() == ITeamRestServiceClient.IRestClientConnection.Response.StatusCode.NOT_MODIFIED) {
            response.getResponseStream().close();
            return NOT_MODIFIED_SINCE;
        }
        return ConnectionManager.compressConnection(response, response.getResponseStream());
    }

    public static InputStream getInputStream(String feedUrl, String requestUrl) throws IOException {
        URL urlObj = new URL(requestUrl);
        IAuthenticatorChecker adapter = (IAuthenticatorChecker)Adapters.getAdapter((Object)urlObj, IAuthenticatorChecker.class);
        if (adapter != null) {
            adapter.ensureAuthenticatorRegistered();
        }
        URLConnection urlCon = urlObj.openConnection();
        ConnectionManager.setupLazySSLSupport(urlCon);
        ConnectionManager.setHeaders(feedUrl, urlCon);
        try {
            URLConnection newCon = FormBasedAuth.handleFormBasedAuthentication((URLConnection)urlCon, (String)requestUrl);
            if (newCon != null) {
                urlCon = newCon;
                ConnectionManager.setupLazySSLSupport(urlCon);
                ConnectionManager.setHeaders(feedUrl, urlCon);
            }
        }
        catch (IOException x) {
            throw x;
        }
        catch (Exception x) {
            FeedCorePlugin.getDefault().log("Authentication failed", x);
            String errorMessage = Messages.ConnectionManager_AUTHENTICATION_REQUIRED;
            throw new IOException(MessageFormat.format((String)errorMessage, (Object[])new String[]{requestUrl}));
        }
        ConnectionManager.cacheConditionalGet(feedUrl, urlCon);
        boolean disableConditionalGet = Boolean.valueOf(Platform.getDebugOption((String)DISABLE_CONDITIONAL_GET));
        if (!disableConditionalGet && urlCon.getHeaderField(0) != null && urlCon.getHeaderField(0).indexOf(HTTP_STATUS_NOT_MODIFIED) >= 0) {
            return NOT_MODIFIED_SINCE;
        }
        return ConnectionManager.compressConnection(urlCon, urlCon.getInputStream());
    }

    public static String getLastModified(String channelUrl) {
        return LAST_MODIFIED_CACHE.get(channelUrl);
    }

    private static void setHeaders(String channelUrl, URLConnection urlCon) {
        String eTag;
        urlCon.setRequestProperty("Accept-Encoding", ACCEPT_GZIP_ENCODING);
        String lastModified = ConnectionManager.getLastModified(channelUrl);
        if (lastModified != null) {
            urlCon.setRequestProperty("If-Modified-Since", lastModified);
        }
        if ((eTag = ConnectionManager.getETag(channelUrl)) != null) {
            urlCon.setRequestProperty("If-None-Match", eTag);
        }
    }

    private static void setHeaders(String channelUrl, ITeamRestServiceClient.IRestClientConnection connection) {
        String eTag;
        connection.addRequestHeader("Accept-Encoding", ACCEPT_GZIP_ENCODING);
        String lastModified = ConnectionManager.getLastModified(channelUrl);
        if (lastModified != null) {
            connection.addRequestHeader("If-Modified-Since", lastModified);
        }
        if ((eTag = ConnectionManager.getETag(channelUrl)) != null) {
            connection.addRequestHeader("If-None-Match", eTag);
        }
    }

    public static void setupLazySSLSupport(URLConnection urlConnection) {
        if (!(urlConnection instanceof HttpsURLConnection)) {
            return;
        }
        HostnameVerifier hv = new HostnameVerifier(){

            public boolean verify(String urlHostname, SSLSession sslSession) {
                return true;
            }
        };
        try {
            final class NaiveTrustManager
            implements X509TrustManager {
                NaiveTrustManager() {
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            }
            SSLContext sc = SSLContextUtil.createSSLContext((TrustManager)new NaiveTrustManager());
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sc.getSocketFactory());
            ((HttpsURLConnection)urlConnection).setHostnameVerifier(hv);
        }
        catch (Exception e) {
            FeedCorePlugin.getDefault().log("A secure connection to the feed could not be created. No secure algorithm available (SSL, SSL_TLS, TLS). Verify the Java Virtual machine is properly configured to support SecureSocket.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uncacheConditionalGet(String feedUrl) {
        Map<Object, String> map = LAST_MODIFIED_CACHE;
        synchronized (map) {
            LAST_MODIFIED_CACHE.remove(feedUrl);
        }
        map = ETAG_CACHE;
        synchronized (map) {
            ETAG_CACHE.remove(feedUrl);
        }
    }
}

