/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.core.internal;

import com.ibm.team.feed.core.internal.dao.DateParser;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class NewsItem {
    private String fCategory;
    private String fDescription;
    private String fLink;
    private String fGuid;
    private Date fPublishDate;
    private String fTitle;
    private final HashMap<String, String> fCustomFields = new HashMap();

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NewsItem)) {
            return false;
        }
        NewsItem toCheck = (NewsItem)obj;
        if (this.getLink() == null && toCheck.getLink() != null) {
            return false;
        }
        if (this.getTitle() == null && toCheck.getTitle() != null) {
            return false;
        }
        Date pubDate1 = this.getPublishDate();
        Date pubDate2 = toCheck.getPublishDate();
        if (pubDate1 == null && pubDate2 != null) {
            return false;
        }
        if (pubDate2 == null && pubDate1 != null) {
            return false;
        }
        if (pubDate1 != null && pubDate2 != null && !pubDate1.equals(pubDate2)) {
            return false;
        }
        if (!this.fCustomFields.equals(toCheck.getAllCustomFields())) {
            return false;
        }
        if (this.getLink() == null && toCheck.getLink() == null) {
            if (this.getTitle() != null) {
                return this.getTitle().equals(toCheck.getTitle());
            }
            return false;
        }
        return this.getLink().equals(toCheck.getLink()) && this.getTitle().equals(toCheck.getTitle());
    }

    public String getCategory() {
        return this.fCategory;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getLink() {
        return this.fLink;
    }

    public Date getPublishDate() {
        return this.fPublishDate;
    }

    public String getTitle() {
        return this.fTitle;
    }

    public void setCategory(String category) {
        this.fCategory = category;
    }

    public void setDescription(String description) {
        this.fDescription = description;
    }

    public void setLink(String link) {
        this.fLink = link;
    }

    public void setPublishDate(Date publishDate) {
        this.fPublishDate = publishDate;
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    public Object getCustomFieldValue(String fieldname) {
        return this.fCustomFields.get(fieldname);
    }

    public Map getCustomFields() {
        return this.fCustomFields;
    }

    public HashMap getAllCustomFields() {
        return this.fCustomFields;
    }

    public void setField(String key, String value) {
        if ("title".equals(key)) {
            this.fTitle = value;
        } else if ("link".equals(key) && !this.isSet(this.fLink)) {
            this.fLink = value;
        } else if ("description".equals(key)) {
            this.fDescription = value;
        } else if ("pubDate".equals(key)) {
            this.fPublishDate = DateParser.parseDate(value);
        } else if ("category".equals(key)) {
            this.fCategory = value;
        } else if ("guid".equals(key)) {
            this.fGuid = value;
        } else {
            this.fCustomFields.put(key, value);
        }
    }

    private boolean isSet(String str) {
        return str != null && str.length() > 0;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("\n[NewsItem]");
        strBuf.append("\nLink: ").append(this.fLink);
        strBuf.append("\nTitle: ").append(this.fTitle);
        strBuf.append("\nDate: ").append(this.fPublishDate);
        strBuf.append("\nDescription: ").append(this.fDescription);
        strBuf.append("\nGuid: ").append(this.fGuid);
        if (this.fCustomFields.size() > 0) {
            strBuf.append("\nCustom Fields:\n");
            Set<String> keys = this.fCustomFields.keySet();
            for (String key : keys) {
                strBuf.append(key).append(" => ").append(this.fCustomFields.get(key)).append('\n');
            }
        }
        return strBuf.toString();
    }

    public String getGuid() {
        return this.fGuid;
    }

    public void setGuid(String guid) {
        this.fGuid = guid;
    }
}

