/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.core.internal;

import com.ibm.team.feed.core.internal.NewsItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Feed {
    private String fDescription;
    private String fLink;
    private final List<NewsItem> fNewsItems;
    private String fTitle;
    private String fUrl;
    private Map<String, String> fCustomFields;

    public Feed(String url) {
        this.fUrl = url;
        this.fNewsItems = new ArrayList<NewsItem>();
    }

    public void addItem(NewsItem newsItem) {
        if (!this.fNewsItems.contains(newsItem)) {
            this.fNewsItems.add(newsItem);
        }
    }

    public String getDescription() {
        return this.fDescription;
    }

    public NewsItem[] getItems() {
        return this.fNewsItems.toArray(new NewsItem[this.fNewsItems.size()]);
    }

    public String getLink() {
        return this.fLink;
    }

    public String getTitle() {
        return this.fTitle;
    }

    public String getUrl() {
        return this.fUrl;
    }

    public void setDescription(String description) {
        this.fDescription = description;
    }

    public void setLink(String link) {
        this.fLink = link;
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    public void setUrl(String url) {
        this.fUrl = url;
    }

    public void setField(String key, String value) {
        if ("link".equals(key)) {
            this.fLink = value;
        } else if ("title".equals(key)) {
            this.fTitle = value;
        } else if ("description".equals(key)) {
            this.fDescription = value;
        } else {
            if (this.fCustomFields == null) {
                this.fCustomFields = new HashMap<String, String>();
            }
            this.fCustomFields.put(key, value);
        }
    }

    public String getCustomField(String key) {
        return this.fCustomFields.get(key);
    }

    public Map<String, String> getCustomFields() {
        return this.fCustomFields;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("\n[Feed]");
        strBuf.append("\nTitle: ").append(this.fTitle);
        strBuf.append("\nLink: ").append(this.fLink);
        strBuf.append("\nDescription: ").append(this.fDescription);
        if (this.fCustomFields != null && this.fCustomFields.size() > 0) {
            strBuf.append("\nCustom Fields:\n");
            Set<String> keys = this.fCustomFields.keySet();
            for (String key : keys) {
                strBuf.append(key).append(" => ").append(this.fCustomFields.get(key)).append('\n');
            }
        }
        NewsItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            strBuf.append(items[i]);
            ++i;
        }
        return strBuf.toString();
    }
}

