/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.core.internal;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.repository.client.util.ThreadCheck;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class EventDispatcher {
    private final String fName;
    private final List<ISafeRunnable> fQueue = new ArrayList<ISafeRunnable>();
    private Job fJob = null;

    public EventDispatcher(String name) {
        this.fName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ISafeRunnable runnable) {
        List<ISafeRunnable> list = this.fQueue;
        synchronized (list) {
            this.fQueue.add(runnable);
            if (this.fJob == null) {
                this.fJob = new InternalJob();
                this.fJob.schedule();
            }
        }
    }

    private class InternalJob
    extends FoundationJob {
        public InternalJob() {
            super(EventDispatcher.this.fName);
            this.setPriority(20);
            this.setSystem(true);
        }

        protected IStatus runProtected(final IProgressMonitor monitor) {
            ThreadCheck.runProhibitingLongOps((Runnable)new Runnable(){

                public void run() {
                    InternalJob.this.internalRun(monitor);
                }
            });
            return Status.OK_STATUS;
        }

        private void internalRun(final IProgressMonitor monitor) {
            final boolean[] run = new boolean[]{true};
            while (run[0]) {
                run[0] = false;
                ISafeRunnable runnable = new ISafeRunnable(){

                    public void run() throws Exception {
                        InternalJob.this.runQueue(monitor);
                    }

                    public void handleException(Throwable exception) {
                        run[0] = true;
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runQueue(IProgressMonitor monitor) {
            while (true) {
                ISafeRunnable runnable;
                List list = EventDispatcher.this.fQueue;
                synchronized (list) {
                    if (monitor.isCanceled() || EventDispatcher.this.fQueue.isEmpty()) {
                        EventDispatcher.this.fJob = null;
                        EventDispatcher.this.fQueue.notifyAll();
                        break;
                    }
                    runnable = (ISafeRunnable)EventDispatcher.this.fQueue.remove(0);
                }
                SafeRunner.run((ISafeRunnable)runnable);
            }
        }
    }
}

