/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.core;

import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.NewsItem;
import java.util.Map;

public class TempChannel
implements Channel {
    private final long fId;
    private final Channel fChannel;
    private boolean fFirstTime;

    protected TempChannel(Channel channel, long id) {
        this.fChannel = channel;
        this.fId = id;
        this.fFirstTime = true;
    }

    public void dispose() {
        FeedManager.getDefault().removeTempChannel(this);
    }

    public long getId() {
        return this.fId;
    }

    public Channel getChannel() {
        return this.fChannel;
    }

    public boolean addNewsItem(NewsItem item) {
        return this.fChannel.addNewsItem(item);
    }

    public void clearCustomAttributes() {
        this.fChannel.clearCustomAttributes();
    }

    public void clearNewsItems() {
        this.fChannel.clearNewsItems();
    }

    public boolean contains(NewsItem item) {
        return this.fChannel.contains(item);
    }

    public long getAgeLimit() {
        return this.fChannel.getAgeLimit();
    }

    public NewsItem[] getAllItems() {
        return this.fChannel.getAllItems();
    }

    public String getCategory() {
        return this.fChannel.getCategory();
    }

    public int getColor() {
        return this.fChannel.getColor();
    }

    public String getCustomAttribute(String namespace, String name) {
        return this.fChannel.getCustomAttribute(namespace, name);
    }

    public Map getCustomFields() {
        return this.fChannel.getCustomFields();
    }

    public String getDescription() {
        return this.fChannel.getDescription();
    }

    public String getETag() {
        return this.fChannel.getETag();
    }

    public String getHomepage() {
        return this.fChannel.getHomepage();
    }

    public int getItemLimit() {
        return this.fChannel.getItemLimit();
    }

    public NewsItem[] getItems() {
        return this.fChannel.getItems();
    }

    public String getLastError() {
        return this.fChannel.getLastError();
    }

    public String getLastModified() {
        return this.fChannel.getLastModified();
    }

    public String getPreviousURL() {
        return this.fChannel.getPreviousURL();
    }

    public NewsItem[] getRelated(NewsItem item) {
        return this.fChannel.getRelated(item);
    }

    public String getTitle() {
        return this.fChannel.getTitle();
    }

    public int getUnreadCount() {
        return this.fChannel.getUnreadCount();
    }

    public int getUpdateInterval() {
        return this.fChannel.getUpdateInterval();
    }

    public String getUrl() {
        return this.fChannel.getUrl();
    }

    public boolean isExplicitRefresh() {
        if (this.fFirstTime) {
            this.fFirstTime = false;
            return true;
        }
        return this.fChannel.isExplicitRefresh();
    }

    public boolean isForceDownload() {
        return this.fChannel.isForceDownload();
    }

    public boolean isLoading() {
        return this.fChannel.isLoading();
    }

    public boolean removeNewsItem(NewsItem item) {
        return this.fChannel.removeNewsItem(item);
    }

    public void setAgeLimit(long value) {
        this.fChannel.setAgeLimit(value);
    }

    public void setCategory(String value) {
        this.fChannel.setCategory(value);
    }

    public void setColor(int value) {
        this.fChannel.setColor(value);
    }

    public void setDescription(String value) {
        this.fChannel.setDescription(value);
    }

    public void setETag(String value) {
        this.fChannel.setETag(value);
    }

    public void setExplicitRefresh(boolean isExplicit) {
        this.fChannel.setExplicitRefresh(isExplicit);
    }

    public void setForceDownload(boolean value) {
        this.fChannel.setForceDownload(value);
    }

    public void setHomepage(String value) {
        this.fChannel.setHomepage(value);
    }

    public void setIsLoading(boolean loading) {
        this.fChannel.setIsLoading(loading);
    }

    public void setItemLimit(int value) {
        this.fChannel.setItemLimit(value);
    }

    public void setLastError(String value) {
        this.fChannel.setLastError(value);
    }

    public void setLastModified(String value) {
        this.fChannel.setLastModified(value);
    }

    public void setPreviousURL(String previousURL) {
        this.fChannel.setPreviousURL(previousURL);
    }

    public void setTitle(String value) {
        this.fChannel.setTitle(value);
    }

    public void setUpdateInterval(int value) {
        this.fChannel.setUpdateInterval(value);
    }

    public void setUrl(String value) {
        this.fChannel.setUrl(value);
    }

    public Object getAdapter(Class adapter) {
        return this.fChannel.getAdapter(adapter);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TempChannel) {
            TempChannel temp = (TempChannel)obj;
            return this.fChannel.equals(temp.getChannel());
        }
        if (obj instanceof Channel) {
            Channel channel = (Channel)obj;
            return this.fChannel.equals(channel);
        }
        return false;
    }

    public int hashCode() {
        return this.fChannel.hashCode();
    }
}

