/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.core;

import com.ibm.team.feed.core.ChannelEvent;
import com.ibm.team.feed.core.IChannelListener;
import com.ibm.team.feed.core.IFeedManagerConfigurer;
import com.ibm.team.feed.core.INewsListener;
import com.ibm.team.feed.core.INewsManagerListener;
import com.ibm.team.feed.core.Messages;
import com.ibm.team.feed.core.NewsEvent;
import com.ibm.team.feed.core.TempChannel;
import com.ibm.team.feed.core.internal.EventDispatcher;
import com.ibm.team.feed.core.internal.FeedCorePlugin;
import com.ibm.team.feed.core.internal.LoadManager;
import com.ibm.team.feed.core.internal.dao.ConnectionManager;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.Channels;
import com.ibm.team.feed.core.model.FeedFactory;
import com.ibm.team.feed.core.model.FeedModel;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.feed.core.model.internal.ChannelImpl;
import com.ibm.team.feed.core.model.internal.FeedModelImpl;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.IDateProvider;
import com.ibm.team.foundation.rcp.core.ILinkProvider;
import com.ibm.team.foundation.rcp.core.IReadStateTracker;
import com.ibm.team.foundation.rcp.core.internal.EMFStorageHelper;
import com.ibm.team.foundation.rcp.core.notification.Notification;
import com.ibm.team.foundation.rcp.core.notification.NotificationInfo;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedManager {
    private static FeedModel fgModel;
    private static final String MODEL_TMP = "data.tmp";
    private static final String MODEL_BACKUP = "data.backup";
    private static final String EXTENSION_POINT_ID_NEWSLISTENER = "com.ibm.team.feed.core.newsListener";
    private static final String EXTENSION_POINT_ID_FEEDCONFIGURER = "com.ibm.team.feed.core.feedManagerConfigurer";
    private static final String SINGLE_NEWS_NOTIFICATION_ID = "com.ibm.team.feed.core.IncomingNews";
    private static final String MULTI_NEWS_NOTIFICATION_ID = "com.ibm.team.feed.core.IncomingMultiNews";
    private static final long DEFERRED_STORE_DELAY = 60000L;
    private static final int NEWS_DELETE = 0;
    private static final int NEWS_ADD = 1;
    private static final int NEWS_CHANGED = 2;
    private static boolean fgSuccessfullLoad;
    private final List<IChannelListener> fChannelListeners = new ArrayList<IChannelListener>();
    private final Set<INewsManagerListener> fNewsManagerListener = new HashSet<INewsManagerListener>();
    private final Channels fChannels;
    private final Map<String, TempChannelEntry> fTempChannels = new HashMap<String, TempChannelEntry>();
    private final Set<Long> fTempChannelIds = new HashSet<Long>();
    private final LoadManager fLoadManager;
    private final Hashtable<String, Collection<INewsListener>> fChannelNewsListeners = new Hashtable();
    private final ArrayList<INewsListener> fAllNewsListeners = new ArrayList();
    private final ArrayList<INewsListener> fContributedListeners = new ArrayList();
    private final Map<String, Channel> fPredefinedChannels = new HashMap<String, Channel>();
    private final Object fgPredefinedChannelsLock = new Object();
    private final Object fDeferredStoreMutex = new Object();
    private final Object fModelMutex = new Object();
    private boolean fIsScheduled = false;
    private boolean fConfigurersLoaded = false;
    private final Job fDeferredStoreJob = new FoundationJob(Messages.FeedManager_DEFERRED_STORING){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus runProtected(IProgressMonitor monitor) {
            block15: {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    try {
                        FeedManager.this.store();
                    }
                    catch (IOException e) {
                        FeedCorePlugin.getDefault().log("Error saving Favorites", e);
                        Object object = FeedManager.this.fDeferredStoreMutex;
                        synchronized (object) {
                            FeedManager.this.fIsScheduled = false;
                            break block15;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object object = FeedManager.this.fDeferredStoreMutex;
                    synchronized (object) {
                        FeedManager.this.fIsScheduled = false;
                    }
                    throw throwable;
                }
                Object object = FeedManager.this.fDeferredStoreMutex;
                synchronized (object) {
                    FeedManager.this.fIsScheduled = false;
                }
            }
            return Status.OK_STATUS;
        }
    };
    private final EventDispatcher fNewsEventDispatcher = new EventDispatcher("News Event Dispatcher");
    private final EventDispatcher fNewsManagerEventDispatcher = new EventDispatcher("NewsManager Event Dispatcher");
    private final EventDispatcher fChannelEventDispatcher = new EventDispatcher("Channel Event Dispatcher");
    private boolean fIsDisposed = false;
    private IListener fLoginListener;
    private ITeamRepositoryService.IRepositoryServiceListener fRepositoryListener;

    static {
        fgSuccessfullLoad = false;
    }

    public static FeedManager getDefault() {
        return Holder.INSTANCE;
    }

    public static boolean isNewsManagerInitialized() {
        return true;
    }

    public static void shutdown() {
        Holder.INSTANCE.dispose();
    }

    public static void clear() {
        Holder.INSTANCE.wipe();
    }

    private static FeedModel getModel() {
        if (fgModel == null) {
            URI backupURI;
            URI modelURI = EMFStorageHelper.getModelURI((String)"com.ibm.team.feed.core");
            EObject root = EMFStorageHelper.loadModel((URI)modelURI, (URI)(backupURI = EMFStorageHelper.getModelURI((String)"com.ibm.team.feed.core", (String)MODEL_BACKUP)));
            if (root instanceof FeedModel) {
                fgModel = (FeedModel)root;
                fgSuccessfullLoad = true;
            } else {
                fgModel = FeedFactory.eINSTANCE.createFeedModel();
            }
            FeedManager.initialize(FeedFactory.eINSTANCE, fgModel);
        }
        return fgModel;
    }

    private static void initialize(FeedFactory factory, FeedModel model) {
        if (model.getChannels() == null) {
            model.setChannels(factory.createChannels());
        }
    }

    private FeedManager(Channels channels) {
        if (fgSuccessfullLoad && fgModel != null) {
            this.backupModel();
        }
        this.fChannels = channels;
        this.fLoadManager = new LoadManager(this);
        this.fDeferredStoreJob.setSystem(true);
        this.hookFactories();
        this.syncConditionalGet();
        this.initUnreadCounts();
        this.onStartup();
        this.registerContributions();
        this.registerListeners();
    }

    private void backupModel() {
        Resource resource = ((FeedModelImpl)fgModel).eResource();
        if (resource != null && resource.getURI() != null) {
            File resourceFile = new File(resource.getURI().toFileString());
            File tmpBackupFile = new File(EMFStorageHelper.getModelURI((String)"com.ibm.team.feed.core", (String)MODEL_TMP).toFileString());
            tmpBackupFile.deleteOnExit();
            File backupFile = new File(EMFStorageHelper.getModelURI((String)"com.ibm.team.feed.core", (String)MODEL_BACKUP).toFileString());
            FileInputStream inS = null;
            FileOutputStream outS = null;
            try {
                inS = new FileInputStream(resourceFile);
                outS = new FileOutputStream(tmpBackupFile);
                FeedManager.copyBytes(inS, outS);
                FeedManager.close(inS, outS);
                FeedManager.replace(tmpBackupFile, backupFile);
            }
            catch (FileNotFoundException e) {
                FeedCorePlugin.getDefault().log(e);
                FeedManager.close(inS, outS);
            }
            catch (IOException e) {
                FeedCorePlugin.getDefault().log(e);
                FeedManager.close(inS, outS);
            }
        }
    }

    private static void close(InputStream inS, OutputStream outS) {
        if (inS != null) {
            try {
                inS.close();
            }
            catch (IOException e1) {
                FeedCorePlugin.getDefault().log(e1);
            }
        }
        if (outS != null) {
            try {
                outS.close();
            }
            catch (IOException e1) {
                FeedCorePlugin.getDefault().log(e1);
            }
        }
    }

    private static void copyBytes(InputStream is, OutputStream os) throws IOException {
        byte[] temp = new byte[1024];
        int bytesRead = is.read(temp);
        while (bytesRead > 0) {
            os.write(temp, 0, bytesRead);
            bytesRead = is.read(temp);
        }
    }

    private void registerListeners() {
        ITeamRepository[] repositories;
        this.fLoginListener = new IListener(){

            public void handleEvents(List events) {
                FeedManager.this.internalHandleEvents(events);
            }
        };
        this.fRepositoryListener = new ITeamRepositoryService.IRepositoryServiceListener(){

            public void addedRepository(ITeamRepository repository) {
                repository.addGenericListener((Object)"state", FeedManager.this.fLoginListener);
            }

            public void removedRepository(ITeamRepository repository) {
                repository.removeGenericListener((Object)"state", FeedManager.this.fLoginListener);
            }
        };
        TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener(this.fRepositoryListener);
        ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            repository.addGenericListener((Object)"state", this.fLoginListener);
            ++n2;
        }
    }

    private void unregisterListeners() {
        ITeamRepository[] repositories;
        TeamPlatform.getTeamRepositoryService().removeRepositoryServiceListener(this.fRepositoryListener);
        ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            repository.removeGenericListener((Object)"state", this.fLoginListener);
            ++n2;
        }
    }

    public void internalHandleEvents(List events) {
        if (!this.fIsDisposed) {
            for (Object event : events) {
                IEventSource source;
                PropertyChangeEvent extended;
                Object property;
                if (!(event instanceof PropertyChangeEvent) || !"state".equals(property = (extended = (PropertyChangeEvent)event).getProperty()) || !((source = extended.getEventSource()) instanceof ITeamRepository)) continue;
                ITeamRepository repository = (ITeamRepository)source;
                int state = repository.getState();
                switch (state) {
                    case 1: {
                        this.onLogin(repository);
                    }
                }
            }
        }
    }

    private void initUnreadCounts() {
        Channel[] channelArray = this.getChannels();
        int n = channelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Channel channel = channelArray[n2];
            int unreadNews = this.countUnreadItems(Arrays.asList(channel.getItems()));
            this.getChannelImplementation(channel).increaseUnreadCount(unreadNews);
            ++n2;
        }
    }

    private void registerContributions() {
        IExtensionPoint extensionPoint;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null && (extensionPoint = registry.getExtensionPoint(EXTENSION_POINT_ID_NEWSLISTENER)) != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement newsListener = elements[j];
                    try {
                        Object object = newsListener.createExecutableExtension("class");
                        if (object instanceof INewsListener) {
                            INewsListener listener = (INewsListener)object;
                            this.fContributedListeners.add(listener);
                            this.addNewsListener(listener);
                        }
                    }
                    catch (CoreException e) {
                        FeedCorePlugin.getDefault().log(Messages.FeedManager_ERROR_LOADING_CONTRIBUTIONS, e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void loadFeedConfigurers() {
        if (this.fConfigurersLoaded) {
            return;
        }
        this.fConfigurersLoaded = true;
        Job job = new Job(Messages.FeedManager_LOAD_FEED_CONFIGURERS){

            protected IStatus run(IProgressMonitor monitor) {
                IExtensionPoint extensionPoint;
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                if (registry != null && (extensionPoint = registry.getExtensionPoint(FeedManager.EXTENSION_POINT_ID_FEEDCONFIGURER)) != null) {
                    IExtension[] extensions;
                    IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement[] elements;
                        IExtension extension = iExtensionArray[n2];
                        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                        int n3 = elements.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement element = iConfigurationElementArray[n4];
                            try {
                                IFeedManagerConfigurer provider = (IFeedManagerConfigurer)element.createExecutableExtension("class");
                                provider.configure(FeedManager.this);
                            }
                            catch (CoreException e) {
                                FeedCorePlugin.getDefault().log(e.getMessage(), e);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChannel(Channel channel) {
        Object object = this.fModelMutex;
        synchronized (object) {
            this.internalAddChannel(channel);
        }
        this.fireNewsManagerEvent(new ChannelEvent(channel), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TempChannel addTempChannel(URL url, String title) {
        TempChannel temp;
        Object object = this.fModelMutex;
        synchronized (object) {
            String urlString = url.toString();
            TempChannelEntry entry = this.fTempChannels.get(urlString);
            if (entry == null) {
                Channel channel = this.getChannel(urlString);
                if (channel == null) {
                    channel = FeedFactory.eINSTANCE.createChannel();
                    channel.setUrl(urlString);
                    channel.setTitle(title);
                    channel.setUpdateInterval(3);
                }
                entry = new TempChannelEntry();
                entry.channel = channel;
                this.fTempChannels.put(urlString, entry);
            }
            long id = System.currentTimeMillis();
            while (!this.fTempChannelIds.add(id)) {
                id = System.currentTimeMillis();
            }
            temp = new TempChannel(entry.channel, id);
            ++entry.refcount;
        }
        temp.setExplicitRefresh(true);
        this.loadNews(temp);
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTempChannel(TempChannel tempChannel) {
        Object object = this.fModelMutex;
        synchronized (object) {
            String urlString = tempChannel.getUrl();
            TempChannelEntry entry = this.fTempChannels.get(urlString);
            if (entry != null) {
                boolean contained = this.fTempChannelIds.remove(tempChannel.getId());
                if (!contained) {
                    return;
                }
                Assert.isLegal((entry.refcount > 0 ? 1 : 0) != 0);
                --entry.refcount;
                if (entry.refcount == 0) {
                    this.fTempChannels.remove(urlString);
                    Channel existingChannel = this.getChannel(urlString);
                    if (existingChannel == null) {
                        this.fLoadManager.cancelChannel(entry.channel);
                        this.fChannelNewsListeners.remove(urlString);
                        ConnectionManager.uncacheConditionalGet(urlString);
                    }
                }
            }
        }
    }

    private void internalAddChannel(Channel channel) {
        Assert.isNotNull((Object)channel);
        if (this.getChannel(channel.getUrl()) == null) {
            this.fChannels.getInternalContents().add(channel);
        }
    }

    public void addChannelListener(IChannelListener listener) {
        if (!this.fChannelListeners.contains(listener)) {
            this.fChannelListeners.add(listener);
        }
    }

    public void addNewsManagerListener(INewsManagerListener listener) {
        this.fNewsManagerListener.add(listener);
    }

    public void addNews(Channel channel, NewsItem[] itemsInFeed) {
        this.addNews(channel, itemsInFeed, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNews(Channel channel, NewsItem[] itemsInFeed, boolean userInitiated) {
        if (itemsInFeed == null || itemsInFeed.length == 0) {
            return;
        }
        Object object = this.fModelMutex;
        synchronized (object) {
            NewsItem[] allItems;
            ArrayList<NewsItem> automaticallyDeletedItems = new ArrayList<NewsItem>();
            ArrayList<NewsItem> itemsToRemoveFromChannel = new ArrayList<NewsItem>();
            NewsItem[] newsItemArray = allItems = channel.getAllItems();
            int n = allItems.length;
            int n2 = 0;
            while (n2 < n) {
                NewsItem item = newsItemArray[n2];
                if (item.isDeleted()) {
                    itemsToRemoveFromChannel.add(item);
                }
                ++n2;
            }
            NewsItem[] items = channel.getItems();
            int itemlimit = channel.getItemLimit();
            long agelimit = channel.getAgeLimit();
            if (itemlimit != -1 || agelimit != -1L) {
                Arrays.sort(items, new Comparator<NewsItem>(){

                    @Override
                    public int compare(NewsItem n1, NewsItem n2) {
                        return n1.getPublishDate().compareTo(n2.getPublishDate());
                    }
                });
                if (itemlimit != -1 && items.length > itemlimit) {
                    int i = 0;
                    while (i < items.length - itemlimit && i < items.length) {
                        if (!items[i].isDeleted()) {
                            items[i].setDeleted(true);
                            itemsToRemoveFromChannel.add(items[i]);
                            automaticallyDeletedItems.add(items[i]);
                        }
                        ++i;
                    }
                }
                if (agelimit != -1L) {
                    Date oldest = new Date(System.currentTimeMillis() - agelimit);
                    int i = 0;
                    while (i < items.length) {
                        if (items[i].isDeleted() || !items[i].getPublishDate().before(oldest)) break;
                        items[i].setDeleted(true);
                        itemsToRemoveFromChannel.add(items[i]);
                        automaticallyDeletedItems.add(items[i]);
                        ++i;
                    }
                }
            }
            ArrayList<NewsItem> itemsAddedToChannel = new ArrayList<NewsItem>();
            NewsItem[] newsItemArray2 = itemsInFeed;
            int n3 = itemsInFeed.length;
            int n4 = 0;
            while (n4 < n3) {
                NewsItem itemInFeed = newsItemArray2[n4];
                boolean itemExists = channel.contains(itemInFeed);
                if (!itemExists) {
                    channel.addNewsItem(itemInFeed);
                    itemsAddedToChannel.add(itemInFeed);
                } else {
                    itemsToRemoveFromChannel.remove(itemInFeed);
                    NewsItem existingItem = null;
                    int i = 0;
                    while (i < items.length) {
                        NewsItem item = items[i];
                        if (item.equals(itemInFeed) && !item.isDeleted()) {
                            existingItem = item;
                            break;
                        }
                        ++i;
                    }
                    if (existingItem != null && !existingItem.sameContent(itemInFeed)) {
                        existingItem.setDeleted(true);
                        channel.removeNewsItem(existingItem);
                        automaticallyDeletedItems.remove(existingItem);
                        itemsToRemoveFromChannel.add(existingItem);
                        channel.addNewsItem(itemInFeed);
                        itemsAddedToChannel.add(itemInFeed);
                    }
                }
                ++n4;
            }
            for (NewsItem itemToRemove : itemsToRemoveFromChannel) {
                channel.removeNewsItem(itemToRemove);
            }
            ChannelImpl implementation = this.getChannelImplementation(channel);
            implementation.setUnreadCount(this.countUnreadItems(implementation.getItems()));
            ArrayList<NewsItem> deletedOrRemovedItems = new ArrayList<NewsItem>();
            deletedOrRemovedItems.addAll(itemsToRemoveFromChannel);
            for (NewsItem newsItem : automaticallyDeletedItems) {
                if (deletedOrRemovedItems.contains(newsItem)) continue;
                deletedOrRemovedItems.add(newsItem);
            }
            if (itemsAddedToChannel.size() > 0) {
                NewsEvent newsEvent = new NewsEvent(channel);
                newsEvent.setUserInitiated(userInitiated);
                newsEvent.setAddedNews(itemsAddedToChannel.toArray(new NewsItem[itemsAddedToChannel.size()]));
                newsEvent.setRemovedNews(deletedOrRemovedItems.toArray(new NewsItem[deletedOrRemovedItems.size()]));
                this.fireNewsAddedEvent(newsEvent);
            }
            if (deletedOrRemovedItems.size() > 0) {
                NewsEvent newsEvent = new NewsEvent(channel);
                newsEvent.setRemovedNews(deletedOrRemovedItems.toArray(new NewsItem[deletedOrRemovedItems.size()]));
                this.fireNewsRemovedEvent(newsEvent);
            }
        }
    }

    private ChannelImpl getChannelImplementation(Channel channel) {
        ChannelImpl implementation;
        if (channel instanceof TempChannel) {
            TempChannel temp = (TempChannel)channel;
            implementation = (ChannelImpl)temp.getChannel();
        } else {
            implementation = (ChannelImpl)channel;
        }
        return implementation;
    }

    public void addNewsListener(Channel channel, INewsListener listener) {
        Collection<INewsListener> newsListeners = this.fChannelNewsListeners.get(channel.getUrl());
        if (newsListeners == null) {
            newsListeners = new ArrayList<INewsListener>();
            this.fChannelNewsListeners.put(channel.getUrl(), newsListeners);
        }
        if (!newsListeners.contains(listener)) {
            newsListeners.add(listener);
        }
    }

    public void addNewsListener(INewsListener listener) {
        if (!this.fAllNewsListeners.contains(listener)) {
            this.fAllNewsListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editChannel(Channel oldChannel, Channel newChannel) {
        Object object = this.fModelMutex;
        synchronized (object) {
            newChannel.setPreviousURL(oldChannel.getUrl());
            this.internalRemoveChannel(oldChannel);
            this.internalAddChannel(newChannel);
        }
        this.fireNewsManagerEvent(new ChannelEvent(oldChannel), false);
        this.fireNewsManagerEvent(new ChannelEvent(newChannel), true);
    }

    private void fireNewsAddedEvent(NewsEvent event) {
        this.fireNewsChangeEvent(event, 1);
        this.sendNotification(event);
    }

    private void sendNotification(NewsEvent event) {
        final NewsItem[] items = event.getAddedNews();
        final ArrayList itemsTriggeredByUser = new ArrayList();
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                itemsTriggeredByUser.addAll(FeedManager.this.getItemsTriggeredByUser(items));
            }

            public void handleException(Throwable exception) {
                FeedCorePlugin.getDefault().log(exception);
            }
        });
        int i = 0;
        while (i < items.length) {
            NewsItem item = items[i];
            NotificationInfo n = new NotificationInfo(){

                public boolean isSameTo(NotificationInfo other) {
                    Object detail = other.getDetail();
                    if (detail == null || !(detail instanceof NewsItem)) {
                        return false;
                    }
                    if (this.getTitle() == null ? other.getTitle() != null : !this.getTitle().equals(other.getTitle())) {
                        return false;
                    }
                    if (this.getMessage() == null ? other.getMessage() != null : !this.getMessage().equals(other.getMessage())) {
                        return false;
                    }
                    return !(this.getCategory() == null ? other.getCategory() != null : !this.getCategory().equals(other.getCategory()));
                }
            };
            String message = null;
            String title = XMLString.createFromXMLText((String)item.getTitle()).getPlainText();
            int newLineIndex = title.indexOf(10);
            if (newLineIndex > 0 && newLineIndex < title.length() - 1) {
                message = title.substring(newLineIndex + 1);
                title = title.substring(0, newLineIndex);
            }
            n.setTitle(title);
            n.setMessage(message);
            n.setDetail((Object)item);
            n.setCategory(item.getCategory() != null ? item.getCategory() : "Unknown");
            String severity = item.getCustomAttribute("http://www.ibm.com/team/Feed", "severity");
            if ("blocker".equalsIgnoreCase(severity) || "critical".equalsIgnoreCase(severity)) {
                n.setPriority(5);
            } else if ("major".equalsIgnoreCase(severity)) {
                n.setPriority(4);
            } else if ("normal".equalsIgnoreCase(severity)) {
                n.setPriority(3);
            } else if ("minor".equalsIgnoreCase(severity)) {
                n.setPriority(2);
            }
            n.setTriggeredByUser(itemsTriggeredByUser.contains(item));
            Notification.send((String)SINGLE_NEWS_NOTIFICATION_ID, (NotificationInfo)n);
            ++i;
        }
        NotificationInfo n = new NotificationInfo();
        n.setDetail((Object)event);
        int maxPriority = 1;
        int i2 = 0;
        while (i2 < items.length) {
            NewsItem item = items[i2];
            String severity = item.getCustomAttribute("http://www.ibm.com/team/Feed", "severity");
            if ("blocker".equalsIgnoreCase(severity) || "critical".equalsIgnoreCase(severity)) {
                maxPriority = 5;
                break;
            }
            if ("major".equalsIgnoreCase(severity) && maxPriority < 4) {
                maxPriority = 4;
            } else if ("normal".equalsIgnoreCase(severity) && maxPriority < 3) {
                maxPriority = 3;
            } else if ("minor".equalsIgnoreCase(severity) && maxPriority < 2) {
                maxPriority = 2;
            }
            ++i2;
        }
        n.setPriority(maxPriority);
        Channel channel = items[0].getChannel();
        n.setMessage(NLS.bind((String)Messages.FeedManager_HAS_NEW_NEWS, (Object)channel.getTitle(), (Object[])new Object[]{items.length}));
        n.setDetail((Object)items);
        HashSet<String> categories = new HashSet<String>();
        int i3 = 0;
        while (i3 < items.length) {
            NewsItem item = items[i3];
            if (item.getCategory() != null) {
                categories.add(item.getCategory());
            }
            ++i3;
        }
        if (categories.size() == 1) {
            n.setCategory((String)categories.iterator().next());
        } else {
            n.setCategory("Unknown");
        }
        n.setTriggeredByUser(itemsTriggeredByUser.size() == items.length);
        Notification.send((String)MULTI_NEWS_NOTIFICATION_ID, (NotificationInfo)n);
    }

    private List<NewsItem> getItemsTriggeredByUser(NewsItem[] items) {
        ArrayList<NewsItem> itemsTriggeredByUser = new ArrayList<NewsItem>();
        ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        NewsItem[] newsItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            NewsItem item = newsItemArray[n2];
            String modifierId = item.getCustomAttribute("http://www.ibm.com/team/Feed", "modifier");
            if (modifierId != null && modifierId.length() != 0) {
                ITeamRepository[] iTeamRepositoryArray = repositories;
                int n3 = repositories.length;
                int n4 = 0;
                while (n4 < n3) {
                    IContributor contributor;
                    ITeamRepository repository = iTeamRepositoryArray[n4];
                    if (repository.loggedIn() && (contributor = repository.loggedInContributor()) != null && contributor.getItemId().getUuidValue().equals(modifierId)) {
                        itemsTriggeredByUser.add(item);
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return itemsTriggeredByUser;
    }

    private void fireNewsRemovedEvent(NewsEvent event) {
        this.fireNewsChangeEvent(event, 0);
    }

    private void fireNewsStateChangedEvent(NewsEvent event) {
        this.fireNewsChangeEvent(event, 2);
    }

    private void fireNewsChangeEvent(final NewsEvent event, final int operation) {
        this.deferredStore();
        ArrayList<INewsListener> newsListeners = new ArrayList<INewsListener>();
        final Collection<INewsListener> channelNewsListener = this.fChannelNewsListeners.get(event.getChannel().getUrl());
        if (channelNewsListener != null) {
            newsListeners.addAll(channelNewsListener);
        }
        newsListeners.addAll(this.fAllNewsListeners);
        final INewsListener[] listeners = newsListeners.toArray(new INewsListener[newsListeners.size()]);
        int i = 0;
        while (i < listeners.length) {
            final int idx = i++;
            this.fNewsEventDispatcher.add(new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    boolean removed = false;
                    if (channelNewsListener != null) {
                        removed = channelNewsListener.remove(listeners[idx]);
                    }
                    if (!removed) {
                        removed = FeedManager.this.fAllNewsListeners.remove(listeners[idx]);
                    }
                    if (removed) {
                        FeedCorePlugin.getDefault().log("Newslistener threw an exception and was disabled: " + listeners[idx].getClass().getName(), exception);
                    }
                }

                public void run() throws Exception {
                    switch (operation) {
                        case 2: {
                            listeners[idx].newsStateChanged(event);
                            break;
                        }
                        case 1: {
                            listeners[idx].newsReceived(event);
                            break;
                        }
                        case 0: {
                            listeners[idx].newsRemoved(event);
                        }
                    }
                }
            });
        }
    }

    private void fireNewsManagerEvent(final ChannelEvent event, final boolean isAddition) {
        this.deferredStore();
        final INewsManagerListener[] listeners = this.fNewsManagerListener.toArray(new INewsManagerListener[this.fNewsManagerListener.size()]);
        int i = 0;
        while (i < listeners.length) {
            final int idx = i++;
            this.fNewsManagerEventDispatcher.add(new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    FeedManager.this.removeNewsManagerListener(listeners[idx]);
                    FeedCorePlugin.getDefault().log("Exception in a INewsManagerListener. It was disabled. wasChannelAdded: " + isAddition, exception);
                }

                public void run() throws Exception {
                    if (isAddition) {
                        listeners[idx].channelAdded(event);
                    } else {
                        listeners[idx].channelRemoved(event);
                    }
                }
            });
        }
    }

    public void fireChannelStatusChangedEvent(final ChannelEvent event) {
        this.deferredStore();
        final IChannelListener[] listeners = this.fChannelListeners.toArray(new IChannelListener[this.fChannelListeners.size()]);
        int i = 0;
        while (i < listeners.length) {
            final int idx = i++;
            this.fChannelEventDispatcher.add(new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    FeedManager.this.fChannelListeners.remove(listeners[idx]);
                    FeedCorePlugin.getDefault().log("The ChannelListener threw an exception and was disabled: " + listeners[idx], exception);
                }

                public void run() throws Exception {
                    listeners[idx].channelStatusChanged(event);
                }
            });
        }
    }

    public void fireChannelEditedEvent(final ChannelEvent event) {
        this.deferredStore();
        final IChannelListener[] listeners = this.fChannelListeners.toArray(new IChannelListener[this.fChannelListeners.size()]);
        int i = 0;
        while (i < listeners.length) {
            final int idx = i++;
            this.fChannelEventDispatcher.add(new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    FeedManager.this.fChannelListeners.remove(listeners[idx]);
                    FeedCorePlugin.getDefault().log("The ChannelListener threw an exception and was disabled: " + listeners[idx], exception);
                }

                public void run() throws Exception {
                    listeners[idx].channelEdited(event);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannel(String url) {
        Channel ret = null;
        ArrayList<Channel> toremove = new ArrayList<Channel>();
        Object object = this.fModelMutex;
        synchronized (object) {
            List channels = this.fChannels.getInternalContents();
            int i = channels.size() - 1;
            while (i >= 0) {
                Channel channel = (Channel)channels.get(i);
                if (channel == null) {
                    FeedCorePlugin.getDefault().log("Channels contained empty entry. Removing", null);
                    channels.remove(i);
                } else if (channel.getUrl() == null) {
                    toremove.add(channel);
                } else if (channel.getUrl().equals(url)) {
                    ret = channel;
                }
                --i;
            }
        }
        if (toremove.size() > 0) {
            FeedCorePlugin.getDefault().log("Channel with no URL found. Removing", null);
            for (Channel channel : toremove) {
                this.removeChannel(channel);
                FeedCorePlugin.getDefault().log("Removed channel: " + channel.getTitle(), null);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel[] getChannels() {
        Object object = this.fModelMutex;
        synchronized (object) {
            return this.fChannels.getInternalContents().toArray(new Channel[this.fChannels.getInternalContents().size()]);
        }
    }

    public int countUnreadNews(Collection<String> selectedChannelUrls, boolean groupByLink) {
        ArrayList<NewsItem> allItems = new ArrayList<NewsItem>();
        for (String string : selectedChannelUrls) {
            Channel channel = this.getChannel(string);
            if (channel == null || channel.getUnreadCount() <= 0) continue;
            allItems.addAll(Arrays.asList(channel.getItems()));
        }
        return this.countUnreadItems(allItems);
    }

    private int countUnreadItems(List<NewsItem> items) {
        int channelUnreadCount = 0;
        HashSet<String> links = new HashSet<String>();
        for (NewsItem item : items) {
            String link;
            if (item.isIsRead() || item.isDeleted() || (link = item.getLink()) != null && links.contains(link)) continue;
            ++channelUnreadCount;
            if (link == null) continue;
            links.add(link);
        }
        return channelUnreadCount;
    }

    private int countUnreadItems(NewsItem[] items) {
        int channelUnreadCount = 0;
        HashSet<String> links = new HashSet<String>();
        NewsItem[] newsItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String link;
            NewsItem item = newsItemArray[n2];
            if (!(item.isIsRead() || item.isDeleted() || (link = item.getLink()) != null && links.contains(link))) {
                ++channelUnreadCount;
                if (link != null) {
                    links.add(link);
                }
            }
            ++n2;
        }
        return channelUnreadCount;
    }

    private void hookFactories() {
        IAdapterFactory factory = new IAdapterFactory(){
            private Class[] fAdapterList = new Class[]{ILinkProvider.class, IDateProvider.class, IReadStateTracker.class};

            public Object getAdapter(Object adaptableObject, Class adapterType) {
                if (IDateProvider.class.equals((Object)adapterType) && adaptableObject instanceof NewsItem) {
                    final NewsItem handle = (NewsItem)adaptableObject;
                    return new IDateProvider(){

                        public Date getDate() {
                            return handle.getPublishDate();
                        }
                    };
                }
                if (ILinkProvider.class.equals((Object)adapterType) && adaptableObject instanceof NewsItem) {
                    final NewsItem handle = (NewsItem)adaptableObject;
                    return new ILinkProvider(){

                        public String getLink() {
                            return handle.getLink();
                        }
                    };
                }
                if (IReadStateTracker.class.equals((Object)adapterType) && adaptableObject instanceof NewsItem) {
                    final NewsItem handle = (NewsItem)adaptableObject;
                    return new IReadStateTracker(){

                        public boolean isMarkedRead() {
                            return handle.isIsRead();
                        }

                        public void markRead() {
                            FeedManager.this.setRead(handle, true);
                        }

                        public void markUnread() {
                            FeedManager.this.setRead(handle, false);
                        }
                    };
                }
                return null;
            }

            public Class[] getAdapterList() {
                return this.fAdapterList;
            }
        };
        IAdapterManager manager = Platform.getAdapterManager();
        manager.registerAdapters(factory, NewsItem.class);
    }

    public void loadNews() {
        this.loadNews(false);
    }

    public void loadNews(boolean fromUserAction) {
        Channel[] channels = this.getChannels();
        int i = 0;
        while (i < channels.length) {
            if (fromUserAction) {
                channels[i].setExplicitRefresh(true);
            }
            this.loadNews(channels[i]);
            ++i;
        }
    }

    private void onStartup() {
        Channel[] channels;
        Channel[] channelArray = channels = this.getChannels();
        int n = channels.length;
        int n2 = 0;
        while (n2 < n) {
            Channel channel = channelArray[n2];
            if (channel.isForceDownload() && !"com.ibm.team.feed.core.SystemFeed".equals(channel.getCategory())) {
                this.loadNews(channel);
            }
            ++n2;
        }
    }

    private void onLogin(ITeamRepository repository) {
        Channel[] channels;
        Channel[] channelArray = channels = this.getChannels();
        int n = channels.length;
        int n2 = 0;
        while (n2 < n) {
            Channel channel = channelArray[n2];
            if (channel.isForceDownload() && this.belongsToRepository(channel.getUrl(), repository)) {
                this.loadNews(channel);
            }
            ++n2;
        }
    }

    private boolean belongsToRepository(String url, ITeamRepository repository) {
        if (url.contains(repository.getRepositoryURI())) {
            return true;
        }
        if (repository.publicUriRoot() != null && url.contains(repository.publicUriRoot())) {
            return true;
        }
        Collection aliasRepositoryURIs = repository.getAliasRepositoryURIs();
        for (Object obj : aliasRepositoryURIs) {
            String aliasUri = (String)obj;
            if (!url.contains(aliasUri)) continue;
            return true;
        }
        return false;
    }

    public void loadNews(Channel channel) {
        this.fLoadManager.loadChannel(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNewsItems(NewsItem[] items) {
        Object object = this.fModelMutex;
        synchronized (object) {
            ArrayList<NewsItem> list;
            HashMap<Channel, ArrayList<NewsItem>> channelToItems = new HashMap<Channel, ArrayList<NewsItem>>();
            int i = 0;
            while (i < items.length) {
                NewsItem item = items[i];
                Channel channel = item.getChannel();
                list = (ArrayList<NewsItem>)channelToItems.get(channel);
                if (list == null) {
                    list = new ArrayList<NewsItem>();
                }
                list.add(item);
                channelToItems.put(channel, list);
                ++i;
            }
            for (Channel channel : channelToItems.keySet()) {
                NewsEvent newsEvent = new NewsEvent(channel);
                list = (List)channelToItems.get(channel);
                int unreadItems = this.countUnreadItems(list);
                this.getChannelImplementation(channel).increaseUnreadCount(-1 * unreadItems);
                for (NewsItem newsItem : list) {
                    newsItem.setDeleted(true);
                }
                newsEvent.setRemovedNews(list.toArray(new NewsItem[list.size()]));
                newsEvent.setUserInitiated(true);
                this.fireNewsRemovedEvent(newsEvent);
            }
        }
    }

    private void prepareStore() {
        Channel[] channels = this.getChannels();
        int i = 0;
        while (i < channels.length) {
            Channel channel = channels[i];
            String eTag = ConnectionManager.getETag(channel.getUrl());
            String lastModified = ConnectionManager.getLastModified(channel.getUrl());
            channel.setETag(eTag);
            channel.setLastModified(lastModified);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() throws IOException {
        Object object = this.fModelMutex;
        synchronized (object) {
            this.prepareStore();
            URI tmpFileUri = EMFStorageHelper.getModelURI((String)"com.ibm.team.feed.core", (String)MODEL_TMP);
            EMFStorageHelper.storeModel((URI)tmpFileUri, (EObject)((EObject)FeedManager.getModel()));
            File tmpFile = new File(tmpFileUri.toFileString());
            tmpFile.deleteOnExit();
            File existingFile = new File(EMFStorageHelper.getModelURI((String)"com.ibm.team.feed.core").toFileString());
            boolean replaced = FeedManager.replace(tmpFile, existingFile);
            if (!replaced) {
                EMFStorageHelper.storeModel((URI)EMFStorageHelper.getModelURI((String)"com.ibm.team.feed.core"), (EObject)((EObject)FeedManager.getModel()));
            }
        }
    }

    private static boolean replace(File source, File target) {
        if (!source.renameTo(target)) {
            target.delete();
            return source.renameTo(target);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deferredStore() {
        Object object = this.fDeferredStoreMutex;
        synchronized (object) {
            if (!this.fIsScheduled) {
                this.fIsScheduled = true;
                this.fDeferredStoreJob.schedule(60000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChannel(Channel channel) {
        Object object = this.fModelMutex;
        synchronized (object) {
            this.internalRemoveChannel(channel);
        }
        this.fireNewsManagerEvent(new ChannelEvent(channel), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRemoveChannel(Channel channel) {
        NewsItem[] removedNews = channel.getAllItems();
        this.fChannels.getInternalContents().remove(channel);
        ConnectionManager.uncacheConditionalGet(channel.getUrl());
        Object object = this.fgPredefinedChannelsLock;
        synchronized (object) {
            for (String constant : this.fPredefinedChannels.keySet()) {
                Channel registered = this.fPredefinedChannels.get(constant);
                if (registered == null || !registered.getUrl().equals(channel.getUrl())) continue;
                this.fPredefinedChannels.remove(constant);
                break;
            }
        }
        NewsEvent newsEvent = new NewsEvent(channel);
        newsEvent.setRemovedNews(removedNews);
        newsEvent.setUserInitiated(true);
        this.fireNewsRemovedEvent(newsEvent);
    }

    public void removeChannelListener(IChannelListener listener) {
        this.fChannelListeners.remove(listener);
    }

    public void removeNewsManagerListener(INewsManagerListener listener) {
        this.fNewsManagerListener.remove(listener);
    }

    public void removeNewsListener(Channel channel, INewsListener listener) {
        Collection<INewsListener> newsListeners = this.fChannelNewsListeners.get(channel.getUrl());
        if (newsListeners != null) {
            newsListeners.remove(listener);
        }
    }

    public void removeNewsListener(INewsListener listener) {
        this.fAllNewsListeners.remove(listener);
    }

    public void setRead(NewsItem newsItem, boolean read) {
        if (newsItem.isIsRead() != read) {
            Channel[] channelArray = this.getChannels();
            int n = channelArray.length;
            int n2 = 0;
            while (n2 < n) {
                Channel channel = channelArray[n2];
                Set<NewsItem> changedItems = this.setReadPerChannel(channel, newsItem, read);
                if (changedItems.size() > 0) {
                    NewsEvent newsEvent = new NewsEvent(channel);
                    newsEvent.setChangedNews(changedItems.toArray(new NewsItem[changedItems.size()]));
                    this.fireNewsStateChangedEvent(newsEvent);
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<NewsItem> setReadPerChannel(Channel channel, NewsItem newsItem, boolean read) {
        HashSet<NewsItem> changedItems = new HashSet<NewsItem>();
        Object object = this.fModelMutex;
        synchronized (object) {
            NewsItem[] items = channel.getItems();
            HashSet<String> bundeledLinks = new HashSet<String>();
            String link = newsItem.getLink();
            if (link != null) {
                int i = 0;
                while (i < items.length) {
                    if (items[i].isIsRead() != read && !items[i].isDeleted() && link.equals(items[i].getLink())) {
                        items[i].setIsRead(read);
                        changedItems.add(items[i]);
                        bundeledLinks.add(items[i].getLink());
                    }
                    ++i;
                }
            }
            if (changedItems.size() > 0) {
                int sign = read ? -1 : 1;
                this.getChannelImplementation(channel).increaseUnreadCount(sign * bundeledLinks.size());
            }
        }
        return changedItems;
    }

    public void setRead(NewsItem[] items, boolean read) {
        Channel[] channelArray = this.getChannels();
        int n = channelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Channel channel = channelArray[n2];
            HashSet<NewsItem> changedItems = new HashSet<NewsItem>();
            int i = 0;
            while (i < items.length) {
                NewsItem newsItem = items[i];
                changedItems.addAll(this.setReadPerChannel(channel, newsItem, read));
                ++i;
            }
            if (changedItems.size() > 0) {
                NewsEvent newsEvent = new NewsEvent(channel);
                newsEvent.setChangedNews(changedItems.toArray(new NewsItem[changedItems.size()]));
                this.fireNewsStateChangedEvent(newsEvent);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getPredefinedChannel(String constant) {
        Assert.isNotNull((Object)constant);
        Object object = this.fgPredefinedChannelsLock;
        synchronized (object) {
            return this.fPredefinedChannels.get(constant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerPredefinedChannel(Channel channel, String constant) {
        Assert.isNotNull((Object)channel);
        Assert.isNotNull((Object)constant);
        Channel knownChannel = this.getChannel(channel.getUrl());
        if (!channel.equals(knownChannel)) {
            return false;
        }
        Object object = this.fgPredefinedChannelsLock;
        synchronized (object) {
            this.fPredefinedChannels.put(constant, channel);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterPredefinedChannel(String constant) {
        Assert.isNotNull((Object)constant);
        Object object = this.fgPredefinedChannelsLock;
        synchronized (object) {
            return this.fPredefinedChannels.remove(constant) != null;
        }
    }

    private void syncConditionalGet() {
        Channel[] channels = this.getChannels();
        int i = 0;
        while (i < channels.length) {
            Channel channel = channels[i];
            String eTag = channel.getETag();
            String lastModified = channel.getLastModified();
            ConnectionManager.cacheConditionalGet(channel.getUrl(), eTag, lastModified);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wipe() {
        Channel[] channels = this.getChannels();
        int i = 0;
        while (i < channels.length) {
            this.removeChannel(channels[i]);
            ++i;
        }
        Object object = this.fModelMutex;
        synchronized (object) {
            this.fChannels.getInternalContents().clear();
        }
    }

    public void dispose() {
        if (!this.fIsDisposed) {
            this.fIsDisposed = true;
            this.unregisterListeners();
            this.fLoadManager.dispose();
            INewsListener[] listener = this.fContributedListeners.toArray(new INewsListener[this.fContributedListeners.size()]);
            int i = 0;
            while (i < listener.length) {
                this.removeNewsListener(listener[i]);
                ++i;
            }
            this.fChannelListeners.clear();
            this.fNewsManagerListener.clear();
            if (this.fIsScheduled && !this.fDeferredStoreJob.cancel()) {
                try {
                    this.fDeferredStoreJob.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                this.store();
            }
            catch (IOException e) {
                FeedCorePlugin.getDefault().log("Error while storing feeds during disposal", e);
            }
        }
    }

    static /* synthetic */ FeedModel access$3() {
        return FeedManager.getModel();
    }

    /* synthetic */ FeedManager(Channels channels, FeedManager feedManager) {
        this(channels);
    }

    private static class Holder {
        private static final FeedManager INSTANCE = new FeedManager(FeedManager.access$3().getChannels(), null);

        private Holder() {
        }
    }

    private class TempChannelEntry {
        Channel channel;
        int refcount = 0;

        private TempChannelEntry() {
        }
    }
}

