/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.core;

import com.ibm.team.feed.core.internal.FeedCorePlugin;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ClientFeedUtils {
    private static ClientFeedUtils fgInstance;
    private static final String REPOSITORY = "repository";
    private static final String USERID = "userid";
    private static final String LOGGED_IN_USERS_PREFS = "loggedInUsers";
    private final Map<String, String> fRepoToContributorId;
    private final Map<String, String> fRepoToContributorUserId;
    private final IListener fStateListener = new IListener(){

        public void handleEvents(List events) {
            HashSet<ITeamRepository> repositories = new HashSet<ITeamRepository>();
            for (IEvent event : events) {
                if (!(event.getEventSource() instanceof ITeamRepository)) continue;
                repositories.add((ITeamRepository)event.getEventSource());
            }
            ClientFeedUtils.this.update(repositories.toArray(new ITeamRepository[repositories.size()]));
        }
    };
    private final Object fgLock = new Object();
    ITeamRepositoryService.IRepositoryServiceListener fRepositoryServiceListener = new ITeamRepositoryService.IRepositoryServiceListener(){

        public void addedRepository(ITeamRepository repository) {
            repository.addGenericListener((Object)"state", ClientFeedUtils.this.fStateListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedRepository(ITeamRepository repository) {
            repository.removeGenericListener((Object)"state", ClientFeedUtils.this.fStateListener);
            Object object = ClientFeedUtils.this.fgLock;
            synchronized (object) {
                ClientFeedUtils.this.fRepoToContributorId.remove(repository.getRepositoryURI());
                ClientFeedUtils.this.fRepoToContributorUserId.remove(repository.getRepositoryURI());
            }
        }
    };

    protected ClientFeedUtils() {
        this.fRepoToContributorId = new HashMap<String, String>();
        this.fRepoToContributorUserId = new HashMap<String, String>();
        this.read();
        this.initListeners();
    }

    public static ClientFeedUtils getInstance() {
        if (fgInstance == null) {
            fgInstance = new ClientFeedUtils();
        }
        return fgInstance;
    }

    public boolean isCreator(NewsItem newsItem) {
        String contributor = this.getCurrentContributorId(newsItem);
        if (contributor == null) {
            return false;
        }
        String userStr = newsItem.getCustomAttribute("http://www.ibm.com/team/Feed", "creator");
        return userStr != null && contributor.equals(userStr);
    }

    public boolean isModifier(NewsItem newsItem) {
        String contributor = this.getCurrentContributorId(newsItem);
        if (contributor == null) {
            return false;
        }
        String userStr = newsItem.getCustomAttribute("http://www.ibm.com/team/Feed", "modifier");
        return userStr != null && contributor.equals(userStr);
    }

    public String getRelation(NewsItem newsItem) {
        String consumerCountStr;
        String contributor = this.getCurrentContributorId(newsItem);
        if (contributor == null) {
            return "unknown";
        }
        String userStr = newsItem.getCustomAttribute("http://www.ibm.com/team/Feed", "owner");
        if (userStr != null && contributor.equals(userStr)) {
            return "owner";
        }
        userStr = newsItem.getCustomAttribute("http://www.ibm.com/team/Feed", "creator");
        if (userStr != null && contributor.equals(userStr)) {
            return "creator";
        }
        userStr = newsItem.getCustomAttribute("http://www.ibm.com/team/Feed", "modifier");
        if (userStr != null && contributor.equals(userStr)) {
            return "modifier";
        }
        String subscriberCountStr = newsItem.getCustomAttribute("http://www.ibm.com/team/Feed", "subscriber_count");
        if (subscriberCountStr != null) {
            int subcriberCount = Integer.parseInt(subscriberCountStr);
            int i = 0;
            while (i < subcriberCount) {
                userStr = newsItem.getCustomAttribute("http://www.ibm.com/team/Feed", "subscriber_" + i);
                if (userStr != null && contributor.equals(userStr)) {
                    return "subscriber";
                }
                ++i;
            }
        }
        if ((consumerCountStr = newsItem.getCustomAttribute("http://www.ibm.com/team/Feed", "consumer_count")) != null) {
            int consumerCount = Integer.parseInt(consumerCountStr);
            int i = 0;
            while (i < consumerCount) {
                userStr = newsItem.getCustomAttribute("http://www.ibm.com/team/Feed", "consumer_" + i);
                if (userStr != null && contributor.equals(userStr)) {
                    return "consumer";
                }
                ++i;
            }
        }
        return "unknown";
    }

    public void dispose() {
        TeamPlatform.getTeamRepositoryService().removeRepositoryServiceListener(this.fRepositoryServiceListener);
        HashSet<ITeamRepository> repositories = new HashSet<ITeamRepository>();
        ITeamRepository[] iTeamRepositoryArray = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = iTeamRepositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repo = iTeamRepositoryArray[n2];
            this.fRepositoryServiceListener.removedRepository(repo);
            if (repo.loggedIn()) {
                repositories.add(repo);
            }
            ++n2;
        }
        this.update(repositories.toArray(new ITeamRepository[repositories.size()]));
    }

    public String getCurrentContributorId(NewsItem newsItem) {
        String repositoryURL = newsItem.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "repositoryURL");
        if (repositoryURL == null) {
            return null;
        }
        ITeamRepository teamRepository = TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryURL, 4);
        if (teamRepository == null) {
            return null;
        }
        if (teamRepository.loggedIn()) {
            return teamRepository.loggedInContributor().getItemId().getUuidValue();
        }
        return this.fRepoToContributorId.get(teamRepository.getRepositoryURI());
    }

    public String getCurrentContributorUserId(String repositoryURL) {
        ITeamRepository teamRepository = TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryURL, 4);
        if (teamRepository == null) {
            return null;
        }
        if (teamRepository.loggedIn()) {
            return teamRepository.loggedInContributor().getUserId();
        }
        return this.fRepoToContributorUserId.get(teamRepository.getRepositoryURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() {
        Object object = this.fgLock;
        synchronized (object) {
            Preferences prefs = new InstanceScope().getNode("com.ibm.team.feed.core").node(LOGGED_IN_USERS_PREFS);
            if (prefs == null) {
                return;
            }
            try {
                String[] entries;
                String[] stringArray = entries = prefs.childrenNames();
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    String userid;
                    String uuid = stringArray[n2];
                    Preferences child = prefs.node(uuid);
                    String repo = child.get(REPOSITORY, null);
                    if (uuid != null) {
                        this.fRepoToContributorId.put(repo, uuid);
                    }
                    if ((userid = child.get(USERID, null)) != null) {
                        this.fRepoToContributorUserId.put(repo, userid);
                    }
                    ++n2;
                }
            }
            catch (BackingStoreException e) {
                FeedCorePlugin.getDefault().log("Error while initializing ClientFeedUtils", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        Object object = this.fgLock;
        synchronized (object) {
            Preferences prefs = new InstanceScope().getNode("com.ibm.team.feed.core").node(LOGGED_IN_USERS_PREFS);
            if (prefs == null) {
                return;
            }
            try {
                prefs.removeNode();
                prefs = new InstanceScope().getNode("com.ibm.team.feed.core").node(LOGGED_IN_USERS_PREFS);
                for (Map.Entry<String, String> entry : this.fRepoToContributorId.entrySet()) {
                    String repo = entry.getKey();
                    String uuid = entry.getValue();
                    if (repo == null || uuid == null) continue;
                    Preferences child = prefs.node(uuid);
                    child.put(REPOSITORY, repo);
                    String userid = this.fRepoToContributorUserId.get(repo);
                    if (userid == null) continue;
                    child.put(USERID, userid);
                }
                prefs.flush();
            }
            catch (BackingStoreException e) {
                FeedCorePlugin.getDefault().log("Error saving repo to contributor association", e);
            }
        }
    }

    private void initListeners() {
        TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener(this.fRepositoryServiceListener);
        ITeamRepository[] iTeamRepositoryArray = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = iTeamRepositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            repository.addGenericListener((Object)"state", this.fStateListener);
            ++n2;
        }
        this.update(TeamPlatform.getTeamRepositoryService().getTeamRepositories());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(ITeamRepository[] repositories) {
        boolean changed = false;
        Object object = this.fgLock;
        synchronized (object) {
            ITeamRepository[] iTeamRepositoryArray = repositories;
            int n = repositories.length;
            int n2 = 0;
            while (n2 < n) {
                ITeamRepository repository = iTeamRepositoryArray[n2];
                String userId = this.fRepoToContributorId.get(repository);
                if (repository.loggedIn() && (userId == null || !userId.equals(repository.loggedInContributor().getItemId().getUuidValue()))) {
                    this.fRepoToContributorId.put(repository.getRepositoryURI(), repository.loggedInContributor().getItemId().getUuidValue());
                    this.fRepoToContributorUserId.put(repository.getRepositoryURI(), repository.loggedInContributor().getUserId());
                    changed = true;
                }
                ++n2;
            }
        }
        if (changed) {
            this.save();
        }
    }
}

