/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.TaskImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.client.workitem.WorkItemHelper;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoChangeSet;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.connector.scm.common.CcConnectorUtils;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.Auditable;
import com.ibm.team.repository.common.model.Item;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Task;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoWorkItem
extends JzRepoResource {
    private static final String UTF_8 = "UTF-8";
    private static final int JUST_UNDER_32K = 32760;

    public JzRepoWorkItem(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return TaskImpl.class;
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)InteropStream.PN_TASK_ID)) {
            return this.getTaskId(feedback);
        }
        if (propertyName.equals((Object)Resource.DISPLAY_NAME)) {
            return this.getDisplayName(feedback);
        }
        if (propertyName.equals((Object)Resource.COMMENT)) {
            return this.getComment(feedback);
        }
        if (propertyName.equals((Object)Task.ACTIVITY_LIST)) {
            return this.getActivityList(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private String getTaskId(SrvcFeedback feedback) throws WvcmException {
        return Integer.toString(this.getWorkItem(feedback).getId());
    }

    @Override
    public String getDisplayName(SrvcFeedback feedback) throws WvcmException {
        IWorkItem workItem = this.getWorkItem(feedback);
        String result = workItem.getHTMLSummary().getPlainText();
        return result;
    }

    private String getComment(SrvcFeedback feedback) throws WvcmException {
        IWorkItem workItem = this.getWorkItem(feedback);
        String result = workItem.getHTMLDescription().getPlainText();
        return result;
    }

    private IWorkItem getWorkItem(SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        ITeamRepository repo = provider.getRepo();
        IWorkItemHandle myItemHandle = (IWorkItemHandle)this.getItemHandle(feedback.nest(20));
        IAuditableClient auditableClient = (IAuditableClient)repo.getClientLibrary(IAuditableClient.class);
        try {
            IWorkItem workItem = (IWorkItem)auditableClient.fetchCurrentAuditable((IAuditableHandle)myItemHandle, IWorkItem.FULL_PROFILE, JzProvider.getMonitor(feedback, 100));
            return workItem;
        }
        catch (ItemNotFoundException notFoundException) {
            throw JzProvider.wrapException((Exception)((Object)notFoundException));
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    private static IWorkItem createWorkItem(JzProvider provider, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback fb) throws WvcmException {
        ITeamRepository repo = provider.getRepo();
        String summary = null;
        String description = null;
        if (updates != null) {
            PropValue commentValue;
            PropValue nameValue = updates.get(Resource.DISPLAY_NAME);
            if (nameValue != null) {
                summary = (String)nameValue.get_value();
                updated.add(Resource.DISPLAY_NAME);
            }
            if ((commentValue = updates.get(Resource.COMMENT)) != null) {
                description = (String)commentValue.get_value();
                updated.add(Resource.COMMENT);
            }
        }
        IWorkItemClient clientLib = (IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class);
        try {
            IBuildResult buildResult;
            IProcessArea processArea = provider.getProcessArea(fb.nest(10));
            IWorkItem templateItem = JzRepoWorkItem.lookupTemplateItem(provider, fb.nest(20));
            IWorkItemType workItemType = JzRepoWorkItem.getWorkItemType(provider, templateItem, fb.nest(30));
            IWorkItemWorkingCopyManager mgr = clientLib.getWorkItemWorkingCopyManager();
            IWorkItemHandle handle = mgr.connectNew(workItemType, JzProvider.getMonitor(fb, 44));
            WorkItemWorkingCopy wc = mgr.getWorkingCopy(handle);
            IWorkItem workItem = wc.getWorkItem();
            if (templateItem != null && !provider.templateIdHasInitialValue()) {
                JzRepoWorkItem.copyPartialWorkItem(provider, workItem, templateItem, null, fb.nest(65));
            } else {
                if (processArea instanceof ITeamArea) {
                    ITeamArea teamArea = (ITeamArea)processArea;
                    IDevelopmentLine developmentLine = clientLib.getAuditableCommon().getDevelopmentLine((ITeamAreaHandle)teamArea, JzProvider.getMonitor(fb, 55));
                    if (developmentLine != null) {
                        workItem.setTarget(developmentLine.getCurrentIteration());
                    }
                }
                JzRepoWorkItem.setCategory(provider, clientLib, workItem, fb.nest(65));
            }
            workItem.setCreator((IContributorHandle)repo.loggedInContributor());
            workItem.setOwner((IContributorHandle)repo.loggedInContributor());
            if (summary != null) {
                workItem.setHTMLSummary(XMLString.createFromPlainText((String)summary));
            }
            if (description != null) {
                XMLString xmlEncodedDescription = JzRepoWorkItem.truncateAndXmlEncode(description, 32760, fb);
                workItem.setHTMLDescription(xmlEncodedDescription);
            }
            if ((buildResult = provider.lookupBuildResult(fb)) != null) {
                try {
                    WorkItemHelper.linkIncludedWorkItem((ITeamRepository)repo, (IBuildResultHandle)buildResult, (IWorkItemHandle)workItem, (IProgressMonitor)JzProvider.getMonitor(fb, 75));
                    WorkItemHelper.setFixedInBuild((ITeamRepository)repo, (IBuildResultHandle)buildResult, (IWorkItemHandle[])new IWorkItemHandle[]{workItem});
                }
                catch (TeamRepositoryException e) {
                    fb.notifyWarning(NLS.bind((String)Messages.JzRepoWorkItem_WARN_CANT_CREATE_BUILDRESULT_WORKITEM_LINK, (Object)e.getLocalizedMessage(), (Object[])new Object[0]));
                }
            }
            return JzRepoWorkItem.saveWorkItem(JzProvider.getMonitor(fb, 100), mgr, wc, workItem);
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    private static XMLString truncateAndXmlEncode(String originalDescription, int max, SrvcFeedback fb) throws WvcmException {
        boolean truncated = false;
        String description = originalDescription;
        int truncateBy = Messages.JzRepoWorkItem_INFO_DESCRIPTION_TRUNCATED.length() + 20;
        try {
            XMLString result;
            byte[] utf8Encoded;
            while ((utf8Encoded = (result = XMLString.createFromPlainText((String)description)).toString().getBytes(UTF_8)).length > max) {
                description = NLS.bind((String)Messages.JzRepoWorkItem_INFO_DESCRIPTION_TRUNCATED, (Object)originalDescription.substring(0, originalDescription.length() - truncateBy), (Object[])new Object[0]);
                truncateBy += 20;
                truncated = true;
            }
            if (truncated) {
                fb.notifyWarning(Messages.JzRepoWorkItem_WARN_DESCRIPTION_TRUNCATED);
            }
            return result;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Could not encode workitem description via encoding: UTF-8");
        }
    }

    private static void setCategory(JzProvider provider, IWorkItemClient clientLib, IWorkItem workItem, SrvcFeedback feedback) throws TeamRepositoryException, WvcmException {
        IProcessArea teamArea = provider.getProcessArea(feedback.nest(10));
        List categories = clientLib.findCategoriesOfProcessArea((IProcessAreaHandle)teamArea, ICategory.DEFAULT_PROFILE, JzProvider.getMonitor(feedback, 30));
        ICategory unassigned = clientLib.findUnassignedCategory(teamArea.getProjectArea(), ICategory.DEFAULT_PROFILE, JzProvider.getMonitor(feedback, 60));
        ICategory category = null;
        for (ICategory c : categories) {
            if (ItemUtil.equivItemRef((IItemHandle)unassigned, (IItemHandle)c)) continue;
            category = c;
            break;
        }
        if (category != null) {
            if (provider.isDebugLogEnabled()) {
                ICategory cat = (ICategory)JzRepoWorkItem.itemManager(provider).fetchPartialItem((IItemHandle)category, 0, Collections.singletonList(ICategory.NAME_PROPERTY), JzProvider.getMonitor(feedback, 100));
                provider.logDebug("assigning category: " + cat.getName());
            }
            workItem.setCategory(category);
        }
    }

    private static IWorkItemType getWorkItemType(JzProvider provider, IWorkItem templateItem, SrvcFeedback feedback) throws TeamRepositoryException, WvcmException {
        String itemName = templateItem != null ? templateItem.getWorkItemType() : "task";
        IWorkItemClient workItemClient = (IWorkItemClient)provider.getRepo().getClientLibrary(IWorkItemClient.class);
        IWorkItemType result = workItemClient.findWorkItemType(provider.getProcessArea(feedback.nest(50)).getProjectArea(), itemName, JzProvider.getMonitor(feedback, 100));
        if (result == null) {
            throw new WvcmException("Internal error.  Could not find task workitem type", WvcmException.ReasonCode.FORBIDDEN);
        }
        return result;
    }

    private static IWorkItem lookupTemplateItem(JzProvider provider, SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkItem proxy;
        IWorkItem result = null;
        String templateId = provider.getTemplateId();
        if (templateId != null && !provider.templateIdHasInitialValue() && (proxy = JzRepoWorkItem.lookupById(provider, templateId, feedback.nest(50))) != null) {
            result = proxy.getWorkItem(feedback);
        }
        return result;
    }

    private static IWorkItem saveWorkItem(IProgressMonitor monitor, IWorkItemWorkingCopyManager mgr, WorkItemWorkingCopy wc, IWorkItem workItem) throws WvcmException {
        IDetailedStatus detailedStatus = wc.save(monitor);
        mgr.disconnect((IWorkItemHandle)workItem);
        int severity = detailedStatus.getSeverity();
        if (severity >= 2) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoWorkItem_ERROR_SAVE_ITEM_FAILED_WITH_DETAILS, (Object)detailedStatus.getMessage(), (Object[])new Object[0]), null, WvcmException.ReasonCode.FORBIDDEN, detailedStatus.getException());
        }
        return workItem;
    }

    public static SrvcResource doCreateGeneratedResource(JzProvider provider, JzLocation loc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        IWorkItem wi = JzRepoWorkItem.createWorkItem(provider, updates, updated, feedback);
        JzRepoWorkItem result = JzRepoWorkItem.create(provider, (IWorkItemHandle)wi);
        provider.logCreation("WorkItem", result.location());
        return result;
    }

    public static JzRepoWorkItem create(JzProvider provider, IWorkItemHandle wiHandle) {
        JzRepoWorkItem result = new JzRepoWorkItem(provider, (Location)JzLocation.createWorkItemLoc(JzRepoWorkItem.getCurrentStateDisplayName((IItemHandle)wiHandle)));
        result.setItemHandle((IItemHandle)wiHandle);
        return result;
    }

    public static JzRepoWorkItem lookup(JzProvider provider, JzLocation loc) throws WvcmException {
        JzRepoWorkItem result = null;
        IItemHandle myItemHandle = JzRepoWorkItem.lookupItemHandle(provider, loc);
        if (myItemHandle != null) {
            result = new JzRepoWorkItem(provider, (Location)loc);
            result.setItemHandle(myItemHandle);
        }
        return result;
    }

    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.COMMENT) && value instanceof String) {
            this.setComment((String)value, feedback);
        } else if (propertyName.equals((Object)InteropStream.PN_CLONE)) {
            this.storeInteropCloneValue((String)value, feedback);
        } else {
            super.setPropertyFromClient(propertyName, value, initialize, feedback);
        }
    }

    private void setComment(String comment, SrvcFeedback fb) throws WvcmException {
        JzProvider provider = this.provider();
        ITeamRepository repo = provider.getRepo();
        IWorkItemClient service = (IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class);
        IWorkItemWorkingCopyManager workItemWorkingCopyManager = service.getWorkItemWorkingCopyManager();
        IWorkItemHandle workItemHandle = (IWorkItemHandle)this.getItemHandle(fb.nest(10));
        try {
            workItemWorkingCopyManager.connectCurrent(workItemHandle, IWorkItem.FULL_PROFILE, JzProvider.getMonitor(fb, 30));
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
        WorkItemWorkingCopy wc = workItemWorkingCopyManager.getWorkingCopy(workItemHandle);
        IWorkItem workItem = wc.getWorkItem();
        workItem.setHTMLDescription(JzRepoWorkItem.truncateAndXmlEncode(comment, 32760, fb));
        JzRepoWorkItem.saveWorkItem(JzProvider.getMonitor(fb, 100), workItemWorkingCopyManager, wc, workItem);
    }

    private List<SrvcResource> getActivityList(SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        List<IChangeSetHandle> changeSetHandles = this.getChangeSetHandles(feedback.nest(30));
        ArrayList<SrvcResource> results = new ArrayList<SrvcResource>(changeSetHandles.size());
        for (IChangeSetHandle changeSetHandle : changeSetHandles) {
            results.add(JzRepoChangeSet.create(provider, changeSetHandle, feedback));
        }
        return results;
    }

    private List<IChangeSetHandle> getChangeSetHandles(SrvcFeedback feedback) throws WvcmException {
        ArrayList<IChangeSetHandle> results = new ArrayList<IChangeSetHandle>();
        JzProvider provider = this.provider();
        IWorkItemHandle myHandle = (IWorkItemHandle)this.getItemHandle(feedback.nest(10));
        try {
            ILinkManager linkManager = JzRepoWorkItem.getLinkManager(provider);
            IItemReference reference = CcConnectorUtils.createReferenceToItem((IItemHandle)myHandle);
            Collection linkCollection = linkManager.findLinksByTarget("com.ibm.team.filesystem.workitems.change_set", (IReference)reference, JzProvider.getMonitor(feedback, 100)).getAllLinksFromHereOn().getLinksById("com.ibm.team.filesystem.workitems.change_set");
            for (ILink link : linkCollection) {
                IReference sourceRef = link.getSourceRef();
                if (!sourceRef.isItemReference()) continue;
                IChangeSetHandle csh = (IChangeSetHandle)((IItemReference)sourceRef).getReferencedItem();
                results.add(csh);
            }
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
        return results;
    }

    public static JzRepoWorkItem lookupById(JzProvider provider, String requestedId, SrvcFeedback feedback) throws WvcmException {
        if (requestedId == null) {
            throw new IllegalArgumentException("requestId must not be null");
        }
        JzRepoWorkItem result = null;
        int id = Integer.parseInt(requestedId);
        try {
            IWorkItemClient workItemClient = (IWorkItemClient)provider.getRepo().getClientLibrary(IWorkItemClient.class);
            List workItemList = workItemClient.findWorkItemsById(Collections.singletonList(id), JzProvider.getMonitor(feedback, 50));
            if (workItemList.size() > 0) {
                IWorkItemHandle workItemHandle = (IWorkItemHandle)workItemList.get(0);
                result = JzRepoWorkItem.create(provider, workItemHandle);
            }
        }
        catch (ItemNotFoundException e) {
            provider.logIgnoredExceptionAsNotAlwaysVisible("JzRepoWorkItem.lookupById", (Exception)((Object)e));
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
        return result;
    }

    private static void copyPartialWorkItem(JzProvider provider, IWorkItem targetItem, IWorkItem sourceItem, Collection<String> exclusions, SrvcFeedback feedback) throws WvcmException {
        try {
            JzRepoWorkItem.copyPartialWorkItem(targetItem, sourceItem, exclusions, (IWorkItemCommon)provider.getRepo().getClientLibrary(IWorkItemCommon.class), JzProvider.getMonitor(feedback, 100));
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    private static void copyPartialWorkItem(IWorkItem targetItem, IWorkItem sourceItem, Collection<String> exclusions, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList includedProperties = new ArrayList(IWorkItem.FULL_PROFILE.getProperties());
        if (exclusions != null) {
            includedProperties.removeAll(exclusions);
        }
        includedProperties.remove(IWorkItem.ID_PROPERTY);
        for (String attributeId : includedProperties) {
            IAttribute attribute = workItemCommon.findAttribute(sourceItem.getProjectArea(), attributeId, monitor);
            if (attribute == null) continue;
            targetItem.setValue(attribute, JzRepoWorkItem.copy(sourceItem.getValue(attribute)));
        }
    }

    private static Object copy(Object from) {
        if (from instanceof Collection) {
            return JzRepoWorkItem.copy((Collection)from);
        }
        if (!(from instanceof EObject)) {
            return from;
        }
        EObject copy = EcoreUtil.copy((EObject)((EObject)from));
        if (copy instanceof Item) {
            Item itemCopy = (Item)copy;
            itemCopy.setWorkingCopy(((Item)from).isWorkingCopy());
            if (copy instanceof Auditable) {
                Auditable auditableCopy = (Auditable)itemCopy;
                Auditable auditableFrom = (Auditable)from;
                auditableCopy.setWorkingCopyMergePredecessor(auditableFrom.getWorkingCopyMergePredecessor());
                auditableCopy.setWorkingCopyPredecessor(auditableFrom.getWorkingCopyPredecessor());
            }
        }
        return copy;
    }

    public static Collection<?> copy(Collection<?> from) {
        ArrayList<Object> copy = new ArrayList<Object>(from.size());
        for (Object object : from) {
            copy.add(JzRepoWorkItem.copy(object));
        }
        return copy;
    }

    protected void doGetAllCustomPropertyNames(List<PropertyNameList.PropertyName<String>> customPNL, SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        IWorkItem workItem = this.getWorkItem(feedback.nest(10));
        IProjectAreaHandle projectArea = workItem.getProjectArea();
        String namespaceName = ((Object)((Object)this)).getClass().getName();
        IWorkItemCommon workItemCommon = (IWorkItemCommon)provider.getRepo().getClientLibrary(IWorkItemCommon.class);
        ArrayList includedProperties = new ArrayList(IWorkItem.FULL_PROFILE.getProperties());
        includedProperties.remove(IWorkItem.ID_PROPERTY);
        includedProperties.remove(IWorkItem.SUMMARY_PROPERTY);
        includedProperties.remove(IWorkItem.DESCRIPTION_PROPERTY);
        int size = includedProperties.size();
        int count = 0;
        for (String attributeId : includedProperties) {
            try {
                Object value;
                int done = JzProvider.FB_BASE(0, 100, ++count, size);
                IAttribute attribute = workItemCommon.findAttribute(projectArea, attributeId, JzProvider.getMonitor(feedback, done));
                if (attribute == null || !workItem.hasAttribute(attribute) || !workItem.isAttributeSet(attribute) || (value = workItem.getValue(attribute)) == null) continue;
                PropertyNameList.PropertyName pn = new PropertyNameList.PropertyName(namespaceName, attributeId);
                customPNL.add((PropertyNameList.PropertyName<String>)pn);
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException((Exception)((Object)e));
            }
        }
        customPNL.add((PropertyNameList.PropertyName<String>)InteropStream.PN_TASK_ID);
    }
}

