/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoFileItem;
import com.ibm.team.connector.scm.client.JzRepoFolderItem;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoSymbolicLinkVersion;
import com.ibm.team.connector.scm.client.JzRepoVersionHistory;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Version;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JzRepoVersion
extends JzRepoResource {
    public JzRepoVersion(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            return this.location().string();
        }
        if (propertyName.equals((Object)Version.VERSION_HISTORY)) {
            JzRepoVersionHistory vh = JzRepoVersionHistory.create(this.provider(), this.location().getComponentLocation(), (IVersionableHandle)this.getItemHandle(feedback));
            return vh;
        }
        if (propertyName.equals((Object)Resource.PATHNAME_LOCATION)) {
            return new JzLocation(this.getBindingName(feedback));
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    protected JzRepoVersionHistory getParentVersionHistory(SrvcFeedback feedback) throws WvcmException {
        IFolderHandle parentHandle = this.fetchCompleteState(feedback).getParent();
        JzLocation compLoc = this.location().getComponentLocation();
        JzLocation resultLoc = compLoc.createVersionHistoryLocation(JzRepoVersion.getCurrentStateDisplayName((IItemHandle)parentHandle));
        JzRepoVersionHistory result = new JzRepoVersionHistory(this.provider(), (Location)resultLoc);
        result.setItemHandle((IItemHandle)parentHandle);
        return result;
    }

    public IVersionable fetchCompleteState(SrvcFeedback feedback) throws WvcmException {
        IVersionableHandle versionableHandle = (IVersionableHandle)this.getItemHandle(feedback);
        return JzRepoVersion.fetchCompleteState(this.provider(), versionableHandle, feedback);
    }

    protected static IVersionable fetchCompleteState(JzProvider provider, IVersionableHandle versionableHandle, SrvcFeedback feedback) throws WvcmException {
        ITeamRepository repo = provider.getRepo();
        try {
            IVersionable result = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteState(versionableHandle, JzProvider.getMonitor(feedback, 100));
            return result;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    protected String getBindingName(SrvcFeedback feedback) throws WvcmException {
        IVersionable me = this.fetchCompleteState(feedback);
        String result = me.getName();
        return result;
    }

    public static boolean isSymbolicLink(IVersionableHandle versionableHandle, JzProvider provider, SrvcFeedback feedback) {
        try {
            IFileItem versionable = (IFileItem)JzRepoVersion.fetchCompleteState(provider, versionableHandle, feedback);
            return versionable.getContentType().equals("text/symblink");
        }
        catch (WvcmException e) {
            throw new RuntimeException("Could not get content of versionable", e);
        }
    }

    public static JzRepoVersion createAppropriateProxy(JzProvider provider, JzLocation resultLoc, IItemHandle myItemHandle, SrvcFeedback feedback) throws WvcmException {
        JzRepoVersion result = null;
        boolean symbolicLinksSupported = "true".equalsIgnoreCase(provider.getSymlinksSupported());
        if (symbolicLinksSupported) {
            result = myItemHandle.getItemType().equals(IFileItem.ITEM_TYPE) ? (JzRepoVersion.isSymbolicLink((IVersionableHandle)myItemHandle, provider, feedback) ? new JzRepoSymbolicLinkVersion(provider, (Location)resultLoc) : new JzRepoFileItem(provider, (Location)resultLoc)) : (myItemHandle.getItemType().equals(ISymbolicLink.ITEM_TYPE) ? new JzRepoSymbolicLinkVersion(provider, (Location)resultLoc) : new JzRepoFolderItem(provider, (Location)resultLoc));
        } else if (myItemHandle.getItemType().equals(IFileItem.ITEM_TYPE)) {
            result = JzRepoVersion.isSymbolicLink((IVersionableHandle)myItemHandle, provider, feedback) ? new JzRepoSymbolicLinkVersion(provider, (Location)resultLoc) : new JzRepoFileItem(provider, (Location)resultLoc);
        } else {
            if (myItemHandle.getItemType().equals(ISymbolicLink.ITEM_TYPE)) {
                throw new WvcmException(Messages.JzRepoVersion_ERROR_UNSUPPORTED_JAZZ_SYMLINK_ENCOUNTERED, null, WvcmException.ReasonCode.FORBIDDEN);
            }
            result = new JzRepoFolderItem(provider, (Location)resultLoc);
        }
        result.setItemHandle(myItemHandle);
        return result;
    }

    public IFolderHandle getParentFolderHandle(SrvcFeedback feedback) throws WvcmException {
        return this.fetchCompleteState(feedback).getParent();
    }

    public JzRepoComponent getJzRepoComponent(SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent result = JzRepoComponent.lookup(this.provider(), this.location().getComponentLocation(), feedback);
        return result;
    }

    public IVersionable getWorkingCopy(SrvcFeedback feedback) throws WvcmException {
        return (IVersionable)this.fetchCompleteState(feedback).getWorkingCopy();
    }
}

