/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.ri.impl.ControllableSymbolicLinkImpl;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoControllableFolder;
import com.ibm.team.connector.scm.client.JzRepoControllableResource;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.content.AbstractVersionedContentManagerInputStreamProvider;
import com.ibm.team.scm.client.content.util.VersionedContentManagerByteArrayInputStreamPovider;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.ControllableSymbolicLink;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoSymbolicLink
extends JzRepoControllableFolder {
    private static final String SLASH = String.valueOf('/');
    public static final String SymbolicLinkPrefix = "<Symbolic Link>";
    public static final String CONTENT_TYPE_SYMLINK = "text/symblink";

    public JzRepoSymbolicLink(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return ControllableSymbolicLinkImpl.class;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)ControllableSymbolicLink.LINK_TARGET)) {
            Location symlinkTarget = null;
            IVersionableHandle vh = this.lookupVersionableHandle(this.location().getPath(), feedback);
            IVersionable ver = JzRepoSymbolicLink.fetchCompleteState(this.provider(), vh, feedback);
            if (ver instanceof ISymbolicLink) {
                String linkTargetPath = ((ISymbolicLink)ver).getTarget();
                symlinkTarget = JzRepoSymbolicLink.relativePathToLocation(linkTargetPath, (WorkspaceProvider)this.provider());
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.doReadContent(out, null, feedback);
                symlinkTarget = JzRepoSymbolicLink.readSymbolicLinkTarget((WorkspaceProvider)this.provider(), this.location(), out, feedback);
            }
            return symlinkTarget;
        }
        if (propertyName.equals((Object)ControllableSymbolicLink.CHILD_MAP)) {
            HashMap result = new HashMap();
            return result;
        }
        if (propertyName.equals((Object)ControllableSymbolicLink.CHILD_LIST)) {
            ArrayList result = new ArrayList();
            return result;
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    protected static IVersionable fetchCompleteState(JzProvider provider, IVersionableHandle versionableHandle, SrvcFeedback feedback) throws WvcmException {
        ITeamRepository repo = provider.getRepo();
        try {
            IVersionable result = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteState(versionableHandle, JzProvider.getMonitor(feedback, 100));
            return result;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public static Location readSymbolicLinkTarget(WorkspaceProvider provider, JzLocation loc, OutputStream out, SrvcFeedback feedback) throws WvcmException {
        String content = out.toString();
        String path = null;
        if (!content.startsWith(SymbolicLinkPrefix)) {
            int end = content.length();
            if (end > 100) {
                content = String.valueOf(content.substring(0, 100)) + "...";
            }
            feedback.notifyWarning(NLS.bind((String)"Bad symlink at location: {0}, content: {1}", (Object)loc.string(), (Object[])new Object[]{content}));
            path = "bad_symlink_target_value";
        } else {
            path = content.substring(SymbolicLinkPrefix.length());
        }
        return JzRepoSymbolicLink.relativePathToLocation(path, provider);
    }

    public static String relativeLocationToString(Location loc) throws WvcmException {
        Location parent = loc.parent();
        if (parent == null) {
            return loc.lastSegment();
        }
        return String.valueOf(JzRepoSymbolicLink.relativeLocationToString(loc.parent())) + SLASH + loc.lastSegment();
    }

    public static Location relativePathToLocation(String path, WorkspaceProvider provider) throws WvcmException {
        String[] segments;
        Location loc = provider.relativeRootLocation();
        String[] stringArray = segments = path.split(SLASH, -1);
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            loc = loc.child(segment);
            ++n2;
        }
        return loc;
    }

    public static JzRepoResource doCreateSymbolicLink(JzProvider provider, JzLocation location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        JzLocation actualAddedItemLocation;
        PropValue propVal = updates.get(ControllableSymbolicLink.LINK_TARGET);
        if (propVal == null) {
            throw new WvcmException("LINK_TARGET must be set when creating a symbolic link", WvcmException.ReasonCode.FORBIDDEN);
        }
        String target = JzRepoSymbolicLink.relativeLocationToString((Location)propVal.get_value());
        boolean symbolicLinksSupported = "true".equalsIgnoreCase(provider.getSymlinksSupported());
        if (symbolicLinksSupported) {
            ISymbolicLink addMe = (ISymbolicLink)ISymbolicLink.ITEM_TYPE.createItem();
            addMe.setTarget(target);
            addMe.setLinkTimestamp(new Date(System.currentTimeMillis()));
            actualAddedItemLocation = JzRepoControllableResource.doAddItemToParent(provider, location, (IVersionable)addMe, feedback);
        } else {
            IFileItem addMe = (IFileItem)IFileItem.ITEM_TYPE.createItem();
            String contentString = SymbolicLinkPrefix + target;
            byte[] contentByteArray = contentString.getBytes();
            try {
                IFileContent content = FileSystemCore.getContentManager((ITeamRepository)provider.getRepo()).storeContent("us-ascii", FileLineDelimiter.LINE_DELIMITER_NONE, (AbstractVersionedContentManagerInputStreamProvider)new VersionedContentManagerByteArrayInputStreamPovider(contentByteArray), null, JzProvider.getMonitor(feedback, 50));
                addMe.setContentType(CONTENT_TYPE_SYMLINK);
                addMe.setContent(content);
                addMe.setFileTimestamp(new Date(System.currentTimeMillis()));
                actualAddedItemLocation = JzRepoControllableResource.doAddItemToParent(provider, location, (IVersionable)addMe, feedback);
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException((Exception)((Object)e));
            }
        }
        JzRepoSymbolicLink result = new JzRepoSymbolicLink(provider, (Location)actualAddedItemLocation);
        updated.add(ControllableSymbolicLink.LINK_TARGET);
        return result;
    }
}

