/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.StreamImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoBaseline;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoFolderItem;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoVersionHistory;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Resource;
import javax.wvcm.Stream;
import javax.wvcm.VersionSet;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoStream
extends JzRepoResource {
    public JzRepoStream(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return StreamImpl.class;
    }

    public static SrvcResource doCreateGeneratedResource(JzProvider provider, JzLocation locationHint, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        IWorkspaceConnection newStreamConnection;
        IProcessArea processAreaHandle = provider.getProcessArea(feedback);
        String randomizer = JzProvider.timeFormatter.format(new Date());
        String basename = locationHint.lastSegment();
        List<IItemHandle> existingWorkspaces = JzRepoStream.findAllStreamsOrWorkspacesByName(provider, basename, true, JzProvider.getMonitor(feedback, 20));
        boolean streamWithBasenameExists = existingWorkspaces.size() > 0;
        String streamName = streamWithBasenameExists ? String.valueOf(basename) + JzProvider.UNDERSCORE + randomizer : basename;
        PropValue commentValue = updates != null ? updates.get(Resource.COMMENT) : null;
        String comment = InteropStream.DOT;
        if (commentValue != null) {
            comment = (String)commentValue.get_value();
            updated.add(Resource.COMMENT);
        }
        ITeamRepository repo = provider.getRepo();
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        try {
            newStreamConnection = workspaceManager.createStream((IProcessAreaHandle)processAreaHandle, streamName, comment, JzProvider.getMonitor(feedback, 100));
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
        IWorkspace resolvedStream = newStreamConnection.getResolvedWorkspace();
        JzLocation resultLoc = JzRepoStream.createStreamLocation((IItemHandle)resolvedStream);
        JzRepoStream result = new JzRepoStream(provider, (Location)resultLoc);
        result.logInfo("created stream named: " + streamName + ", in: team area @: " + resultLoc.string());
        return result;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals(JzProvider.PN_PROCESS_AREA_ID)) {
            return this.getTeamAreaId(feedback);
        }
        if (propertyName.equals((Object)Stream.LATEST_VERSION_LIST)) {
            return this.doGetBaselines(feedback);
        }
        if (propertyName.equals((Object)Stream.VERSION_LIST)) {
            return this.getVersionList(feedback);
        }
        if (propertyName.equals((Object)Stream.WORKSPACE)) {
            return this.getStreamWorkspace(feedback);
        }
        if (propertyName.getNamespace() != null) {
            return this.getCustomProperty(propertyName, feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private Object getTeamAreaId(SrvcFeedback feedback) throws WvcmException {
        IProcessAreaHandle owner = this.getOwner(feedback);
        return JzRepoStream.getCurrentStateDisplayName((IItemHandle)owner);
    }

    private List<JzRepoVersion> getVersionList(SrvcFeedback feedback) throws WvcmException {
        ArrayList<JzRepoVersion> result = new ArrayList<JzRepoVersion>();
        JzProvider provider = this.provider();
        try {
            List componentHandles = this.getConnection(feedback).getComponents();
            for (IComponentHandle componentHandle : componentHandles) {
                JzRepoComponent comp = JzRepoComponent.create(componentHandle, provider);
                IConfiguration config = this.getConnection(feedback).configuration(componentHandle);
                JzRepoStream.getVersionList(provider, comp, config, result, feedback);
            }
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
        return result;
    }

    private List<JzRepoBaseline> doGetBaselines(SrvcFeedback feedback) throws WvcmException {
        ArrayList<JzRepoBaseline> results = new ArrayList<JzRepoBaseline>();
        IWorkspaceConnection sConn = this.getConnection(feedback);
        this.logDebug("getting baselines from stream: " + sConn.getName() + " (" + this.location().string() + ")");
        try {
            List knownComponents = sConn.getComponents();
            for (IComponentHandle componentHandle : knownComponents) {
                JzRepoComponent comp = JzRepoComponent.create(componentHandle, this.provider());
                JzRepoBaseline latestBaseline = comp.lookupLatestBaseline((IFlowNodeConnection)sConn, feedback);
                if (latestBaseline == null) continue;
                results.add(latestBaseline);
            }
            return results;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public JzRepoWorkspace getStreamWorkspace(SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkspace result = null;
        JzLocation wsLoc = JzLocation.createStreamWorkspaceLoc(this.location());
        result = (JzRepoWorkspace)this.provider().lookup((Location)wsLoc, feedback);
        return result;
    }

    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.getNamespace() != null) {
            this.storeCustomProperty(propertyName, (String)value, initialize, feedback);
        } else if (propertyName.equals((Object)Resource.DISPLAY_NAME)) {
            this.rename((String)value, feedback);
        } else {
            super.setPropertyFromClient(propertyName, value, initialize, feedback);
        }
    }

    private void rename(String value, SrvcFeedback feedback) throws WvcmException {
        try {
            IWorkspaceConnection conn = this.getConnection(feedback);
            conn.setName(value, JzProvider.getMonitor(feedback, 100));
        }
        catch (TeamRepositoryException e) {
            JzProvider.wrapException((Exception)((Object)e));
        }
    }

    @Override
    public Location getPathnameLocation(SrvcFeedback feedback) throws WvcmException {
        JzLocation result = JzLocation.root().child("stream").child(this.getDisplayName(feedback));
        return result;
    }

    public static JzRepoStream lookup(JzProvider provider, JzLocation loc) throws WvcmException {
        JzRepoStream result = null;
        IItemHandle myItemHandle = JzRepoStream.lookupItemHandle(provider, loc);
        if (myItemHandle != null) {
            result = JzRepoStream.create(provider, loc, myItemHandle);
        }
        return result;
    }

    public static JzRepoStream create(Stream streamProxy) throws WvcmException {
        JzLocation syncStreamLocation;
        JzProvider p = (JzProvider)streamProxy.provider();
        JzRepoStream syncStream = JzRepoStream.lookup(p, syncStreamLocation = JzLocation.create(streamProxy.location()));
        if (syncStream == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoStream_ERROR_STREAM_NOT_FOUND_WITH_LOCSTRING, (Object)syncStreamLocation.string(), (Object[])new Object[0]), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return syncStream;
    }

    public static JzRepoStream create(JzProvider provider, JzLocation loc, IItemHandle myItemHandle) {
        JzRepoStream result = new JzRepoStream(provider, (Location)loc);
        result.setItemHandle(myItemHandle);
        return result;
    }

    public static JzRepoStream create(JzProvider provider, IItemHandle itemHandle) {
        JzLocation resultLoc = JzRepoStream.createStreamLocation(itemHandle);
        return JzRepoStream.create(provider, resultLoc, itemHandle);
    }

    public static JzLocation createStreamLocation(IItemHandle itemHandle) {
        String displayName = JzRepoResource.getCurrentStateDisplayName(itemHandle);
        JzLocation resultLoc = JzLocation.createStreamLoc(displayName);
        return resultLoc;
    }

    public IWorkspaceConnection getConnection(SrvcFeedback feedback) throws WvcmException {
        IWorkspaceHandle streamHandle = (IWorkspaceHandle)this.getItemHandle(feedback);
        IWorkspaceConnection result = JzRepoWorkspace.lookupConnection(this.provider(), streamHandle, true, feedback);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoStream_ERROR_CANT_GET_STREAM_CONN_WITH_UUID, (Object)streamHandle.getItemId(), (Object[])new Object[0]), WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    @Override
    public String getDisplayName(SrvcFeedback feedback) throws WvcmException {
        String result = this.getConnection(feedback).getName();
        return result;
    }

    public <T extends SrvcResource> void doUpdate(List<T> sourceList, SrvcFeedback feedback) throws WvcmException {
        for (SrvcResource resource : sourceList) {
            JzRepoWorkspace source = null;
            if (resource instanceof JzRepoWorkspace) {
                source = (JzRepoWorkspace)resource;
            } else if (resource instanceof JzRepoStream) {
                source = ((JzRepoStream)resource).getConnection(feedback);
            } else {
                throw new IllegalArgumentException(NLS.bind((String)"Unsupported source for Stream.doUpdate operation: ''{0}''", (Object)((Object)((Object)source)).getClass().getName(), (Object[])new Object[0]));
            }
            this.doUpdate((Object)source, feedback);
        }
    }

    public void doUpdate(Object source, SrvcFeedback feedback) throws WvcmException {
        IFlowNodeConnection sourceConn = null;
        if (source instanceof JzRepoWorkspace) {
            JzRepoWorkspace ws = (JzRepoWorkspace)((Object)source);
            ws.closeAllCurrentActivities(feedback.nest(10));
            sourceConn = ws.getConnection(feedback.nest(20));
        } else {
            sourceConn = (IFlowNodeConnection)source;
        }
        JzRepoWorkspace.doUpdate(this.provider(), this.location(), (IFlowNodeConnection)this.getConnection(feedback.nest(30)), sourceConn, true, feedback);
    }

    public Map<String, SrvcResource> getFolderVersionChildMap(SrvcResource genericFolderVersion, SrvcFeedback feedback) throws WvcmException {
        JzRepoFolderItem folderVersion = (JzRepoFolderItem)genericFolderVersion;
        IComponentHandle compH = JzRepoComponent.getComponentItemHandle(this.provider(), folderVersion.location().getComponentLocation(), feedback);
        try {
            return folderVersion.childMap(true, this.getConnection(feedback).configuration(compH), feedback);
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public List<SrvcResource> getFolderVersionChildList(SrvcResource folderVersion, SrvcFeedback feedback) throws WvcmException {
        return new ArrayList<SrvcResource>(this.getFolderVersionChildMap(folderVersion, feedback).values());
    }

    public void doUnbindAll(SrvcFeedback feedback) throws WvcmException {
        IWorkspaceManager workspaceManager = this.getWorkspaceManager();
        try {
            IWorkspaceConnection conn = this.getConnection(feedback);
            IWorkspaceHandle wsHandle = (IWorkspaceHandle)this.getItemHandle(feedback);
            IFlowTable flowTable = conn.getFlowTable().getWorkingCopy();
            flowTable.removeAll((IFlowNodeHandle)wsHandle);
            conn.setFlowTable(flowTable, JzProvider.getMonitor(feedback, 50));
            workspaceManager.deleteWorkspace(wsHandle, JzProvider.getMonitor(feedback, 100));
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public List<SrvcResource.SrvcCompareReport> doCompareReport(SrvcResource resource, VersionSet.CompareFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        if (!(resource instanceof JzRepoStream)) {
            throw new WvcmException("JzRepoStream.doCompareReport is not supported for resource other than JzRepoStreams", WvcmException.ReasonCode.FORBIDDEN);
        }
        try {
            IWorkspaceConnection thisConnection = this.getConnection(feedback);
            TreeSet<IComponentHandle> thisStreamComponents = new TreeSet<IComponentHandle>(ItemUtil.itemIdComparator);
            thisStreamComponents.addAll(thisConnection.getComponents());
            IWorkspaceConnection otherConnection = ((JzRepoStream)resource).getConnection(feedback);
            TreeSet<IComponentHandle> otherStreamComponents = new TreeSet<IComponentHandle>(ItemUtil.itemIdComparator);
            otherStreamComponents.addAll(otherConnection.getComponents());
            TreeSet<IComponentHandle> includedComponents = new TreeSet<IComponentHandle>(ItemUtil.itemIdComparator);
            includedComponents.addAll(thisStreamComponents);
            includedComponents.retainAll(otherStreamComponents);
            TreeSet<IComponentHandle> excludedComponents = new TreeSet<IComponentHandle>(ItemUtil.itemIdComparator);
            excludedComponents.addAll(thisStreamComponents);
            excludedComponents.addAll(otherStreamComponents);
            excludedComponents.removeAll(includedComponents);
            boolean debugLogEnabled = this.isDebugLogEnabled();
            if (debugLogEnabled) {
                this.logDebug("this components: " + this.commaSeparatedComponentNames(thisStreamComponents, feedback));
                this.logDebug("other components: " + this.commaSeparatedComponentNames(otherStreamComponents, feedback));
                this.logDebug("included components (intersection): " + this.commaSeparatedComponentNames(includedComponents, feedback));
                this.logDebug("excluded components (): " + this.commaSeparatedComponentNames(excludedComponents, feedback));
            }
            return this.computeWvcmCompareReport((IConnection)thisConnection, (IConnection)otherConnection, new ArrayList<IComponentHandle>(includedComponents), new ArrayList<IComponentHandle>(excludedComponents), flags, feedback);
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    protected SrvcResource locateByHistory(SrvcResource genericVersionHistory, SrvcFeedback feedback) throws WvcmException {
        return JzRepoWorkspace.locateByHistory(this.provider(), this.getConnection(feedback), (JzRepoVersionHistory)genericVersionHistory, feedback);
    }

    public IProcessAreaHandle getOwner(SrvcFeedback feedback) throws WvcmException {
        return (IProcessAreaHandle)this.getConnection(feedback).getOwner();
    }

    public static Stream lookupStreamByName(JzProvider provider, String name, PropertyRequestItem.PropertyRequest propertyRequest, SrvcFeedback feedback) throws WvcmException {
        int resultSize;
        IItemQueryPage itemQueryPage;
        Stream result;
        block4: {
            result = null;
            IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)provider.getRepo());
            try {
                itemQueryPage = wm.findWorkspacesByName(name, false, true, true, 2, JzProvider.getMonitor(feedback, 50));
                resultSize = itemQueryPage.getResultSize();
                if (resultSize != 0) break block4;
                return null;
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException((Exception)((Object)e));
            }
        }
        if (resultSize > 1) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoStream_ERROR_AMBIGUOUS_STREAM_NAME, (Object)name, (Object[])new Object[]{resultSize}), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        JzLocation streamLoc = JzRepoStream.createStreamLocation((IItemHandle)itemQueryPage.getItemHandles().get(0));
        result = (Stream)provider.buildProxy((Location)streamLoc, propertyRequest, feedback);
        return result;
    }
}

