/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.ri.impl.VersionImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoVersionHistory;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IChangeSetSearchCriteria;
import java.util.List;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Version;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoRootVersion
extends JzRepoVersion {
    public JzRepoRootVersion(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return VersionImpl.class;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            return this.location().string();
        }
        if (propertyName.equals((Object)Version.VERSION_HISTORY)) {
            return this.getVersionHistory(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private JzRepoVersionHistory getVersionHistory(SrvcFeedback feedback) throws WvcmException {
        JzRepoVersionHistory result = (JzRepoVersionHistory)this.provider().lookup((Location)this.location().getVersionHistoryLocation(), feedback);
        return result;
    }

    @Override
    public IVersionable fetchCompleteState(SrvcFeedback feedback) throws WvcmException {
        JzRepoVersionHistory vh = this.getVersionHistory(null);
        IVersionableHandle versionableHandle = (IVersionableHandle)vh.getItemHandle(feedback);
        return JzRepoRootVersion.fetchCompleteState(this.provider(), versionableHandle, feedback);
    }

    @Override
    protected String getBindingName(SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("getBindingName is NYI", WvcmException.ReasonCode.FORBIDDEN);
    }

    @Override
    public IFolderHandle getParentFolderHandle(SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent comp = this.getJzRepoComponent(feedback);
        IFolderHandle parent = comp.getRootFolderHandle(feedback);
        return parent;
    }

    @Override
    protected JzRepoVersionHistory getParentVersionHistory(SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("getParentVersionHistory is NYI", WvcmException.ReasonCode.FORBIDDEN);
    }

    @Override
    public JzRepoComponent getJzRepoComponent(SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent result = JzRepoComponent.lookup(this.provider(), this.location().getVersionHistoryLocation().getComponentLocation(), feedback);
        return result;
    }

    @Override
    public IVersionable getWorkingCopy(SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        ITeamRepository repo = provider.getRepo();
        JzRepoVersionHistory vh = this.getVersionHistory(null);
        IVersionableHandle versionableHandle = (IVersionableHandle)vh.getItemHandle(feedback.nest(10));
        IComponentHandle componentHandle = vh.getJzRepoComponent(feedback.nest(15)).getComponentItemHandle(feedback.nest(20));
        try {
            IChangeSetSearchCriteria criteria = IChangeSetSearchCriteria.FACTORY.newInstance();
            criteria.setComponent(componentHandle);
            criteria.setItem(versionableHandle);
            List changeSets = this.getWorkspaceManager().findChangeSets(criteria, 512, JzProvider.getMonitor(feedback, 30));
            int size = changeSets.size();
            int count = 0;
            for (IChangeSetHandle changeSetHandle : changeSets) {
                int done = JzProvider.FB_BASE(31, 100, ++count, size);
                IChangeSet changeSet = (IChangeSet)repo.itemManager().fetchCompleteItem((IItemHandle)changeSetHandle, 1, JzProvider.getMonitor(feedback, done));
                List changes = changeSet.changes();
                IVersionableHandle result = null;
                for (IChange change : changes) {
                    IVersionableHandle afterStateHandle;
                    if (!change.item().sameItemId((IItemHandle)versionableHandle) || (result = change.beforeState()) != null || (afterStateHandle = change.afterState()) == null) continue;
                    IVersionable rootVersion = JzRepoRootVersion.fetchCompleteState(this.provider(), afterStateHandle, feedback);
                    return (IVersionable)rootVersion.getWorkingCopy();
                }
                if (result == null) continue;
                IVersionable rootVersion = JzRepoRootVersion.fetchCompleteState(this.provider(), result, feedback);
                return (IVersionable)rootVersion.getWorkingCopy();
            }
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
        throw new WvcmException(NLS.bind((String)Messages.JzRepoRootVersion_ERROR_FIND_ANY_STATE_OF_VERSIONABLE_FAILED_WITH_VH_LOCSTRING, (Object)vh.location().string(), (Object[])new Object[0]), WvcmException.ReasonCode.FORBIDDEN);
    }
}

