/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.ri.impl.ResourceImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoChangeSet;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoControllableFolder;
import com.ibm.team.connector.scm.client.JzRepoControllableResource;
import com.ibm.team.connector.scm.client.JzRepoSymbolicLink;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoVersionHistory;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.connector.scm.common.CcConnectorUtils;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.interop.client.IInteropManager;
import com.ibm.team.interop.common.IExternalProxy;
import com.ibm.team.interop.common.IExternalProxyHandle;
import com.ibm.team.interop.common.IExternalState;
import com.ibm.team.interop.common.InteropFactory;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.VersionSet;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoResource
extends SrvcResource {
    protected JzLocation _location;
    IItemHandle _myItemHandleCache;
    public static int SEGMENT_LENGTH_MAX = 32760;
    public static String SEGMENT_PREFIX = ".segment.";
    public static int SEGMENT_FORMAT_VERSION = 1;
    static final String ERROR_COULD_NOT_CREATE_URI_FROM_CLONE_VAL_WITH_VAL = Messages.JzRepoResource_ERROR_CREATE_URI_FROM_CLONE_VAL_FAILED_WITH_VAL;
    public static final String SINGLE_QUOTE = String.valueOf('\'');

    public JzRepoResource(JzProvider provider, Location loc) {
        this._provider = provider;
        this._location = JzLocation.create(loc);
    }

    public Class<?> get_proxyClass() {
        return ResourceImpl.class;
    }

    public JzLocation location() {
        return this._location;
    }

    public JzProvider provider() {
        return (JzProvider)this._provider;
    }

    public static IItemManager itemManager(JzProvider provider) {
        return provider.getRepo().itemManager();
    }

    public IItemManager getItemManager() {
        return JzRepoResource.itemManager(this.provider());
    }

    public IWorkspaceManager getWorkspaceManager() {
        return SCMPlatform.getWorkspaceManager((ITeamRepository)this.provider().getRepo());
    }

    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            return this.location().string();
        }
        if (propertyName.equals((Object)Resource.PATHNAME_LOCATION)) {
            return this.getPathnameLocation(feedback);
        }
        if (propertyName.equals((Object)Resource.DISPLAY_NAME)) {
            return this.getDisplayName(feedback);
        }
        if (propertyName.equals((Object)InteropStream.PN_CLONE)) {
            String result = this.lookupCloneValue(feedback);
            return result;
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public String getDisplayName(SrvcFeedback feedback) throws WvcmException {
        return this.location().string();
    }

    public Location getPathnameLocation(SrvcFeedback feedback) throws WvcmException {
        return this.location();
    }

    public static String getVHInitialComponentPropertyName() {
        return "InitialComponent";
    }

    public static String getFolderVersionBindingListPropertyName() {
        return "FolderVersionBindingList";
    }

    public static JzLocation createChildJzLocationFromHandle(JzLocation parent, IItemHandle handle) throws WvcmException {
        return parent.child(JzRepoResource.getCurrentStateDisplayName(handle));
    }

    public static String getCurrentStateDisplayName(IWorkspaceConnection connection) {
        IWorkspace resolvedWorkspace = connection.getResolvedWorkspace();
        String displayName = JzRepoResource.getCurrentStateDisplayName((IItemHandle)resolvedWorkspace);
        return displayName;
    }

    public static IItemHandle lookupItemHandle(JzProvider provider, URI uri) throws WvcmException {
        IItemHandle result = null;
        try {
            ITeamRepository repo = provider.getRepo();
            result = JzRepoResource.lookupItemHandle(repo, uri);
        }
        catch (WvcmException e) {
            if (WvcmException.ReasonCode.NOT_FOUND.equals((Object)e.getReasonCode())) {
                provider.logIgnoredExceptionAsNotAlwaysVisible("JzRepoResource.lookupItemHandle", (Exception)((Object)e));
            }
            throw e;
        }
        return result;
    }

    public static IItemHandle lookupItemHandle(ITeamRepository repo, URI uri) throws WvcmException {
        com.ibm.team.repository.common.Location usableLoc = JzRepoResource.createJazzLocation(repo, uri);
        IItemHandle result = usableLoc.getItemHandle();
        if (result != null && result.getOrigin() == null) {
            result = result.getItemType().createItemHandle((Object)repo, result.getItemId(), result.getStateId());
        }
        return result;
    }

    public static IItemHandle lookupItemHandle(JzProvider provider, JzLocation wvcmLocation) throws WvcmException {
        IItemHandle result = null;
        ITeamRepository repo = provider.getRepo();
        result = JzRepoResource.lookupItemHandle(repo, wvcmLocation);
        return result;
    }

    private static IItemHandle lookupItemHandle(ITeamRepository repo, JzLocation wvcmLocation) throws WvcmException {
        URI uri = wvcmLocation.getURI();
        IItemHandle result = JzRepoResource.lookupItemHandle(repo, uri);
        return result;
    }

    public static IItemHandle getItemHandle(JzProvider provider, JzLocation wvcmLocation) throws WvcmException {
        return JzRepoResource.getItemHandle(provider.getRepo(), wvcmLocation);
    }

    public static IItemHandle getItemHandle(ITeamRepository repo, JzLocation wvcmLocation) throws WvcmException {
        if (wvcmLocation.kind().equals((Object)JzLocation.Kind.BaselineControlledFolder)) {
            throw new IllegalArgumentException("JRR.getMyItemHandle should never be called with a BCF " + wvcmLocation.string());
        }
        URI uri = wvcmLocation.getURI();
        IItemHandle result = JzRepoResource.lookupItemHandle(repo, uri);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoResource_ERROR_GET_ITEM_HANDLE_FAILED_WITH_URI, (Object)uri.toString(), (Object[])new Object[0]), null, WvcmException.ReasonCode.FORBIDDEN);
        }
        return result;
    }

    private static com.ibm.team.repository.common.Location createJazzLocation(ITeamRepository repo, URI itemURI) throws WvcmException {
        try {
            com.ibm.team.repository.common.Location usableLoc = com.ibm.team.repository.common.Location.location((com.ibm.team.repository.common.Location)com.ibm.team.repository.common.Location.location((URI)itemURI), (String)repo.getRepositoryURI(), null);
            return usableLoc;
        }
        catch (TeamRepositoryException ex) {
            throw JzProvider.wrapException((Exception)((Object)ex));
        }
        catch (IllegalArgumentException ex) {
            throw JzProvider.wrapExceptionGivenExternalizedMsg(NLS.bind((String)Messages.JzRepoResource_ERROR_COULD_NOT_CREATE_JAZZ_LOCATION_FROM_URI_WITH_URISTRING, (Object)itemURI.toString(), (Object[])new Object[0]), ex);
        }
    }

    public static String getCurrentStateDisplayName(IItemHandle handle) {
        String uriString = JzRepoResource.getCurrentStateLocationUriString(handle);
        String displayName = "URI:" + uriString;
        return displayName;
    }

    public static String getCurrentStateLocationUriString(IItemHandle handle) {
        return com.ibm.team.repository.common.Location.itemLocation((IItemHandle)handle, null).toRelativeUri().toString();
    }

    public static String getItemStateDisplayName(IVersionableHandle handle) {
        com.ibm.team.repository.common.Location wsLoc = com.ibm.team.repository.common.Location.stateLocation((IItemHandle)handle, null);
        String displayName = "URI:" + wsLoc.toRelativeUri().toString();
        return displayName;
    }

    public void removePropertyFromClient(PropertyNameList.PropertyName<?> propertyName, SrvcFeedback feedback) throws WvcmException {
        this.removeCustomProperty(propertyName, feedback);
    }

    public JzRepoWorkspace getWvcmWorkspace(SrvcFeedback feedback) throws WvcmException {
        return JzRepoResource.getWvcmWorkspace(this.provider(), this.location(), feedback);
    }

    public IWorkspaceConnection getWorkspaceConnection(SrvcFeedback feedback) throws WvcmException {
        return this.getWvcmWorkspace(feedback.nest(50)).getConnection(feedback);
    }

    public static JzRepoWorkspace getWvcmWorkspace(JzProvider provider, JzLocation loc, SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkspace ws = (JzRepoWorkspace)provider.lookup((Location)loc.getWorkspaceLocation(), feedback.nest(10));
        if (ws == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoResource_ERROR_GET_WS_FROM_LOC_FAILED_WITH_LOC_STRING, (Object)loc.string(), (Object[])new Object[0]), WvcmException.ReasonCode.NOT_FOUND);
        }
        return ws;
    }

    public IConfiguration getConfiguration(SrvcFeedback feedback) throws WvcmException {
        return JzRepoResource.getConfiguration(this.provider(), this.location(), feedback);
    }

    public static IConfiguration getConfiguration(JzProvider provider, JzLocation myLoc, SrvcFeedback feedback) throws WvcmException {
        IConfiguration config = JzRepoResource.lookupConfiguration(provider, myLoc, feedback);
        if (config == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoResource_ERROR_GET_CONFIG_FAILED_WITH_LOCSTRING, (Object)myLoc.string(), (Object[])new Object[0]), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return config;
    }

    public static IConfiguration lookupConfiguration(JzProvider provider, JzLocation myLoc, SrvcFeedback feedback) throws WvcmException {
        IConfiguration config = null;
        JzLocation wsLoc = myLoc.lookupContextLocation(JzLocation.Kind.Workspace);
        JzLocation compLoc = myLoc.lookupContextLocation(JzLocation.Kind.Component);
        if (wsLoc != null && compLoc != null) {
            JzRepoWorkspace ws = (JzRepoWorkspace)provider.lookup((Location)wsLoc, null);
            config = ws.lookupConfiguration(compLoc, feedback);
        }
        return config;
    }

    protected synchronized void setItemHandle(IItemHandle h) {
        this._myItemHandleCache = h;
    }

    public synchronized IItemHandle lookupItemHandle() throws WvcmException {
        if (this._myItemHandleCache == null) {
            this._myItemHandleCache = JzRepoResource.lookupItemHandle(this.provider(), this.location());
        }
        return this._myItemHandleCache;
    }

    public synchronized IItemHandle getItemHandle(SrvcFeedback feedback) throws WvcmException {
        if (this._myItemHandleCache == null) {
            this._myItemHandleCache = this.computeItemHandle(feedback);
        }
        return this._myItemHandleCache;
    }

    public IItemHandle computeItemHandle(SrvcFeedback feedbackIgnored) throws WvcmException {
        return JzRepoResource.getItemHandle(this.provider(), this.location());
    }

    public static IInteropManager getInteropManager(JzProvider provider) throws WvcmException {
        return (IInteropManager)provider.getRepo().getClientLibrary(IInteropManager.class);
    }

    public static ILinkManager getLinkManager(JzProvider provider) {
        return (ILinkManager)provider.getRepo().getClientLibrary(ILinkManager.class);
    }

    public static IItemReference createReferenceToItem(ILinkManager linkManager, IItemHandle itemHandle) {
        return linkManager.referenceFactory().createReferenceToItem(itemHandle);
    }

    public static IURIReference createReferenceToUri(ILinkManager linkManager, URI uri) {
        return linkManager.referenceFactory().createReferenceFromURI(uri);
    }

    public String getCustomProperty(PropertyNameList.PropertyName<?> propertyName, SrvcFeedback feedback) throws WvcmException {
        return this.getStringCustomProperty(propertyName.getName(), feedback);
    }

    public String getStringCustomProperty(String name, SrvcFeedback feedback) throws WvcmException {
        String result = (String)this.getCustomProperty(name, feedback);
        return result;
    }

    public Object getCustomProperty(String name, SrvcFeedback feedback) throws WvcmException {
        return JzRepoResource.getCustomProperty(this.provider(), this.getItemHandle(feedback), name, feedback);
    }

    public static Object getCustomProperty(JzProvider provider, IItemHandle h, String name, SrvcFeedback feedback) throws WvcmException {
        IExternalProxy proxy;
        IInteropManager interopManager;
        block3: {
            interopManager = JzRepoResource.getInteropManager(provider);
            try {
                proxy = interopManager.findProxybyTargetItem(h, JzProvider.getMonitor(feedback, 50));
                if (proxy != null) break block3;
                return null;
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException((Exception)((Object)e));
            }
        }
        Map latestState = interopManager.getLatestState(proxy, JzProvider.getMonitor(feedback, 100));
        String value = latestState == null ? null : JzRepoResource.getStringValue(latestState, name);
        JzRepoResource.traceProxyWithState(provider, "got", name, value == null ? null : value, h.getItemId().toString());
        return value;
    }

    public String lookupCloneValue(SrvcFeedback feedback) throws WvcmException {
        return JzRepoResource.lookupCloneValue(this.provider(), this.getItemHandle(feedback), feedback);
    }

    public static String lookupCloneValue(JzProvider provider, IItemHandle h, SrvcFeedback feedback) throws WvcmException {
        String result = null;
        ILinkManager linkManager = JzRepoResource.getLinkManager(provider);
        IItemReference itemReference = JzRepoResource.createReferenceToItem(linkManager, h);
        IURIReference uriReference = JzRepoResource.lookupTargetUriReference(provider, itemReference, feedback);
        if (uriReference != null) {
            result = JzRepoResource.createCloneValueFromUri(uriReference.getURI());
        }
        return result;
    }

    private static IURIReference lookupTargetUriReference(JzProvider provider, IItemReference itemReference, SrvcFeedback feedback) throws WvcmException {
        ILinkManager linkManager = JzRepoResource.getLinkManager(provider);
        try {
            ILink link;
            Collection links = linkManager.findLinksBySource(CcConnectorUtils.CLONE_LINK_TYPE, (IReference)itemReference, JzProvider.getMonitor(feedback, 100)).getAllLinksFromHereOn().getLinksById(CcConnectorUtils.CLONE_LINK_TYPE);
            Iterator linksIterator = links.iterator();
            IReference targetRef = null;
            if (linksIterator.hasNext() && !(targetRef = (link = (ILink)linksIterator.next()).getTargetRef()).isURIReference()) {
                targetRef = null;
            }
            links.size();
            IURIReference uriReference = targetRef == null ? null : (IURIReference)targetRef;
            return uriReference;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    private void removeCustomProperty(PropertyNameList.PropertyName<?> propertyName, SrvcFeedback feedback) throws WvcmException {
        JzRepoResource.storeCustomProperty(this.provider(), this.location(), this.getItemHandle(feedback.nest(50)), propertyName.getName(), null, false, feedback);
    }

    public void storeCustomProperty(PropertyNameList.PropertyName<?> propertyName, String value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        JzRepoResource.storeCustomProperty(this.provider(), this.location(), this.getItemHandle(feedback.nest(50)), propertyName.getName(), value, initialize, feedback);
    }

    public static void storeCustomProperty(JzProvider provider, JzLocation locationForExceptionMsg, IItemHandle h, String name, String value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        IInteropManager interopManager = JzRepoResource.getInteropManager(provider);
        JzRepoResource.traceProxyWithState(provider, "saving", name, value == null ? null : value.toString(), h.getItemId().toString());
        try {
            IExternalProxy proxy = interopManager.findProxybyTargetItem(h, JzProvider.getMonitor(feedback, 10));
            IExternalState xstate = null;
            HashMap<String, Object> state = null;
            if (proxy == null) {
                proxy = InteropFactory.INSTANCE.createExternalProxy();
                IProjectArea area = provider.getProjectArea(feedback);
                proxy.setContextId(area.getContextId());
                proxy = interopManager.saveProxyWithTargetItem(proxy, h, JzProvider.getMonitor(feedback, 60));
            } else {
                xstate = interopManager.getExternalState(proxy, JzProvider.getMonitor(feedback, 60));
            }
            proxy = (IExternalProxy)proxy.getWorkingCopy();
            if (xstate == null) {
                xstate = InteropFactory.INSTANCE.createExternalState();
                xstate = (IExternalState)xstate.getWorkingCopy();
                state = new HashMap<String, Object>(1);
            } else {
                xstate = (IExternalState)xstate.getWorkingCopy();
                state = xstate.getState();
            }
            JzRepoResource.putValue(state, name, value, initialize);
            xstate.setState(state);
            interopManager.saveProxyWithState(proxy, xstate, JzProvider.getMonitor(feedback, 90));
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    private static String getStringValue(Map<String, Object> latestState, String baseName) {
        if (latestState.containsKey(baseName)) {
            return (String)latestState.get(baseName);
        }
        String descriptorKey = JzRepoResource.baseNameToDescriptorKey(baseName);
        if (latestState.containsKey(descriptorKey)) {
            SegmentFoldingDescriptor descriptor = new SegmentFoldingDescriptor((String)latestState.get(descriptorKey));
            StringBuilder builder = new StringBuilder(descriptor._numSegments * descriptor._maxSegmentLength);
            int i = 0;
            while (i < descriptor._numSegments) {
                String key = JzRepoResource.computeKey(baseName, i);
                builder.append((String)latestState.get(key));
                ++i;
            }
            String result = builder.toString();
            assert (result.length() == descriptor._totalLength);
            return result;
        }
        return null;
    }

    private static void deleteAnySegments(Map<String, Object> state, String baseName) {
        state.put(baseName, null);
        String expanderMapNameKey = JzRepoResource.baseNameToDescriptorKey(baseName);
        if (state.containsKey(expanderMapNameKey)) {
            String[] prefixes;
            String expanderMap = (String)state.get(expanderMapNameKey);
            String[] stringArray = prefixes = expanderMap.split(JzProvider.COMMA);
            int n = prefixes.length;
            int n2 = 0;
            while (n2 < n) {
                String prefix = stringArray[n2];
                state.put(String.valueOf(prefix) + baseName, null);
                ++n2;
            }
        }
    }

    private static String baseNameToDescriptorKey(String baseName) {
        return "expanderMapPrefix." + baseName;
    }

    private static void putValue(Map<String, Object> state, String baseName, String value, boolean initialize) throws WvcmException {
        if (initialize && JzRepoResource.getStringValue(state, baseName) != null) {
            throw new WvcmException("Property already set: " + baseName, WvcmException.ReasonCode.CANNOT_OVERWRITE);
        }
        JzRepoResource.deleteAnySegments(state, baseName);
        if (value == null) {
            return;
        }
        if (value.length() <= SEGMENT_LENGTH_MAX) {
            state.put(baseName, value);
        } else {
            JzRepoResource.putMultiSegmentValue(state, baseName, value);
        }
    }

    private static void putMultiSegmentValue(Map<String, Object> state, String baseName, String value) throws WvcmException {
        StringReader valueStream = new StringReader(value);
        char[] buffer = new char[SEGMENT_LENGTH_MAX];
        int segmentNum = 0;
        int numCharsRead = 0;
        try {
            do {
                if ((numCharsRead = valueStream.read(buffer, 0, SEGMENT_LENGTH_MAX)) <= 0) continue;
                state.put(JzRepoResource.computeKey(baseName, segmentNum++), new String(buffer, 0, numCharsRead));
            } while (numCharsRead > 0);
            SegmentFoldingDescriptor descriptor = new SegmentFoldingDescriptor(SEGMENT_FORMAT_VERSION, value.length(), SEGMENT_LENGTH_MAX, segmentNum);
            state.put(JzRepoResource.baseNameToDescriptorKey(baseName), descriptor.encode());
        }
        catch (IOException e) {
            throw new WvcmException("Could not store property value", null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    private static String computeKey(String baseName, int segmentNum) {
        return String.format("%s%d.%s", SEGMENT_PREFIX, segmentNum, baseName);
    }

    public void removeInteropCloneValue(SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        ILinkManager linkManager = JzRepoResource.getLinkManager(provider);
        IItemReference itemReference = JzRepoResource.createReferenceToItem(linkManager, this.getItemHandle(feedback.nest(10)));
        try {
            Collection itemsLinks = linkManager.findLinksBySource(CcConnectorUtils.CLONE_LINK_TYPE, (IReference)itemReference, JzProvider.getMonitor(feedback, 20)).getAllLinksFromHereOn().getLinksById(CcConnectorUtils.CLONE_LINK_TYPE);
            if (itemsLinks.size() > 0) {
                linkManager.deleteLinks(itemsLinks, JzProvider.getMonitor(feedback, 30));
            }
            feedback.notifyPercentComplete(100);
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public static Map<JzRepoResource, Object> storeInteropCloneValues(JzProvider provider, Map<JzRepoResource, String> sources2Values, SrvcFeedback feedback) throws WvcmException {
        HashMap<JzRepoResource, Object> results = new HashMap<JzRepoResource, Object>();
        ILinkManager linkManager = JzRepoResource.getLinkManager(provider);
        Map<JzRepoResource, CloneLinkInfo> linkages = JzRepoResource.computeReferences(linkManager, sources2Values, feedback);
        JzRepoResource.ensureNoExistingClones(provider, linkages, feedback);
        ArrayList<ILink> links = new ArrayList<ILink>();
        for (JzRepoResource source : linkages.keySet()) {
            CloneLinkInfo entry = linkages.get((Object)source);
            if (entry._result != null) continue;
            try {
                if (provider.isDebugLogEnabled()) {
                    provider.logDebug(String.format("linking VH %s to clone %s", JzRepoResource.getCurrentStateDisplayName(source.getItemHandle(feedback.nest(40))), entry._targetCloneValue));
                }
                ILink link = linkManager.createLink(CcConnectorUtils.CLONE_LINK_TYPE, (IReference)entry._sourceRef, (IReference)entry._targetRef);
                links.add(link);
            }
            catch (TeamRepositoryException e) {
                WvcmException value = JzProvider.wrapExceptionGivenExternalizedMsg(NLS.bind((String)Messages.JzRepoResource_ERROR_CREATE_LINK_FAILED_WITH_LOC_STRING, (Object)((Object)source.location()), (Object[])new Object[0]), (Exception)((Object)e));
                entry._result = value;
            }
        }
        try {
            linkManager.saveLinks(links, JzProvider.getMonitor(feedback, 100));
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
        return results;
    }

    private static void ensureNoExistingClones(JzProvider provider, Map<JzRepoResource, CloneLinkInfo> info, SrvcFeedback feedback) throws WvcmException {
        for (JzRepoResource source : info.keySet()) {
            CloneLinkInfo entry = info.get((Object)source);
            JzRepoResource.ensureNoClonesOfSource(provider, entry._sourceRef, source, feedback.nest(50));
            JzRepoResource.ensureNoCloneOfTarget(provider, entry._targetRef, entry._targetCloneValue, feedback);
        }
    }

    private static Map<JzRepoResource, CloneLinkInfo> computeReferences(ILinkManager linkManager, Map<JzRepoResource, String> sources2Values, SrvcFeedback feedback) throws WvcmException {
        HashMap<JzRepoResource, CloneLinkInfo> results = new HashMap<JzRepoResource, CloneLinkInfo>();
        for (JzRepoResource source : sources2Values.keySet()) {
            CloneLinkInfo result = new CloneLinkInfo();
            results.put(source, result);
            try {
                result._sourceRef = source.createReferenceToItem(linkManager, feedback);
                result._targetCloneValue = sources2Values.get((Object)source);
                URI uri = JzRepoResource.createUriFromCloneValue(result._targetCloneValue);
                result._targetRef = JzRepoResource.createReferenceToUri(linkManager, uri);
            }
            catch (Exception e) {
                WvcmException value = new WvcmException("Could not create link to resource with location" + (Object)((Object)source.location()), null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
                result._result = value;
            }
        }
        feedback.notifyPercentComplete(100);
        return results;
    }

    protected IItemReference createReferenceToItem(ILinkManager linkManager, SrvcFeedback feedback) throws WvcmException {
        IItemReference result = null;
        if (this instanceof JzRepoVersionHistory) {
            throw new IllegalStateException("Expected JzRepoVersionHistory's override to run instead of this one");
        }
        result = JzRepoResource.createReferenceToItem(linkManager, this.getItemHandle(feedback));
        return result;
    }

    public void storeInteropCloneValue(String cloneValue, SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        IItemHandle h = this.getItemHandle(feedback.nest(10));
        JzRepoResource.traceProxyWithState(provider, "saving", "clone URI", cloneValue == null ? null : cloneValue, h.getItemId().toString());
        HashMap<JzRepoResource, String> sources2Values = new HashMap<JzRepoResource, String>(1);
        sources2Values.put(this, cloneValue);
        JzRepoResource.storeInteropCloneValues(provider, sources2Values, feedback);
    }

    private static void ensureNoClonesOfSource(JzProvider provider, IItemReference reference, JzRepoResource source, SrvcFeedback feedback) throws WvcmException {
        IURIReference i = JzRepoResource.lookupTargetUriReference(provider, reference, feedback);
        if (i != null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoResource_ERROR_ITEM_ALREADY_HAS_CLONE_WITH_ITEM_ID, (Object)JzRepoResource.getCurrentStateDisplayName(source.getItemHandle(feedback)), (Object[])new Object[0]), null, WvcmException.ReasonCode.CONFLICT);
        }
    }

    private static void ensureNoCloneOfTarget(JzProvider provider, IURIReference uriReference, String cloneValue, SrvcFeedback feedback) throws WvcmException {
        if (JzRepoResource.hasClone(provider, uriReference, feedback)) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoResource_URI_ALREADY_HAS_CLONE_WITH_URI, (Object)cloneValue, (Object[])new Object[0]), null, WvcmException.ReasonCode.CONFLICT);
        }
    }

    public static boolean hasClone(JzProvider provider, IURIReference reference, SrvcFeedback feedback) throws WvcmException {
        Map<IURIReference, IItemReference> clones = JzRepoResource.getClonesOfTargets(provider, feedback, reference);
        return clones.get(reference) != null;
    }

    public static URI createUriFromCloneValue(String cloneValue) throws WvcmException {
        try {
            URI result = CcConnectorUtils.createUriFromCloneValue((String)cloneValue);
            return result;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not create URI from clone value: " + cloneValue, e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Could not create URI from clone value: " + cloneValue, e);
        }
    }

    public static String createCloneValueFromUri(URI uri) throws WvcmException {
        try {
            String result = CcConnectorUtils.createCloneValueFromUri((URI)uri);
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoResource_ERROR_CREATE_URI_FROM_CLONE_VAL_FAILED_WITH_VAL, (Object)uri.toString(), (Object[])new Object[0]), null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    public static IItemHandle lookupByCloneValue(JzProvider provider, PropertyNameList.PropertyName<?> ignored, String value, SrvcFeedback feedback) throws WvcmException {
        if (value.startsWith("CQ%3A")) {
            return JzRepoResource.lookupWorkItemByCqInteropUri(provider, value, feedback);
        }
        URI uri = JzRepoResource.createUriFromCloneValue(value);
        IURIReference reference = JzRepoResource.createReferenceToUri(JzRepoResource.getLinkManager(provider), uri);
        Map<IURIReference, IItemReference> clones = JzRepoResource.getClonesOfTargets(provider, feedback, reference);
        IItemReference itemReference = clones.get(reference);
        IItemHandle result = itemReference == null ? null : itemReference.getReferencedItem();
        return result;
    }

    protected static Map<IURIReference, IItemReference> getClonesOfTargets(JzProvider provider, SrvcFeedback feedback, IURIReference ... uriReferences) throws WvcmException {
        ILinkManager linkManager = JzRepoResource.getLinkManager(provider);
        try {
            Collection links = linkManager.findLinksByTarget(new String[]{CcConnectorUtils.CLONE_LINK_TYPE}, (IReference[])uriReferences, JzProvider.getMonitor(feedback, 100)).getAllLinksFromHereOn().getLinksById(CcConnectorUtils.CLONE_LINK_TYPE);
            TreeMap<IURIReference, IItemReference> results = new TreeMap<IURIReference, IItemReference>(new URIRefComparator());
            for (ILink link : links) {
                IReference targetRef = link.getTargetRef();
                if (targetRef.isURIReference()) {
                    IURIReference key = (IURIReference)targetRef;
                    IReference sourceRef = link.getSourceRef();
                    IItemReference result = sourceRef.isItemReference() ? (IItemReference)sourceRef : null;
                    results.put(key, result);
                    continue;
                }
                throw new IllegalStateException("internal error: Clone link target reference is not a URI reference");
            }
            return results;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    private static IItemHandle lookupWorkItemByCqInteropUri(JzProvider provider, String value, SrvcFeedback feedback) throws WvcmException {
        IExternalProxy proxy;
        IInteropManager interopManager;
        IItemHandle result;
        block3: {
            result = null;
            interopManager = JzRepoResource.getInteropManager(provider);
            try {
                proxy = interopManager.findProxybyUri(URI.create(value), JzProvider.getMonitor(feedback, 50));
                if (proxy != null) break block3;
                return null;
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException((Exception)((Object)e));
            }
        }
        result = interopManager.getTargetItem((IExternalProxyHandle)proxy, JzProvider.getMonitor(feedback, 100));
        return result;
    }

    public static void traceProxyWithState(JzProvider provider, String verb, String name, String value, String id) {
        int len = value == null ? 0 : value.length();
        int display = len <= 200 ? len : 200;
        String valueString = value == null ? "{null}" : value.substring(0, display);
        provider.logDebug(String.format("%s property: %s value length: %d, prefix: %s on %s\n", verb, name, len, valueString, id));
    }

    public String getItemStateDisplayName(IVersionableHandle itemHandle, IConfiguration config, SrvcFeedback feedback) throws WvcmException {
        String result = this.lookupItemStateDisplayName(itemHandle, config, feedback);
        if (result == null) {
            throw new WvcmException("Could not get Item State Display Name", null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    public String lookupItemStateDisplayName(IVersionableHandle itemHandle, IConfiguration config, SrvcFeedback feedback) throws WvcmException {
        IVersionable meWithStateId = this.lookupItemState(itemHandle, config, feedback);
        if (meWithStateId == null) {
            return null;
        }
        String myURIString = JzRepoResource.getItemStateDisplayName((IVersionableHandle)meWithStateId);
        return myURIString;
    }

    public IVersionable lookupItemState(IVersionableHandle itemHandle, IConfiguration config, SrvcFeedback feedback) throws WvcmException {
        try {
            IVersionable meWithStateId = config.fetchPartialItem(itemHandle, null, JzProvider.getMonitor(feedback, 100));
            return meWithStateId;
        }
        catch (ItemNotFoundException itemNotFoundException) {
            return null;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public static JzLocation getVersionHistoryLocation(JzLocation compLoc, IVersionableHandle vH) throws WvcmException {
        return compLoc.createVersionHistoryLocation(JzRepoResource.getCurrentStateDisplayName((IItemHandle)vH));
    }

    public static JzRepoControllableResource createFromVersionable(JzProvider provider, JzLocation loc, IVersionableHandle vH) {
        JzRepoControllableResource result = null;
        IItemType t = vH.getItemType();
        if (t.equals(IFileItem.ITEM_TYPE)) {
            result = new JzRepoControllableResource(provider, (Location)loc);
        } else if (t.equals(IFolder.ITEM_TYPE)) {
            result = new JzRepoControllableFolder(provider, (Location)loc);
        } else if (t.equals(ISymbolicLink.ITEM_TYPE)) {
            result = new JzRepoSymbolicLink(provider, (Location)loc);
        } else {
            throw new IllegalStateException("did not recognize item type" + t.toString());
        }
        result.setItemHandle((IItemHandle)vH);
        return result;
    }

    public boolean isDebugLogEnabled() {
        return this.provider().isDebugLogEnabled();
    }

    public void logCreation(String objectKind, JzLocation requestedLocation, String resourceIdentifer, String otherInfo) {
        this.provider().logCreation(objectKind, requestedLocation, resourceIdentifer, otherInfo);
    }

    public void logCreation(String objectName, JzLocation objectLocation) {
        this.provider().logCreation(objectName, objectLocation);
    }

    public void logInfo(String msg) {
        this.provider().logInfo(msg);
    }

    public void logDebug(String msg) {
        this.provider().logDebug(msg);
    }

    public void logIgnoredExceptionAsAlwaysVisible(String methodName, Exception e, String extraDescription) {
        this.provider().logIgnoredExceptionAsAlwaysVisible(methodName, e, extraDescription);
    }

    public void logIgnoredExceptionAsNotAlwaysVisible(String methodName, Exception e, String extraDescription) {
        this.provider().logIgnoredExceptionAsNotAlwaysVisible(methodName, e, extraDescription);
    }

    public Map<String, SrvcResource> childMap(boolean childrenAreVersionHistories, IConfiguration config, SrvcFeedback feedback) throws WvcmException {
        JzLocation loc = this.location();
        JzProvider provider = this.provider();
        IFolderHandle folder = (IFolderHandle)this.getItemHandle(feedback.nest(10));
        JzLocation compLoc = JzRepoComponent.createComponentLocation(config.component());
        try {
            Map kids = config.childEntries(folder, JzProvider.getMonitor(feedback, 100));
            HashMap<String, SrvcResource> result = new HashMap<String, SrvcResource>(kids.size());
            for (String childName : kids.keySet()) {
                IVersionableHandle vH = (IVersionableHandle)kids.get(childName);
                JzRepoResource value = childrenAreVersionHistories ? new JzRepoVersionHistory(provider, (Location)compLoc.createVersionHistoryLocation(JzRepoResource.getCurrentStateDisplayName((IItemHandle)vH))) : JzRepoResource.createFromVersionable(provider, loc.child(childName), vH);
                result.put(childName, value);
            }
            return result;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public static WvcmException.ReasonCode exceptionToReasonCode(Exception e) {
        WvcmException.ReasonCode result = WvcmException.ReasonCode.FORBIDDEN;
        if (e instanceof PermissionDeniedException) {
            result = WvcmException.ReasonCode.UNAUTHORIZED;
        } else if (e instanceof ItemNotFoundException) {
            result = WvcmException.ReasonCode.NOT_FOUND;
        }
        return result;
    }

    protected List<SrvcResource.SrvcCompareReport> computeWvcmCompareReport(IConnection thisConn, IConnection otherConn, List<IComponentHandle> includedComponents, List<IComponentHandle> excludedComponents, VersionSet.CompareFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        boolean computeActivityReport = flags != null && Arrays.asList(flags).contains(VersionSet.CompareFlag.ACTIVITIES);
        boolean thisIsBaselineConnection = thisConn instanceof IBaselineConnection;
        boolean otherIsBaselineConnection = otherConn instanceof IBaselineConnection;
        JzLocation helperWsHintLocation = new JzLocation("doCompareHelper");
        ArrayList<SrvcResource.SrvcCompareReport> results = new ArrayList<SrvcResource.SrvcCompareReport>();
        boolean debugLogEnabled = this.isDebugLogEnabled();
        if (debugLogEnabled) {
            String includedNames = this.commaSeparatedComponentNames(includedComponents, feedback.nest(3));
            this.logDebug("included components: " + includedNames);
            String excludedNames = this.commaSeparatedComponentNames(excludedComponents, feedback.nest(8));
            this.logDebug("excluded components: " + excludedNames);
        }
        IWorkspaceConnection helperWsConn = null;
        JzRepoWorkspace helperWs = null;
        try {
            try {
                if (thisIsBaselineConnection) {
                    helperWs = JzRepoWorkspace.doCreateGeneratedWorkspace(this.provider(), helperWsHintLocation, null, null, "doCompareHelper", null, null, feedback.nest(10));
                    helperWsConn = helperWs.getConnection(feedback);
                    helperWsConn.addComponent(includedComponents.get(0), (IBaselineConnection)thisConn, false, JzProvider.getMonitor(feedback, 20));
                } else {
                    helperWs = JzRepoWorkspace.doCreateGeneratedWorkspace(this.provider(), helperWsHintLocation, null, null, "doCompareHelper", (IWorkspaceHandle)((IWorkspaceConnection)thisConn).getResolvedWorkspace(), null, feedback.nest(10));
                    helperWsConn = helperWs.getConnection(feedback.nest(20));
                    if (debugLogEnabled) {
                        String helperNames = this.commaSeparatedComponentNames(helperWsConn.getComponents(), feedback.nest(21));
                        this.logDebug("components in helper workspace: " + helperNames);
                    }
                }
                IChangeHistorySyncReport activityReport = null;
                if (computeActivityReport) {
                    activityReport = otherIsBaselineConnection ? helperWsConn.compareToBaseline(((IBaselineConnection)otherConn).getBaseline(), JzProvider.getMonitor(feedback, 25)) : helperWsConn.compareTo((IFlowNodeConnection)otherConn, WorkspaceComparisonFlags.CHANGE_SET_COMPARISON_ONLY, Collections.EMPTY_LIST, JzProvider.getMonitor(feedback, 25));
                    this.addActivitiesToReport(activityReport, results);
                }
                IUpdateReport comparisonReport = null;
                IProgressMonitor monitor50 = JzProvider.getMonitor(feedback, 50);
                comparisonReport = thisIsBaselineConnection ? helperWsConn.replaceComponent(includedComponents.get(0), otherConn, true, monitor50) : helperWsConn.compareConfigurations((IFlowNodeConnection)otherConn, null, monitor50);
                this.computeWvcmCompareReport(comparisonReport, results, feedback.nest(90));
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException((Exception)((Object)e));
            }
        }
        finally {
            if (helperWs != null) {
                helperWs.doUnbindAll(feedback);
            }
        }
        return results;
    }

    public String commaSeparatedComponentNames(Collection<IComponentHandle> componentHandles, SrvcFeedback feedback) throws WvcmException {
        StringBuffer names = new StringBuffer();
        boolean insertComma = false;
        for (IComponentHandle componentHandle : componentHandles) {
            if (insertComma) {
                names.append(JzProvider.COMMA_SPACE);
            } else {
                insertComma = true;
            }
            names.append(JzRepoComponent.create(componentHandle, this.provider()).getName(feedback));
        }
        return names.toString();
    }

    protected void computeWvcmCompareReport(IUpdateReport comparisonReport, List<SrvcResource.SrvcCompareReport> results, SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        int conflictCount = comparisonReport.conflicts().size();
        if (conflictCount > 0) {
            throw new WvcmException("computeWvcmCompareReport: expected zero conflicts.  found: " + Integer.toString(conflictCount), WvcmException.ReasonCode.FORBIDDEN);
        }
        Collection updates = comparisonReport.updates();
        this.logDebug("computing Wvcm Compare Report with item updates: " + Integer.toString(updates.size()));
        for (IItemUpdateReport u : updates) {
            IVersionableHandle previousState = u.getPreviousState();
            IVersionableHandle newCurrentState = u.getNewCurrentState();
            JzRepoComponent priorJzRepoComponent = JzRepoComponent.create(u.getPriorComponent(), provider);
            JzRepoComponent newJzRepoComponent = JzRepoComponent.create(u.getComponent(), provider);
            if (previousState == null) {
                results.add((SrvcResource.SrvcCompareReport)new SrvcResource.SrvcAddedVersion((SrvcResource)JzRepoResource.versionableToVersion(provider, newJzRepoComponent, newCurrentState, feedback)));
                continue;
            }
            if (newCurrentState == null) {
                results.add((SrvcResource.SrvcCompareReport)new SrvcResource.SrvcDeletedVersion((SrvcResource)JzRepoResource.versionableToVersion(provider, newJzRepoComponent, previousState, feedback)));
                continue;
            }
            if (priorJzRepoComponent.getComponentItemHandle(feedback.nest(10)).sameItemId((IItemHandle)newJzRepoComponent.getComponentItemHandle(feedback.nest(20)))) {
                results.add((SrvcResource.SrvcCompareReport)new SrvcResource.SrvcChangedVersion((SrvcResource)JzRepoResource.versionableToVersion(provider, newJzRepoComponent, previousState, feedback.nest(50)), (SrvcResource)JzRepoResource.versionableToVersion(provider, newJzRepoComponent, newCurrentState, feedback)));
                continue;
            }
            results.add((SrvcResource.SrvcCompareReport)new SrvcResource.SrvcDeletedVersion((SrvcResource)JzRepoResource.versionableToVersion(provider, priorJzRepoComponent, previousState, feedback.nest(50))));
            results.add((SrvcResource.SrvcCompareReport)new SrvcResource.SrvcAddedVersion((SrvcResource)JzRepoResource.versionableToVersion(provider, newJzRepoComponent, newCurrentState, feedback)));
        }
    }

    protected void addActivitiesToReport(IChangeHistorySyncReport activityReport, List<SrvcResource.SrvcCompareReport> results) throws WvcmException {
        if (activityReport != null) {
            JzProvider provider = this.provider();
            ArrayList<JzRepoChangeSet> changeSets = this.createWvcmChangeSetsForJazzChangeSets(provider, activityReport.incomingChangeSets());
            for (JzRepoChangeSet cs : changeSets) {
                results.add((SrvcResource.SrvcCompareReport)new SrvcResource.SrvcAddedActivity((SrvcResource)cs));
            }
            changeSets.clear();
            changeSets = this.createWvcmChangeSetsForJazzChangeSets(provider, activityReport.outgoingChangeSets());
            for (JzRepoChangeSet cs : changeSets) {
                results.add((SrvcResource.SrvcCompareReport)new SrvcResource.SrvcDeletedActivity((SrvcResource)cs));
            }
        }
    }

    protected ArrayList<JzRepoChangeSet> createWvcmChangeSetsForJazzChangeSets(JzProvider provider, List<IChangeSetHandle> incomingCS) throws WvcmException {
        ArrayList<JzRepoChangeSet> changeSets = new ArrayList<JzRepoChangeSet>(incomingCS.size());
        for (IChangeSetHandle cSH : incomingCS) {
            String displayName = JzRepoResource.getCurrentStateDisplayName((IItemHandle)cSH);
            JzRepoChangeSet serverProxy = (JzRepoChangeSet)provider.get((Location)JzLocation.createChangeSetLocation(displayName), null);
            changeSets.add(serverProxy);
        }
        return changeSets;
    }

    static JzRepoVersion versionableToVersion(JzProvider provider, JzRepoComponent newJzRepoComponent, IVersionableHandle versionableHandle, SrvcFeedback feedback) throws WvcmException {
        String displayName = JzRepoResource.getItemStateDisplayName(versionableHandle);
        JzRepoVersion result = JzRepoVersion.createAppropriateProxy(provider, newJzRepoComponent.location().createVersionLocation(displayName), (IItemHandle)versionableHandle, feedback);
        return result;
    }

    public static List<IItemHandle> findAllStreamsOrWorkspacesByName(JzProvider provider, String name, boolean findStreams, IProgressMonitor monitor) throws WvcmException {
        ArrayList<IItemHandle> result = new ArrayList<IItemHandle>();
        ITeamRepository repo = provider.getRepo();
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        String namePattern = JzRepoResource.convertToQueryPattern(name, false, false);
        try {
            IItemQueryPage page = wm.findWorkspacesByName(namePattern, !findStreams, findStreams, false, 100, monitor);
            while (page != null) {
                List itemHandles = page.getItemHandles();
                result.addAll(itemHandles);
                page = wm.fetchNextPage(page, null);
            }
        }
        catch (TeamRepositoryException e) {
            JzProvider.wrapException((Exception)((Object)e));
        }
        return result;
    }

    public static void getVersionList(JzProvider provider, JzRepoComponent comp, IConfiguration config, List<JzRepoVersion> result, SrvcFeedback feedback) throws WvcmException {
        try {
            IFolder root = config.partialRootFolder(null, JzProvider.getMonitor(feedback, 30));
            result.add(JzRepoResource.versionableToVersion(provider, comp, (IVersionableHandle)root, feedback.nest(60)));
            JzRepoResource.computeVersionList(provider, comp, config, (IFolderHandle)root, result, feedback);
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    private static void computeVersionList(JzProvider provider, JzRepoComponent comp, IConfiguration config, IFolderHandle folderHandle, List<JzRepoVersion> versionList, SrvcFeedback feedback) throws WvcmException {
        try {
            Map kids = config.childEntries(folderHandle, JzProvider.getMonitor(feedback, 30));
            int size = kids.size();
            int count = 0;
            for (IVersionableHandle childHandle : kids.values()) {
                int done = JzProvider.FB_BASE(31, 95, count++, size);
                versionList.add(JzRepoResource.versionableToVersion(provider, comp, childHandle, feedback.nest(done)));
                if (!childHandle.getItemType().equals(IFolder.ITEM_TYPE)) continue;
                JzRepoResource.computeVersionList(provider, comp, config, (IFolderHandle)childHandle, versionList, feedback.nest(done + 5));
            }
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public static void forEachCloneLink(JzProvider provider, IVisitCloneLink visitor) throws WvcmException {
        ILinkManager linkManager = JzRepoResource.getLinkManager(provider);
        NullProgressMonitor fakeMonitor = new NullProgressMonitor();
        try {
            Collection links = linkManager.findLinks(new String[]{CcConnectorUtils.CLONE_LINK_TYPE}, (IProgressMonitor)fakeMonitor).getAllLinksFromHereOn().getLinksById(CcConnectorUtils.CLONE_LINK_TYPE);
            for (ILink cloneLink : links) {
                visitor.visit(cloneLink);
            }
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public static Map<String, IItemHandle> lookupByManyCloneValue(JzProvider provider, PropertyNameList.PropertyName<?> ignored, List<String> cloneStrings, SrvcFeedback feedback) throws WvcmException {
        if (cloneStrings.size() == 0) {
            return Collections.emptyMap();
        }
        ILinkManager linkManager = JzRepoResource.getLinkManager(provider);
        HashMap<String, IURIReference> s2u = new HashMap<String, IURIReference>();
        for (String value : cloneStrings) {
            s2u.put(value, JzRepoResource.createReferenceToUri(linkManager, JzRepoResource.createUriFromCloneValue(value)));
        }
        Map<IURIReference, IItemReference> clonesByRef = JzRepoResource.getClonesOfTargets(provider, feedback, s2u.values().toArray(new IURIReference[s2u.size()]));
        HashMap<String, IItemHandle> results = new HashMap<String, IItemHandle>(clonesByRef.size());
        for (String value : cloneStrings) {
            IURIReference uriRef = (IURIReference)s2u.get(value);
            IItemReference itemReference = clonesByRef.get(uriRef);
            IItemHandle cloneItemHandle = itemReference.getReferencedItem();
            results.put(value, cloneItemHandle);
        }
        return results;
    }

    public static String convertToQueryPattern(String text, boolean matchAnyAtBeginning, boolean matchAnyAtEnd) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (matchAnyAtBeginning && i == 0 && ch != '*') {
                buffer.append("%");
            }
            switch (ch) {
                case '*': {
                    buffer.append("%");
                    break;
                }
                case '?': {
                    buffer.append("_");
                    break;
                }
                case '%': {
                    buffer.append("\\%");
                    break;
                }
                case '_': {
                    buffer.append("\\_");
                    break;
                }
                case '\\': {
                    buffer.append("\\\\");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            if (matchAnyAtEnd && i == text.length() - 1 && ch != '*') {
                buffer.append("%");
            }
            ++i;
        }
        return buffer.toString();
    }

    public static class CloneLinkInfo {
        public IItemReference _sourceRef;
        public String _targetCloneValue;
        public IURIReference _targetRef;
        public Object _result;
    }

    public static class CountingVisitor
    implements IVisitCloneLink {
        private int _visits = 0;
        private int _matches = 0;
        private boolean _verbose = false;

        public CountingVisitor(boolean verbose) {
            this._verbose = verbose;
        }

        public boolean visit(ILink cloneLink) throws WvcmException {
            String targetString;
            ++this._visits;
            IReference sourceRef = cloneLink.getSourceRef();
            IItemHandle referencedItem = sourceRef.isItemReference() ? ((IItemReference)sourceRef).getReferencedItem() : null;
            IReference targetRef = cloneLink.getTargetRef();
            String string = targetString = targetRef.isURIReference() ? JzRepoResource.createCloneValueFromUri(((IURIReference)targetRef).getURI()) : null;
            if (referencedItem != null && targetString != null) {
                ++this._matches;
                CountingVisitor.printCloneLinkInfo(referencedItem, targetString, this._verbose);
            }
            return true;
        }

        public int getVisits() {
            return this._visits;
        }

        public int getMatches() {
            return this._matches;
        }

        public static void printCloneLinkInfo(IItemHandle thisItem, String uriString, boolean verbose) throws WvcmException {
            String thisString = verbose ? JzRepoResource.getCurrentStateDisplayName(thisItem) : thisItem.getItemType().getName();
            System.out.printf("thisInfo: %s, otherUri: %s\n", thisString, uriString);
        }
    }

    public static interface IVisitCloneLink {
        public boolean visit(ILink var1) throws WvcmException;
    }

    public static class SegmentFoldingDescriptor {
        int _formatVersion;
        int _totalLength;
        int _maxSegmentLength;
        int _numSegments;
        private static String nameEqualNumberSemi = "\\w+=(\\d+);";
        private static Pattern decodePattern = Pattern.compile(String.valueOf(nameEqualNumberSemi) + nameEqualNumberSemi + nameEqualNumberSemi + nameEqualNumberSemi);

        public SegmentFoldingDescriptor(int version, int length, int segmentLength, int segments) {
            this._formatVersion = version;
            this._totalLength = length;
            this._maxSegmentLength = segmentLength;
            this._numSegments = segments;
        }

        public SegmentFoldingDescriptor(String encodedDescriptor) {
            Matcher m = decodePattern.matcher(encodedDescriptor);
            if (!m.find()) {
                throw new IllegalStateException("Could not parse segment folding descriptor: " + encodedDescriptor);
            }
            this._formatVersion = Integer.parseInt(m.group(1));
            this._totalLength = Integer.parseInt(m.group(2));
            this._maxSegmentLength = Integer.parseInt(m.group(3));
            this._numSegments = Integer.parseInt(m.group(4));
        }

        public String encode() {
            return String.format("formatVersion=%d;totalLength=%d;maxSegmentLength=%d;numSegments=%d;", this._formatVersion, this._totalLength, this._maxSegmentLength, this._numSegments);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class URIRefComparator
    implements Comparator<IURIReference> {
        @Override
        public int compare(IURIReference o1, IURIReference o2) {
            return o1.getURI().compareTo(o2.getURI());
        }
    }
}

