/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.ri.impl.VersionImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileContentManager;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoFileItem
extends JzRepoVersion {
    private static final String IO_ERROR_WHILE_DOWNLOADING_WITH_NAME = Messages.JzRepoFileItem_ERROR_WHILE_DOWNLOADING_WITH_NAME;
    static final List<PropertyNameList.PropertyName<?>> CONTENT_PROPERTIES = new ArrayList<PropertyNameList.PropertyName>(Arrays.asList(Resource.CONTENT_CHARACTER_SET, Resource.CONTENT_LENGTH, InteropStream.PN_LINE_SEPARATOR));
    static final Map<FileLineDelimiter, InteropStream.LineSeparator> delimsToSeps = new HashMap<FileLineDelimiter, InteropStream.LineSeparator>();

    static {
        delimsToSeps.put(FileLineDelimiter.LINE_DELIMITER_CR, InteropStream.LineSeparator.CR);
        delimsToSeps.put(FileLineDelimiter.LINE_DELIMITER_CRLF, InteropStream.LineSeparator.CRLF);
        delimsToSeps.put(FileLineDelimiter.LINE_DELIMITER_LF, InteropStream.LineSeparator.LF);
        delimsToSeps.put(FileLineDelimiter.LINE_DELIMITER_PLATFORM, InteropStream.LineSeparator.PLATFORM);
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (CONTENT_PROPERTIES.contains(propertyName)) {
            IFileContent content = this.getContent(feedback);
            if (propertyName.equals((Object)Resource.CONTENT_CHARACTER_SET)) {
                return content.getCharacterEncoding();
            }
            if (propertyName.equals((Object)InteropStream.PN_LINE_SEPARATOR)) {
                FileLineDelimiter ld = content.getLineDelimiter();
                if (delimsToSeps.containsKey(ld)) {
                    return delimsToSeps.get(ld).name();
                }
                return InteropStream.LineSeparator.UNSPECIFIED.name();
            }
            if (propertyName.equals((Object)Resource.CONTENT_LENGTH)) {
                return content.getRawLength();
            }
        } else {
            if (propertyName.equals((Object)Resource.CONTENT_TYPE)) {
                return ((IFileItem)this.fetchCompleteState(feedback)).getContentType();
            }
            if (propertyName.equals((Object)Resource.IS_EXECUTABLE)) {
                return new Boolean(((IFileItem)this.fetchCompleteState(feedback)).isExecutable());
            }
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private IFileItem getFileItem(SrvcFeedback feedback) throws WvcmException {
        this.provider().applyDeferredContentCommits(feedback);
        return (IFileItem)this.fetchCompleteState(feedback);
    }

    private IFileContent getContent(SrvcFeedback feedback) throws WvcmException {
        return this.getFileItem(feedback).getContent();
    }

    public JzRepoFileItem(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return VersionImpl.class;
    }

    public void doReadContent(OutputStream result, Resource accept, SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        try {
            FileLineDelimiter lineDelimiter;
            IFileItem file = this.getFileItem(feedback.nest(40));
            InteropStream.LineSeparator lineSeparator = JzProvider.lookupLineSeparator(accept);
            FileLineDelimiter fileLineDelimiter = lineDelimiter = lineSeparator == null ? FileLineDelimiter.LINE_DELIMITER_NONE : JzProvider.getLineDelimiter(lineSeparator);
            if (file != null) {
                this.readContent(FileSystemCore.getContentManager((ITeamRepository)provider.getRepo()), (IFileItemHandle)file, file.getContent(), lineDelimiter, result, JzProvider.getMonitor(feedback, 100));
            }
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    protected boolean hasSameContent(SrvcResource otherVersion, SrvcFeedback feedback) throws WvcmException {
        JzRepoFileItem otherFileItem = (JzRepoFileItem)otherVersion;
        IFileContent myContent = this.getContent(feedback);
        IFileContent otherContent = ((IFileItem)otherFileItem.fetchCompleteState(feedback)).getContent();
        return myContent.sameContent(otherContent);
    }

    private void readContent(IFileContentManager contentManager, IFileItemHandle state, IFileContent storedContent, FileLineDelimiter requestedDelimiter, OutputStream output, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean useStoredDelimiter;
        FileLineDelimiter storedDelimiter;
        if (requestedDelimiter.equals((Object)FileLineDelimiter.LINE_DELIMITER_PLATFORM)) {
            requestedDelimiter = FileLineDelimiter.getPlatformDelimiter();
        }
        if ((storedDelimiter = storedContent.getLineDelimiter()).equals((Object)FileLineDelimiter.LINE_DELIMITER_PLATFORM)) {
            storedDelimiter = FileLineDelimiter.getPlatformDelimiter();
        }
        boolean bl = useStoredDelimiter = storedDelimiter.equals((Object)requestedDelimiter) || FileLineDelimiter.LINE_DELIMITER_NONE.equals((Object)storedDelimiter);
        if (useStoredDelimiter) {
            contentManager.retrieveContent(state, storedContent, output, monitor);
        } else {
            try {
                InputStream input = contentManager.retrieveContentStream(state, storedContent, storedContent.getCharacterEncoding(), requestedDelimiter, monitor);
                try {
                    byte[] buf = new byte[8192];
                    int read = input.read(buf);
                    while (read != -1) {
                        output.write(buf, 0, read);
                        read = input.read(buf);
                    }
                }
                finally {
                    input.close();
                }
            }
            catch (IOException e) {
                throw new TeamRepositoryException(NLS.bind((String)IO_ERROR_WHILE_DOWNLOADING_WITH_NAME, (Object)storedContent, (Object[])new Object[0]), (Throwable)e);
            }
        }
    }
}

